<?php
/**
@version $Id: PartyFilter.php,v 1.4 2004/07/26 10:52:29 minahito Exp $
*/

require_once "exForm/Filter.php";

class PartyAdminFilter extends exAbstractFilterForm {
	var $end_=false;

	function fetch() {
		$this->end_=$this->_getRequest('end');
	}

	function getCriteria($start=0,$limit=0) {
		$ret = new CriteriaCompo();
		if(!$this->end_)
			$ret->add(new Criteria('event_date',time(),'>='));

		$ret->setSort('event_date');
		$ret->setStart($start);
		$ret->setLimit($limit);
		return ($ret);
	}

	function getStructure($type='s')
	{
		$ret=array();
		$ret['end']=($this->end_) ? 1 : 0;
		return $ret;
	}
}

class PartyFilter extends PartyAdminFilter {
	function getCriteria($start=0,$limit=0) {
		$ret = parent::getCriteria($start,$limit);
		$ret->add(new Criteria('private',0));

		return ($ret);
	}

}



?>
