<?php
require_once DISCUSS_PATH . '/class/message.php';
require_once DISCUSS_PATH . '/class/general/xoopssimplecontroller.php';

class DiscussMessageAdminList extends XoopsTableObjectList
{
	function DiscussMessageAdminList()
	{
		$this->addElement('discuss_id', 'discuss', 50, array('sort'=>true, 'filter'=>true, 'method'=>'id2name', 'class'=>'discussion'));
		$this->addElement('message_id', 'id', 20, array('sort'=>true));
		$this->addElement('uid', 'uid', 20, array('sort'=>true));
		$this->addElement('uname', 'uname', 100, array('sort'=>true, 'filter'=>true));
		$this->addElement('message', 'message', 500);
		$this->addElement('timestamp', 'datetime', 150, array('sort'=>true, 'method'=>'time2str', 'format'=>'y/m/d H/i'));
		$this->addElement('color', 'color', 10);
		$this->addElement('ip', 'ip', 100);
		$this->addElement('__SimpleEditLink__', '', 50);
		$this->addElement('__SimpleDeleteLink__', '', 50);
	}

	function getSelf() {
		return DISCUSS_URL . '/admin/index.php/message';
	}
}

class DiscussMessageAdminForm extends XoopsTableObjectForm
{
	function DiscussMessageAdminForm()
	{
		$this->setPrefix('discuss_msg');
		$this->addElement('discuss_id', 'Hidden', '', 0);
		$this->addElement('message_id', 'Hidden', '', 0);
		$this->addElement('uid', 'Text', 'uid');
		$this->addElement('uname', 'Text', 'uname');
		$this->addElement('message', 'TextArea', 'message');
//		$this->addElement('timestamp', 'Text', 'timestamp');
//		$this->addElement('color', 'Text', 'color');
	}
}

class DiscussMessageAdminController extends XoopsSimpleAdminController
{
	function DiscussMessageAdminController()
	{
		parent::XoopsSimpleAdminController('DiscussMessage', _AD_DISCUSS_LANG_MESSAGE);
		$this->allowedOp = array('list','edit','save','delete','deleteok','deleteall','deleteallok');
		$this->url = DISCUSS_URL . '/admin/index.php/message';
	}
}
?>