<?php
/**
 * Generate active discussion block
 *
 * @version $Id$
 */
function b_discuss_active_show($options)
{
	$mydirname = empty($options[0]) ? 'discuss' : $options[0];
	if (preg_match('/[^0-9a-zA-Z_-]/', $mydirname)) { die('Invalid mydirname'); }

	$message_length = isset($options[1]) ? intval($options[1]) : 30;//Zero is no display message
	$message_lifetime = isset($options[2]) ? intval($options[2]) : 10;//minutes. Zero is no display message

	require_once dirname(dirname(__FILE__)) . '/class/root.php';
	$date_format = DISCUSS_DATE_SHORT;

	$attendee_handler =& Discuss::getHandler('attendee');
	$attendee_array =& $attendee_handler->getActiveAttendee();
	if (!$attendee_array) {	return false; }

	if (is_object($GLOBALS['xoopsUser'])) {
		$permission_handler =& Discuss::getHandler('permission');
		$permitted_discuss_ids = $permission_handler->getPermittedDiscussIds($GLOBALS['xoopsUser']->getVar('uid'));
	} else {
		$permitted_discuss_ids = null;
	}

	$discussion_handler =& Discuss::getHandler('discussion');
	$discussion_objects =& $discussion_handler->getDiscussions($permitted_discuss_ids, array_keys($attendee_array));

	if ($message_length > 0) {
		$ts =& MyTextSanitizer::getInstance();
		$message_handler =& Discuss::getHandler('message');
	}

	$block_outdata = array();
	foreach ($discussion_objects as $discuss_id => $discussion) {
		$block_outdata[$discuss_id] = array();
		$block_outdata[$discuss_id]['title'] = $discussion->getvar('subject');
		$block_outdata[$discuss_id]['link'] = XOOPS_URL . '/modules/' . $mydirname . '/#d:' . $discuss_id;

		if ($message_length > 0 && $message_lifetime > 0) {
			$messages =& $message_handler->getRecentMessages($discuss_id, $message_lifetime * 60, 1);
			if ( $messages ) {
				$block_outdata[$discuss_id]['context'] = $ts->htmlSpecialChars(xoops_substr($messages[0]->getVar('message', 'none'), 0, $message_length));
				$block_outdata[$discuss_id]['time'] = htmlspecialchars(formatTimestamp($messages[0]->getVar('timestamp'), $date_format), ENT_QUOTES);
				$block_outdata[$discuss_id]['uname'] = $messages[0]->getVar('uname');
			}
		}

		$block_outdata[$discuss_id]['attendee'] = array();
		foreach ($attendee_array[$discuss_id] as $member) {
			$block_outdata[$discuss_id]['attendee'][] = $member->getVar('uname');
		}
	}
	return $block_outdata;
}

function b_discuss_active_edit( $options )
{
	$mydirname = empty( $options[0] ) ? '?' : $options[0] ;
	if (preg_match('/[^0-9a-zA-Z_-]/', $mydirname) || !file_exists(XOOPS_ROOT_PATH . "/modules/{$mydirname}/xoops_version.php")) {
		$block_handler =& xoops_gethandler('block');
		$block =& $block_handler->get(intval($_GET['bid']));
		$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->get($block->getVar('mid'));
		$mydirname = $module->getVar('dirname');
	}

	$message_length = isset($options[1]) ? $options[1] : 30;
	$message_lifetime = isset($options[2]) ? intval($options[2]) : 10;

	$form = '
		<input type="hidden" name="options[0]" value="'. $mydirname .'" />
		<table width="100%">
		<tr><td width="40%">'. _MB_DISCUSS_MESSAGECHARS .':</td>
		<td><input type="text" name="options[1]" value="'. $message_length .'" /></td></tr>
		<tr><td width="40%">'. _MB_DISCUSS_MSGLIFETIME .':</td>
		<td><input type="text" name="options[2]" value="'. $message_lifetime .'" /></td></tr>
		<tr><td Colspan=2>' . _MB_DISCUSS_MSGLIFETIMEDSC . '</td></tr>
		</table>
	';
	return $form;
}

/**
 * Show recent messages by discussions
 */
function b_discuss_messages_show($options)
{
	//---- init option ----//
	$mydirname = empty($options[0]) ? 'discuss' : $options[0];
	if(preg_match('/[^0-9a-zA-Z_-]/', $mydirname)) { die('Invalid mydirname'); }

	$message_length = !empty($options[1]) ? intval($options[1]) : 30;//not zero
	$message_lifetime = isset($options[2]) ? intval($options[2]) : 0;//Hours. Zero is no limited
	$message_count = !empty($options[3]) ? intval($options[3]) : 5;//not zero

	require_once dirname(dirname(__FILE__)) . '/class/root.php';
	$date_format = DISCUSS_DATE_LONG;

	if (is_object($GLOBALS['xoopsUser'])) {
		$permission_handler =& Discuss::getHandler('permission');
		$permitted_discuss_ids = $permission_handler->getPermittedDiscussIds($GLOBALS['xoopsUser']->getVar('uid'));
	} else {
		$permitted_discuss_ids = null;
	}

	//---- get discussion objects ----//
	$discussion_handler =& Discuss::getHandler('discussion');
	$specified_ids = getArrayFromOptions($options, 4);
	$discussions =& $discussion_handler->getDiscussions($permitted_discuss_ids, $specified_ids);
	if (!$discussions) { return false; }

	$ts =& MyTextSanitizer::getInstance();
	$message_handler =& Discuss::getHandler('message');

	$block_outdata = array();
	foreach ($discussions as $discuss_id => $discussion) {
		$messages =& $message_handler->getRecentMessages($discuss_id, $message_lifetime * 3600, $message_count);
		if (!$messages) { continue; }

		//---- make discussdata array ----//
		$block_outdata[$discuss_id] = array();
		$block_outdata[$discuss_id]['title'] = $discussion->getVar('subject');
		$block_outdata[$discuss_id]['link'] = XOOPS_URL .'/modules/'. $mydirname .'/#d:'. $discuss_id;
		$block_outdata[$discuss_id]['messages'] = array();

		foreach ($messages as $message_id => $message_object) {
			//---- make messagedata array ----//
			$block_outdata[$discuss_id]['messages'][$message_id] = array();
			$block_outdata[$discuss_id]['messages'][$message_id]['uname'] = $message_object->getVar('uname');
			//show format
			$block_outdata[$discuss_id]['messages'][$message_id]['context'] = $ts->htmlSpecialChars(xoops_substr($message_object->getVar('message', 'none'), 0, $message_length));
			$block_outdata[$discuss_id]['messages'][$message_id]['time'] = htmlspecialchars(formatTimestamp($message_object->getVar('timestamp'), $date_format), ENT_QUOTES);
		}
	}
	return $block_outdata;
}

/**
 * Try to see what tabs are visibles (if we are in restricted view of course)
 */
function getArrayFromOptions(&$options, $offset)
{
	$discussIDs = array();
	$opt_discussIDs = array_slice($options, $offset);
	foreach ($opt_discussIDs as $v) {
		$discussIDs[] = intval($v) ;
	}
	return $discussIDs;
}

function b_discuss_messages_edit($options)
{
	//---- init option ----//
	$mydirname = empty($options[0]) ? '?' : $options[0];
	if (preg_match('/[^0-9a-zA-Z_-]/', $mydirname) || !file_exists(XOOPS_ROOT_PATH . "/modules/{$mydirname}/xoops_version.php")) {
		$block_handler =& xoops_gethandler('block');
		$block =& $block_handler->get(intval($_GET['bid']));
		$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->get($block->getVar('mid'));
		$mydirname = $module->getVar('dirname');
	}

	$message_length = empty($options[1]) ? $options[1] : 30;
	$message_lifetime = isset($options[2]) ? $options[2] : 0;
	$message_count = empty($options[3]) ? $options[3] : 5;

	$form = '
		<input type="hidden" name="options[0]" value="'. $mydirname .'" />
		<table width="100%">
		<tr><td width="40%">'. _MB_DISCUSS_MESSAGECHARS .':</td>
		<td><input type="text" name="options[1]" value="'. $message_length .'" /></td></tr>
		<tr><td width="40%">'. _MB_DISCUSS_MSGLIFETIME .':</td>
		<td><input type="text" name="options[2]" value="'. $message_lifetime .'" /></td></tr>
		<tr><td Colspan=2>'. _MB_DISCUSS_MSGLIFETIMEDSC .':</td></tr>
		<tr><td width="40%">'. _MB_DISCUSS_MSGCOUNT .':</td>
		<td><input type="text" name="options[3]" value="'. $message_count .'" /></td></tr>
		<tr><td Colspan=2>'. _MB_DISCUSS_MSGCOUNTDSC .':</td></tr>
		</table>
	';

	//-------------------------------------	
	// Try to see what tabs are visibles (if we are in restricted view of course)
	$discussIDs = getArrayFromOptions($options, 4);
	
	//---- get discuss objs ----//
	require_once dirname(dirname(__FILE__)) . '/class/root.php';
	$discussion_handler =& Discuss::getHandler('discussion');
	$discussions =& $discussion_handler->getObjects();
	if (!$discussions) { return $form; }

	$form .= '<br />' . _MB_DISCUSS_SELECT . '<br /><select name="options[]" multiple="multiple">';
	foreach ($discussions as $discussion_object) {
		$discuss_id = $discussion_object->getVar('discuss_id');
		$subject = $discussion_object->getVar('subject') ;
		if ( in_array( $discuss_id , $discussIDs) ) {
				$sel = ' selected="selected"';
		} else {
				$sel = '';
		}
		$form .= '<option value="' . $discuss_id . '"' . $sel . '>' . $discuss_id . ': ' . $subject . '</option>';
	}
	$form .= '</select><br />';
	return $form;
}

function b_discuss_calendar_show($options)
{
	$block_outdata = array();
	$block_outdata['dayofweek'] = array( _MB_DISCUSS_SUNDAY, _MB_DISCUSS_MONDAY, _MB_DISCUSS_TUESDAY,
		_MB_DISCUSS_WEDNESDAY, _MB_DISCUSS_THURSDAY, _MB_DISCUSS_FRIDAY, _MB_DISCUSS_SATURDAY);

 	return $block_outdata;
}

function b_discuss_calendar_edit($options)
{
	//---- init option ----//
	$mydirname = empty($options[0]) ? '?' : $options[0];
	if (preg_match('/[^0-9a-zA-Z_-]/', $mydirname) || !file_exists(XOOPS_ROOT_PATH . "/modules/{$mydirname}/xoops_version.php")) {
		$block_handler =& xoops_gethandler('block');
		$block =& $block_handler->get(intval($_GET['bid']));
		$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->get($block->getVar('mid'));
		$mydirname = $module->getVar('dirname');
	}

	$form = '<input type="hidden" name="options[0]" value="' . $mydirname . '" />';
	return $form;
}

?>