<?php
/**
 * @version $Id$
 */
require_once DISCUSS_PATH . '/class/general/context.php';

class DiscussControllerBackend
{
    /**
     * @var string
     */
    var $_control;

    /**
     * @var object
     */
    var $context;

    /**
     * @var string
     */
    var $errorMsg = '';

    function DiscussControllerBackend()
    {
        $this->_control = preg_replace("/discusscontroller/i","", get_class($this));
    }

    /**
     * @return string
     */
    function getError()
    {
        if (defined('DISCUSS_DEBUG') && DISCUSS_DEBUG) {
            return $this->errorMsg;
        } else {
            return '';
        }
    }

    /**
     * @return void
     */
    function execute()
    {
        if (!isset($this->viewName)) {
            $this->viewName = $this->_control;
        }
        $view =& $this->load($this->viewName, 'view');

        if ($this->action($view)) {
            $view->render();
        } else {
            header('HTTP/1.1 503 Service Unavailable');
            exit( $this->getError() );
        }
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {
        $handler_attendee =& $this->load('attendee');
        if (!$attendee =& $handler_attendee->get($this->context)) {
            return false;
        }
        $view->setEnv('', $attendee->get('timeoffset'));

        $handler =& $this->load($this->_control);
        if ($handler->assign($view, $this->context)) {
            return true;
        } else {
            $this->errorMsg = $handler->getErrors();
            return false;
        }
    }

    /**
     * @param string $name
     * @param string[optinal] $type
     * @return mixed
     */
    function &load($name, $type = 'model')
    {
        require_once DISCUSS_PATH . '/class/' . $type . '/' . strtolower($name) . '.php';
        $class = 'Discuss' . ucfirst($type) . ucfirst($name);
        $instance =& new $class();
        return $instance;
    }

    /**
     * @param DiscussDiscussion[reference] $discussion
     * @param DiscussUser[reference] $user
     * @return boolean
     */
    function checkPermission(&$discussion, &$user)
    {
        if ($discussion->get('perm_type') == 0) {
            return true;
        }
        if ($user->get('uid') > 0) {
            if ($discussion->get('perm_type') == 1) {
                return true;
            } else {
                $permission =& $this->load('permission');
                if ($permission->isPermited($this->context, $user)) {
                    return true;
                }
                $this->errorMsg = $permission->getErrors();
            }
        }
        return false;
    }
}
?>