<?php
/**
 * Leave from discussion
 * @version $Id$
 */
require_once dirname(__FILE__ ) . '/backend.php';

class DiscussControllerLeave extends DiscussControllerBackend
{
    /**
     * Constructor
     */
    function DiscussControllerLeave()
    {
        $this->_control = 'leave';

        $this->context =& new DiscussGeneralContext();
        $this->context->accept('discuss_id', 'd');
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {
        $attendee =& $this->load('attendee');
        if (!$attendee->leave($this->context)) {
            $this->errorMsg = $attendee->getErrors();
            return false;
        }

        //Notify participant that I've left from discussion.
        $member =& $this->load('member', 'view');
        $member->set('x', 'L');
        $member->set('sess_id', session_id());

        $ticket = null;
        $discussion =& $this->load('discussion');
        if ($discussion->cache($this->context, $member, $ticket)) {
            return true;
        } else {
            $this->errorMsg = $discussion->getErrors();
            return false;
        }
    }
}
?>