<?php
/**
 * @version $Id$
 */
require_once dirname(__FILE__ ) . '/backend.php';

class DiscussControllerMessage extends DiscussControllerBackend
{
    /**
     * Constructor
     */
    function DiscussControllerMessage()
    {
        $this->_control = 'message';

        $this->context =& new DiscussGeneralContext();
        $this->context->filter('discuss_id', 'd');
        $this->context->filter('start', 's');
        $this->context->filter('prev', 'p');
        $this->context->filter('year', 'y');
        $this->context->filter('month', 'm');
        $this->context->filter('day', 'e');
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {
        $handler_attendee =& $this->load('attendee');
        if (!$attendee =& $handler_attendee->get($this->context)) {
            return false;
        }

        $handler =& $this->load('message');
        if ($this->context->get('year') && $this->context->get('month') && $this->context->get('day')) {
            if ($handler->assignByDate($view, $this->context)) {
                return true;
            }
        } else {
            if ($handler->assign($view, $this->context)) {
                return true;
            }
        }
        $this->errorMsg = $handler->getErrors();
        return false;
    }
}
?>