<?php
/**
 * Post message
 *
 * @version $Id$
 */
require_once dirname(__FILE__ ) . '/backend.php';

class DiscussControllerPost extends DiscussControllerBackend
{
    /**
     * Constructor
     */
    function DiscussControllerPost()
    {
        $this->_control = 'post';

        $this->context =& new DiscussGeneralContext();
        $this->context->accept('discuss_id', 'd');
        $this->context->accept('color', 'c');
        $this->context->accept('message', 'm', 'string');
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {
        //validity session
        $handler_attendee =& $this->load('attendee');
        $attendee =& $handler_attendee->getActive($this->context);
        if (!$attendee) {
            $this->errorMsg = $handler_attendee->getErrors();
            return false;
        }

        $message =& $this->load('message');
        $message_id = $message->insertMessage($this->context, $attendee);
        if ($message_id == 0) {
            $this->errorMsg = $message->getErrors();
            return false;
        }

        //Write message to cache file.
        $view->setEnv(DISCUSS_DATE_SHORT, $attendee->get('timeoffset'));
        $view->set('message_id', $message_id);
        $view->set('uname', $attendee->get('uname'));
        $view->set('message', $this->context->get('message'));
        $view->set('timestamp', time());
        $view->set('color', $this->context->get('color'));

        $ticket = null;
        $discussion =& $this->load('discussion');
        if ($discussion->cache($this->context, $view, $ticket)) {
            return true;
        } else {
            $this->errorMsg = $discussion->getErrors();
            return false;
        }
    }
}
?>