<?php
/**
 * @version $Rev: 269 $
 * @link $URL: https://ajax-discuss.svn.sourceforge.net/svnroot/ajax-discuss/discuss/trunk/class/general/context.php $
 */
class DiscussGeneralContext
{
    /**
     * @var array
     * @access private
     */
    var $_vars;

    function DiscussGeneralContext()
    {
        $this->_vars = array();
    }

    /**
     * @return void
     */
    function accept($name, $key, $type = 'int')
    {
        switch ($type) {
        case 'int':
            $this->_vars[$name] = isset($_POST[$key]) ? intval($_POST[$key]) : 0;
            break;
        case 'string':
            if (!isset($_POST[$key])) {
                $this->_vars[$name] = '';
                break;
            }

            $value = $_POST[$key];
            if (get_magic_quotes_gpc()) {
                $value = stripslashes($value);
            }
            $value = DiscussEncoder::fromUtf8($value);
//            $this->_vars[$name] = preg_replace("/[\\x00-\\x1f]/", '', $value);
            $this->_vars[$name] = preg_replace("/[\\x00-\\x08]|[\\x0b-\\x0c]|[\\x0e-\\x1f]/", '', $value);
        }
    }

    /**
     * @param string $key
     * @return mixed
     */
    function get($key, $default = 0)
    {
        return isset($this->_vars[$key]) ? $this->_vars[$key] : $default;
    }

    /**
     * @return void
     */
    function filter($name, $key)
    {
        $this->_vars[$name] = isset($_GET[$key]) ? intval($_GET[$key]) : 0;
    }
}
?>