<?php
/**
 * Class for cached log file
 * client access this cache file directly to get loged message
 *
 * @version $Id$
 */
class DiscussLibCache
{
	/**
	 * cache expire date time
	 *
	 * @var int
	 */
	var $expiry_time;

	/**
	 * token to access cache file
	 *
	 * @var string
	 */
	var $access_key;

	/**
	 * cache file path
	 *
	 * @var string
	 */
	var $_filepath;

	/**
	 * cache file is new ganerated now
	 *
	 * @var boolean
	 */
	var $generated;

	/**
	 * @param DiscussRecordDiscussion $discussion
	 */
	function DiscussLibCache(&$discussion)
	{
		$this->expiry_time = $discussion->get('key_term');
		$this->access_key = $discussion->get('access_key');
		$this->formatFilepath();
	}

	/**
	 * @return void
	 */
	function formatFilepath()
	{
		$format = defined('DISCUSS_CACHE_NAME') ? DISCUSS_CACHE_NAME : '/log/%s.json';
		$this->_filepath = DISCUSS_PATH . sprintf($format, $this->access_key);
	}

	/**
	 * @return boolean
	 */
	function conect()
	{
		$lifetime = defined('DISCUSS_CACHE_LIFETIME') ? DISCUSS_CACHE_LIFETIME : 1800;
		if (time() >= $this->expiry_time ||
			@filectime($this->_filepath) <= time() - $lifetime) {

			if (file_exists($this->_filepath) && !$this->delete()) {
				return false;
			}
			$this->access_key = md5(uniqid(mt_rand(), true));
			$this->expiry_time = time() + $lifetime;
			$this->formatFilepath();
			$this->generated = true;
		} else {
			if (!file_exists($this->_filepath) && !$this->touch()) {
				return false;
			}
			$this->generated = false;
		}
		return true;
	}

	/**
	 * @return boolean
	 */
	function isGenarated()
	{
		return $this->generated;
	}

	/**
	 * @return boolean
	 */
	function touch()
	{
		$i = 0;
		while (!@touch($this->_filepath)) {
			if ($i++ > 2) {
				return false;
			}
			$k = rand(0, 10);
			usleep(round($k*100000));//100 miliseconds
		}
		return true;
	}

	function delete()
	{
		$i = 0;
		while (!@unlink($this->_filepath)) {
			clearstatcache();
			if (!file_exists($this->_filepath) || $i++ > 2) {
				//other conection delete file.
				return false;
			}
			$k = rand(0, 10);
			usleep(round($k*100000));//100 miliseconds
		}
		return true;
	}

	/**
	 * Write in cache file
	 *
	 * @param string $contents
	 * @return boolean
	 */
	function write($contents)
	{
		$i = 0;
		while (!$fp = @fopen($this->_filepath, "ab")) {
			if ($i++ > 2) {
				return false;
			}
			$k = rand(0, 10);
			usleep(round($k*100000));//100 miliseconds
		}
		set_file_buffer($fp, 0);

		$ret = true;
		$i = 0;
		while (!fwrite($fp, $contents . "\n")) {
			if ($i++ > 2) {
				$ret = false;
				break;
			}
			$k = rand(0, 10);
			usleep(round($k*100000));//100 miliseconds
		}

		$i = 0;
		while (!fclose($fp)) {
			if ($i++ > 2) {
				return false;
			}
			$k = rand(0, 10);
			usleep(round($k*100000));//100 miliseconds
		}
		return $ret;
	}

	/**
	 * Return cache file infomation
	 */
	function assignInfo(&$view)
	{
		$size = filesize($this->_filepath);
		$mod = gmdate('r', filemtime($this->_filepath));

		$format = defined('DISCUSS_CACHE_NAME') ? DISCUSS_CACHE_NAME : '/log/%s.json';
		$url =  DISCUSS_URL . sprintf($format, $this->access_key);

		$view->incObject('key');
		$view->set('url', $url);
		$view->set('expiry_time', $this->expiry_time * 1000);
		$view->set('mod', $mod);
		$view->set('size', $size - 1);
		$view->endObject();
	}
}
?>