<?php
/**
 * @version $Rev: 269 $
 * @link $URL: https://ajax-discuss.svn.sourceforge.net/svnroot/ajax-discuss/discuss/trunk/class/lib/user.php $
 */
class DiscussUser
{
	/**
	 * @var array
	 * @access private
	 */
	var $_vars;

	/**
	 * @var array
	 * @access private
	 */
	var $_groups;

	function DiscussUser()
	{
		$this->_vars = array('uid'=>0, 'uname'=>'');
	}

	/**
	 * @param array $var_arr
	 * @return void
	 */
	function set($key, $value)
	{
		$this->_vars[$key] =& $value;
	}

	/**
	 * @param string $key
	 * @return string
	 */
	function get($key)
	{
		return isset($this->_vars[$key]) ? $this->_vars[$key] : null;
	}

	function getGroups()
	{
		return $this->_groups;
	}
}

/**
 * @version $Id$
 */
class DiscussLibUser
{
	function &create($context)
	{
		$user =& new DiscussUser();
		$user->_groups = array(XOOPS_GROUP_ANONYMOUS);

		if (is_object($GLOBALS['xoopsUser'])) {
			$user->set('uid', $GLOBALS['xoopsUser']->getVar('uid'));
			if ($GLOBALS['xoopsModuleConfig']['show_realname'] && strlen($GLOBALS['xoopsUser']->getVar('name', 'n')) > 0) {
				$user->set('uname', $GLOBALS['xoopsUser']->getVar('name', 'n'));
			} else {
				$user->set('uname', $GLOBALS['xoopsUser']->getVar('uname', 'n'));
			}
			$timeoffset = $GLOBALS['xoopsUser']->getVar("timezone_offset");
			$user->set('timeoffset', intval($timeoffset) - $GLOBALS['xoopsConfig']['server_TZ']);
			$user->_groups = $GLOBALS['xoopsUser']->getGroups();
		}
		elseif (!empty($_SESSION['discussUname'])) {
			$user->set('uname', $_SESSION['discussUname']);
		}
		else {
			$uname = preg_replace("/\\x09|\\x0a|\\x0d/", '', $context->get('guestname', ''));
			if ($uname != '') {
			    $uname = $this->convert_trip($uname);
			    $user->set('uname', $uname);
			    $_SESSION['discussUname'] = $uname;
            } else {
                $user->set('uname', $GLOBALS['xoopsConfig']['anonymous']);
            }
		}
        if ($user->get('timeoffset') == null) {
			$user->set('timeoffset', $GLOBALS['xoopsConfig']['default_TZ'] - $GLOBALS['xoopsConfig']['server_TZ']);
		}
		return $user;
	}

	/**
	 * add identifiable word to user name
	 *
	 * @author nao-pon
	 * @param string $val
	 * @return string
	 */
	function convert_trip($val)
	{
		if (preg_match('/([^#]+)#(.+)/', $val, $matches)) {
			$name = $matches[1];
			$key = $matches[2];
			$salt = substr($key.'H.', 1, 2);
			$salt = strtr($salt,':;<=>?@[\]^_`','ABCDEFGabcdef');
			$salt = preg_replace('/\W/', '.', $salt);
			$trip = substr(crypt($key, $salt), -10);
			return $name .'#'. $trip;
		} else {
			return $val .'#';
		}
	}
}
?>