<?php
/**
 * @version $Id$
 */
require_once DISCUSS_PATH . '/class/general/model.php';

class DiscussRecordDiscussion extends DiscussGeneralRecord
{
	/**
	 * @return boolean
	 */
	function isOpen()
	{
		if ( !$this->vars['closed']
		 && ($this->vars['close_time'] == 0 || time() < $this->vars['close_time'])
		 && time() > $this->vars['open_time'] ) {
			return true;
		}
		return false;
	}
}

class DiscussModelDiscussion extends DiscussGeneralModel
{
	/**
	 * @var string
	 * @access private
	 */
	var $tableName = 'discuss';

	/**
	 * @var string
	 * @access private
	 */
	var $record = 'DiscussRecordDiscussion';

	/**
	 * @param DiscussContext[reference] $context
	 * @return string
	 */
	function key2where(&$context)
	{
		return sprintf('`discuss_id`=%u', $context->get('discuss_id'));
	}

	/**
	 * @param DiscussContext[reference] $context
	 * @param DiscussView[reference] $data_object
	 * @param DiscussView[reference] $ticket
	 * @return boolean
	 */
	function cache(&$context, &$data_object, &$ticket)
	{
		$discussion =& $this->get($context);

		require_once DISCUSS_PATH .'/class/lib/cache.php';
		$cache =& new DiscussLibCache($discussion);

		if (!$discussion->isOpen()) {
			$cache->delete();
			$this->_errors[] = _MD_DISCUSS_CLOSED;
			return false;
		}

		$counter = 0;
		while (!$cache->conect()) {
			if ($counter++ > 2) {
				$this->_errors[] = 'Missing OR cannot delete cache file';
				return false;
			}
			$k = rand(0, 10);
			usleep(round($k*100000));//100 miliseconds
		}

		if ($cache->isGenarated()) {
			$format = '`access_key`=%s, `key_term`=%u WHERE `discuss_id`=%u';
			$sql = sprintf($format, $this->db->quoteString($cache->access_key),
				 $cache->expiry_time, $context->get('discuss_id'));

			if (!$this->update($sql) || !$cache->touch()) {
				$this->_errors[] = 'Cannot make cache file';
				return false;
			}
		}

		if ($data_object && !$cache->write($data_object->getEncoded())) {
			$this->_errors[] = 'Cache write error';
			return false;
		}

		if ($ticket) {
			$cache->assignInfo($ticket);
		}
		return true;
	}
}
?>