<?php
/**
 * @version $Id$
 */
require_once DISCUSS_PATH . '/class/general/model.php';

class DiscussModelMessage extends DiscussGeneralModel
{
    /**
     * Database table name
     *
     * @var string
     */
    var $tableName = 'discuss_message';

    /**
     * @param DiscussContext[reference] $context
     * @param DiscussGeneralRecord[reference] $user
     * @return int $message_id
     */
    function insertMessage(&$context, &$user)
    {
        $format = '(`discuss_id`, `message_id`, `uid`, `uname`, `message`, `timestamp`, `color`, `ip`)';
        $format .= ' VALUES (%u, %u, %u, %s, %s, %u, %u, %s)';

        $sql = sprintf($format, $context->get('discuss_id'), $this->db->genId('discuss_message_id_seq'),
             $user->get('uid'), $this->db->quoteString($user->get('uname')),
             $this->db->quoteString($context->get('message')), time(),
             $context->get('color'), $this->db->quoteString($_SERVER['REMOTE_ADDR']));

        if ($this->insert($sql)) {
            return $this->db->getInsertId();
        } else {
            return 0;
        }
    }

    /**
     * @param DiscussView[reference] $view
     * @param DiscussContext[reference] $context
     * @param int $limit
     * @return bool
     */
    function assign(&$view, &$context, $limit = 30)
    {
        $start = $context->get('start');
        switch (true) {
        case ($start == 0):
            $condition = '';
            $order = ' DESC';
            break;

        case $context->get('prev'):
            $condition = " AND `message_id`<{$start}";
            $order = ' DESC';
            break;

        default:
            $condition = " AND `message_id`>={$start}";
            $order = '';
        }
        $format = 'SELECT * FROM `%s` WHERE `discuss_id`=%u%s ORDER BY `message_id`%s';
        $sql = sprintf($format, $this->db->prefix($this->tableName),
             $context->get('discuss_id'), $condition, $order);

        return $this->assignObjects($view, $sql, $limit);
    }

    /**
     * @param DiscussView[reference] $view
     * @param DiscussContext[reference] $context
     * @return bool
     */
    function assignbyDate(&$view, &$context)
    {
        $format = 'SELECT * FROM `%s` WHERE `discuss_id`=%u AND FROM_UNIXTIME(`timestamp`, \'%s\')=%04d%02d%02d ORDER BY `message_id`';
        $sql = sprintf($format, $this->db->prefix($this->tableName),
             $context->get('discuss_id'), '%Y%m%d', $context->get('year'), $context->get('month'), $context->get('day'));

        return $this->assignObjects($view, $sql, 30);
    }

    /**
     * @param DiscussView[reference] $view
     * @param DiscussContext[reference] $context
     * @param int $limit
     * @return bool
     */
    function assignNavigation(&$view, &$context, $limit = 12)
    {
        switch ($context->get('nav')) {
        case 2:
            $grouping = '%y%m';
            $dateformat = DISCUSS_DATE_MONTH;
            break;
        case 1:
            $grouping = '%y%m%d';
            $dateformat = DISCUSS_DATE_DAY;
            break;
        default:
            $grouping = '%y%m%d%H';
            $dateformat = DISCUSS_DATE_HOUR;
        }
        $view->setEnv($dateformat);

        $prev = $context->get('prev');
        $start = $context->get('start');
        switch (true) {
        case ($prev == 1 && $start == 1):
            return true;

        case ($prev == 1 && $start > 0):
            $condition = " AND `message_id`<{$start}";
            $order = ' DESC';
            break;

        case ($start > 0):
            $condition = " AND `message_id`>={$start}";
            $order = '';
            break;

        default:
            $condition = '';
            $order = ' DESC';
        }
        $format = 'SELECT MIN(`message_id`) AS id, MIN(`timestamp`) AS ts FROM `%s` WHERE `discuss_id`=%u%s GROUP BY FROM_UNIXTIME(`timestamp`, \'%s\')%s';
        $sql = sprintf($format, $this->db->prefix($this->tableName), $context->get('discuss_id'), $condition, $grouping, $order);

        return $this->assignObjects($view, $sql, $limit);
    }

    /**
     * @param DiscussView[reference] $view
     * @param DiscussContext[reference] $context
     * @return bool
     */
    function assignDays(&$view, &$context)
    {
        $year = ($context->get('year') > 0) ? $context->get('year') : date('Y');
        $month = ($context->get('month') > 0) ? $context->get('month') : date('m');
        
        $format = 'SELECT FROM_UNIXTIME(`timestamp`, \'%s\') AS day FROM `%s` WHERE `discuss_id`=%u AND FROM_UNIXTIME(`timestamp`, \'%s\')=%04d%02d GROUP BY FROM_UNIXTIME(`timestamp`, \'%s\')';
        $sql = sprintf($format, '%e', $this->db->prefix($this->tableName), $context->get('discuss_id'), '%Y%m', $year, $month, '%y%m%d');

        return $this->assignObjects($view, $sql);
    }

    /**
     * @param DiscussView[reference] $view
     * @param DiscussContext[reference] $context
     * @return bool
     */
    function assignMonths(&$view, &$context)
    {
        $format = 'SELECT FROM_UNIXTIME(`timestamp`, \'%s\') AS month FROM `%s` WHERE `discuss_id`=%u GROUP BY month';
        $sql = sprintf($format, '%Y%m', $this->db->prefix($this->tableName), $context->get('discuss_id'));

        return $this->assignObjects($view, $sql);
    }

    /**
     * @param DiscussView[reference] $view
     * @param DiscussContext[reference] $context
     * @return bool
     */
    function search(&$view, &$context)
    {
        $sql = 'SELECT * FROM `';
        $sql .= $this->db->prefix($this->tableName);
        $sql .= '` WHERE `discuss_id`=';
        $sql .= $context->get('discuss_id');

        $queryarray = $context->get('queryarray');
        $count = count($queryarray);

        $andor = ($context->get('andor') == 1) ? 'OR' : 'AND';

        $sql .= ' AND (message LIKE ';
        $sql .= $this->db->quoteString('%' . $queryarray[0] . '%');
        for ($i = 1; $i < $count; $i++) {
            $sql .= " $andor message LIKE ";
            $sql .= $this->db->quoteString('%' . $queryarray[0] . '%');
        }
        $sql .= ') ORDER BY `message_id` DESC';

        return $this->assignObjects($view, $sql, 20, $offset);
    }
}
?>