<?php
/**
 * Class for permission control
 * @version $Id$
 */
require_once DISCUSS_PATH . '/class/general/model.php';

class DiscussModelPermission extends DiscussGeneralModel
{
	/**
	 * Database table name
	 *
	 * @var string
	 */
	var $tableName = 'discuss_permission';

	/**
	 * @param DiscussContext[reference] $context
	 * @param DiscussUser[reference] $user
	 * @return boolean
	 */
	function isPermited(&$context, &$user)
	{
		$format = '`discuss_id`=%u AND `uid`=%s AND `perm`=1';
		$where = sprintf($format, $context->get('discuss_id'), $user->get('uid'));

		if ($this->getCount($where) == 1) {
			//allow only users who is registered on whitelist.
			return true;
		}
		return false;
	}
}
?>