<?php
/**
 * @version $Id$
 */
if (!class_exists('DiscussPermission')) {
require_once DISCUSS_PATH . '/class/general/xoopstableobject.php';

class DiscussPermission extends XoopsTableObject
{
	function DiscussPermission()
	{
		// call parent constructor
		$this->XoopsTableObject();
		
		// define object elements
		$this->initVar('discuss_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('uid', XOBJ_DTYPE_INT, null, true);
		$this->initVar('perm', XOBJ_DTYPE_INT, null, true);

		// define primary key
		$this->setKeyFields(array('discuss_id','uid'));
	}
}

class DiscussPermissionHandler extends XoopsTableObjectHandler
{
	/**
	 * database table name
	 *
	 * @var string
	 */
	var $tableName = 'discuss_permission';

	/**
	 * Return user's allowed discussion ids
	 *
	 * @param int $uid
	 * @return array of int discuss_id
	 */
	function getPermittedDiscussIds($uid)
	{
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('uid', $uid));
		$criteria->add(new Criteria('perm', 0, '>'));

		$discussIds = array();
		if ($result =& $this->open($criteria)) {
			while ($myrow = $this->db->fetchArray($result)) {
				$discussIds[] = intval($myrow['discuss_id']);
			}
		}
		return $discussIds;
	}
}
}//end of if
?>