<?php
/**
 * @version $Rev: 269 $
 * @link $URL: https://ajax-discuss.svn.sourceforge.net/svnroot/ajax-discuss/discuss/trunk/class/root.php $
 */
$mydirname = basename(dirname(dirname(__FILE__)));
define('DISCUSS_PATH', XOOPS_ROOT_PATH . "/modules/{$mydirname}");
define('DISCUSS_URL', XOOPS_URL . "/modules/{$mydirname}");

if (file_exists(DISCUSS_PATH . '/settings/definition.inc.php')) {
	include_once DISCUSS_PATH . '/settings/definition.inc.php';
}
if (!defined('DISCUSS_DATE_SHORT'))    define('DISCUSS_DATE_SHORT', 'H:i');
if (!defined('DISCUSS_DATE_LONG'))     define('DISCUSS_DATE_LONG', 'm/d H:i');
if (!defined('DISCUSS_STAY_INTERVAL')) define('DISCUSS_STAY_INTERVAL', 60);

class Discuss
{
	/**
	 * @var string
	 */
	var $_controller;

	function Discuss()
	{
		$this->_controller = '';
		$pathinfo_index = isset($_SERVER['ORIG_PATH_INFO']) ? 'ORIG_PATH_INFO' : 'PATH_INFO';
		if (isset($_SERVER[$pathinfo_index])) {
			$path_info = explode('/', trim($_SERVER[$pathinfo_index], '/'));
			if ($count = count($path_info)) {
                $this->_controller = $path_info[$count - 1];
			}
		}
		if (strlen($this->_controller) == 0 || $this->_controller == 'index.php') {
			$this->_controller = 'main';
		}
	}

	/**
	 * @return boolean
	 */
	function route()
	{
		switch ($this->_controller) {
		case 'stay':
		case 'leave':
		case 'post':
		case 'message':
		case 'days':
		case 'months':
		case 'attendee':
		case 'renew':
			if (!defined('DISCUSS_DEBUG') || !DISCUSS_DEBUG) {
				error_reporting(0);
			}
			ini_set('mbstring.http_input', 'pass');
			ini_set('mbstring.http_output', 'pass');
			if (function_exists('mb_http_output')) {
				mb_http_output('pass');
			}
			$this->_minimumCommon();
			return 'ajax';

		case 'join':
		case 'open':
			$this->_loadEncoder($GLOBALS['xoopsConfig']);
			return 'ajax';

		case 'main':
		case 'log':
			return 'main';

		default:
			exit('Invalid controller.');
		}
	}

	/**
	 * @return string
	 */
	function templateName()
	{
		return "discuss_{$this->_controller}.html";
	}

	function execute()
	{
		require_once DISCUSS_PATH . "/class/controller/{$this->_controller}.php";
		$className = 'DiscussController' . ucfirst($this->_controller);
		$instance =& new $className();
		$instance->execute();
	}

	function executeAdmin()
	{
		$allowed = array('main', 'discussion', 'attendee', 'message', 'permission', 'test');
		if (in_array($this->_controller, $allowed)) {
			require_once DISCUSS_PATH . "/admin/controller/{$this->_controller}.php";
			$className = 'Discuss' . ucfirst($this->_controller) . 'AdminController';
			$instance =& new $className();
			$instance->execute();
		} else {
			exit(htmlspecialchars($this->_controller, ENT_QUOTES));
		}
	}

	/**
	 * @param string $name
	 * @return XoopsTableObjectHandler[reference]
	 * @static
	 */
	function &getHandler($name)
	{
		static $handlers;
		if (!isset($handlers['discuss'][$name])) {
			require_once DISCUSS_PATH . "/class/{$name}.php";
			$className = 'Discuss'. ucfirst($name) .'Handler';
			$handlers['discuss'][$name] =& new $className($GLOBALS['xoopsDB']);
		}
		return $handlers['discuss'][$name];
	}

	function _minimumCommon()
	{
		$this->_setupDB();

		require_once DISCUSS_PATH . '/class/model/config.php';
		$config =& DiscussModelConfig::getConfigs();

		require_once DISCUSS_PATH . '/class/lib/session.php';
		DiscussLibSession::start($config);

		$this->_loadEncoder($config);

		$filename = XOOPS_ROOT_PATH . '/modules/legacy/language/' . $config['language'] . '/charset_' . XOOPS_DB_TYPE . '.php';
		if (file_exists($filename)) {
			$GLOBALS['xoopsDB'] =& XoopsDatabaseFactory::getDatabaseConnection();
			require_once($filename);
		}
	}

	function _setupDB()
	{
		require_once XOOPS_ROOT_PATH . '/class/logger.php';
		require_once XOOPS_ROOT_PATH . '/class/database/databasefactory.php';

		$ref = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
		if ($_SERVER['REQUEST_METHOD'] != 'POST' || $ref == '' || strpos($ref, XOOPS_URL) !== 0 ) {
			define('XOOPS_DB_PROXY', 1);
		}
	}

	function _loadEncoder(&$config)
	{
		if (file_exists(DISCUSS_PATH . '/language/' . $config['language'] . '/encoder.php')) {
			//include language peculiar encoder file if exist.
			require_once DISCUSS_PATH . '/language/' . $config['language'] . '/encoder.php';
		} else {
			require_once DISCUSS_PATH . '/class/lib/encoder.php';
		}
	}
}
?>