<?php
/**
 * Discuss released for developers
 * @version $Rev: 269 $
 * @link $URL: https://ajax-discuss.svn.sourceforge.net/svnroot/ajax-discuss/discuss/trunk/xoops_version.php $
 * @author Discuss Friends
 * @license GPL
 */
$mydirname = basename( dirname( __FILE__ ) ) ;

$modversion['name'] = _MI_DISCUSS_NAME;
$modversion['version'] = 'r269';
$modversion['description'] = _MI_DISCUSS_DESC;
$modversion['credits'] = '';
$modversion['author'] = 'Discuss Friends';
$modversion['help'] = '';
$modversion['license'] = 'GPL';
$modversion['official'] = 0;
$modversion['image'] = 'images/discuss_slogo.png';
$modversion['dirname'] = $mydirname;

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][] = "discuss";
$modversion['tables'][] = "discuss_message";
$modversion['tables'][] = "discuss_attendee";
$modversion['tables'][] = "discuss_permission";

// Admin
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = 'admin/index.php';
$modversion['adminmenu'] = 'admin/admin_menu.php';

// Search
$modversion['hasSearch'] = 1;
$modversion['search']['file'] = 'include/search.inc.php';
$modversion['search']['func'] = 'discuss_global_search';

// Menu
$modversion['hasMain'] = 1;

// Templates
$modversion['templates'] = array();

$modversion['templates'][1] = array(
 'file'		=> 'discuss_main.html',
 'description'	=> 'discuss main'
);

$modversion['templates'][] = array(
 'file'		=> 'discuss_log.html',
 'description'	=> 'discuss log'
);

// Blocks
$modversion['blocks'] = array();

$modversion['blocks'][1] = array(
 'file'		=> 'blocks.php',
 'name'		=> _MI_DISCUSS_BLOCK_ACTIVE,
 'description'	=> _MI_DISCUSS_BLOCK_ACTIVE_DESC,
 'show_func'	=> 'b_discuss_active_show',
 'edit_func'	=> 'b_discuss_active_edit',
 'options'	=> $mydirname .'|30|10',
 'template'	=> 'discuss_block_active.html',
 'can_clone'	=> true
);

$modversion['blocks'][] = array(
 'file'		=> 'blocks.php',
 'name'		=> _MI_DISCUSS_BLOCK_MESSAGES,
 'description'	=> _MI_DISCUSS_BLOCK_MESSAGES_DESC,
 'show_func'	=> 'b_discuss_messages_show',
 'edit_func'	=> 'b_discuss_messages_edit',
 'options'	=> $mydirname .'|30|0|5',
 'template'	=> 'discuss_block_messages.html',
 'can_clone'	=> true
);

$modversion['blocks'][] = array(
 'file'		=> 'blocks.php',
 'name'		=> _MI_DISCUSS_BLOCK_CALENDAR,
 'description'	=> _MI_DISCUSS_BLOCK_CALENDAR_DESC,
 'show_func'	=> 'b_discuss_calendar_show',
 'edit_func'	=> 'b_discuss_calendar_edit',
 'options'	=> $mydirname,
 'template'	=> 'discuss_block_calendar.html',
 'can_clone'	=> false
);

// Config
$modversion['hasconfig'] = 1;
$modversion['config'] = array();

$modversion['config'][] = array(
 'name'		=> 'message_limit',
 'title'	=> '_MI_DISCUSS_LIMIT',
 'description'	=> '_MI_DISCUSS_LIMITDSC',
 'formtype'	=> 'select',
 'valuetype'	=> 'int',
 'default'	=> 10,
 'options'	=> array('10' => 10, '15' => 15, '20' => 20, '25' => 25, '30' => 30)
);

$modversion['config'][] = array(
 'name'		=> 'colors',
 'title'	=> '_MI_DISCUSS_COLORS',
 'description'	=> '_MI_DISCUSS_COLORS_DESC',
 'formtype'	=> 'textarea',
 'valuetype'	=> 'array',
 'default'	=> array('#000000','#dc0000','#4cb5e8'),
 'options'	=> array()
);

$modversion['config'][] = array(
 'name'		=> 'show_realname',
 'title'	=> '_MI_DISCUSS_SHOWNAME',
 'description'	=> '_MI_DISCUSS_SHOWNAME_DESC',
 'formtype'	=> 'yesno',
 'valuetype'	=> 'int',
 'default'	=> 0,
 'options'	=> array()
);

$modversion['onUpdate'] = 'include/onupdate.inc.php';

// On Update
if( ! defined( 'XOOPS_CUBE_LEGACY' ) && substr( XOOPS_VERSION , 6 , 3 ) < 2.1 && ! empty( $_POST['fct'] ) && ! empty( $_POST['op'] ) && $_POST['fct'] == 'modulesadmin' && $_POST['op'] == 'update_ok' && $_POST['dirname'] == $modversion['dirname'] ) {
	include dirname(__FILE__).'/include/x20_keepblockoptions.inc.php' ;
}
?>