<?php
/* $Id: editcompany.php 1 2006-06-07 08:07:41Z hodaka $
 *  ------------------------------------------------------------------------ *
 *                XOOPS - PHP Content Management System                      *
 *                    Copyright (c) 2000 XOOPS.org                           *
 *                       <http://www.xoops.org/>                             *
 *  ------------------------------------------------------------------------ *
 *                     MyAddress - XOOPS addressbook                         *
 *                        <http://www.kuri3.net/>                            *
 *             Copyright (c) 2004 by hodaka <hodaka@kuri3.net>               *
 * ------------------------------------------------------------------------- *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * You may not change or alter any portion of this comment or credits        *
 * of supporting developers from this source code or any supporting          *
 * source code which is considered copyrighted (c) material of the           *
 * original comment or credit authors.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
 */

if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit;

function edit_company( $op, $zipconvert ) {

	global $myts, $xoopsDB, $cattree, $xoopsTpl;
	global $table_addressbook, $table_company, $table_cat, $table_zipcode;
	global $table_relations, $myaddress_numperpage, $myaddress_catorder;
	global $isadmin, $myaddress_mid, $my_uid, $my_groups, $mod_url, $mod_copyright;
	global $pop, $mode, $cid, $c_id;

	if( $zipconvert != "" ) {
		if( $zipconvert == "ziptoadrs" ) {
			$zipselkey = isset($_POST['czipcode']) ? $myts->makeTboxData4Show($_POST['czipcode']) : "";
			$ziparray = zipconvert( $zipconvert, $zipselkey );
		} else {
			$address1 = isset($_POST['caddress1']) ? $myts->makeTboxData4Show($_POST['caddress1']) : "";
			$address2 = isset($_POST['caddress2']) ? $myts->makeTboxData4Show($_POST['caddress2']) : "";
			$zipselkey['address1'] = $address1;
			$zipselkey['address2'] = $address2;
			$ziparray = zipconvert( $zipconvert, $zipselkey );
		}
	} else {
		$ziparray = array();
	}

	$edititems = array(
		'mod_url' => $mod_url,
		'mod_copyright' => $mod_copyright,
		'mode' => $mode,
		'cid' => $cid,
		'op' => $op,
		'pop' => $pop,
		'c_id' => $c_id
	);

	if ( $op == "add" ) {
		//-----------------------------------------------------------------//
		//                     to add a new company profile                //
		//-----------------------------------------------------------------//

		$heading = _MD_MYADDRESS_ADDCOMPANY;
		$c_id = 0;
		$cname = isset($_POST['cname']) ? $myts->makeTboxData4Edit($_POST['cname']) : "" ;
		$cname_jh = isset($_POST['cname_jh']) ? $myts->makeTboxData4Edit($_POST['cname_jh']) : "" ;
		$cdivision = isset($_POST['cdivision']) ? $myts->makeTboxData4Edit($_POST['cdivision']) : "" ;
		$czipcode = isset($_POST['czipcode']) ? $myts->makeTboxData4Edit($_POST['czipcode']) : "" ;
		$caddress1 = isset($_POST['caddress1']) ? $myts->makeTboxData4Edit($_POST['caddress1']) : "" ;
		$caddress2 = isset($_POST['caddress2']) ? $myts->makeTboxData4Edit($_POST['caddress2']) : "" ;
		$caddress3 = isset($_POST['caddress3']) ? $myts->makeTboxData4Edit($_POST['caddress3']) : "" ;
		$cphone = isset($_POST['cphone']) ? $myts->makeTboxData4Edit($_POST['cphone']) : "" ;
		$cfax = isset($_POST['cfax']) ? $myts->makeTboxData4Edit($_POST['cfax']) : "" ;
		$cweb = isset($_post['cweb']) ? $myts->makeTboxData4Edit($_POST['cweb']) : "http://" ;
		$ccomments = isset($_POST['ccomments']) ? $myts->makeTareaData4Edit($_POST['ccomments']) : "" ;
		$updated = "";

	} elseif ( $op == "edit" ) {
		//-----------------------------------------------------------------//
		//                     to update company profile                  //
		//-----------------------------------------------------------------//

		$heading = _MD_MYADDRESS_EDITCOMPANY;
		if ( $zipconvert == "" ) {
			$sql = "SELECT c_id, cdivision, cid, cname, cname_jh, czipcode, caddress1, caddress2, caddress3, cphone, cfax, cweb, ccomments, updated FROM $table_company WHERE c_id=$c_id";
			$result = $xoopsDB->query( $sql );
			list( $c_id, $cdivision, $cid, $cname, $cname_jh, $czipcode, $caddress1, $caddress2, $caddress3, $cphone, $cfax, $cweb, $ccomments, $updated ) = $xoopsDB->fetchRow( $result );
		} else {
			$c_id = $_POST['c_id'];
			$cname = $myts->makeTboxData4Edit($_POST['cname']);
			$cname_jh = $myts->makeTboxData4Edit($_POST['cname_jh']);
			$cdivision = $myts->makeTboxData4Edit($_POST['cdivision']);
			$czipcode = $myts->makeTboxData4Edit($_POST['czipcode']);
			$caddress1 = $myts->makeTboxData4Edit($_POST['caddress1']);
			$caddress2 = $myts->makeTboxData4Edit($_POST['caddress2']);
			$caddress3 = $myts->makeTboxData4Edit($_POST['caddress3']);
			$cphone = $myts->makeTboxData4Edit($_POST['cphone']);
			$cfax = $myts->makeTboxData4Edit($_POST['cfax']);
			$cweb =  $myts->makeTboxData4Edit($_POST['cweb']);
			$ccomments = $myts->makeTareaData4Edit($_POST['ccomments']);
			$updated = $_POST['updated'];
		}
	}

		// some hidden items
		$edititems['mode'] = $mode;
		$edititems['pop'] = $pop;
		$edititems['cid'] = $cid;
		$edititems['op'] = $op;
		$edititems['c_id'] = $c_id;

		$edititems['lang_editcompany'] = $heading;

		$edititems['lang_cat_title'] = _MD_MYADDRESS_CATEGORY;
		$tree = $cattree->getChildTreeArray( 0, $myaddress_catorder );
		$tree = push_gperm_array( $tree, "myadrs_category" );
		$cidselbox = array();
		foreach( $tree as $leaf ) {
			$leaf['prefix'] = substr($leaf['prefix'], 0, -1);
			$leaf['prefix'] = str_replace(".","--",$leaf['prefix']);
			$cidselbox['label'] = $leaf['prefix'].$leaf['title'];
			$cidselbox['value'] = $leaf['cid'];
			$cidselboxdata[] = $cidselbox;
		}
		$edititems['cidselboxdata'] = $cidselboxdata;

		$edititems['lang_cname'] = _MD_MYADDRESS_CNAME;
		$edititems['cname'] = $myts->makeTboxData4Edit($cname);

		$edititems['lang_cname_jh'] = _MD_MYADDRESS_FULLNAME_JH;
		$edititems['cname_jh'] = $myts->makeTboxData4Edit($cname_jh);

		$edititems['lang_cdivision'] = _MD_MYADDRESS_DIVISION;
		$edititems['cdivision'] = $myts->makeTboxData4Edit($cdivision);

		//------------------------------------------------------------------//
		//       	     search results of zipcode                            //
		//------------------------------------------------------------------//

		$edititems['zipsearchresult'] = "";
		if ( $zipconvert != "" ) {
			if ( !isset( $ziparray ) || count( $ziparray ) == 0 ) {
				$edititems['zipsearchresult'] = "&nbsp;<B><FONT COLOR='red'>["._MD_MYADDRESS_NOFOUND."]</FONT></B>";
			} elseif ( count( $ziparray ) < 2 ) {
				$czipcode = substr( $ziparray[0]['zipcode'], 0, 3 ) . "-" . substr( $ziparray[0]['zipcode'], 3, 4 );
				$caddress1 = trim( $ziparray[0]['pref'] );
				$caddress2 = trim( $ziparray[0]['address2'] );
			} else {
				if ( $zipconvert == "adrstozip" ) {
// bug fixed at ver.1.1.3
					if (!isset($_SESSION)) $_SESSION = array();
					$_SESSION['adrs1'] = $caddress1;
					$_SESSION['adrs2'] = $caddress2;
//					$edititems['zipsearchresult'] = "&nbsp;<B>[<A HREF=\"javascript:openWithSelfMain('searchmore.php?form=company&amp;adrs1=".$caddress1."&amp;adrs2=".$caddress2."','searchmore',400,400)\">".sprintf( _MD_MYADDRESS_SEARCHMORE, count($ziparray) )."</A>]</B>";
					$edititems['zipsearchresult'] = "&nbsp;<B>[<A HREF=\"javascript:openWithSelfMain('searchmore.php?form=company','searchmore',400,400)\">".sprintf( _MD_MYADDRESS_SEARCHMORE, count($ziparray) )."</A>]</B>";
				} else {
					$edititems['zipsearchresult'] = "&nbsp;<B>[<A HREF=\"javascript:openWithSelfMain('searchmore.php?form=company&amp;zip=".$czipcode."','searchmore',400,400);\">".sprintf( _MD_MYADDRESS_SEARCHMORE, count($ziparray) )."</A>]</B>";
				}
			}
		}
		$edititems['lang_zipcode'] = _MD_MYADDRESS_ZIPCODE;
		$edititems['czipcode'] = $myts->makeTboxData4Edit($czipcode);
		$edititems['lang_searchzip'] = _MD_MYADDRESS_SEARCHZIP;
		$edititems['lang_searchadrs'] = _MD_MYADDRESS_SEARCHADRS;

		$edititems['lang_address1'] = _MD_MYADDRESS_ADDRESS1;
		$edititems['caddress1'] = $myts->makeTboxData4Edit($caddress1);
		$edititems['lang_address2'] = _MD_MYADDRESS_ADDRESS2;
		$edititems['caddress2'] = $myts->makeTboxData4Edit($caddress2);
		$edititems['lang_address3'] = _MD_MYADDRESS_ADDRESS3;
		$edititems['caddress3'] = $myts->makeTboxData4Edit($caddress3);

		$edititems['lang_phonefax'] = _MD_MYADDRESS_PHONEFAX;
		$edititems['lang_cphone'] = _MD_MYADDRESS_PHONE;
		$edititems['lang_cfax'] = _MD_MYADDRESS_FAX;
		$edititems['cphone'] = $myts->makeTboxData4Edit($cphone);
		$edititems['cfax'] = $myts->makeTboxData4Edit($cfax);

		$edititems['lang_web'] = _MD_MYADDRESS_WEB;
		$edititems['cweb'] = $myts->makeTboxData4Edit($cweb);

		$edititems['lang_comments'] = _MD_MYADDRESS_COMMENTS;
		$edititems['ccomments'] = $myts->makeTareaData4Show($ccomments);


		$edititems['lang_updated'] = _MD_MYADDRESS_UPDATED;
		if( $op != "add" ) {
			$rend_updated = convert_timestamp ( $updated );
			$edititems['rend_updated'] = date("Y/m/d H:i:s", $rend_updated);
		}
		$edititems['updated'] = $updated;

		$edititems['lang_add'] = _MD_MYADDRESS_NEW;
		$edititems['lang_back'] = _MD_MYADDRESS_BACK;
		$edititems['lang_update'] = _MD_MYADDRESS_UPDATE;
		$edititems['lang_delete'] = _MD_MYADDRESS_DELETE;

		return $edititems;
}
?>
