<?php
/**
@file
@brief Entry ѥե
*/

require_once "exForm/Form.php";
require_once "exComponent/Input.php";
require_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

class EntryForm extends exAbstractActionForm {
	var $party_;

	function EntryForm(&$party) {
		parent::exAbstractForm();
		$this->party_=&$party;
	}

	function doGet($data) {
		global $xoopsUser;

		if(!is_object($xoopsUser)) {
			$this->msg_[]='Ͽ桼ǤʤƤǤޤ';
		}

		$handler = bxParty::getHandler('entry');

		// õ
		$lid=$this->getPositive($_REQUEST['lid']);
		$this->data_=$handler->get($lid);
		if(!is_object($this->data_))
			$this->data_= $handler->create();

		if($this->data_->isNew()) {
			$this->data_->setVar('id',$this->party_->getVar('id'));
			$this->data_->setVar('uid',$xoopsUser->uid());
			$this->data_->setVar('entry_date',$this->party_->getVar('event_date'));
		}
		else {
			if(!$xoopsUser->isAdmin() && $this->data_->getVar('uid')!=$xoopsUser->uid())
				$this->msg_[]="Խ¤ޤ";
		}
	}
	
	function doPost($data) {
		global $xoopsUser;

		$this->doGet($data);

		$this->data_->setVar('update_date',time());

		$entry_date=exFrame::decodeXoopsFormDateTime($_POST['entry_date']);
		if(!$entry_date) {
			$this->msg_[]='ȥ꡼ͤǤ';
		}
		$this->data_->setVar('entry_date',$entry_date);

		if(!$this->validateMaxLength($_POST['comment'],255)) {
			$this->msg_[]="Ȥ 255 ʸˤƤ";
		}
		$this->data_->setVar('comment',trim($_POST['comment']));

		// ơå(Ūͳ 0 ޤ)
		$status=$this->getPositive($_POST['status']);
		if($status) {
			$handler=&bxParty::getHandler('status');
			$tmp=$handler->get($status);
			if(!is_object($tmp)) {
				$this->msg_[]="ơǤ";
			}
			else {	// ѤɤơɤĴ٤
				if(!($tmp->getVar('status')==_BXPARTY_STATUS_BOTH || $tmp->getVar('status')==_BXPARTY_STATUS_PARTY)) {
					$this->msg_[]="ơǤ";
				}
			}
		}
		$this->data_->setVar('status',$status);

		if(!$this->data_->cleanVars()) {
			$this->msg_=array_merge($this->msg_,$this->data_->getErrors());
		}
	}
}

class EntryInputComponentRender extends exInputComponentRender {
	function render() {
		$handler=bxParty::getHandler('status');
		$criteria=new CriteriaCompo();
		$criteria->add(new Criteria("type",_BXPARTY_STATUS_BOTH));
		$criteria->add(new Criteria("type",_BXPARTY_STATUS_ENTRY),"OR");
		$objs=&$handler->getObjects($criteria,null,'priority');

		$form = new XoopsThemeForm('Entry','entry',$_SERVER['SCRIPT_NAME'],'POST');

		$form->addElement(new XoopsFormHidden('lid',$this->component_->form_->data_->getVar('lid')));
		$form->addElement(new XoopsFormHidden('id',$this->component_->form_->data_->getVar('id')));
		$form->addElement(new XoopsFormDateTime(_MD_BXPARTY_LANG_ENTRY_DATE,'entry_date',15,$this->component_->form_->data_->getVar('entry_date')));

		$sel=new XoopsFormSelect(_MD_BXPARTY_LANG_STATUS,'status',$this->component_->form_->data_->getVar('status'));
		foreach($objs as $o) {
			$sel->addOption($o->getVar('id'),$o->getVar('name'));
		}
		$form->addElement($sel);

		$form->addElement(new XoopsFormText(_MD_BXPARTY_LANG_COMMENT,'comment',64,255,$this->component_->form_->data_->getVar('comment','e')));
		$form->addElement(new XoopsFormButton('SAVE',"submit","submit","submit"));

		$form->display();
	}
}

?>