<?php
/**
 * @package controller
 */
require '../../mainfile.php';

$xoopsOption['template_main'] = 'discuss_log.html';
include XOOPS_ROOT_PATH.'/header.php';

require './class/message.php';
require_once './class/xoopssimplecontroller.php';
require_once './class/mypagenav.php';

class DiscussMessageList extends XoopsTableObjectList
{
	function DiscussMessageList() {
		$this->addElement('message_id', 'No', 1);
		$this->addElement('uname', _POSTEDBY, 100, array('filter'=>true));
		$this->addElement('message',  _MD_DISCUSS_MESSAGE, 500);
		$this->addElement('timestamp',  _MD_DISCUSS_DATE, 100, array('method'=>'time2str', 'format'=>'m/d H:i'));
	}
}

$discuss_id = !empty($_GET["discuss_id"]) ? intval($_GET["discuss_id"]) : 0;
if ($discuss_id == 0) {
	redirect_header(XOOPS_URL."/modules/discuss/index.php",1,'discuss id is not selected.');
}

$start = 0;
if (!empty($_GET['recent'])) {
	$msgobj_h =& xoops_getmodulehandler('message');
	$criteria = new Criteria('discuss_id', $discuss_id);
	if ($count = $msgobj_h->getCount($criteria)) {
		$perpage = 30;
		if ($count > $perpage) {
			$start = intval(($count - 1) / $perpage) * $perpage ;
		}		
	}
}

$controller =& new XoopsSimpleMainController('DiscussMessage', 'discuss_message', _MD_DISCUSS_READLOG);
$controller->setJoin2List('discuss', 'discuss_id', 'discuss_id', 'INNER');
$controller->allowedOp = array('list');
$controller->navclass = 'MyPageNav';
$controller->start = $start;
$controller->execute();

include(XOOPS_ROOT_PATH.'/footer.php');
?>