<?php
/* $Id: draw_functions.php 1 2006-06-07 08:07:41Z hodaka $
 *  ------------------------------------------------------------------------ *
 *                XOOPS - PHP Content Management System                      *
 *                    Copyright (c) 2000 XOOPS.org                           *
 *                       <http://www.xoops.org/>                             *
 *  ------------------------------------------------------------------------ *
 *                     MyAddress - XOOPS addressbook                         *
 *                        <http://www.kuri3.net/>                            *
 *             Copyright (c) 2004 by hodaka <hodaka@kuri3.net>               *
 * ------------------------------------------------------------------------- *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * You may not change or alter any portion of this comment or credits        *
 * of supporting developers from this source code or any supporting          *
 * source code which is considered copyrighted (c) material of the           *
 * original comment or credit authors.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
 */

// return appropriate name from uid
function get_name_from_uid( $uid ) {

	if( $uid > 0 ) {
		$poster = new XoopsUser( $uid );
		$name = $poster->uname();
	} else {
		$name = XOOPS_USER_GUESTNAME;
	}

	return $name ;
}

// change mode
function select_mode( $mode, $cid ) {

	$PHP_SELF = $_SERVER['PHP_SELF'];

	$mode_list = array(
		1 => _MD_MYADDRESS_SEARCHBYNAME,
		2 => _MD_MYADDRESS_SEARCHBYCOMPANY
	);

	$mode_sel = "<FORM ACTION='".$PHP_SELF."' NAME='selmode' METHOD='POST'>"._MD_MYADDRESS_SELECTMODE."&nbsp;<SELECT SIZE=\"1\" NAME=\"mode\" ONCHANGE=\"location='".$PHP_SELF."?cid=".$cid."&amp;mode='+this.options[this.selectedIndex].value\">";

	foreach ($mode_list as $k => $v) {
		$sel = '';
		if ($k == $mode) {
			$sel = ' selected="selected"';
		}
		$mode_sel .= '<OPTION VALUE="'.$k.'"'.$sel.'>'.$v.'</OPTION>';
	}
	$mode_sel .= '</SELECT>';
	$mode_sel .= '<INPUT TYPE=HIDDEN NAME="cid" VALUE="'.$cid.'">';
	$mode_sel .= '</FORM>';
	return 	$mode_sel;
}

function show_searchnav( $mode, $cid, $url="viewcat.php" ) {

	$url .= "?mode=".$mode."&amp;cid=".$cid."&amp;op=search";

	$keyarray = get_keyarray();
	foreach( $keyarray as $key=>$val ) {
		$skeys[] = array( "skey" => $key, "char" => $val);
	}

	$searchnav = array(
		'lang_buttonforsearch' => _MD_MYADDRESS_BUTTONFORSEARCH,
		'action_url' => $url,
		'action_key' => $skeys
	);
	return $searchnav;
}

// get list of sub categories in header space
function get_sub_categories( $mode, $parent_id ) {
	global $xoopsDB, $myts, $table_cat, $myaddress_catorder;
	global $my_groups, $myaddress_mid, $cattree;

	$ret = array() ;

	$crs = $xoopsDB->query( "SELECT cid, title, imgurl FROM $table_cat WHERE pid=$parent_id ORDER BY $myaddress_catorder") or die( "Error: Get Category." );

	while( list( $cid , $title , $imgurl ) = $xoopsDB->fetchRow( $crs ) ) {

		// Show first child of this category
		$subcat = array();
		$arr = $cattree->getFirstChild( $cid , "title" );
		$arr = push_gperm_array( $arr, "myadrs_category" );

		foreach( $arr as $child ) {
			$subcat[] = array(
				'mode' => $mode,
				'cid' => $child['cid'] ,
				'title' => $myts->makeTboxData4Show( $child['title'] ) ,
				'address_small_sum' => get_address_small_sum_from_cat( $mode, $child['cid'] )
			);
		}

		// Category's banner default
		if( $imgurl == "http://" ) $imgurl = '';

		// Total sum of addresses
		$cids = $cattree->getAllChildId( $cid );
		$cids = push_gperm_array( $cids, "myadrs_category" );
		if ( ( haveGperm( $cid, "myadrs_category" ) ) || count( $cids ) > 0 ) {
			array_push( $cids , $cid );
			$address_total_sum = get_address_total_sum_from_cats( $mode, $cids );
			$ret[] = array(
				'mode' => $mode,
				'cid' => $cid,
				'imgurl' => $myts->makeTboxData4Edit( $imgurl ),
				'address_small_sum' => get_address_small_sum_from_cat( $mode, $cid ),
				'address_total_sum' => $address_total_sum,
				'title' => $myts->makeTboxData4Show( $title ),
				'subcategories' => $subcat
			);
		}
	}

	return $ret;
}

// Returns the number of addresses included in a Category
function get_address_small_sum_from_cat( $mode, $cid ) {
	global $xoopsDB , $table_addressbook, $table_company;
	if ($mode == 1) {
		$sql = "SELECT COUNT(aid) FROM $table_addressbook WHERE cid=$cid";
	} elseif ($mode == 2) {
		$sql = "SELECT COUNT(c_id) FROM $table_company WHERE cid=$cid";
	} else {
		$numrows = 0;
		exit;
	}
	$rs = $xoopsDB->query( $sql ) ;
	list( $numrows ) = $xoopsDB->fetchRow( $rs );
	return $numrows;
}

// Returns the number of whole addresses included in a Category
function get_address_total_sum_from_cats( $mode, $cids ) {
	global $xoopsDB , $table_addressbook, $table_company;

	$whr_cid = "cid IN (";
	foreach( $cids as $cat ) {
		$whr_cid .= "$cat,";
	}
	$whr_cid = substr( $whr_cid , 0 , -1 ) . ")";

	if ($mode == 1) {
		$sql = "SELECT COUNT(aid) FROM $table_addressbook WHERE $whr_cid";
	} elseif ($mode == 2) {
		$sql = "SELECT COUNT(c_id) FROM $table_company WHERE $whr_cid";
	} else {
		$numrows = 0;
		exit;
	}
	$rs = $xoopsDB->query( $sql ) ;
	list( $numrows ) = $xoopsDB->fetchRow( $rs );
	return $numrows;
}
?>