<?php
/* $Id: read_configs.php 16 2006-06-08 08:31:06Z hodaka $
 *  ------------------------------------------------------------------------ *
 *                XOOPS - PHP Content Management System                      *
 *                    Copyright (c) 2000 XOOPS.org                           *
 *                       <http://www.xoops.org/>                             *
 *  ------------------------------------------------------------------------ *
 *                     MyAddress - XOOPS addressbook                         *
 *                        <http://www.kuri3.net/>                            *
 *             Copyright (c) 2004 by hodaka <hodaka@kuri3.net>               *
 * ------------------------------------------------------------------------- *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * You may not change or alter any portion of this comment or credits        *
 * of supporting developers from this source code or any supporting          *
 * source code which is considered copyrighted (c) material of the           *
 * original comment or credit authors.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
 */

	if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit;

	global $xoopsConfig, $xoopsDB, $xoopsUser;

	// module information
	$mod_url = XOOPS_URL . "/modules/myaddress";
	$mod_path = XOOPS_ROOT_PATH . "/modules/myaddress";
	$xoopsModule = XoopsModule::getByDirname("myaddress");
	$myaddress_mid = $xoopsModule->getVar('mid');
	$mod_version = $xoopsModule->getVar('version');
	$version = $mod_version / 100;
	$mod_copyright = "<a href='http://www.kuri3.net/' target='_blank'><strong>MyAddress ".$version."</strong></a>";

	// global language file
	$language = $xoopsConfig['language'];
	if ( file_exists( "$mod_path/language/$language/main.php" ) ) {
		include_once "$mod_path/language/$language/main.php";
	} else {
		include_once "$mod_path/language/english/main.php";
		$language = "english" ;
	}

	// read from xoops_config
	// get my mid
//	$rs = $xoopsDB->query( "SELECT mid FROM ".$xoopsDB->prefix('modules')." WHERE dirname='myaddress'" ) ;
//	list( $myaddress_mid ) = $xoopsDB->fetchRow( $rs );
	
	// read configs from xoops_config directly
	$rs = $xoopsDB->query( "SELECT conf_name,conf_value FROM ".$xoopsDB->prefix('config')." WHERE conf_modid=$myaddress_mid" ) ;
	while( list( $key, $val ) = $xoopsDB->fetchRow( $rs ) ) {
		$myaddress_configs[ $key ] = $val;
	}

	// check if
	foreach( $myaddress_configs as $key => $val ) {
		if( strncmp( $key, "myaddress_", 10 ) == 0 ) $$key = $val;
	}

	// User Informations
	if( empty( $xoopsUser ) ) {
		$my_uid = 0;
		$my_groups = XOOPS_GROUP_ANONYMOUS;
		$isadmin = false;
	} else {
		$my_uid = $xoopsUser->uid();
		$my_groups = $xoopsUser->getGroups();
		$isadmin = $xoopsUser->isAdmin( $myaddress_mid );
	}

	// DB table name (if you use this module multiplly, change here.)
	$table_addressbook = $xoopsDB->prefix( "myaddress_addressbook" );
	$table_cat = $xoopsDB->prefix( "myaddress_cat" );
	$table_company = $xoopsDB->prefix( "myaddress_company" );
	$table_relations = $xoopsDB->prefix( "myaddress_relations" );
	$table_view = $xoopsDB->prefix( "myaddress_tableview" );	// itoh add

// ver.1.1.2
// the zipcode table is now replaced by the postalcode table offered by Marijunna.
//	$table_zipcode = $xoopsDB->prefix( "myaddress_zipcode" );
	$table_zipcode = $xoopsDB->prefix( "postalcode" );

	// make a category tree object
	include_once(XOOPS_ROOT_PATH."/class/xoopstree.php");
	$cattree = new XoopsTree($table_cat,"cid","pid");
?>