<?php
/* $Id: viewcat.php 16 2006-06-08 08:31:06Z hodaka $
 *  ------------------------------------------------------------------------ *
 *                XOOPS - PHP Content Management System                      *
 *                    Copyright (c) 2000 XOOPS.org                           *
 *                       <http://www.xoops.org/>                             *
 *  ------------------------------------------------------------------------ *
 *                      MyAddress - XOOPS addressbook                        *
 *                        <http://www.kuri3.net/>                            *
 *              Copyright (c) 2004 by hodaka <hodaka@kuri3.net>              *
 * ------------------------------------------------------------------------- *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * You may not change or alter any portion of this comment or credits        *
 * of supporting developers from this source code or any supporting          *
 * source code which is considered copyrighted (c) material of the           *
 * original comment or credit authors.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
 */

include("header.php");
$myts =& MyTextSanitizer::getInstance();

// reject no perm modified on v1.23
if( empty($xoopsModuleConfig['myaddress_guestperm']) && !is_object($xoopsUser) ) {
	redirect_header( XOOPS_URL."/user.php" , 2 , _MD_MYADDRESS_YOUMUSTREG );
	exit();
} elseif( !haveGroupPerm() ) {
	redirect_header( XOOPS_URL."/index.php", 2, _MD_MYADDRESS_YOUHAVENOPERM );
	exit();
}

$mode = isset($_GET['mode']) ? intval( $_GET['mode'] ) : (isset($_POST['mode']) ? intval( $_POST['mode'] ) : $myaddress_mode);
$cid = isset($_GET['cid']) ? intval( $_GET['cid'] ) : (isset($_POST['cid']) ? intval( $_POST['cid'] ) : 0);
$c_id = isset( $_GET['c_id'] ) ? intval($_GET['c_id']) : 0;

$skey = isset($_GET['skey'])? ( is_numeric($_GET['skey'])? intval($_GET['skey']) : trim($_GET['skey'])) : "all";

$from = isset( $_GET['from'] ) ? intval($_GET['from']): 0;

// check if argument 'op' exists
// _GET from viewcat.php,setcompany.php, _POST from myself in case of employee data maintenace
$op = isset( $_GET['op']) ? trim($_GET['op']) : (isset($_POST['op']) ? trim($_POST['op']) : "");

// define template file
$xoopsOption['template_main'] = 'myaddress_viewcat.html';

// Include the page header
include(XOOPS_ROOT_PATH."/header.php");

$xoopsTpl->assign( 'lang_total',  _MD_MYADDRESS_TOTAL );
$xoopsTpl->assign( 'mod_url', $mod_url );
$xoopsTpl->assign( 'mod_copyright', $mod_copyright );
$xoopsTpl->assign( 'mode', $mode );
$xoopsTpl->assign( 'cid', $cid );
$xoopsTpl->assign( 'op', $op );

// show the select box to choose a name-based or company-based mode
$xoopsTpl->assign( 'select_mode' , select_mode( $mode, $cid ) );

// show a link to add an addressbook
if ( $mode == 1 ) {
	$xoopsTpl->assign( 'lang_add_data', _MD_MYADDRESS_ADDMYADDRESS );
	$xoopsTpl->assign( 'add_data_url', 'viewaddress.php?mode='.$mode.'&amp;cid='.$cid.'&amp;op=add' );
} elseif ( $mode == 2 ) {
	$xoopsTpl->assign( 'lang_add_data', _MD_MYADDRESS_ADDCOMPANY );
	$xoopsTpl->assign( 'add_data_url', 'viewcompany.php?mode='.$mode.'&amp;cid='.$cid.'&amp;op=add' );
}

$xoopsTpl->assign( 'lang_subcategory', _MD_MYADDRESS_SUBCATEGORY );
$xoopsTpl->assign( 'subcategories', get_sub_categories( $mode, $cid ) );
$xoopsTpl->assign( 'call_url', "viewcat.php" );

$cids = $cattree->getAllChildId( $cid );
$cids = push_gperm_array( $cids, "myadrs_category" );
array_push( $cids , $cid );
$address_total_sum = get_address_total_sum_from_cats( $mode, $cids );

$xoopsTpl->assign( 'mainpathstring', "<A HREF='index.php?mode=$mode'>"._MD_MYADDRESS_MAIN."</A>" );
$xoopsTpl->assign( 'address_sub_title' , $cattree->getNicePathFromId( $cid , 'title' , "viewcat.php?mode=$mode" ) );

if ($mode == 1) {
	$prs = $xoopsDB->query( "SELECT COUNT(aid) FROM $table_addressbook WHERE cid=$cid" );
} elseif ($mode == 2) {
	$prs = $xoopsDB->query( "SELECT COUNT(c_id) FROM $table_company WHERE cid=$cid" );
}
list( $address_small_sum ) = $xoopsDB->fetchRow( $prs ) ;
$xoopsTpl->assign( 'address_small_sum' , $address_small_sum ) ;
$xoopsTpl->assign( 'address_total_sum' , ( empty( $address_total_sum ) ? $address_small_sum : $address_total_sum ) );

//--------------------------------------------------------------------//
//                      show buttons for search                       //
//--------------------------------------------------------------------//

$xoopsTpl->assign( show_searchnav( $mode, $cid ) );

//---------------------------------------------------------------//
//                 show the results of search                    //
//---------------------------------------------------------------//

if ( $op == "search" ) {
	include_once( "include/searchresults.php" );
	$xoopsTpl->assign( search_results( $mode, $cid, $skey ) );
}

//--------------------------------------------------------------------//
//            show the company profile & the employees list           //
//--------------------------------------------------------------------//

if ( $op == "list" ) {
	include_once( "include/searchresults.php" );
	$xoopsTpl->assign( 'employees' , employees_search_results( $skey ) );
}

include(XOOPS_ROOT_PATH."/footer.php");
?>