/** 
 * mod_xsi.c -- eXtensible Server Interface
 * Copyright (C) 2004 Shingo Tokuoka
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.  
 */ 

/**
 * ܸ쥳ȤѸ첽Ǥ
 * ԤαѸϤʤΤǥȤޤϥܥܥǤ
 */

#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"
#include "xsi.h"

XSI_API xsi_error(xsi_t *xsi, char *mes)
{
    xsi_contents(xsi, "Internal Error", mes);
    xsi->r->content_type = "text/html";
    ap_send_http_header(xsi->r);
    ap_rputs(xsi->contents, xsi->r);
    return OK;
}

XSI_API xsi_read(xsi_t *xsi)
{
    FILE *fp;
    char *buffer;
/*
    buffer = (char *)ap_palloc(xsi->r->pool, XSI_BUFFER_SIZE + 1);

    fp = ap_pfopen(xsi->r->pool, xsi->r->filename, "r");
    if(!fp)
        return XSI_ERROR;

    while((fgets(buffer, XSI_BUFFER_SIZE, fp) != EOF))
        ap_pstrcat(xsi->r->pool, xsi->xsi_file, buffer);
*/
/* ν */
	xsi->xsi_file = (char *)malloc(1000);
	fp = fopen(xsi->r->filename, "r");
	if(!fp)
	{
		xsi->contents = "fopen error";
		return XSI_OK;
	}
	fgets(xsi->xsi_file, 1000, fp);
	fclose(fp);

	xsi->xsi_file[strlen(xsi->xsi_file) - 1] = '\0';

    return XSI_OK;
}

XSI_API xsi_parse(xsi_t *xsi)
{
    xsi->so_path = xsi->xsi_file;
    return XSI_OK;
}

XSI_API xsi_dlopen(xsi_t *xsi)
{

    if(!(xsi->handle = ap_os_dso_load(xsi->so_path)))
        return XSI_ERROR;

    //if(!(xsi->entry = ap_os_dso_sym(xsi->handle, "xsi_entry")))
    if(!(xsi->d_entry = ap_os_dso_sym(xsi->handle, "xsi_d_entry")))
        return XSI_ERROR;

    return XSI_OK;
}

XSI_API xsi_get_request_body(xsi_t *xsi)
{
}

/**
 * Set Request Data & Server Staus for D
 */
XSI_API xsi_set_xsid(xsi_t *xsi)
{
    xsi->d->document_root  = (char *)ap_document_root(xsi->r);
    xsi->d->remote_addr    = xsi->r->connection->remote_ip;
    xsi->d->request_method = xsi->r->method;
    xsi->d->remote_user    = xsi->r->connection->user;
    ap_get_basic_auth_pw(xsi->r, &xsi->d->remote_passwd);
    xsi->d->request_uri    = xsi->r->unparsed_uri;
    xsi_get_request_body(xsi);
    xsi->d->query_string   = xsi->r->args;
    xsi->d->http_cookie    = ap_table_get(xsi->r->headers_in , "Cookie");
    xsi->d->http_session   = "";

    xsi->d->server_name    = (char *)ap_get_server_name(xsi->r);
    xsi->d->server_port    = ap_get_server_port(xsi->r);
}

/**
 * ưŪ󥯤Хʥμ¹Խ
 */
XSI_API xsi_execute(xsi_t *xsi)
{
/* ȤꤢDͻҤߤ*/
    xsi->lang = D;
    switch(xsi->lang)
    {
        case C: xsi->entry(xsi);     break; /* C(Apache API)Ѥμ¹Ѵؿ */
        case D: xsi->d_entry(xsi->d);break; /* ȤꤢD                   */
        default:break;                      /* ǥե̤(ͤͤ)        */
    }
    return XSI_OK;
}

XSI_API xsi_contents(xsi_t *xsi, char *title, char *body)
{
    if(title == NULL)
        title = "";
    if(body == NULL)
        body = "";

    xsi->contents = ap_psprintf(xsi->r->pool, 
        "<html>\n"
        "<head>\n"
        "<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n"
        "<title>XSI: %s</title>\n"
        "</head>\n"
        "<body>"
		"<table bgcolor=\"#7788FF\" width=\"100%\"><tr><td><b>"
		"<font size=+3 color=\"#FFFFFF\">&nbsp;XSI: %s</font>"
		"</b></td></tr></table>\n<br>\n"
        "<font face=\"arial\"><b>%s</b></font>"
        "</body>\n",
		title,
        title,
        body
    );

    xsi->output_lock = XSI_OUTPUT_LOCK;

    return strlen(xsi->contents);
}

XSI_API xsi_handler(request_rec *r)
{
    /* setup */
    xsi_t xsi;
    xsi_d xsid;

    xsi.r = r;
    xsi.d = &xsid;

    xsi.output_lock = XSI_OUTPUT_UNLOCK;
    xsi.contents = "default";
    xsi.so_path  = "default";
    xsi.xsi_file = "default";

    r->content_type = "text/html";

    /* Reading XSI config file */
    if(xsi_read(&xsi) == XSI_ERROR)
        return xsi_error(&xsi, "xsi file read failed");

    /* Parsing XSI config data */
    if(xsi_parse(&xsi) == XSI_ERROR)
        return xsi_error(&xsi, "syntax error xsi file");

    /* Loading XSI program */
    if(xsi_dlopen(&xsi) == XSI_ERROR)
        return xsi_error(&xsi, (char *)ap_os_dso_error());

    if(xsi_set_xsid(&xsi) == XSI_ERROR)
        return xsi_error(&xsi, "Can't set XSID");

    /* Exexute XSI entry function */
    if(xsi_execute(&xsi) == XSI_ERROR)
        return xsi_error(&xsi, "Can't Execute");


    /* Output contents data */
    if(xsi.output_lock == XSI_OUTPUT_UNLOCK)
    {
        xsi.contents[strlen(xsi.contents) -2] = '\0';
        ap_send_http_header(r);
        ap_rputs(xsi.contents, r);
    }

    return OK;
}

const handler_rec xsi_handlers[] = { 
    { "xsi", xsi_handler }, 
    { NULL, NULL }
};

module MODULE_VAR_EXPORT xsi_module = {
    STANDARD_MODULE_STUFF, 
    NULL,                  /* module initializer                  */
    NULL,                  /* create per-dir    config structures */
    NULL,                  /* merge  per-dir    config structures */
    NULL,                  /* create per-server config structures */
    NULL,                  /* merge  per-server config structures */
    NULL,                  /* table of config file commands       */
    xsi_handlers,          /* [#8] MIME-typed-dispatched handlers */
    NULL,                  /* [#1] URI to filename translation    */
    NULL,                  /* [#4] validate user id from request  */
    NULL,                  /* [#5] check if the user is ok _here_ */
    NULL,                  /* [#3] check access by host address   */
    NULL,                  /* [#6] determine MIME type            */
    NULL,                  /* [#7] pre-run fixups                 */
    NULL,                  /* [#9] log a transaction              */
    NULL,                  /* [#2] header parser                  */
    NULL,                  /* child_init                          */
    NULL,                  /* child_exit                          */
    NULL                   /* [#0] post read-request              */
};
