/**
 * xsi.h -- eXtensible Server Interface
 * Copyright (C) 2004 Shingo Tokuoka
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */ 

#ifndef __XSI_H
#define __XSI_H

#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"

#define XSI_BUFFER_SIZE 1024

/**
 * XSI return code
 */
#define XSI_OK 0
#define XSI_ERROR -1

/* Application API */

#define XSI_API static int
#define XSI_ENTRY extern
#define XSI_OUTPUT_UNLOCK 0
#define XSI_OUTPUT_LOCK 1

typedef struct xsi_t xsi_t;
typedef struct xsi_d xsi_d;
typedef enum lang_e lang_e;


/**
 * XSI Structure for D
 */
struct xsi_d{
    const char *document_root;
    const char *remote_addr;
    const char *request_method;
    const char *remote_user;
    const char *remote_passwd;
    const char *request_uri;
    const char *request_body;
    const char *query_string;
    const char *http_cookie;
    const char *http_session;

    char *server_name;
    int server_port;
	char *contents;
};

/**
 * Target programming langurage
 */
enum lang_e{
    C,
    CPP,
    CSHARP,
    D
};

/**
 * XSI program handle
 */
struct xsi_t{
    xsi_d *d;
    request_rec *r;            /* Apache request handle       */
    ap_os_dso_handle_t handle; /* XSI DSO hanle               */
    int status;                /* Status code                 */
    char *so_path;             /* DSO file                    */
    char *xsi_file;            /* Config data                 */
    char *contents;          /* Output contents             */
    char (*entry)(xsi_t *xsi);  /* XSI execute function        */
    char (*d_entry)(xsi_d *xsid); /* for D                       */
    int output_lock;           /* Output lock flag            */
    lang_e lang;               /* Target programming language */
};

/**
 * Prototype of a function group is declared
 */
XSI_API xsi_error(xsi_t *xsi, char *mes);
XSI_API xsi_read(xsi_t *xsi);
XSI_API xsi_parse(xsi_t *xsi);
XSI_API xsi_dlopen(xsi_t *xsi);
XSI_API xsi_execute(xsi_t *xsi);
XSI_API xsi_get_request_body(xsi_t *xsi);
XSI_API xsi_contents(xsi_t *xsi, char *title, char *body);


/* Entry point */

#ifdef __cplusplus
extern (C){
#endif
XSI_ENTRY int xsi_entry(xsi_t *xsi);
#ifdef __cplusplus
}
#endif

extern void xsi_d_entry(xsi_d *xsid);

#ifdef __cplusplus
#include "xsi++.h"
#endif

#endif
