#include "config.h"
#include "xyzsh/xyzsh.h"
#include <stdio.h>

static void version()
{
    printf("xyzsh version %s\n", getenv("XYZSH_VERSION"));
}

int main(int argc, char** argv)
{
    CHECKML_BEGIN(FALSE);

    setenv("XYZSH_VERSION", "0.9.9g", 1);
    setenv("XYZSH_DATAROOTDIR", DATAROOTDIR, 1);

    srandom((unsigned)time(NULL));

    char* optc = NULL;
    BOOL no_runtime_script = FALSE;
    char* file = NULL;
    int i;
    for(i=1; i<argc; i++) {
        if(strcmp(argv[i], "-c") == 0 && i+1 < argc) {
            optc = argv[i+1];
        }
        else if(strcmp(argv[i], "--version") == 0) {
            version();
            exit(0);
        }
        else if(strcmp(argv[i], "-nr") == 0) {
            no_runtime_script = TRUE;
        }
        else {
            file = argv[i];
        }
    }

    if(optc) {
        xyzsh_opt_c(optc, argv, argc, no_runtime_script);
    }
    else if(file) {
        xyzsh_load_file(file, argv, argc, no_runtime_script);
    }
    else {
        setenv("XYZSH_RUNNING_AS_INTRACTIVE_MODE", "1", 1);
        xyzsh_readline_interface(argv, argc, no_runtime_script);
    }

    CHECKML_END();

    return 0;
}
