#include "config.h"
#include "xyzsh/xyzsh.h"
#include <stdio.h>

static void version()
{
    printf("xyzsh version %s\n", getenv("XYZSH_VERSION"));
}

static void main_xyzsh_job_done(int job_num, char* job_title)
{
    printf("%d: %s done.\n", job_num+1, job_title);
}

int main(int argc, char** argv)
{
    CHECKML_BEGIN(FALSE);

    setenv("XYZSH_VERSION", "1.0.5a", 1);
    setenv("XYZSH_DATAROOTDIR", DATAROOTDIR, 1);

    srandom((unsigned)time(NULL));

    char* optc = NULL;
    BOOL no_runtime_script = FALSE;
    char* file = NULL;
    int i;
    for(i=1; i<argc; i++) {
        if(strcmp(argv[i], "-c") == 0 && i+1 < argc) {
            optc = argv[i+1];
        }
        else if(strcmp(argv[i], "--version") == 0) {
            version();
            exit(0);
        }
        else if(strcmp(argv[i], "-nr") == 0) {
            no_runtime_script = TRUE;
        }
        else {
            file = argv[i];
        }
    }


    if(optc) {
        xyzsh_init(kATOptC, no_runtime_script);
        xyzsh_opt_c(optc, argv, argc);
    }
    else if(file) {
        xyzsh_init(kATOptC, no_runtime_script);
        xyzsh_load_file(file, argv, argc);
    }
    else {
        xyzsh_init(kATConsoleApp, no_runtime_script);
        setenv("XYZSH_RUNNING_AS_INTRACTIVE_MODE", "1", 1);
        xyzsh_readline_interface("", -1, argv, argc);
    }

    xyzsh_final();

    CHECKML_END();

    return 0;
}
