#include "config.h"
#include "xyzsh.h"
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <ctype.h>
#include <pwd.h>
#include <limits.h>

// skip spaces
static void skip_spaces(char** p)
{
    while(**p == ' ' || **p == '\t') {
        (*p)++;
    }
}

sNodeTree* sNodeTree_create_operand(enum eOperand operand, sNodeTree* left, sNodeTree* right)
{
    sNodeTree* self = MALLOC(sizeof(sNodeTree));

    self->mType = 0;
    self->mOperand = operand;
    self->mLeft = left;
    self->mRight = right;

    return self;
}

sNodeTree* sNodeTree_create_value(int value, sNodeTree* left, sNodeTree* right)
{
    sNodeTree* self = MALLOC(sizeof(sNodeTree));

    self->mType = 1;
    self->mValue = value;

    self->mLeft = left;
    self->mRight = right;

    return self;
}

void sNodeTree_free(sNodeTree* self)
{
    if(self->mLeft) sNodeTree_free(self->mLeft);
    if(self->mRight) sNodeTree_free(self->mRight);

    if(self) FREE(self);
}

static BOOL expression_node(sNodeTree** node, char** p, char* sname, int* sline)
{
    if(**p == '0' && **p <= '9' || **p == '-') {
        char buf[128];
        char* p2 = buf;

        if(**p == '-') {
            *p2++ = '-';
        }

        while(**p >= '0' && **p <= '9') {
            *p2++ = **p;
            (*p)++;

            if(p2 - buf >= 128) {
                err_msg("overflow node of number",  sname, *sline, "");
                return FALSE;
            }
        }
        *p2 = 0;

        *node = sNodeTree_create_value(atoi(buf), NULL, NULL);
    }
    else {
        char buf[128];
        snprintf(buf, 128, "invalid character (%c)", **p);
        err_msg(buf, sname, *sline, "");
        return FALSE;
    }

    return TRUE;
}

static BOOL expression_mult_div(sNodeTree** node, char** p, char* sname, int* sline)
{
    if(!expression_node(node, p, sname, sline)) {
        return FALSE;
    }

    while(**p) {
        if(**p == '*') {
            (*p)++;
            sNodeTree* right;
            if(!expression_node(&right, p, sname, sline)) {
                return FALSE;
            }

            *node = sNodeTree_create_operand(kOpMult, *node, right);
        }
        else if(**p == '/') {
            (*p)++;
            sNodeTree* right;
            if(!expression_node(&right, p, sname, sline)) {
                return FALSE;
            }

            *node = sNodeTree_create_operand(kOpDiv, *node, right);
        }
        else {
            break;
        }
    }

    return TRUE;
}

BOOL expression_add_sub(sNodeTree** node, char** p, char* sname, int* sline)
{
    if(!expression_mult_div(node, p, sname, sline)) {
        return FALSE;
    }

    while(**p) {
        if(**p == '+') {
            (*p)++;
            sNodeTree* right;
            if(!expression_mult_div(&right, p, sname, sline)) {
                return FALSE;
            }

            *node = sNodeTree_create_operand(kOpAdd, *node, right);
        }
        else if(**p == '-') {
            (*p)++;
            sNodeTree* right;
            if(!expression_mult_div(&right, p, sname, sline)) {
                return FALSE;
            }

            *node = sNodeTree_create_operand(kOpSub, *node, right);
        }
        else {
            break;
        }
    }

    return TRUE;
}
