/* Copyright 1999-2002 Red Hat, Inc.
 *
 * This software may be freely redistributed under the terms of the GNU
 * public license.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/serial.h>

#include "firewire.h"
#include "modules.h"

static void firewireFreeDevice(struct firewireDevice *dev)
{
	freeDevice((struct device *) dev);
}

static void firewireWriteDevice(FILE *file, struct firewireDevice *dev)
{
	writeDevice(file, (struct device *)dev);
}

static int firewireCompareDevice(struct firewireDevice *dev1, struct firewireDevice *dev2)
{
	return compareDevice( (struct device *)dev1, (struct device *)dev2);
}

struct firewireDevice *firewireNewDevice(struct firewireDevice *old)
{
	struct firewireDevice *ret;

	ret = malloc(sizeof(struct firewireDevice));
	memset(ret, '\0', sizeof(struct firewireDevice));
	ret = (struct firewireDevice *) newDevice((struct device *) old, (struct device *) ret);
	ret->bus = BUS_FIREWIRE;
	ret->newDevice = firewireNewDevice;
	ret->freeDevice = firewireFreeDevice;
	ret->writeDevice = firewireWriteDevice;
	ret->compareDevice = firewireCompareDevice;
	return ret;
}

struct device *firewireProbe(enum deviceClass probeClass, int probeFlags,
			struct device *devlist)
{
	struct firewireDevice *fwdev;
	int loaded_driver = 0;
	unsigned long specid, version;
	
	if (
	    (probeClass == CLASS_UNSPEC) ||
	    (probeClass == CLASS_SCSI) 
	    ) {
		char *next, *buf = NULL, *tmp;
		char tmpbuf[4096];
		int fd, bytes =0;
		
		if (!loadModule("ohci1394"))
			loaded_driver = 1;
		fd = open("/proc/bus/ieee1394/devices", O_RDONLY);
		if (fd < 0)
			goto out;
		
		memset(tmpbuf,'\0',4096);
		while (read(fd,tmpbuf,4096) > 0) {
			buf = realloc(buf,bytes+4096);
			memcpy(buf+bytes,tmpbuf,4096);
			bytes += 4096;
			memset(tmpbuf,'\0',4096);
		}
		close(fd);
	        
		if (!buf)
			goto out;
		while (buf && *buf) {
			next = strstr(buf+1,"Node[");
			if (next) 
				*(next-1) = '\0';
			specid = version = 0;
			if ((tmp=strstr(buf,"Software Specifier ID: "))) {
				specid = strtoul(tmp+23,NULL,16);
				tmp = strstr(buf,"Software Version: ");
				if (tmp)
					version = strtoul(tmp+18,NULL,16);
				if (version == 0x010483 &&
				    specid == 0x00609e) {
					fwdev = firewireNewDevice(NULL);
					fwdev->driver = strdup("sbp2");
					fwdev->class = CLASS_SCSI;
					tmp = strstr(buf,"Vendor/Model ID:");
					if (tmp) {
						char *end;
						
						end = strstr(tmp,"\n");
						if (end)
							*end = '\0';
						fwdev->desc=strdup(tmp+17);
					} else {
						fwdev->desc=strdup("Generic Firewire Storage Controller");
					}
					if (devlist)
						fwdev->next = devlist;
					devlist = (struct device *) fwdev;
				}
			}
			buf = next;
		}
	}
out:
	if (loaded_driver == 1)
		removeModule("ohci1394");
	return devlist;
}
