/****************************************************************************
** $Id: qt/qstring.cpp   3.1.1   edited Dec 4 16:56 $
**
** Implementation of the QString class and related Unicode functions
**
** Created : 920722
**
** Copyright (C) 1992-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

// Don't define it while compiling this module, or USERS of Qt will
// not be able to link.
#ifdef QT_NO_CAST_ASCII
#undef QT_NO_CAST_ASCII
#endif

#include "qstring.h"
#include "qregexp.h"
#include "qdatastream.h"
#ifndef QT_NO_TEXTCODEC
#include "qtextcodec.h"
#endif
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(Q_WS_WIN)
#include "qt_windows.h"
#endif
#if !defined( QT_NO_COMPONENT ) && !defined( QT_LITE_COMPONENT )
#include "qcleanuphandler.h"
#endif

#ifdef QT_NO_UNICODETABLES
# include <ctype.h>
#endif


/* -------------------------------------------------------------------------
 * unicode information
 * these tables are generated from the unicode reference file
 * ftp://ftp.unicode.org/Public/3.2-Update/UnicodeData.txt
 *
 * Lars
 * -------------------------------------------------------------------------
 */

/* Perl script to generate (run perl -x tools/qstring.cpp)

#!perl

sub numberize
{
    my(%r, $n, $id);
    for $id ( @_ ) {
      $i = $id;
	$i="" if $i eq "EMPTY";
	$r{$i}=$n++;
    }
    return %r;
}


sub readUnicodeDataLine {
    $code = shift @_;
    for $n (qw{
	    name category combining_class bidi_category
	    character_decomposition decimal_digit_value digit_value
	    numeric_value mirrored oldname comment
	    uppercase lowercase titlecase})
    {
	$id = shift @_;
	$codes = "${n}_code";
	if ( defined %$codes && defined $$codes{$id} ) {
	    $id = $$codes{$id};
	}
	${$n}{$code}=$id;
    }
    $decomp = $character_decomposition{$code};
    if ( length $decomp == 0 ) {
	$decomp = "<single>";
    }
    if (substr($decomp, 0, 1) ne '<') {
	$decomp = "<canonical> " . $decomp;
    }
    @_ = split(" ", $decomp);
    $tag = shift @_;
    $tag = $character_decomposition_tag{$tag};
    $decomp = join( ", 0x", @_ );
    $decomp = "0x".$decomp;
    $decomposition{$code} = $decomp;
    $decomposition_tag{$code} = $tag;
    $decomposition_pos{$code} = $position;
    $len = scalar(@_);
    $decomposition_len{$code} = $len;

#   we use canonical decompositions longer than 1 char
#   we exlude Arabic ligatures from the table
    if($len > 1 and $tag == 1) {
#      ligature to add...
	$start = shift @_;
	$ligature{$start} = $ligature{$start}." ".$code;
    }

#   adjust position
    if($len != 0) {
	$position += $len + 3;
    }
}


# Code to integer mappings...
#
%category_code = numberize(qw{
      EMPTY
      Mn Mc Me
      Nd Nl No
      Zs Zl Zp
      Cc Cf Cs Co Cn

      Lu Ll Lt Lm Lo
      Pc Pd Ps Pe Pi Pf Po
      Sm Sc Sk So
});
%bidi_category_code = numberize(qw{
      L R EN ES ET AN CS B S WS ON LRE LRO AL RLE RLO PDF NSM BN});
%character_decomposition_tag = numberize(qw{
      <single> <canonical> <font> <noBreak> <initial> <medial>
      <final> <isolated> <circle> <super> <sub> <vertical>
      <wide> <narrow> <small> <square> <compat> <fraction>
});
%mirrored_code = numberize(qw{N Y});

%joining_code = numberize(qw{U D R C});

# Read data into hashes...
#
open IN, "UnicodeData.txt";
$position = 1;
while (<IN>) {
    @fields = split /;/;
    if ( length($fields[0]) < 5 ) {
      if ( $fields[1] =~ /, First>/ ) {
	$codeRangeBegin = $fields[0];
      } elsif ( $fields[1] =~ /, Last>/ ) {
	for ( $i=hex($codeRangeBegin); $i<=hex($fields[0]); $i+=1 ) {
	  @fields2 = @fields;
	  $fields2[0] = sprintf "%lX", $i;
	  readUnicodeDataLine @fields2;
	}
      } else {
	readUnicodeDataLine @fields;
      }
    }
}

open IN2, "ArabicShaping.txt";
$position = 1;
while (<IN2>) {
    @fields = split /;/;
    $code = shift @fields;
    $dummy = shift @fields;
    $join = shift @fields;
    $join =~ s/ //g;
    $join = $joining_code{$join};
    $joining{$code}=$join;
}

# Build pages...
#
$rowtable_txt =
    "static const Q_UINT8 * const unicode_info[256] = {";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $category{$code};
	$info = 0 if !defined $info;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$size+=256;
	$therow = "ui_".sprintf("%02X",$row);
	$rowtext{$therow} =
	    "static const Q_UINT8 ${therow}[] = {$txt\n};\n\n";
	$row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

print "// START OF GENERATED DATA\n\n";
print "#ifndef QT_NO_UNICODETABLES\n\n";

# Print pages...
#
for $r ( sort keys %rowtext ) {
    print $rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";

# Build decomposition tables
#
$rowtable_txt =
    "static const Q_UINT16 * const decomposition_info[256] = {";
$table_txt =
    "static const Q_UINT16 decomposition_map[] = {\n    0,\n";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( $decomposition_tag{$code} != 0 ) {
	    $txt .= " $decomposition_pos{$code},";
	    $table_txt .= "    $decomposition_tag{$code},";
	    $table_txt .= " 0x$code,";
	    $table_txt .= " $decomposition{$code}, 0,\n";
	    $size += 2 * $decomposition_len{$code} + 6;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$size+=512;
	$therow = "di_".sprintf("%02X",$row);
	$dec_rowtext{$therow} =
	    "static const Q_UINT16 ${therow}[] = {$txt\n};\n\n";
	$row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print decomposition tables
#
print "$table_txt\n};\n\n";
for $r ( sort keys %dec_rowtext ) {
    print $dec_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";


# build ligature tables
#
$size = 0;
$position = 1;
$rowtable_txt =
    "static const Q_UINT16 * const ligature_info[256] = {";
$table_txt =
    "static const Q_UINT16 ligature_map[] = {\n    0,\n";
for $lig_row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$lig_row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( defined $ligature{$code} ) {
	    $txt .= " $position,";
	    @ligature = split(" ", $ligature{$code});
#           we need to sort ligatures according to their length.
#           long ones have to come first!
	    @ligature_sort = sort { $decomposition_len{$b} <=>  $decomposition_len{$a} } @ligature;
#           now replace each code by its position in
#           the decomposition map.
	    undef(@lig_pos);
	    for $n (@ligature_sort) {
		push(@lig_pos, $decomposition_pos{$n});
	    }
#           debug info
	    if( 0 ) {
		print "ligatures: $ligature{$code}\n";
		$sort = join(" ", @ligature_sort);
		print "sorted   : $sort\n";
	    }
	    $lig = join(", ", @lig_pos);
	    $table_txt .= "    $lig, 0,\n";
	    $size += 2 * scalar(@ligature) + 2;
	    $position += scalar(@ligature) + 1;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $lig_row{$txt};
    if ( !defined $therow ) {
	$size+=512;
	$therow = "li_".sprintf("%02X",$lig_row);
	$lig_rowtext{$therow} =
	    "static const Q_UINT16 ${therow}[] = {$txt\n};\n\n";
	$lig_row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $lig_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print ligature tables
#
print "$table_txt\n};\n\n";
for $r ( sort keys %lig_rowtext ) {
    print $lig_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";



# Build direction/joining/mirrored pages...
#
$rowtable_txt =
    "static const Q_UINT8 * const direction_info[256] = {";
for $dir_row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$dir_row,$cell);
	$dir = $bidi_category{$code};
	$dir = 0 if !defined $dir;
	$join = $joining{$code};
	$join = 0 if !defined $join;
	$mirr = $mirrored{$code};
	$mirr = 0 if !defined $mirr;
	$info = $dir + 32*$join + 128*$mirr;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $dir_row{$txt};
    if ( !defined $therow ) {
	$size+=256;
	$therow = "dir_".sprintf("%02X",$dir_row);
	$dir_rowtext{$therow} =
	    "static const Q_UINT8 ${therow}[] = {$txt\n};\n\n";
	$dir_row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $dir_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print pages...
#
for $r ( sort keys %dir_rowtext ) {
    print $dir_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";

# Build table of combining classes
#
$rowtable_txt =
    "static const Q_UINT8 * const combining_info[256] = {";
for $combining_row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$combining_row,$cell);
	$info = $combining_class{$code};
	$info = 0 if !defined $info;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $combining_row{$txt};
    if ( !defined $therow ) {
	$size+=256;
	$therow = "cmb_".sprintf("%02X",$combining_row);
	$combining_rowtext{$therow} =
	    "static const Q_UINT8 ${therow}[] = {$txt\n};\n\n";
	$combining_row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $combining_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print pages...
#
for $r ( sort keys %combining_rowtext ) {
    print $combining_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";

# Build case info
#
$rowtable_txt =
    "static const Q_UINT16 * const case_info[256] = {";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $uppercase{$code};
	if ( length( $info ) eq 0 ) {
	  $info = $lowercase{$code};
	}
	$info =~ s/^0+//;
	if ( length( $info ) eq 0 ) {
	  $info = "0";
	} else {
	  $info = "0x".lc($info);
	}
	if ( length( $info ) ne 1 ) {
	  $nonzero = 1;
	}
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $case_row{$txt};
    if ( !defined $therow && $nonzero ne 0 ) {
	$size+=512;
	$therow = "case_".sprintf("%02X",$row);
	$case_rowtext{$therow} =
	    "static const Q_UINT16 ${therow}[] = {$txt\n};\n\n";
	$case_row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    if ( $nonzero ne 0 ) {
      $rowtable_txt .= "$therow, ";
    } else {
      $rowtable_txt .= "0, ";
    }
}

# Print pages...
#
for $r ( sort keys %case_rowtext ) {
    print $case_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";

# Build decimal info
#
$rowtable_txt =
    "static const Q_INT8 * const decimal_info[256] = {";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $digit_value{$code};
	if ( length( $info ) eq 0 ) {
	  $info = -1;
	} else {
	  $nonzero = 1;
	}
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $decimal_row{$txt};
    if ( !defined $therow && $nonzero ne 0 ) {
	$size+=512;
	$therow = "num_".sprintf("%02X",$row);
	$decimal_rowtext{$therow} =
	    "static const Q_INT8 ${therow}[] = {$txt\n};\n\n";
	$decimal_row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    if ( $nonzero ne 0 ) {
      $rowtable_txt .= "$therow, ";
    } else {
      $rowtable_txt .= "0, ";
    }
}

# Print pages...
#
for $r ( sort keys %decimal_rowtext ) {
    print $decimal_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";



print "#endif\n\n";
print "// END OF GENERATED DATA\n\n";



__END__

*/

// START OF GENERATED DATA

static const Q_UINT8 ui_00[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 28, 28, 28, 28, 30, 30,
    29, 30, 16, 24, 27, 21, 30, 29,
    30, 27, 6, 6, 29, 16, 30, 26,
    29, 6, 16, 25, 6, 6, 6, 26,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 27,
    15, 15, 15, 15, 15, 15, 15, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 27,
    16, 16, 16, 16, 16, 16, 16, 16,
};

#ifndef QT_NO_UNICODETABLES

static const Q_UINT8 ui_01[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 15, 16, 15, 16, 15, 16, 16,
    16, 15, 15, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 16, 15, 15,
    15, 15, 16, 15, 15, 16, 15, 15,
    15, 16, 16, 16, 15, 15, 16, 15,
    15, 16, 15, 16, 15, 16, 15, 15,
    16, 15, 16, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 15, 16, 15,
    15, 16, 16, 19, 15, 16, 16, 16,
    19, 19, 19, 19, 15, 17, 16, 15,
    17, 16, 15, 17, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 17, 16, 15, 16, 15, 15,
    15, 16, 15, 16, 15, 16, 15, 16,
};

static const Q_UINT8 ui_02[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 0, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 0, 0,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 29, 29, 18, 18, 18, 18, 18,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29,
    18, 18, 18, 18, 18, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_03[] = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 29, 29, 0, 0,
    0, 0, 18, 0, 0, 0, 26, 0,
    0, 0, 0, 0, 29, 29, 15, 26,
    15, 15, 15, 0, 15, 0, 15, 15,
    16, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 0, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 0,
    16, 16, 15, 15, 15, 16, 16, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 16, 16, 16, 15, 16, 27, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_04[] = {
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 30, 1, 1, 1, 1, 0,
    3, 3, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 0, 0,
    15, 16, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_05[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 0,
    0, 18, 26, 26, 26, 26, 26, 26,
    0, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 26, 21, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 26, 1,
    26, 1, 1, 26, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 26, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 26, 0, 0, 0, 26,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 26, 26, 19, 19,
    1, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 26, 19, 1, 1,
    1, 1, 1, 1, 1, 11, 3, 1,
    1, 1, 1, 1, 1, 18, 18, 1,
    1, 30, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 19, 19, 19, 30, 30, 0,
};

static const Q_UINT8 ui_07[] = {
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 0, 11,
    19, 1, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_08[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_09[] = {
    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 2, 1, 0, 0,
    19, 1, 1, 1, 1, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 26, 26, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    26, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 0, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 1, 1, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 1, 1, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    19, 19, 28, 28, 6, 6, 6, 6,
    6, 6, 30, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0A[] = {
    0, 0, 1, 0, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 0,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 0, 0, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 19, 19, 0, 19, 0,
    0, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    1, 1, 19, 19, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 0, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 0, 1,
    1, 2, 0, 2, 2, 1, 0, 0,
    19, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0B[] = {
    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 1,
    2, 1, 1, 1, 0, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    30, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 19, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 0, 0,
    0, 19, 19, 0, 19, 0, 19, 19,
    0, 0, 0, 19, 19, 0, 0, 0,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    1, 2, 2, 0, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    6, 6, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0C[] = {
    0, 2, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 1, 1,
    1, 2, 2, 2, 2, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 1,
    2, 2, 2, 2, 2, 0, 1, 2,
    2, 0, 2, 2, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 19, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0D[] = {
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    2, 1, 1, 1, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 1, 0, 0, 0, 0, 2,
    2, 2, 1, 1, 1, 0, 1, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0E[] = {
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 28,
    19, 19, 19, 19, 19, 19, 18, 1,
    1, 1, 1, 1, 1, 1, 1, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 0, 19, 0, 0, 19,
    19, 0, 19, 0, 0, 19, 0, 0,
    0, 0, 0, 0, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 0, 19, 0, 19,
    0, 0, 19, 19, 0, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 19, 0, 0,
    19, 19, 19, 19, 19, 0, 18, 0,
    1, 1, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0F[] = {
    19, 30, 30, 30, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 30, 30, 30, 30, 30,
    1, 1, 30, 30, 30, 30, 30, 30,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 1, 30, 1,
    30, 1, 22, 23, 22, 23, 2, 2,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2,
    1, 1, 1, 1, 1, 26, 1, 1,
    19, 19, 19, 19, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 30, 30,
    30, 30, 30, 30, 30, 30, 1, 30,
    30, 30, 30, 30, 30, 0, 0, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_10[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    0, 19, 19, 0, 2, 1, 1, 1,
    1, 2, 1, 0, 0, 0, 1, 1,
    2, 1, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 26, 26, 26, 26,
    19, 19, 19, 19, 19, 19, 2, 2,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 0, 26, 0, 0, 0, 0,
};

static const Q_UINT8 ui_11[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_12[] = {
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_13[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 26, 26, 26, 26, 26, 26, 26,
    26, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_14[] = {
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_15[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_16[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 26, 26, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 22, 23, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 26, 26, 26, 5, 5,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_17[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 19, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 1, 26, 26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 2, 2, 2, 1,
    1, 1, 1, 1, 1, 1, 2, 2,
    2, 2, 2, 2, 2, 2, 1, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 26, 26, 26, 18,
    26, 26, 26, 28, 19, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_18[] = {
    26, 26, 26, 26, 26, 26, 21, 26,
    26, 26, 26, 1, 1, 1, 11, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 18, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_1E[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 16, 16,
    16, 16, 16, 16, 0, 0, 0, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_1F[] = {
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 15, 0, 15, 0, 15, 0, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 16, 29,
    29, 29, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 29, 29,
    16, 16, 16, 16, 0, 0, 16, 16,
    15, 15, 15, 15, 0, 29, 29, 29,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 29, 29, 29,
    0, 0, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 29, 0,
};

static const Q_UINT8 ui_20[] = {
    7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 11, 11, 11, 11,
    21, 21, 21, 21, 21, 21, 26, 26,
    24, 25, 22, 24, 24, 25, 22, 24,
    26, 26, 26, 26, 26, 26, 26, 26,
    8, 9, 11, 11, 11, 11, 11, 7,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 24, 25, 26, 26, 26, 26, 20,
    20, 26, 26, 26, 27, 22, 23, 26,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 27, 0, 0, 0, 0, 26,
    0, 0, 0, 0, 0, 0, 0, 7,
    11, 11, 11, 11, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 11,
    6, 16, 0, 0, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 16,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 3, 3, 3,
    3, 1, 3, 3, 3, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_21[] = {
    30, 30, 15, 30, 30, 30, 30, 15,
    30, 30, 16, 15, 15, 15, 16, 16,
    15, 15, 15, 16, 30, 15, 30, 30,
    30, 15, 15, 15, 15, 15, 30, 30,
    30, 30, 30, 30, 15, 30, 15, 30,
    15, 30, 15, 15, 15, 15, 30, 16,
    15, 15, 30, 15, 16, 19, 19, 19,
    19, 16, 30, 0, 0, 16, 15, 15,
    27, 27, 27, 27, 27, 15, 16, 16,
    16, 16, 30, 27, 0, 0, 0, 0,
    0, 0, 0, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 30, 30, 30,
    30, 30, 27, 27, 30, 30, 30, 30,
    27, 30, 30, 27, 30, 30, 27, 30,
    30, 30, 30, 30, 30, 30, 27, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 27, 27,
    30, 30, 27, 30, 27, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
};

static const Q_UINT8 ui_22[] = {
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
};

static const Q_UINT8 ui_23[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 27, 27, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 30, 30, 30, 30, 30, 30,
    30, 22, 23, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 27, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 22, 23, 26, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_24[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 0,
};

static const Q_UINT8 ui_25[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 27,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 27, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 27, 27, 27, 27, 27, 27,
};

static const Q_UINT8 ui_26[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 27,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_27[] = {
    0, 30, 30, 30, 30, 0, 30, 30,
    30, 30, 0, 0, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 30, 0, 30,
    30, 30, 30, 0, 0, 0, 30, 0,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 30, 30, 30, 30, 30, 30, 30,
    22, 23, 22, 23, 22, 23, 22, 23,
    22, 23, 22, 23, 22, 23, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 22, 23,
    22, 23, 22, 23, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
};

static const Q_UINT8 ui_28[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
};

static const Q_UINT8 ui_29[] = {
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    22, 23, 22, 23, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 22, 23, 27, 27,
};

static const Q_UINT8 ui_2E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 0, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_2F[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
};

static const Q_UINT8 ui_30[] = {
    7, 26, 26, 26, 30, 18, 19, 5,
    22, 23, 22, 23, 22, 23, 22, 23,
    22, 23, 30, 30, 22, 23, 22, 23,
    22, 23, 22, 23, 21, 22, 23, 23,
    30, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 1, 1, 1, 1, 1, 1,
    21, 18, 18, 18, 18, 18, 30, 30,
    5, 5, 5, 18, 19, 26, 30, 30,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 1, 1, 29, 29, 18, 18, 19,
    21, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 20, 18, 18, 18, 19,
};

static const Q_UINT8 ui_31[] = {
    0, 0, 0, 0, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    30, 30, 6, 6, 6, 6, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_32[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 30,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
};

static const Q_UINT8 ui_33[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
};

static const Q_UINT8 ui_4D[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_9F[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_A4[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_D7[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_D8[] = {
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
};

static const Q_UINT8 ui_E0[] = {
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
};

static const Q_UINT8 ui_FA[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_FB[] = {
    16, 16, 16, 16, 16, 16, 16, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 16, 16, 16, 16, 16,
    0, 0, 0, 0, 0, 19, 1, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 27, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 0, 19, 0,
    19, 19, 0, 19, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_FD[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 22, 23,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 28, 0, 0, 0,
};

static const Q_UINT8 ui_FE[] = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    26, 21, 21, 20, 20, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 26, 26, 0,
    0, 26, 26, 26, 26, 20, 20, 20,
    26, 26, 26, 0, 26, 26, 26, 26,
    21, 22, 23, 22, 23, 22, 23, 26,
    26, 26, 27, 21, 27, 27, 27, 0,
    26, 28, 26, 26, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 11,
};

static const Q_UINT8 ui_FF[] = {
    0, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 22,
    23, 26, 22, 23, 26, 20, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 18, 18,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 0, 0, 0,
    28, 28, 27, 29, 30, 28, 28, 0,
    30, 27, 27, 27, 27, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 11, 11, 11, 30, 30, 0, 0,
};

static const Q_UINT8 * const unicode_info[256] = {
    ui_00, ui_01, ui_02, ui_03, ui_04, ui_05, ui_06, ui_07,
    ui_08, ui_09, ui_0A, ui_0B, ui_0C, ui_0D, ui_0E, ui_0F,
    ui_10, ui_11, ui_12, ui_13, ui_14, ui_15, ui_16, ui_17,
    ui_18, ui_08, ui_08, ui_08, ui_08, ui_08, ui_1E, ui_1F,
    ui_20, ui_21, ui_22, ui_23, ui_24, ui_25, ui_26, ui_27,
    ui_28, ui_29, ui_22, ui_08, ui_08, ui_08, ui_2E, ui_2F,
    ui_30, ui_31, ui_32, ui_33, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_4D, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_9F,
    ui_15, ui_15, ui_15, ui_15, ui_A4, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15,
    ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_15, ui_D7,
    ui_D8, ui_D8, ui_D8, ui_D8, ui_D8, ui_D8, ui_D8, ui_D8,
    ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0,
    ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0,
    ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0, ui_E0,
    ui_E0, ui_15, ui_FA, ui_FB, ui_15, ui_FD, ui_FE, ui_FF,
};
// 14848 bytes

static const Q_UINT16 decomposition_map[] = {
    0,
    3, 0x00A0, 0x0020, 0,
    16, 0x00A8, 0x0020, 0x0308, 0,
    9, 0x00AA, 0x0061, 0,
    16, 0x00AF, 0x0020, 0x0304, 0,
    9, 0x00B2, 0x0032, 0,
    9, 0x00B3, 0x0033, 0,
    16, 0x00B4, 0x0020, 0x0301, 0,
    16, 0x00B5, 0x03BC, 0,
    16, 0x00B8, 0x0020, 0x0327, 0,
    9, 0x00B9, 0x0031, 0,
    9, 0x00BA, 0x006F, 0,
    17, 0x00BC, 0x0031, 0x2044, 0x0034, 0,
    17, 0x00BD, 0x0031, 0x2044, 0x0032, 0,
    17, 0x00BE, 0x0033, 0x2044, 0x0034, 0,
    1, 0x00C0, 0x0041, 0x0300, 0,
    1, 0x00C1, 0x0041, 0x0301, 0,
    1, 0x00C2, 0x0041, 0x0302, 0,
    1, 0x00C3, 0x0041, 0x0303, 0,
    1, 0x00C4, 0x0041, 0x0308, 0,
    1, 0x00C5, 0x0041, 0x030A, 0,
    1, 0x00C7, 0x0043, 0x0327, 0,
    1, 0x00C8, 0x0045, 0x0300, 0,
    1, 0x00C9, 0x0045, 0x0301, 0,
    1, 0x00CA, 0x0045, 0x0302, 0,
    1, 0x00CB, 0x0045, 0x0308, 0,
    1, 0x00CC, 0x0049, 0x0300, 0,
    1, 0x00CD, 0x0049, 0x0301, 0,
    1, 0x00CE, 0x0049, 0x0302, 0,
    1, 0x00CF, 0x0049, 0x0308, 0,
    1, 0x00D1, 0x004E, 0x0303, 0,
    1, 0x00D2, 0x004F, 0x0300, 0,
    1, 0x00D3, 0x004F, 0x0301, 0,
    1, 0x00D4, 0x004F, 0x0302, 0,
    1, 0x00D5, 0x004F, 0x0303, 0,
    1, 0x00D6, 0x004F, 0x0308, 0,
    1, 0x00D9, 0x0055, 0x0300, 0,
    1, 0x00DA, 0x0055, 0x0301, 0,
    1, 0x00DB, 0x0055, 0x0302, 0,
    1, 0x00DC, 0x0055, 0x0308, 0,
    1, 0x00DD, 0x0059, 0x0301, 0,
    1, 0x00E0, 0x0061, 0x0300, 0,
    1, 0x00E1, 0x0061, 0x0301, 0,
    1, 0x00E2, 0x0061, 0x0302, 0,
    1, 0x00E3, 0x0061, 0x0303, 0,
    1, 0x00E4, 0x0061, 0x0308, 0,
    1, 0x00E5, 0x0061, 0x030A, 0,
    1, 0x00E7, 0x0063, 0x0327, 0,
    1, 0x00E8, 0x0065, 0x0300, 0,
    1, 0x00E9, 0x0065, 0x0301, 0,
    1, 0x00EA, 0x0065, 0x0302, 0,
    1, 0x00EB, 0x0065, 0x0308, 0,
    1, 0x00EC, 0x0069, 0x0300, 0,
    1, 0x00ED, 0x0069, 0x0301, 0,
    1, 0x00EE, 0x0069, 0x0302, 0,
    1, 0x00EF, 0x0069, 0x0308, 0,
    1, 0x00F1, 0x006E, 0x0303, 0,
    1, 0x00F2, 0x006F, 0x0300, 0,
    1, 0x00F3, 0x006F, 0x0301, 0,
    1, 0x00F4, 0x006F, 0x0302, 0,
    1, 0x00F5, 0x006F, 0x0303, 0,
    1, 0x00F6, 0x006F, 0x0308, 0,
    1, 0x00F9, 0x0075, 0x0300, 0,
    1, 0x00FA, 0x0075, 0x0301, 0,
    1, 0x00FB, 0x0075, 0x0302, 0,
    1, 0x00FC, 0x0075, 0x0308, 0,
    1, 0x00FD, 0x0079, 0x0301, 0,
    1, 0x00FF, 0x0079, 0x0308, 0,
    1, 0x0100, 0x0041, 0x0304, 0,
    1, 0x0101, 0x0061, 0x0304, 0,
    1, 0x0102, 0x0041, 0x0306, 0,
    1, 0x0103, 0x0061, 0x0306, 0,
    1, 0x0104, 0x0041, 0x0328, 0,
    1, 0x0105, 0x0061, 0x0328, 0,
    1, 0x0106, 0x0043, 0x0301, 0,
    1, 0x0107, 0x0063, 0x0301, 0,
    1, 0x0108, 0x0043, 0x0302, 0,
    1, 0x0109, 0x0063, 0x0302, 0,
    1, 0x010A, 0x0043, 0x0307, 0,
    1, 0x010B, 0x0063, 0x0307, 0,
    1, 0x010C, 0x0043, 0x030C, 0,
    1, 0x010D, 0x0063, 0x030C, 0,
    1, 0x010E, 0x0044, 0x030C, 0,
    1, 0x010F, 0x0064, 0x030C, 0,
    1, 0x0112, 0x0045, 0x0304, 0,
    1, 0x0113, 0x0065, 0x0304, 0,
    1, 0x0114, 0x0045, 0x0306, 0,
    1, 0x0115, 0x0065, 0x0306, 0,
    1, 0x0116, 0x0045, 0x0307, 0,
    1, 0x0117, 0x0065, 0x0307, 0,
    1, 0x0118, 0x0045, 0x0328, 0,
    1, 0x0119, 0x0065, 0x0328, 0,
    1, 0x011A, 0x0045, 0x030C, 0,
    1, 0x011B, 0x0065, 0x030C, 0,
    1, 0x011C, 0x0047, 0x0302, 0,
    1, 0x011D, 0x0067, 0x0302, 0,
    1, 0x011E, 0x0047, 0x0306, 0,
    1, 0x011F, 0x0067, 0x0306, 0,
    1, 0x0120, 0x0047, 0x0307, 0,
    1, 0x0121, 0x0067, 0x0307, 0,
    1, 0x0122, 0x0047, 0x0327, 0,
    1, 0x0123, 0x0067, 0x0327, 0,
    1, 0x0124, 0x0048, 0x0302, 0,
    1, 0x0125, 0x0068, 0x0302, 0,
    1, 0x0128, 0x0049, 0x0303, 0,
    1, 0x0129, 0x0069, 0x0303, 0,
    1, 0x012A, 0x0049, 0x0304, 0,
    1, 0x012B, 0x0069, 0x0304, 0,
    1, 0x012C, 0x0049, 0x0306, 0,
    1, 0x012D, 0x0069, 0x0306, 0,
    1, 0x012E, 0x0049, 0x0328, 0,
    1, 0x012F, 0x0069, 0x0328, 0,
    1, 0x0130, 0x0049, 0x0307, 0,
    16, 0x0132, 0x0049, 0x004A, 0,
    16, 0x0133, 0x0069, 0x006A, 0,
    1, 0x0134, 0x004A, 0x0302, 0,
    1, 0x0135, 0x006A, 0x0302, 0,
    1, 0x0136, 0x004B, 0x0327, 0,
    1, 0x0137, 0x006B, 0x0327, 0,
    1, 0x0139, 0x004C, 0x0301, 0,
    1, 0x013A, 0x006C, 0x0301, 0,
    1, 0x013B, 0x004C, 0x0327, 0,
    1, 0x013C, 0x006C, 0x0327, 0,
    1, 0x013D, 0x004C, 0x030C, 0,
    1, 0x013E, 0x006C, 0x030C, 0,
    16, 0x013F, 0x004C, 0x00B7, 0,
    16, 0x0140, 0x006C, 0x00B7, 0,
    1, 0x0143, 0x004E, 0x0301, 0,
    1, 0x0144, 0x006E, 0x0301, 0,
    1, 0x0145, 0x004E, 0x0327, 0,
    1, 0x0146, 0x006E, 0x0327, 0,
    1, 0x0147, 0x004E, 0x030C, 0,
    1, 0x0148, 0x006E, 0x030C, 0,
    16, 0x0149, 0x02BC, 0x006E, 0,
    1, 0x014C, 0x004F, 0x0304, 0,
    1, 0x014D, 0x006F, 0x0304, 0,
    1, 0x014E, 0x004F, 0x0306, 0,
    1, 0x014F, 0x006F, 0x0306, 0,
    1, 0x0150, 0x004F, 0x030B, 0,
    1, 0x0151, 0x006F, 0x030B, 0,
    1, 0x0154, 0x0052, 0x0301, 0,
    1, 0x0155, 0x0072, 0x0301, 0,
    1, 0x0156, 0x0052, 0x0327, 0,
    1, 0x0157, 0x0072, 0x0327, 0,
    1, 0x0158, 0x0052, 0x030C, 0,
    1, 0x0159, 0x0072, 0x030C, 0,
    1, 0x015A, 0x0053, 0x0301, 0,
    1, 0x015B, 0x0073, 0x0301, 0,
    1, 0x015C, 0x0053, 0x0302, 0,
    1, 0x015D, 0x0073, 0x0302, 0,
    1, 0x015E, 0x0053, 0x0327, 0,
    1, 0x015F, 0x0073, 0x0327, 0,
    1, 0x0160, 0x0053, 0x030C, 0,
    1, 0x0161, 0x0073, 0x030C, 0,
    1, 0x0162, 0x0054, 0x0327, 0,
    1, 0x0163, 0x0074, 0x0327, 0,
    1, 0x0164, 0x0054, 0x030C, 0,
    1, 0x0165, 0x0074, 0x030C, 0,
    1, 0x0168, 0x0055, 0x0303, 0,
    1, 0x0169, 0x0075, 0x0303, 0,
    1, 0x016A, 0x0055, 0x0304, 0,
    1, 0x016B, 0x0075, 0x0304, 0,
    1, 0x016C, 0x0055, 0x0306, 0,
    1, 0x016D, 0x0075, 0x0306, 0,
    1, 0x016E, 0x0055, 0x030A, 0,
    1, 0x016F, 0x0075, 0x030A, 0,
    1, 0x0170, 0x0055, 0x030B, 0,
    1, 0x0171, 0x0075, 0x030B, 0,
    1, 0x0172, 0x0055, 0x0328, 0,
    1, 0x0173, 0x0075, 0x0328, 0,
    1, 0x0174, 0x0057, 0x0302, 0,
    1, 0x0175, 0x0077, 0x0302, 0,
    1, 0x0176, 0x0059, 0x0302, 0,
    1, 0x0177, 0x0079, 0x0302, 0,
    1, 0x0178, 0x0059, 0x0308, 0,
    1, 0x0179, 0x005A, 0x0301, 0,
    1, 0x017A, 0x007A, 0x0301, 0,
    1, 0x017B, 0x005A, 0x0307, 0,
    1, 0x017C, 0x007A, 0x0307, 0,
    1, 0x017D, 0x005A, 0x030C, 0,
    1, 0x017E, 0x007A, 0x030C, 0,
    16, 0x017F, 0x0073, 0,
    1, 0x01A0, 0x004F, 0x031B, 0,
    1, 0x01A1, 0x006F, 0x031B, 0,
    1, 0x01AF, 0x0055, 0x031B, 0,
    1, 0x01B0, 0x0075, 0x031B, 0,
    16, 0x01C4, 0x0044, 0x017D, 0,
    16, 0x01C5, 0x0044, 0x017E, 0,
    16, 0x01C6, 0x0064, 0x017E, 0,
    16, 0x01C7, 0x004C, 0x004A, 0,
    16, 0x01C8, 0x004C, 0x006A, 0,
    16, 0x01C9, 0x006C, 0x006A, 0,
    16, 0x01CA, 0x004E, 0x004A, 0,
    16, 0x01CB, 0x004E, 0x006A, 0,
    16, 0x01CC, 0x006E, 0x006A, 0,
    1, 0x01CD, 0x0041, 0x030C, 0,
    1, 0x01CE, 0x0061, 0x030C, 0,
    1, 0x01CF, 0x0049, 0x030C, 0,
    1, 0x01D0, 0x0069, 0x030C, 0,
    1, 0x01D1, 0x004F, 0x030C, 0,
    1, 0x01D2, 0x006F, 0x030C, 0,
    1, 0x01D3, 0x0055, 0x030C, 0,
    1, 0x01D4, 0x0075, 0x030C, 0,
    1, 0x01D5, 0x00DC, 0x0304, 0,
    1, 0x01D6, 0x00FC, 0x0304, 0,
    1, 0x01D7, 0x00DC, 0x0301, 0,
    1, 0x01D8, 0x00FC, 0x0301, 0,
    1, 0x01D9, 0x00DC, 0x030C, 0,
    1, 0x01DA, 0x00FC, 0x030C, 0,
    1, 0x01DB, 0x00DC, 0x0300, 0,
    1, 0x01DC, 0x00FC, 0x0300, 0,
    1, 0x01DE, 0x00C4, 0x0304, 0,
    1, 0x01DF, 0x00E4, 0x0304, 0,
    1, 0x01E0, 0x0226, 0x0304, 0,
    1, 0x01E1, 0x0227, 0x0304, 0,
    1, 0x01E2, 0x00C6, 0x0304, 0,
    1, 0x01E3, 0x00E6, 0x0304, 0,
    1, 0x01E6, 0x0047, 0x030C, 0,
    1, 0x01E7, 0x0067, 0x030C, 0,
    1, 0x01E8, 0x004B, 0x030C, 0,
    1, 0x01E9, 0x006B, 0x030C, 0,
    1, 0x01EA, 0x004F, 0x0328, 0,
    1, 0x01EB, 0x006F, 0x0328, 0,
    1, 0x01EC, 0x01EA, 0x0304, 0,
    1, 0x01ED, 0x01EB, 0x0304, 0,
    1, 0x01EE, 0x01B7, 0x030C, 0,
    1, 0x01EF, 0x0292, 0x030C, 0,
    1, 0x01F0, 0x006A, 0x030C, 0,
    16, 0x01F1, 0x0044, 0x005A, 0,
    16, 0x01F2, 0x0044, 0x007A, 0,
    16, 0x01F3, 0x0064, 0x007A, 0,
    1, 0x01F4, 0x0047, 0x0301, 0,
    1, 0x01F5, 0x0067, 0x0301, 0,
    1, 0x01F8, 0x004E, 0x0300, 0,
    1, 0x01F9, 0x006E, 0x0300, 0,
    1, 0x01FA, 0x00C5, 0x0301, 0,
    1, 0x01FB, 0x00E5, 0x0301, 0,
    1, 0x01FC, 0x00C6, 0x0301, 0,
    1, 0x01FD, 0x00E6, 0x0301, 0,
    1, 0x01FE, 0x00D8, 0x0301, 0,
    1, 0x01FF, 0x00F8, 0x0301, 0,
    1, 0x0200, 0x0041, 0x030F, 0,
    1, 0x0201, 0x0061, 0x030F, 0,
    1, 0x0202, 0x0041, 0x0311, 0,
    1, 0x0203, 0x0061, 0x0311, 0,
    1, 0x0204, 0x0045, 0x030F, 0,
    1, 0x0205, 0x0065, 0x030F, 0,
    1, 0x0206, 0x0045, 0x0311, 0,
    1, 0x0207, 0x0065, 0x0311, 0,
    1, 0x0208, 0x0049, 0x030F, 0,
    1, 0x0209, 0x0069, 0x030F, 0,
    1, 0x020A, 0x0049, 0x0311, 0,
    1, 0x020B, 0x0069, 0x0311, 0,
    1, 0x020C, 0x004F, 0x030F, 0,
    1, 0x020D, 0x006F, 0x030F, 0,
    1, 0x020E, 0x004F, 0x0311, 0,
    1, 0x020F, 0x006F, 0x0311, 0,
    1, 0x0210, 0x0052, 0x030F, 0,
    1, 0x0211, 0x0072, 0x030F, 0,
    1, 0x0212, 0x0052, 0x0311, 0,
    1, 0x0213, 0x0072, 0x0311, 0,
    1, 0x0214, 0x0055, 0x030F, 0,
    1, 0x0215, 0x0075, 0x030F, 0,
    1, 0x0216, 0x0055, 0x0311, 0,
    1, 0x0217, 0x0075, 0x0311, 0,
    1, 0x0218, 0x0053, 0x0326, 0,
    1, 0x0219, 0x0073, 0x0326, 0,
    1, 0x021A, 0x0054, 0x0326, 0,
    1, 0x021B, 0x0074, 0x0326, 0,
    1, 0x021E, 0x0048, 0x030C, 0,
    1, 0x021F, 0x0068, 0x030C, 0,
    1, 0x0226, 0x0041, 0x0307, 0,
    1, 0x0227, 0x0061, 0x0307, 0,
    1, 0x0228, 0x0045, 0x0327, 0,
    1, 0x0229, 0x0065, 0x0327, 0,
    1, 0x022A, 0x00D6, 0x0304, 0,
    1, 0x022B, 0x00F6, 0x0304, 0,
    1, 0x022C, 0x00D5, 0x0304, 0,
    1, 0x022D, 0x00F5, 0x0304, 0,
    1, 0x022E, 0x004F, 0x0307, 0,
    1, 0x022F, 0x006F, 0x0307, 0,
    1, 0x0230, 0x022E, 0x0304, 0,
    1, 0x0231, 0x022F, 0x0304, 0,
    1, 0x0232, 0x0059, 0x0304, 0,
    1, 0x0233, 0x0079, 0x0304, 0,
    9, 0x02B0, 0x0068, 0,
    9, 0x02B1, 0x0266, 0,
    9, 0x02B2, 0x006A, 0,
    9, 0x02B3, 0x0072, 0,
    9, 0x02B4, 0x0279, 0,
    9, 0x02B5, 0x027B, 0,
    9, 0x02B6, 0x0281, 0,
    9, 0x02B7, 0x0077, 0,
    9, 0x02B8, 0x0079, 0,
    16, 0x02D8, 0x0020, 0x0306, 0,
    16, 0x02D9, 0x0020, 0x0307, 0,
    16, 0x02DA, 0x0020, 0x030A, 0,
    16, 0x02DB, 0x0020, 0x0328, 0,
    16, 0x02DC, 0x0020, 0x0303, 0,
    16, 0x02DD, 0x0020, 0x030B, 0,
    9, 0x02E0, 0x0263, 0,
    9, 0x02E1, 0x006C, 0,
    9, 0x02E2, 0x0073, 0,
    9, 0x02E3, 0x0078, 0,
    9, 0x02E4, 0x0295, 0,
    1, 0x0340, 0x0300, 0,
    1, 0x0341, 0x0301, 0,
    1, 0x0343, 0x0313, 0,
    1, 0x0344, 0x0308, 0x0301, 0,
    1, 0x0374, 0x02B9, 0,
    16, 0x037A, 0x0020, 0x0345, 0,
    1, 0x037E, 0x003B, 0,
    16, 0x0384, 0x0020, 0x0301, 0,
    1, 0x0385, 0x00A8, 0x0301, 0,
    1, 0x0386, 0x0391, 0x0301, 0,
    1, 0x0387, 0x00B7, 0,
    1, 0x0388, 0x0395, 0x0301, 0,
    1, 0x0389, 0x0397, 0x0301, 0,
    1, 0x038A, 0x0399, 0x0301, 0,
    1, 0x038C, 0x039F, 0x0301, 0,
    1, 0x038E, 0x03A5, 0x0301, 0,
    1, 0x038F, 0x03A9, 0x0301, 0,
    1, 0x0390, 0x03CA, 0x0301, 0,
    1, 0x03AA, 0x0399, 0x0308, 0,
    1, 0x03AB, 0x03A5, 0x0308, 0,
    1, 0x03AC, 0x03B1, 0x0301, 0,
    1, 0x03AD, 0x03B5, 0x0301, 0,
    1, 0x03AE, 0x03B7, 0x0301, 0,
    1, 0x03AF, 0x03B9, 0x0301, 0,
    1, 0x03B0, 0x03CB, 0x0301, 0,
    1, 0x03CA, 0x03B9, 0x0308, 0,
    1, 0x03CB, 0x03C5, 0x0308, 0,
    1, 0x03CC, 0x03BF, 0x0301, 0,
    1, 0x03CD, 0x03C5, 0x0301, 0,
    1, 0x03CE, 0x03C9, 0x0301, 0,
    16, 0x03D0, 0x03B2, 0,
    16, 0x03D1, 0x03B8, 0,
    16, 0x03D2, 0x03A5, 0,
    1, 0x03D3, 0x03D2, 0x0301, 0,
    1, 0x03D4, 0x03D2, 0x0308, 0,
    16, 0x03D5, 0x03C6, 0,
    16, 0x03D6, 0x03C0, 0,
    16, 0x03F0, 0x03BA, 0,
    16, 0x03F1, 0x03C1, 0,
    16, 0x03F2, 0x03C2, 0,
    16, 0x03F4, 0x0398, 0,
    16, 0x03F5, 0x03B5, 0,
    1, 0x0400, 0x0415, 0x0300, 0,
    1, 0x0401, 0x0415, 0x0308, 0,
    1, 0x0403, 0x0413, 0x0301, 0,
    1, 0x0407, 0x0406, 0x0308, 0,
    1, 0x040C, 0x041A, 0x0301, 0,
    1, 0x040D, 0x0418, 0x0300, 0,
    1, 0x040E, 0x0423, 0x0306, 0,
    1, 0x0419, 0x0418, 0x0306, 0,
    1, 0x0439, 0x0438, 0x0306, 0,
    1, 0x0450, 0x0435, 0x0300, 0,
    1, 0x0451, 0x0435, 0x0308, 0,
    1, 0x0453, 0x0433, 0x0301, 0,
    1, 0x0457, 0x0456, 0x0308, 0,
    1, 0x045C, 0x043A, 0x0301, 0,
    1, 0x045D, 0x0438, 0x0300, 0,
    1, 0x045E, 0x0443, 0x0306, 0,
    1, 0x0476, 0x0474, 0x030F, 0,
    1, 0x0477, 0x0475, 0x030F, 0,
    1, 0x04C1, 0x0416, 0x0306, 0,
    1, 0x04C2, 0x0436, 0x0306, 0,
    1, 0x04D0, 0x0410, 0x0306, 0,
    1, 0x04D1, 0x0430, 0x0306, 0,
    1, 0x04D2, 0x0410, 0x0308, 0,
    1, 0x04D3, 0x0430, 0x0308, 0,
    1, 0x04D6, 0x0415, 0x0306, 0,
    1, 0x04D7, 0x0435, 0x0306, 0,
    1, 0x04DA, 0x04D8, 0x0308, 0,
    1, 0x04DB, 0x04D9, 0x0308, 0,
    1, 0x04DC, 0x0416, 0x0308, 0,
    1, 0x04DD, 0x0436, 0x0308, 0,
    1, 0x04DE, 0x0417, 0x0308, 0,
    1, 0x04DF, 0x0437, 0x0308, 0,
    1, 0x04E2, 0x0418, 0x0304, 0,
    1, 0x04E3, 0x0438, 0x0304, 0,
    1, 0x04E4, 0x0418, 0x0308, 0,
    1, 0x04E5, 0x0438, 0x0308, 0,
    1, 0x04E6, 0x041E, 0x0308, 0,
    1, 0x04E7, 0x043E, 0x0308, 0,
    1, 0x04EA, 0x04E8, 0x0308, 0,
    1, 0x04EB, 0x04E9, 0x0308, 0,
    1, 0x04EC, 0x042D, 0x0308, 0,
    1, 0x04ED, 0x044D, 0x0308, 0,
    1, 0x04EE, 0x0423, 0x0304, 0,
    1, 0x04EF, 0x0443, 0x0304, 0,
    1, 0x04F0, 0x0423, 0x0308, 0,
    1, 0x04F1, 0x0443, 0x0308, 0,
    1, 0x04F2, 0x0423, 0x030B, 0,
    1, 0x04F3, 0x0443, 0x030B, 0,
    1, 0x04F4, 0x0427, 0x0308, 0,
    1, 0x04F5, 0x0447, 0x0308, 0,
    1, 0x04F8, 0x042B, 0x0308, 0,
    1, 0x04F9, 0x044B, 0x0308, 0,
    16, 0x0587, 0x0565, 0x0582, 0,
    1, 0x0622, 0x0627, 0x0653, 0,
    1, 0x0623, 0x0627, 0x0654, 0,
    1, 0x0624, 0x0648, 0x0654, 0,
    1, 0x0625, 0x0627, 0x0655, 0,
    1, 0x0626, 0x064A, 0x0654, 0,
    16, 0x0675, 0x0627, 0x0674, 0,
    16, 0x0676, 0x0648, 0x0674, 0,
    16, 0x0677, 0x06C7, 0x0674, 0,
    16, 0x0678, 0x064A, 0x0674, 0,
    1, 0x06C0, 0x06D5, 0x0654, 0,
    1, 0x06C2, 0x06C1, 0x0654, 0,
    1, 0x06D3, 0x06D2, 0x0654, 0,
    1, 0x0929, 0x0928, 0x093C, 0,
    1, 0x0931, 0x0930, 0x093C, 0,
    1, 0x0934, 0x0933, 0x093C, 0,
    1, 0x0958, 0x0915, 0x093C, 0,
    1, 0x0959, 0x0916, 0x093C, 0,
    1, 0x095A, 0x0917, 0x093C, 0,
    1, 0x095B, 0x091C, 0x093C, 0,
    1, 0x095C, 0x0921, 0x093C, 0,
    1, 0x095D, 0x0922, 0x093C, 0,
    1, 0x095E, 0x092B, 0x093C, 0,
    1, 0x095F, 0x092F, 0x093C, 0,
    1, 0x09CB, 0x09C7, 0x09BE, 0,
    1, 0x09CC, 0x09C7, 0x09D7, 0,
    1, 0x09DC, 0x09A1, 0x09BC, 0,
    1, 0x09DD, 0x09A2, 0x09BC, 0,
    1, 0x09DF, 0x09AF, 0x09BC, 0,
    1, 0x0A33, 0x0A32, 0x0A3C, 0,
    1, 0x0A36, 0x0A38, 0x0A3C, 0,
    1, 0x0A59, 0x0A16, 0x0A3C, 0,
    1, 0x0A5A, 0x0A17, 0x0A3C, 0,
    1, 0x0A5B, 0x0A1C, 0x0A3C, 0,
    1, 0x0A5E, 0x0A2B, 0x0A3C, 0,
    1, 0x0B48, 0x0B47, 0x0B56, 0,
    1, 0x0B4B, 0x0B47, 0x0B3E, 0,
    1, 0x0B4C, 0x0B47, 0x0B57, 0,
    1, 0x0B5C, 0x0B21, 0x0B3C, 0,
    1, 0x0B5D, 0x0B22, 0x0B3C, 0,
    1, 0x0B94, 0x0B92, 0x0BD7, 0,
    1, 0x0BCA, 0x0BC6, 0x0BBE, 0,
    1, 0x0BCB, 0x0BC7, 0x0BBE, 0,
    1, 0x0BCC, 0x0BC6, 0x0BD7, 0,
    1, 0x0C48, 0x0C46, 0x0C56, 0,
    1, 0x0CC0, 0x0CBF, 0x0CD5, 0,
    1, 0x0CC7, 0x0CC6, 0x0CD5, 0,
    1, 0x0CC8, 0x0CC6, 0x0CD6, 0,
    1, 0x0CCA, 0x0CC6, 0x0CC2, 0,
    1, 0x0CCB, 0x0CCA, 0x0CD5, 0,
    1, 0x0D4A, 0x0D46, 0x0D3E, 0,
    1, 0x0D4B, 0x0D47, 0x0D3E, 0,
    1, 0x0D4C, 0x0D46, 0x0D57, 0,
    1, 0x0DDA, 0x0DD9, 0x0DCA, 0,
    1, 0x0DDC, 0x0DD9, 0x0DCF, 0,
    1, 0x0DDD, 0x0DDC, 0x0DCA, 0,
    1, 0x0DDE, 0x0DD9, 0x0DDF, 0,
    16, 0x0E33, 0x0E4D, 0x0E32, 0,
    16, 0x0EB3, 0x0ECD, 0x0EB2, 0,
    16, 0x0EDC, 0x0EAB, 0x0E99, 0,
    16, 0x0EDD, 0x0EAB, 0x0EA1, 0,
    3, 0x0F0C, 0x0F0B, 0,
    1, 0x0F43, 0x0F42, 0x0FB7, 0,
    1, 0x0F4D, 0x0F4C, 0x0FB7, 0,
    1, 0x0F52, 0x0F51, 0x0FB7, 0,
    1, 0x0F57, 0x0F56, 0x0FB7, 0,
    1, 0x0F5C, 0x0F5B, 0x0FB7, 0,
    1, 0x0F69, 0x0F40, 0x0FB5, 0,
    1, 0x0F73, 0x0F71, 0x0F72, 0,
    1, 0x0F75, 0x0F71, 0x0F74, 0,
    1, 0x0F76, 0x0FB2, 0x0F80, 0,
    16, 0x0F77, 0x0FB2, 0x0F81, 0,
    1, 0x0F78, 0x0FB3, 0x0F80, 0,
    16, 0x0F79, 0x0FB3, 0x0F81, 0,
    1, 0x0F81, 0x0F71, 0x0F80, 0,
    1, 0x0F93, 0x0F92, 0x0FB7, 0,
    1, 0x0F9D, 0x0F9C, 0x0FB7, 0,
    1, 0x0FA2, 0x0FA1, 0x0FB7, 0,
    1, 0x0FA7, 0x0FA6, 0x0FB7, 0,
    1, 0x0FAC, 0x0FAB, 0x0FB7, 0,
    1, 0x0FB9, 0x0F90, 0x0FB5, 0,
    1, 0x1026, 0x1025, 0x102E, 0,
    1, 0x1E00, 0x0041, 0x0325, 0,
    1, 0x1E01, 0x0061, 0x0325, 0,
    1, 0x1E02, 0x0042, 0x0307, 0,
    1, 0x1E03, 0x0062, 0x0307, 0,
    1, 0x1E04, 0x0042, 0x0323, 0,
    1, 0x1E05, 0x0062, 0x0323, 0,
    1, 0x1E06, 0x0042, 0x0331, 0,
    1, 0x1E07, 0x0062, 0x0331, 0,
    1, 0x1E08, 0x00C7, 0x0301, 0,
    1, 0x1E09, 0x00E7, 0x0301, 0,
    1, 0x1E0A, 0x0044, 0x0307, 0,
    1, 0x1E0B, 0x0064, 0x0307, 0,
    1, 0x1E0C, 0x0044, 0x0323, 0,
    1, 0x1E0D, 0x0064, 0x0323, 0,
    1, 0x1E0E, 0x0044, 0x0331, 0,
    1, 0x1E0F, 0x0064, 0x0331, 0,
    1, 0x1E10, 0x0044, 0x0327, 0,
    1, 0x1E11, 0x0064, 0x0327, 0,
    1, 0x1E12, 0x0044, 0x032D, 0,
    1, 0x1E13, 0x0064, 0x032D, 0,
    1, 0x1E14, 0x0112, 0x0300, 0,
    1, 0x1E15, 0x0113, 0x0300, 0,
    1, 0x1E16, 0x0112, 0x0301, 0,
    1, 0x1E17, 0x0113, 0x0301, 0,
    1, 0x1E18, 0x0045, 0x032D, 0,
    1, 0x1E19, 0x0065, 0x032D, 0,
    1, 0x1E1A, 0x0045, 0x0330, 0,
    1, 0x1E1B, 0x0065, 0x0330, 0,
    1, 0x1E1C, 0x0228, 0x0306, 0,
    1, 0x1E1D, 0x0229, 0x0306, 0,
    1, 0x1E1E, 0x0046, 0x0307, 0,
    1, 0x1E1F, 0x0066, 0x0307, 0,
    1, 0x1E20, 0x0047, 0x0304, 0,
    1, 0x1E21, 0x0067, 0x0304, 0,
    1, 0x1E22, 0x0048, 0x0307, 0,
    1, 0x1E23, 0x0068, 0x0307, 0,
    1, 0x1E24, 0x0048, 0x0323, 0,
    1, 0x1E25, 0x0068, 0x0323, 0,
    1, 0x1E26, 0x0048, 0x0308, 0,
    1, 0x1E27, 0x0068, 0x0308, 0,
    1, 0x1E28, 0x0048, 0x0327, 0,
    1, 0x1E29, 0x0068, 0x0327, 0,
    1, 0x1E2A, 0x0048, 0x032E, 0,
    1, 0x1E2B, 0x0068, 0x032E, 0,
    1, 0x1E2C, 0x0049, 0x0330, 0,
    1, 0x1E2D, 0x0069, 0x0330, 0,
    1, 0x1E2E, 0x00CF, 0x0301, 0,
    1, 0x1E2F, 0x00EF, 0x0301, 0,
    1, 0x1E30, 0x004B, 0x0301, 0,
    1, 0x1E31, 0x006B, 0x0301, 0,
    1, 0x1E32, 0x004B, 0x0323, 0,
    1, 0x1E33, 0x006B, 0x0323, 0,
    1, 0x1E34, 0x004B, 0x0331, 0,
    1, 0x1E35, 0x006B, 0x0331, 0,
    1, 0x1E36, 0x004C, 0x0323, 0,
    1, 0x1E37, 0x006C, 0x0323, 0,
    1, 0x1E38, 0x1E36, 0x0304, 0,
    1, 0x1E39, 0x1E37, 0x0304, 0,
    1, 0x1E3A, 0x004C, 0x0331, 0,
    1, 0x1E3B, 0x006C, 0x0331, 0,
    1, 0x1E3C, 0x004C, 0x032D, 0,
    1, 0x1E3D, 0x006C, 0x032D, 0,
    1, 0x1E3E, 0x004D, 0x0301, 0,
    1, 0x1E3F, 0x006D, 0x0301, 0,
    1, 0x1E40, 0x004D, 0x0307, 0,
    1, 0x1E41, 0x006D, 0x0307, 0,
    1, 0x1E42, 0x004D, 0x0323, 0,
    1, 0x1E43, 0x006D, 0x0323, 0,
    1, 0x1E44, 0x004E, 0x0307, 0,
    1, 0x1E45, 0x006E, 0x0307, 0,
    1, 0x1E46, 0x004E, 0x0323, 0,
    1, 0x1E47, 0x006E, 0x0323, 0,
    1, 0x1E48, 0x004E, 0x0331, 0,
    1, 0x1E49, 0x006E, 0x0331, 0,
    1, 0x1E4A, 0x004E, 0x032D, 0,
    1, 0x1E4B, 0x006E, 0x032D, 0,
    1, 0x1E4C, 0x00D5, 0x0301, 0,
    1, 0x1E4D, 0x00F5, 0x0301, 0,
    1, 0x1E4E, 0x00D5, 0x0308, 0,
    1, 0x1E4F, 0x00F5, 0x0308, 0,
    1, 0x1E50, 0x014C, 0x0300, 0,
    1, 0x1E51, 0x014D, 0x0300, 0,
    1, 0x1E52, 0x014C, 0x0301, 0,
    1, 0x1E53, 0x014D, 0x0301, 0,
    1, 0x1E54, 0x0050, 0x0301, 0,
    1, 0x1E55, 0x0070, 0x0301, 0,
    1, 0x1E56, 0x0050, 0x0307, 0,
    1, 0x1E57, 0x0070, 0x0307, 0,
    1, 0x1E58, 0x0052, 0x0307, 0,
    1, 0x1E59, 0x0072, 0x0307, 0,
    1, 0x1E5A, 0x0052, 0x0323, 0,
    1, 0x1E5B, 0x0072, 0x0323, 0,
    1, 0x1E5C, 0x1E5A, 0x0304, 0,
    1, 0x1E5D, 0x1E5B, 0x0304, 0,
    1, 0x1E5E, 0x0052, 0x0331, 0,
    1, 0x1E5F, 0x0072, 0x0331, 0,
    1, 0x1E60, 0x0053, 0x0307, 0,
    1, 0x1E61, 0x0073, 0x0307, 0,
    1, 0x1E62, 0x0053, 0x0323, 0,
    1, 0x1E63, 0x0073, 0x0323, 0,
    1, 0x1E64, 0x015A, 0x0307, 0,
    1, 0x1E65, 0x015B, 0x0307, 0,
    1, 0x1E66, 0x0160, 0x0307, 0,
    1, 0x1E67, 0x0161, 0x0307, 0,
    1, 0x1E68, 0x1E62, 0x0307, 0,
    1, 0x1E69, 0x1E63, 0x0307, 0,
    1, 0x1E6A, 0x0054, 0x0307, 0,
    1, 0x1E6B, 0x0074, 0x0307, 0,
    1, 0x1E6C, 0x0054, 0x0323, 0,
    1, 0x1E6D, 0x0074, 0x0323, 0,
    1, 0x1E6E, 0x0054, 0x0331, 0,
    1, 0x1E6F, 0x0074, 0x0331, 0,
    1, 0x1E70, 0x0054, 0x032D, 0,
    1, 0x1E71, 0x0074, 0x032D, 0,
    1, 0x1E72, 0x0055, 0x0324, 0,
    1, 0x1E73, 0x0075, 0x0324, 0,
    1, 0x1E74, 0x0055, 0x0330, 0,
    1, 0x1E75, 0x0075, 0x0330, 0,
    1, 0x1E76, 0x0055, 0x032D, 0,
    1, 0x1E77, 0x0075, 0x032D, 0,
    1, 0x1E78, 0x0168, 0x0301, 0,
    1, 0x1E79, 0x0169, 0x0301, 0,
    1, 0x1E7A, 0x016A, 0x0308, 0,
    1, 0x1E7B, 0x016B, 0x0308, 0,
    1, 0x1E7C, 0x0056, 0x0303, 0,
    1, 0x1E7D, 0x0076, 0x0303, 0,
    1, 0x1E7E, 0x0056, 0x0323, 0,
    1, 0x1E7F, 0x0076, 0x0323, 0,
    1, 0x1E80, 0x0057, 0x0300, 0,
    1, 0x1E81, 0x0077, 0x0300, 0,
    1, 0x1E82, 0x0057, 0x0301, 0,
    1, 0x1E83, 0x0077, 0x0301, 0,
    1, 0x1E84, 0x0057, 0x0308, 0,
    1, 0x1E85, 0x0077, 0x0308, 0,
    1, 0x1E86, 0x0057, 0x0307, 0,
    1, 0x1E87, 0x0077, 0x0307, 0,
    1, 0x1E88, 0x0057, 0x0323, 0,
    1, 0x1E89, 0x0077, 0x0323, 0,
    1, 0x1E8A, 0x0058, 0x0307, 0,
    1, 0x1E8B, 0x0078, 0x0307, 0,
    1, 0x1E8C, 0x0058, 0x0308, 0,
    1, 0x1E8D, 0x0078, 0x0308, 0,
    1, 0x1E8E, 0x0059, 0x0307, 0,
    1, 0x1E8F, 0x0079, 0x0307, 0,
    1, 0x1E90, 0x005A, 0x0302, 0,
    1, 0x1E91, 0x007A, 0x0302, 0,
    1, 0x1E92, 0x005A, 0x0323, 0,
    1, 0x1E93, 0x007A, 0x0323, 0,
    1, 0x1E94, 0x005A, 0x0331, 0,
    1, 0x1E95, 0x007A, 0x0331, 0,
    1, 0x1E96, 0x0068, 0x0331, 0,
    1, 0x1E97, 0x0074, 0x0308, 0,
    1, 0x1E98, 0x0077, 0x030A, 0,
    1, 0x1E99, 0x0079, 0x030A, 0,
    16, 0x1E9A, 0x0061, 0x02BE, 0,
    1, 0x1E9B, 0x017F, 0x0307, 0,
    1, 0x1EA0, 0x0041, 0x0323, 0,
    1, 0x1EA1, 0x0061, 0x0323, 0,
    1, 0x1EA2, 0x0041, 0x0309, 0,
    1, 0x1EA3, 0x0061, 0x0309, 0,
    1, 0x1EA4, 0x00C2, 0x0301, 0,
    1, 0x1EA5, 0x00E2, 0x0301, 0,
    1, 0x1EA6, 0x00C2, 0x0300, 0,
    1, 0x1EA7, 0x00E2, 0x0300, 0,
    1, 0x1EA8, 0x00C2, 0x0309, 0,
    1, 0x1EA9, 0x00E2, 0x0309, 0,
    1, 0x1EAA, 0x00C2, 0x0303, 0,
    1, 0x1EAB, 0x00E2, 0x0303, 0,
    1, 0x1EAC, 0x1EA0, 0x0302, 0,
    1, 0x1EAD, 0x1EA1, 0x0302, 0,
    1, 0x1EAE, 0x0102, 0x0301, 0,
    1, 0x1EAF, 0x0103, 0x0301, 0,
    1, 0x1EB0, 0x0102, 0x0300, 0,
    1, 0x1EB1, 0x0103, 0x0300, 0,
    1, 0x1EB2, 0x0102, 0x0309, 0,
    1, 0x1EB3, 0x0103, 0x0309, 0,
    1, 0x1EB4, 0x0102, 0x0303, 0,
    1, 0x1EB5, 0x0103, 0x0303, 0,
    1, 0x1EB6, 0x1EA0, 0x0306, 0,
    1, 0x1EB7, 0x1EA1, 0x0306, 0,
    1, 0x1EB8, 0x0045, 0x0323, 0,
    1, 0x1EB9, 0x0065, 0x0323, 0,
    1, 0x1EBA, 0x0045, 0x0309, 0,
    1, 0x1EBB, 0x0065, 0x0309, 0,
    1, 0x1EBC, 0x0045, 0x0303, 0,
    1, 0x1EBD, 0x0065, 0x0303, 0,
    1, 0x1EBE, 0x00CA, 0x0301, 0,
    1, 0x1EBF, 0x00EA, 0x0301, 0,
    1, 0x1EC0, 0x00CA, 0x0300, 0,
    1, 0x1EC1, 0x00EA, 0x0300, 0,
    1, 0x1EC2, 0x00CA, 0x0309, 0,
    1, 0x1EC3, 0x00EA, 0x0309, 0,
    1, 0x1EC4, 0x00CA, 0x0303, 0,
    1, 0x1EC5, 0x00EA, 0x0303, 0,
    1, 0x1EC6, 0x1EB8, 0x0302, 0,
    1, 0x1EC7, 0x1EB9, 0x0302, 0,
    1, 0x1EC8, 0x0049, 0x0309, 0,
    1, 0x1EC9, 0x0069, 0x0309, 0,
    1, 0x1ECA, 0x0049, 0x0323, 0,
    1, 0x1ECB, 0x0069, 0x0323, 0,
    1, 0x1ECC, 0x004F, 0x0323, 0,
    1, 0x1ECD, 0x006F, 0x0323, 0,
    1, 0x1ECE, 0x004F, 0x0309, 0,
    1, 0x1ECF, 0x006F, 0x0309, 0,
    1, 0x1ED0, 0x00D4, 0x0301, 0,
    1, 0x1ED1, 0x00F4, 0x0301, 0,
    1, 0x1ED2, 0x00D4, 0x0300, 0,
    1, 0x1ED3, 0x00F4, 0x0300, 0,
    1, 0x1ED4, 0x00D4, 0x0309, 0,
    1, 0x1ED5, 0x00F4, 0x0309, 0,
    1, 0x1ED6, 0x00D4, 0x0303, 0,
    1, 0x1ED7, 0x00F4, 0x0303, 0,
    1, 0x1ED8, 0x1ECC, 0x0302, 0,
    1, 0x1ED9, 0x1ECD, 0x0302, 0,
    1, 0x1EDA, 0x01A0, 0x0301, 0,
    1, 0x1EDB, 0x01A1, 0x0301, 0,
    1, 0x1EDC, 0x01A0, 0x0300, 0,
    1, 0x1EDD, 0x01A1, 0x0300, 0,
    1, 0x1EDE, 0x01A0, 0x0309, 0,
    1, 0x1EDF, 0x01A1, 0x0309, 0,
    1, 0x1EE0, 0x01A0, 0x0303, 0,
    1, 0x1EE1, 0x01A1, 0x0303, 0,
    1, 0x1EE2, 0x01A0, 0x0323, 0,
    1, 0x1EE3, 0x01A1, 0x0323, 0,
    1, 0x1EE4, 0x0055, 0x0323, 0,
    1, 0x1EE5, 0x0075, 0x0323, 0,
    1, 0x1EE6, 0x0055, 0x0309, 0,
    1, 0x1EE7, 0x0075, 0x0309, 0,
    1, 0x1EE8, 0x01AF, 0x0301, 0,
    1, 0x1EE9, 0x01B0, 0x0301, 0,
    1, 0x1EEA, 0x01AF, 0x0300, 0,
    1, 0x1EEB, 0x01B0, 0x0300, 0,
    1, 0x1EEC, 0x01AF, 0x0309, 0,
    1, 0x1EED, 0x01B0, 0x0309, 0,
    1, 0x1EEE, 0x01AF, 0x0303, 0,
    1, 0x1EEF, 0x01B0, 0x0303, 0,
    1, 0x1EF0, 0x01AF, 0x0323, 0,
    1, 0x1EF1, 0x01B0, 0x0323, 0,
    1, 0x1EF2, 0x0059, 0x0300, 0,
    1, 0x1EF3, 0x0079, 0x0300, 0,
    1, 0x1EF4, 0x0059, 0x0323, 0,
    1, 0x1EF5, 0x0079, 0x0323, 0,
    1, 0x1EF6, 0x0059, 0x0309, 0,
    1, 0x1EF7, 0x0079, 0x0309, 0,
    1, 0x1EF8, 0x0059, 0x0303, 0,
    1, 0x1EF9, 0x0079, 0x0303, 0,
    1, 0x1F00, 0x03B1, 0x0313, 0,
    1, 0x1F01, 0x03B1, 0x0314, 0,
    1, 0x1F02, 0x1F00, 0x0300, 0,
    1, 0x1F03, 0x1F01, 0x0300, 0,
    1, 0x1F04, 0x1F00, 0x0301, 0,
    1, 0x1F05, 0x1F01, 0x0301, 0,
    1, 0x1F06, 0x1F00, 0x0342, 0,
    1, 0x1F07, 0x1F01, 0x0342, 0,
    1, 0x1F08, 0x0391, 0x0313, 0,
    1, 0x1F09, 0x0391, 0x0314, 0,
    1, 0x1F0A, 0x1F08, 0x0300, 0,
    1, 0x1F0B, 0x1F09, 0x0300, 0,
    1, 0x1F0C, 0x1F08, 0x0301, 0,
    1, 0x1F0D, 0x1F09, 0x0301, 0,
    1, 0x1F0E, 0x1F08, 0x0342, 0,
    1, 0x1F0F, 0x1F09, 0x0342, 0,
    1, 0x1F10, 0x03B5, 0x0313, 0,
    1, 0x1F11, 0x03B5, 0x0314, 0,
    1, 0x1F12, 0x1F10, 0x0300, 0,
    1, 0x1F13, 0x1F11, 0x0300, 0,
    1, 0x1F14, 0x1F10, 0x0301, 0,
    1, 0x1F15, 0x1F11, 0x0301, 0,
    1, 0x1F18, 0x0395, 0x0313, 0,
    1, 0x1F19, 0x0395, 0x0314, 0,
    1, 0x1F1A, 0x1F18, 0x0300, 0,
    1, 0x1F1B, 0x1F19, 0x0300, 0,
    1, 0x1F1C, 0x1F18, 0x0301, 0,
    1, 0x1F1D, 0x1F19, 0x0301, 0,
    1, 0x1F20, 0x03B7, 0x0313, 0,
    1, 0x1F21, 0x03B7, 0x0314, 0,
    1, 0x1F22, 0x1F20, 0x0300, 0,
    1, 0x1F23, 0x1F21, 0x0300, 0,
    1, 0x1F24, 0x1F20, 0x0301, 0,
    1, 0x1F25, 0x1F21, 0x0301, 0,
    1, 0x1F26, 0x1F20, 0x0342, 0,
    1, 0x1F27, 0x1F21, 0x0342, 0,
    1, 0x1F28, 0x0397, 0x0313, 0,
    1, 0x1F29, 0x0397, 0x0314, 0,
    1, 0x1F2A, 0x1F28, 0x0300, 0,
    1, 0x1F2B, 0x1F29, 0x0300, 0,
    1, 0x1F2C, 0x1F28, 0x0301, 0,
    1, 0x1F2D, 0x1F29, 0x0301, 0,
    1, 0x1F2E, 0x1F28, 0x0342, 0,
    1, 0x1F2F, 0x1F29, 0x0342, 0,
    1, 0x1F30, 0x03B9, 0x0313, 0,
    1, 0x1F31, 0x03B9, 0x0314, 0,
    1, 0x1F32, 0x1F30, 0x0300, 0,
    1, 0x1F33, 0x1F31, 0x0300, 0,
    1, 0x1F34, 0x1F30, 0x0301, 0,
    1, 0x1F35, 0x1F31, 0x0301, 0,
    1, 0x1F36, 0x1F30, 0x0342, 0,
    1, 0x1F37, 0x1F31, 0x0342, 0,
    1, 0x1F38, 0x0399, 0x0313, 0,
    1, 0x1F39, 0x0399, 0x0314, 0,
    1, 0x1F3A, 0x1F38, 0x0300, 0,
    1, 0x1F3B, 0x1F39, 0x0300, 0,
    1, 0x1F3C, 0x1F38, 0x0301, 0,
    1, 0x1F3D, 0x1F39, 0x0301, 0,
    1, 0x1F3E, 0x1F38, 0x0342, 0,
    1, 0x1F3F, 0x1F39, 0x0342, 0,
    1, 0x1F40, 0x03BF, 0x0313, 0,
    1, 0x1F41, 0x03BF, 0x0314, 0,
    1, 0x1F42, 0x1F40, 0x0300, 0,
    1, 0x1F43, 0x1F41, 0x0300, 0,
    1, 0x1F44, 0x1F40, 0x0301, 0,
    1, 0x1F45, 0x1F41, 0x0301, 0,
    1, 0x1F48, 0x039F, 0x0313, 0,
    1, 0x1F49, 0x039F, 0x0314, 0,
    1, 0x1F4A, 0x1F48, 0x0300, 0,
    1, 0x1F4B, 0x1F49, 0x0300, 0,
    1, 0x1F4C, 0x1F48, 0x0301, 0,
    1, 0x1F4D, 0x1F49, 0x0301, 0,
    1, 0x1F50, 0x03C5, 0x0313, 0,
    1, 0x1F51, 0x03C5, 0x0314, 0,
    1, 0x1F52, 0x1F50, 0x0300, 0,
    1, 0x1F53, 0x1F51, 0x0300, 0,
    1, 0x1F54, 0x1F50, 0x0301, 0,
    1, 0x1F55, 0x1F51, 0x0301, 0,
    1, 0x1F56, 0x1F50, 0x0342, 0,
    1, 0x1F57, 0x1F51, 0x0342, 0,
    1, 0x1F59, 0x03A5, 0x0314, 0,
    1, 0x1F5B, 0x1F59, 0x0300, 0,
    1, 0x1F5D, 0x1F59, 0x0301, 0,
    1, 0x1F5F, 0x1F59, 0x0342, 0,
    1, 0x1F60, 0x03C9, 0x0313, 0,
    1, 0x1F61, 0x03C9, 0x0314, 0,
    1, 0x1F62, 0x1F60, 0x0300, 0,
    1, 0x1F63, 0x1F61, 0x0300, 0,
    1, 0x1F64, 0x1F60, 0x0301, 0,
    1, 0x1F65, 0x1F61, 0x0301, 0,
    1, 0x1F66, 0x1F60, 0x0342, 0,
    1, 0x1F67, 0x1F61, 0x0342, 0,
    1, 0x1F68, 0x03A9, 0x0313, 0,
    1, 0x1F69, 0x03A9, 0x0314, 0,
    1, 0x1F6A, 0x1F68, 0x0300, 0,
    1, 0x1F6B, 0x1F69, 0x0300, 0,
    1, 0x1F6C, 0x1F68, 0x0301, 0,
    1, 0x1F6D, 0x1F69, 0x0301, 0,
    1, 0x1F6E, 0x1F68, 0x0342, 0,
    1, 0x1F6F, 0x1F69, 0x0342, 0,
    1, 0x1F70, 0x03B1, 0x0300, 0,
    1, 0x1F71, 0x03AC, 0,
    1, 0x1F72, 0x03B5, 0x0300, 0,
    1, 0x1F73, 0x03AD, 0,
    1, 0x1F74, 0x03B7, 0x0300, 0,
    1, 0x1F75, 0x03AE, 0,
    1, 0x1F76, 0x03B9, 0x0300, 0,
    1, 0x1F77, 0x03AF, 0,
    1, 0x1F78, 0x03BF, 0x0300, 0,
    1, 0x1F79, 0x03CC, 0,
    1, 0x1F7A, 0x03C5, 0x0300, 0,
    1, 0x1F7B, 0x03CD, 0,
    1, 0x1F7C, 0x03C9, 0x0300, 0,
    1, 0x1F7D, 0x03CE, 0,
    1, 0x1F80, 0x1F00, 0x0345, 0,
    1, 0x1F81, 0x1F01, 0x0345, 0,
    1, 0x1F82, 0x1F02, 0x0345, 0,
    1, 0x1F83, 0x1F03, 0x0345, 0,
    1, 0x1F84, 0x1F04, 0x0345, 0,
    1, 0x1F85, 0x1F05, 0x0345, 0,
    1, 0x1F86, 0x1F06, 0x0345, 0,
    1, 0x1F87, 0x1F07, 0x0345, 0,
    1, 0x1F88, 0x1F08, 0x0345, 0,
    1, 0x1F89, 0x1F09, 0x0345, 0,
    1, 0x1F8A, 0x1F0A, 0x0345, 0,
    1, 0x1F8B, 0x1F0B, 0x0345, 0,
    1, 0x1F8C, 0x1F0C, 0x0345, 0,
    1, 0x1F8D, 0x1F0D, 0x0345, 0,
    1, 0x1F8E, 0x1F0E, 0x0345, 0,
    1, 0x1F8F, 0x1F0F, 0x0345, 0,
    1, 0x1F90, 0x1F20, 0x0345, 0,
    1, 0x1F91, 0x1F21, 0x0345, 0,
    1, 0x1F92, 0x1F22, 0x0345, 0,
    1, 0x1F93, 0x1F23, 0x0345, 0,
    1, 0x1F94, 0x1F24, 0x0345, 0,
    1, 0x1F95, 0x1F25, 0x0345, 0,
    1, 0x1F96, 0x1F26, 0x0345, 0,
    1, 0x1F97, 0x1F27, 0x0345, 0,
    1, 0x1F98, 0x1F28, 0x0345, 0,
    1, 0x1F99, 0x1F29, 0x0345, 0,
    1, 0x1F9A, 0x1F2A, 0x0345, 0,
    1, 0x1F9B, 0x1F2B, 0x0345, 0,
    1, 0x1F9C, 0x1F2C, 0x0345, 0,
    1, 0x1F9D, 0x1F2D, 0x0345, 0,
    1, 0x1F9E, 0x1F2E, 0x0345, 0,
    1, 0x1F9F, 0x1F2F, 0x0345, 0,
    1, 0x1FA0, 0x1F60, 0x0345, 0,
    1, 0x1FA1, 0x1F61, 0x0345, 0,
    1, 0x1FA2, 0x1F62, 0x0345, 0,
    1, 0x1FA3, 0x1F63, 0x0345, 0,
    1, 0x1FA4, 0x1F64, 0x0345, 0,
    1, 0x1FA5, 0x1F65, 0x0345, 0,
    1, 0x1FA6, 0x1F66, 0x0345, 0,
    1, 0x1FA7, 0x1F67, 0x0345, 0,
    1, 0x1FA8, 0x1F68, 0x0345, 0,
    1, 0x1FA9, 0x1F69, 0x0345, 0,
    1, 0x1FAA, 0x1F6A, 0x0345, 0,
    1, 0x1FAB, 0x1F6B, 0x0345, 0,
    1, 0x1FAC, 0x1F6C, 0x0345, 0,
    1, 0x1FAD, 0x1F6D, 0x0345, 0,
    1, 0x1FAE, 0x1F6E, 0x0345, 0,
    1, 0x1FAF, 0x1F6F, 0x0345, 0,
    1, 0x1FB0, 0x03B1, 0x0306, 0,
    1, 0x1FB1, 0x03B1, 0x0304, 0,
    1, 0x1FB2, 0x1F70, 0x0345, 0,
    1, 0x1FB3, 0x03B1, 0x0345, 0,
    1, 0x1FB4, 0x03AC, 0x0345, 0,
    1, 0x1FB6, 0x03B1, 0x0342, 0,
    1, 0x1FB7, 0x1FB6, 0x0345, 0,
    1, 0x1FB8, 0x0391, 0x0306, 0,
    1, 0x1FB9, 0x0391, 0x0304, 0,
    1, 0x1FBA, 0x0391, 0x0300, 0,
    1, 0x1FBB, 0x0386, 0,
    1, 0x1FBC, 0x0391, 0x0345, 0,
    16, 0x1FBD, 0x0020, 0x0313, 0,
    1, 0x1FBE, 0x03B9, 0,
    16, 0x1FBF, 0x0020, 0x0313, 0,
    16, 0x1FC0, 0x0020, 0x0342, 0,
    1, 0x1FC1, 0x00A8, 0x0342, 0,
    1, 0x1FC2, 0x1F74, 0x0345, 0,
    1, 0x1FC3, 0x03B7, 0x0345, 0,
    1, 0x1FC4, 0x03AE, 0x0345, 0,
    1, 0x1FC6, 0x03B7, 0x0342, 0,
    1, 0x1FC7, 0x1FC6, 0x0345, 0,
    1, 0x1FC8, 0x0395, 0x0300, 0,
    1, 0x1FC9, 0x0388, 0,
    1, 0x1FCA, 0x0397, 0x0300, 0,
    1, 0x1FCB, 0x0389, 0,
    1, 0x1FCC, 0x0397, 0x0345, 0,
    1, 0x1FCD, 0x1FBF, 0x0300, 0,
    1, 0x1FCE, 0x1FBF, 0x0301, 0,
    1, 0x1FCF, 0x1FBF, 0x0342, 0,
    1, 0x1FD0, 0x03B9, 0x0306, 0,
    1, 0x1FD1, 0x03B9, 0x0304, 0,
    1, 0x1FD2, 0x03CA, 0x0300, 0,
    1, 0x1FD3, 0x0390, 0,
    1, 0x1FD6, 0x03B9, 0x0342, 0,
    1, 0x1FD7, 0x03CA, 0x0342, 0,
    1, 0x1FD8, 0x0399, 0x0306, 0,
    1, 0x1FD9, 0x0399, 0x0304, 0,
    1, 0x1FDA, 0x0399, 0x0300, 0,
    1, 0x1FDB, 0x038A, 0,
    1, 0x1FDD, 0x1FFE, 0x0300, 0,
    1, 0x1FDE, 0x1FFE, 0x0301, 0,
    1, 0x1FDF, 0x1FFE, 0x0342, 0,
    1, 0x1FE0, 0x03C5, 0x0306, 0,
    1, 0x1FE1, 0x03C5, 0x0304, 0,
    1, 0x1FE2, 0x03CB, 0x0300, 0,
    1, 0x1FE3, 0x03B0, 0,
    1, 0x1FE4, 0x03C1, 0x0313, 0,
    1, 0x1FE5, 0x03C1, 0x0314, 0,
    1, 0x1FE6, 0x03C5, 0x0342, 0,
    1, 0x1FE7, 0x03CB, 0x0342, 0,
    1, 0x1FE8, 0x03A5, 0x0306, 0,
    1, 0x1FE9, 0x03A5, 0x0304, 0,
    1, 0x1FEA, 0x03A5, 0x0300, 0,
    1, 0x1FEB, 0x038E, 0,
    1, 0x1FEC, 0x03A1, 0x0314, 0,
    1, 0x1FED, 0x00A8, 0x0300, 0,
    1, 0x1FEE, 0x0385, 0,
    1, 0x1FEF, 0x0060, 0,
    1, 0x1FF2, 0x1F7C, 0x0345, 0,
    1, 0x1FF3, 0x03C9, 0x0345, 0,
    1, 0x1FF4, 0x03CE, 0x0345, 0,
    1, 0x1FF6, 0x03C9, 0x0342, 0,
    1, 0x1FF7, 0x1FF6, 0x0345, 0,
    1, 0x1FF8, 0x039F, 0x0300, 0,
    1, 0x1FF9, 0x038C, 0,
    1, 0x1FFA, 0x03A9, 0x0300, 0,
    1, 0x1FFB, 0x038F, 0,
    1, 0x1FFC, 0x03A9, 0x0345, 0,
    1, 0x1FFD, 0x00B4, 0,
    16, 0x1FFE, 0x0020, 0x0314, 0,
    1, 0x2000, 0x2002, 0,
    1, 0x2001, 0x2003, 0,
    16, 0x2002, 0x0020, 0,
    16, 0x2003, 0x0020, 0,
    16, 0x2004, 0x0020, 0,
    16, 0x2005, 0x0020, 0,
    16, 0x2006, 0x0020, 0,
    3, 0x2007, 0x0020, 0,
    16, 0x2008, 0x0020, 0,
    16, 0x2009, 0x0020, 0,
    16, 0x200A, 0x0020, 0,
    3, 0x2011, 0x2010, 0,
    16, 0x2017, 0x0020, 0x0333, 0,
    16, 0x2024, 0x002E, 0,
    16, 0x2025, 0x002E, 0x002E, 0,
    16, 0x2026, 0x002E, 0x002E, 0x002E, 0,
    3, 0x202F, 0x0020, 0,
    16, 0x2033, 0x2032, 0x2032, 0,
    16, 0x2034, 0x2032, 0x2032, 0x2032, 0,
    16, 0x2036, 0x2035, 0x2035, 0,
    16, 0x2037, 0x2035, 0x2035, 0x2035, 0,
    16, 0x203C, 0x0021, 0x0021, 0,
    16, 0x203E, 0x0020, 0x0305, 0,
    16, 0x2047, 0x003F, 0x003F, 0,
    16, 0x2048, 0x003F, 0x0021, 0,
    16, 0x2049, 0x0021, 0x003F, 0,
    16, 0x2057, 0x2032, 0x2032, 0x2032, 0x2032, 0,
    16, 0x205F, 0x0020, 0,
    9, 0x2070, 0x0030, 0,
    9, 0x2071, 0x0069, 0,
    9, 0x2074, 0x0034, 0,
    9, 0x2075, 0x0035, 0,
    9, 0x2076, 0x0036, 0,
    9, 0x2077, 0x0037, 0,
    9, 0x2078, 0x0038, 0,
    9, 0x2079, 0x0039, 0,
    9, 0x207A, 0x002B, 0,
    9, 0x207B, 0x2212, 0,
    9, 0x207C, 0x003D, 0,
    9, 0x207D, 0x0028, 0,
    9, 0x207E, 0x0029, 0,
    9, 0x207F, 0x006E, 0,
    10, 0x2080, 0x0030, 0,
    10, 0x2081, 0x0031, 0,
    10, 0x2082, 0x0032, 0,
    10, 0x2083, 0x0033, 0,
    10, 0x2084, 0x0034, 0,
    10, 0x2085, 0x0035, 0,
    10, 0x2086, 0x0036, 0,
    10, 0x2087, 0x0037, 0,
    10, 0x2088, 0x0038, 0,
    10, 0x2089, 0x0039, 0,
    10, 0x208A, 0x002B, 0,
    10, 0x208B, 0x2212, 0,
    10, 0x208C, 0x003D, 0,
    10, 0x208D, 0x0028, 0,
    10, 0x208E, 0x0029, 0,
    16, 0x20A8, 0x0052, 0x0073, 0,
    16, 0x2100, 0x0061, 0x002F, 0x0063, 0,
    16, 0x2101, 0x0061, 0x002F, 0x0073, 0,
    2, 0x2102, 0x0043, 0,
    16, 0x2103, 0x00B0, 0x0043, 0,
    16, 0x2105, 0x0063, 0x002F, 0x006F, 0,
    16, 0x2106, 0x0063, 0x002F, 0x0075, 0,
    16, 0x2107, 0x0190, 0,
    16, 0x2109, 0x00B0, 0x0046, 0,
    2, 0x210A, 0x0067, 0,
    2, 0x210B, 0x0048, 0,
    2, 0x210C, 0x0048, 0,
    2, 0x210D, 0x0048, 0,
    2, 0x210E, 0x0068, 0,
    2, 0x210F, 0x0127, 0,
    2, 0x2110, 0x0049, 0,
    2, 0x2111, 0x0049, 0,
    2, 0x2112, 0x004C, 0,
    2, 0x2113, 0x006C, 0,
    2, 0x2115, 0x004E, 0,
    16, 0x2116, 0x004E, 0x006F, 0,
    2, 0x2119, 0x0050, 0,
    2, 0x211A, 0x0051, 0,
    2, 0x211B, 0x0052, 0,
    2, 0x211C, 0x0052, 0,
    2, 0x211D, 0x0052, 0,
    9, 0x2120, 0x0053, 0x004D, 0,
    16, 0x2121, 0x0054, 0x0045, 0x004C, 0,
    9, 0x2122, 0x0054, 0x004D, 0,
    2, 0x2124, 0x005A, 0,
    1, 0x2126, 0x03A9, 0,
    2, 0x2128, 0x005A, 0,
    1, 0x212A, 0x004B, 0,
    1, 0x212B, 0x00C5, 0,
    2, 0x212C, 0x0042, 0,
    2, 0x212D, 0x0043, 0,
    2, 0x212F, 0x0065, 0,
    2, 0x2130, 0x0045, 0,
    2, 0x2131, 0x0046, 0,
    2, 0x2133, 0x004D, 0,
    2, 0x2134, 0x006F, 0,
    16, 0x2135, 0x05D0, 0,
    16, 0x2136, 0x05D1, 0,
    16, 0x2137, 0x05D2, 0,
    16, 0x2138, 0x05D3, 0,
    2, 0x2139, 0x0069, 0,
    2, 0x213D, 0x03B3, 0,
    2, 0x213E, 0x0393, 0,
    2, 0x213F, 0x03A0, 0,
    2, 0x2140, 0x2211, 0,
    2, 0x2145, 0x0044, 0,
    2, 0x2146, 0x0064, 0,
    2, 0x2147, 0x0065, 0,
    2, 0x2148, 0x0069, 0,
    2, 0x2149, 0x006A, 0,
    17, 0x2153, 0x0031, 0x2044, 0x0033, 0,
    17, 0x2154, 0x0032, 0x2044, 0x0033, 0,
    17, 0x2155, 0x0031, 0x2044, 0x0035, 0,
    17, 0x2156, 0x0032, 0x2044, 0x0035, 0,
    17, 0x2157, 0x0033, 0x2044, 0x0035, 0,
    17, 0x2158, 0x0034, 0x2044, 0x0035, 0,
    17, 0x2159, 0x0031, 0x2044, 0x0036, 0,
    17, 0x215A, 0x0035, 0x2044, 0x0036, 0,
    17, 0x215B, 0x0031, 0x2044, 0x0038, 0,
    17, 0x215C, 0x0033, 0x2044, 0x0038, 0,
    17, 0x215D, 0x0035, 0x2044, 0x0038, 0,
    17, 0x215E, 0x0037, 0x2044, 0x0038, 0,
    17, 0x215F, 0x0031, 0x2044, 0,
    16, 0x2160, 0x0049, 0,
    16, 0x2161, 0x0049, 0x0049, 0,
    16, 0x2162, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2163, 0x0049, 0x0056, 0,
    16, 0x2164, 0x0056, 0,
    16, 0x2165, 0x0056, 0x0049, 0,
    16, 0x2166, 0x0056, 0x0049, 0x0049, 0,
    16, 0x2167, 0x0056, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2168, 0x0049, 0x0058, 0,
    16, 0x2169, 0x0058, 0,
    16, 0x216A, 0x0058, 0x0049, 0,
    16, 0x216B, 0x0058, 0x0049, 0x0049, 0,
    16, 0x216C, 0x004C, 0,
    16, 0x216D, 0x0043, 0,
    16, 0x216E, 0x0044, 0,
    16, 0x216F, 0x004D, 0,
    16, 0x2170, 0x0069, 0,
    16, 0x2171, 0x0069, 0x0069, 0,
    16, 0x2172, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2173, 0x0069, 0x0076, 0,
    16, 0x2174, 0x0076, 0,
    16, 0x2175, 0x0076, 0x0069, 0,
    16, 0x2176, 0x0076, 0x0069, 0x0069, 0,
    16, 0x2177, 0x0076, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2178, 0x0069, 0x0078, 0,
    16, 0x2179, 0x0078, 0,
    16, 0x217A, 0x0078, 0x0069, 0,
    16, 0x217B, 0x0078, 0x0069, 0x0069, 0,
    16, 0x217C, 0x006C, 0,
    16, 0x217D, 0x0063, 0,
    16, 0x217E, 0x0064, 0,
    16, 0x217F, 0x006D, 0,
    1, 0x219A, 0x2190, 0x0338, 0,
    1, 0x219B, 0x2192, 0x0338, 0,
    1, 0x21AE, 0x2194, 0x0338, 0,
    1, 0x21CD, 0x21D0, 0x0338, 0,
    1, 0x21CE, 0x21D4, 0x0338, 0,
    1, 0x21CF, 0x21D2, 0x0338, 0,
    1, 0x2204, 0x2203, 0x0338, 0,
    1, 0x2209, 0x2208, 0x0338, 0,
    1, 0x220C, 0x220B, 0x0338, 0,
    1, 0x2224, 0x2223, 0x0338, 0,
    1, 0x2226, 0x2225, 0x0338, 0,
    16, 0x222C, 0x222B, 0x222B, 0,
    16, 0x222D, 0x222B, 0x222B, 0x222B, 0,
    16, 0x222F, 0x222E, 0x222E, 0,
    16, 0x2230, 0x222E, 0x222E, 0x222E, 0,
    1, 0x2241, 0x223C, 0x0338, 0,
    1, 0x2244, 0x2243, 0x0338, 0,
    1, 0x2247, 0x2245, 0x0338, 0,
    1, 0x2249, 0x2248, 0x0338, 0,
    1, 0x2260, 0x003D, 0x0338, 0,
    1, 0x2262, 0x2261, 0x0338, 0,
    1, 0x226D, 0x224D, 0x0338, 0,
    1, 0x226E, 0x003C, 0x0338, 0,
    1, 0x226F, 0x003E, 0x0338, 0,
    1, 0x2270, 0x2264, 0x0338, 0,
    1, 0x2271, 0x2265, 0x0338, 0,
    1, 0x2274, 0x2272, 0x0338, 0,
    1, 0x2275, 0x2273, 0x0338, 0,
    1, 0x2278, 0x2276, 0x0338, 0,
    1, 0x2279, 0x2277, 0x0338, 0,
    1, 0x2280, 0x227A, 0x0338, 0,
    1, 0x2281, 0x227B, 0x0338, 0,
    1, 0x2284, 0x2282, 0x0338, 0,
    1, 0x2285, 0x2283, 0x0338, 0,
    1, 0x2288, 0x2286, 0x0338, 0,
    1, 0x2289, 0x2287, 0x0338, 0,
    1, 0x22AC, 0x22A2, 0x0338, 0,
    1, 0x22AD, 0x22A8, 0x0338, 0,
    1, 0x22AE, 0x22A9, 0x0338, 0,
    1, 0x22AF, 0x22AB, 0x0338, 0,
    1, 0x22E0, 0x227C, 0x0338, 0,
    1, 0x22E1, 0x227D, 0x0338, 0,
    1, 0x22E2, 0x2291, 0x0338, 0,
    1, 0x22E3, 0x2292, 0x0338, 0,
    1, 0x22EA, 0x22B2, 0x0338, 0,
    1, 0x22EB, 0x22B3, 0x0338, 0,
    1, 0x22EC, 0x22B4, 0x0338, 0,
    1, 0x22ED, 0x22B5, 0x0338, 0,
    1, 0x2329, 0x3008, 0,
    1, 0x232A, 0x3009, 0,
    8, 0x2460, 0x0031, 0,
    8, 0x2461, 0x0032, 0,
    8, 0x2462, 0x0033, 0,
    8, 0x2463, 0x0034, 0,
    8, 0x2464, 0x0035, 0,
    8, 0x2465, 0x0036, 0,
    8, 0x2466, 0x0037, 0,
    8, 0x2467, 0x0038, 0,
    8, 0x2468, 0x0039, 0,
    8, 0x2469, 0x0031, 0x0030, 0,
    8, 0x246A, 0x0031, 0x0031, 0,
    8, 0x246B, 0x0031, 0x0032, 0,
    8, 0x246C, 0x0031, 0x0033, 0,
    8, 0x246D, 0x0031, 0x0034, 0,
    8, 0x246E, 0x0031, 0x0035, 0,
    8, 0x246F, 0x0031, 0x0036, 0,
    8, 0x2470, 0x0031, 0x0037, 0,
    8, 0x2471, 0x0031, 0x0038, 0,
    8, 0x2472, 0x0031, 0x0039, 0,
    8, 0x2473, 0x0032, 0x0030, 0,
    16, 0x2474, 0x0028, 0x0031, 0x0029, 0,
    16, 0x2475, 0x0028, 0x0032, 0x0029, 0,
    16, 0x2476, 0x0028, 0x0033, 0x0029, 0,
    16, 0x2477, 0x0028, 0x0034, 0x0029, 0,
    16, 0x2478, 0x0028, 0x0035, 0x0029, 0,
    16, 0x2479, 0x0028, 0x0036, 0x0029, 0,
    16, 0x247A, 0x0028, 0x0037, 0x0029, 0,
    16, 0x247B, 0x0028, 0x0038, 0x0029, 0,
    16, 0x247C, 0x0028, 0x0039, 0x0029, 0,
    16, 0x247D, 0x0028, 0x0031, 0x0030, 0x0029, 0,
    16, 0x247E, 0x0028, 0x0031, 0x0031, 0x0029, 0,
    16, 0x247F, 0x0028, 0x0031, 0x0032, 0x0029, 0,
    16, 0x2480, 0x0028, 0x0031, 0x0033, 0x0029, 0,
    16, 0x2481, 0x0028, 0x0031, 0x0034, 0x0029, 0,
    16, 0x2482, 0x0028, 0x0031, 0x0035, 0x0029, 0,
    16, 0x2483, 0x0028, 0x0031, 0x0036, 0x0029, 0,
    16, 0x2484, 0x0028, 0x0031, 0x0037, 0x0029, 0,
    16, 0x2485, 0x0028, 0x0031, 0x0038, 0x0029, 0,
    16, 0x2486, 0x0028, 0x0031, 0x0039, 0x0029, 0,
    16, 0x2487, 0x0028, 0x0032, 0x0030, 0x0029, 0,
    16, 0x2488, 0x0031, 0x002E, 0,
    16, 0x2489, 0x0032, 0x002E, 0,
    16, 0x248A, 0x0033, 0x002E, 0,
    16, 0x248B, 0x0034, 0x002E, 0,
    16, 0x248C, 0x0035, 0x002E, 0,
    16, 0x248D, 0x0036, 0x002E, 0,
    16, 0x248E, 0x0037, 0x002E, 0,
    16, 0x248F, 0x0038, 0x002E, 0,
    16, 0x2490, 0x0039, 0x002E, 0,
    16, 0x2491, 0x0031, 0x0030, 0x002E, 0,
    16, 0x2492, 0x0031, 0x0031, 0x002E, 0,
    16, 0x2493, 0x0031, 0x0032, 0x002E, 0,
    16, 0x2494, 0x0031, 0x0033, 0x002E, 0,
    16, 0x2495, 0x0031, 0x0034, 0x002E, 0,
    16, 0x2496, 0x0031, 0x0035, 0x002E, 0,
    16, 0x2497, 0x0031, 0x0036, 0x002E, 0,
    16, 0x2498, 0x0031, 0x0037, 0x002E, 0,
    16, 0x2499, 0x0031, 0x0038, 0x002E, 0,
    16, 0x249A, 0x0031, 0x0039, 0x002E, 0,
    16, 0x249B, 0x0032, 0x0030, 0x002E, 0,
    16, 0x249C, 0x0028, 0x0061, 0x0029, 0,
    16, 0x249D, 0x0028, 0x0062, 0x0029, 0,
    16, 0x249E, 0x0028, 0x0063, 0x0029, 0,
    16, 0x249F, 0x0028, 0x0064, 0x0029, 0,
    16, 0x24A0, 0x0028, 0x0065, 0x0029, 0,
    16, 0x24A1, 0x0028, 0x0066, 0x0029, 0,
    16, 0x24A2, 0x0028, 0x0067, 0x0029, 0,
    16, 0x24A3, 0x0028, 0x0068, 0x0029, 0,
    16, 0x24A4, 0x0028, 0x0069, 0x0029, 0,
    16, 0x24A5, 0x0028, 0x006A, 0x0029, 0,
    16, 0x24A6, 0x0028, 0x006B, 0x0029, 0,
    16, 0x24A7, 0x0028, 0x006C, 0x0029, 0,
    16, 0x24A8, 0x0028, 0x006D, 0x0029, 0,
    16, 0x24A9, 0x0028, 0x006E, 0x0029, 0,
    16, 0x24AA, 0x0028, 0x006F, 0x0029, 0,
    16, 0x24AB, 0x0028, 0x0070, 0x0029, 0,
    16, 0x24AC, 0x0028, 0x0071, 0x0029, 0,
    16, 0x24AD, 0x0028, 0x0072, 0x0029, 0,
    16, 0x24AE, 0x0028, 0x0073, 0x0029, 0,
    16, 0x24AF, 0x0028, 0x0074, 0x0029, 0,
    16, 0x24B0, 0x0028, 0x0075, 0x0029, 0,
    16, 0x24B1, 0x0028, 0x0076, 0x0029, 0,
    16, 0x24B2, 0x0028, 0x0077, 0x0029, 0,
    16, 0x24B3, 0x0028, 0x0078, 0x0029, 0,
    16, 0x24B4, 0x0028, 0x0079, 0x0029, 0,
    16, 0x24B5, 0x0028, 0x007A, 0x0029, 0,
    8, 0x24B6, 0x0041, 0,
    8, 0x24B7, 0x0042, 0,
    8, 0x24B8, 0x0043, 0,
    8, 0x24B9, 0x0044, 0,
    8, 0x24BA, 0x0045, 0,
    8, 0x24BB, 0x0046, 0,
    8, 0x24BC, 0x0047, 0,
    8, 0x24BD, 0x0048, 0,
    8, 0x24BE, 0x0049, 0,
    8, 0x24BF, 0x004A, 0,
    8, 0x24C0, 0x004B, 0,
    8, 0x24C1, 0x004C, 0,
    8, 0x24C2, 0x004D, 0,
    8, 0x24C3, 0x004E, 0,
    8, 0x24C4, 0x004F, 0,
    8, 0x24C5, 0x0050, 0,
    8, 0x24C6, 0x0051, 0,
    8, 0x24C7, 0x0052, 0,
    8, 0x24C8, 0x0053, 0,
    8, 0x24C9, 0x0054, 0,
    8, 0x24CA, 0x0055, 0,
    8, 0x24CB, 0x0056, 0,
    8, 0x24CC, 0x0057, 0,
    8, 0x24CD, 0x0058, 0,
    8, 0x24CE, 0x0059, 0,
    8, 0x24CF, 0x005A, 0,
    8, 0x24D0, 0x0061, 0,
    8, 0x24D1, 0x0062, 0,
    8, 0x24D2, 0x0063, 0,
    8, 0x24D3, 0x0064, 0,
    8, 0x24D4, 0x0065, 0,
    8, 0x24D5, 0x0066, 0,
    8, 0x24D6, 0x0067, 0,
    8, 0x24D7, 0x0068, 0,
    8, 0x24D8, 0x0069, 0,
    8, 0x24D9, 0x006A, 0,
    8, 0x24DA, 0x006B, 0,
    8, 0x24DB, 0x006C, 0,
    8, 0x24DC, 0x006D, 0,
    8, 0x24DD, 0x006E, 0,
    8, 0x24DE, 0x006F, 0,
    8, 0x24DF, 0x0070, 0,
    8, 0x24E0, 0x0071, 0,
    8, 0x24E1, 0x0072, 0,
    8, 0x24E2, 0x0073, 0,
    8, 0x24E3, 0x0074, 0,
    8, 0x24E4, 0x0075, 0,
    8, 0x24E5, 0x0076, 0,
    8, 0x24E6, 0x0077, 0,
    8, 0x24E7, 0x0078, 0,
    8, 0x24E8, 0x0079, 0,
    8, 0x24E9, 0x007A, 0,
    8, 0x24EA, 0x0030, 0,
    16, 0x2A0C, 0x222B, 0x222B, 0x222B, 0x222B, 0,
    16, 0x2A74, 0x003A, 0x003A, 0x003D, 0,
    16, 0x2A75, 0x003D, 0x003D, 0,
    16, 0x2A76, 0x003D, 0x003D, 0x003D, 0,
    1, 0x2ADC, 0x2ADD, 0x0338, 0,
    16, 0x2E9F, 0x6BCD, 0,
    16, 0x2EF3, 0x9F9F, 0,
    16, 0x2F00, 0x4E00, 0,
    16, 0x2F01, 0x4E28, 0,
    16, 0x2F02, 0x4E36, 0,
    16, 0x2F03, 0x4E3F, 0,
    16, 0x2F04, 0x4E59, 0,
    16, 0x2F05, 0x4E85, 0,
    16, 0x2F06, 0x4E8C, 0,
    16, 0x2F07, 0x4EA0, 0,
    16, 0x2F08, 0x4EBA, 0,
    16, 0x2F09, 0x513F, 0,
    16, 0x2F0A, 0x5165, 0,
    16, 0x2F0B, 0x516B, 0,
    16, 0x2F0C, 0x5182, 0,
    16, 0x2F0D, 0x5196, 0,
    16, 0x2F0E, 0x51AB, 0,
    16, 0x2F0F, 0x51E0, 0,
    16, 0x2F10, 0x51F5, 0,
    16, 0x2F11, 0x5200, 0,
    16, 0x2F12, 0x529B, 0,
    16, 0x2F13, 0x52F9, 0,
    16, 0x2F14, 0x5315, 0,
    16, 0x2F15, 0x531A, 0,
    16, 0x2F16, 0x5338, 0,
    16, 0x2F17, 0x5341, 0,
    16, 0x2F18, 0x535C, 0,
    16, 0x2F19, 0x5369, 0,
    16, 0x2F1A, 0x5382, 0,
    16, 0x2F1B, 0x53B6, 0,
    16, 0x2F1C, 0x53C8, 0,
    16, 0x2F1D, 0x53E3, 0,
    16, 0x2F1E, 0x56D7, 0,
    16, 0x2F1F, 0x571F, 0,
    16, 0x2F20, 0x58EB, 0,
    16, 0x2F21, 0x5902, 0,
    16, 0x2F22, 0x590A, 0,
    16, 0x2F23, 0x5915, 0,
    16, 0x2F24, 0x5927, 0,
    16, 0x2F25, 0x5973, 0,
    16, 0x2F26, 0x5B50, 0,
    16, 0x2F27, 0x5B80, 0,
    16, 0x2F28, 0x5BF8, 0,
    16, 0x2F29, 0x5C0F, 0,
    16, 0x2F2A, 0x5C22, 0,
    16, 0x2F2B, 0x5C38, 0,
    16, 0x2F2C, 0x5C6E, 0,
    16, 0x2F2D, 0x5C71, 0,
    16, 0x2F2E, 0x5DDB, 0,
    16, 0x2F2F, 0x5DE5, 0,
    16, 0x2F30, 0x5DF1, 0,
    16, 0x2F31, 0x5DFE, 0,
    16, 0x2F32, 0x5E72, 0,
    16, 0x2F33, 0x5E7A, 0,
    16, 0x2F34, 0x5E7F, 0,
    16, 0x2F35, 0x5EF4, 0,
    16, 0x2F36, 0x5EFE, 0,
    16, 0x2F37, 0x5F0B, 0,
    16, 0x2F38, 0x5F13, 0,
    16, 0x2F39, 0x5F50, 0,
    16, 0x2F3A, 0x5F61, 0,
    16, 0x2F3B, 0x5F73, 0,
    16, 0x2F3C, 0x5FC3, 0,
    16, 0x2F3D, 0x6208, 0,
    16, 0x2F3E, 0x6236, 0,
    16, 0x2F3F, 0x624B, 0,
    16, 0x2F40, 0x652F, 0,
    16, 0x2F41, 0x6534, 0,
    16, 0x2F42, 0x6587, 0,
    16, 0x2F43, 0x6597, 0,
    16, 0x2F44, 0x65A4, 0,
    16, 0x2F45, 0x65B9, 0,
    16, 0x2F46, 0x65E0, 0,
    16, 0x2F47, 0x65E5, 0,
    16, 0x2F48, 0x66F0, 0,
    16, 0x2F49, 0x6708, 0,
    16, 0x2F4A, 0x6728, 0,
    16, 0x2F4B, 0x6B20, 0,
    16, 0x2F4C, 0x6B62, 0,
    16, 0x2F4D, 0x6B79, 0,
    16, 0x2F4E, 0x6BB3, 0,
    16, 0x2F4F, 0x6BCB, 0,
    16, 0x2F50, 0x6BD4, 0,
    16, 0x2F51, 0x6BDB, 0,
    16, 0x2F52, 0x6C0F, 0,
    16, 0x2F53, 0x6C14, 0,
    16, 0x2F54, 0x6C34, 0,
    16, 0x2F55, 0x706B, 0,
    16, 0x2F56, 0x722A, 0,
    16, 0x2F57, 0x7236, 0,
    16, 0x2F58, 0x723B, 0,
    16, 0x2F59, 0x723F, 0,
    16, 0x2F5A, 0x7247, 0,
    16, 0x2F5B, 0x7259, 0,
    16, 0x2F5C, 0x725B, 0,
    16, 0x2F5D, 0x72AC, 0,
    16, 0x2F5E, 0x7384, 0,
    16, 0x2F5F, 0x7389, 0,
    16, 0x2F60, 0x74DC, 0,
    16, 0x2F61, 0x74E6, 0,
    16, 0x2F62, 0x7518, 0,
    16, 0x2F63, 0x751F, 0,
    16, 0x2F64, 0x7528, 0,
    16, 0x2F65, 0x7530, 0,
    16, 0x2F66, 0x758B, 0,
    16, 0x2F67, 0x7592, 0,
    16, 0x2F68, 0x7676, 0,
    16, 0x2F69, 0x767D, 0,
    16, 0x2F6A, 0x76AE, 0,
    16, 0x2F6B, 0x76BF, 0,
    16, 0x2F6C, 0x76EE, 0,
    16, 0x2F6D, 0x77DB, 0,
    16, 0x2F6E, 0x77E2, 0,
    16, 0x2F6F, 0x77F3, 0,
    16, 0x2F70, 0x793A, 0,
    16, 0x2F71, 0x79B8, 0,
    16, 0x2F72, 0x79BE, 0,
    16, 0x2F73, 0x7A74, 0,
    16, 0x2F74, 0x7ACB, 0,
    16, 0x2F75, 0x7AF9, 0,
    16, 0x2F76, 0x7C73, 0,
    16, 0x2F77, 0x7CF8, 0,
    16, 0x2F78, 0x7F36, 0,
    16, 0x2F79, 0x7F51, 0,
    16, 0x2F7A, 0x7F8A, 0,
    16, 0x2F7B, 0x7FBD, 0,
    16, 0x2F7C, 0x8001, 0,
    16, 0x2F7D, 0x800C, 0,
    16, 0x2F7E, 0x8012, 0,
    16, 0x2F7F, 0x8033, 0,
    16, 0x2F80, 0x807F, 0,
    16, 0x2F81, 0x8089, 0,
    16, 0x2F82, 0x81E3, 0,
    16, 0x2F83, 0x81EA, 0,
    16, 0x2F84, 0x81F3, 0,
    16, 0x2F85, 0x81FC, 0,
    16, 0x2F86, 0x820C, 0,
    16, 0x2F87, 0x821B, 0,
    16, 0x2F88, 0x821F, 0,
    16, 0x2F89, 0x826E, 0,
    16, 0x2F8A, 0x8272, 0,
    16, 0x2F8B, 0x8278, 0,
    16, 0x2F8C, 0x864D, 0,
    16, 0x2F8D, 0x866B, 0,
    16, 0x2F8E, 0x8840, 0,
    16, 0x2F8F, 0x884C, 0,
    16, 0x2F90, 0x8863, 0,
    16, 0x2F91, 0x897E, 0,
    16, 0x2F92, 0x898B, 0,
    16, 0x2F93, 0x89D2, 0,
    16, 0x2F94, 0x8A00, 0,
    16, 0x2F95, 0x8C37, 0,
    16, 0x2F96, 0x8C46, 0,
    16, 0x2F97, 0x8C55, 0,
    16, 0x2F98, 0x8C78, 0,
    16, 0x2F99, 0x8C9D, 0,
    16, 0x2F9A, 0x8D64, 0,
    16, 0x2F9B, 0x8D70, 0,
    16, 0x2F9C, 0x8DB3, 0,
    16, 0x2F9D, 0x8EAB, 0,
    16, 0x2F9E, 0x8ECA, 0,
    16, 0x2F9F, 0x8F9B, 0,
    16, 0x2FA0, 0x8FB0, 0,
    16, 0x2FA1, 0x8FB5, 0,
    16, 0x2FA2, 0x9091, 0,
    16, 0x2FA3, 0x9149, 0,
    16, 0x2FA4, 0x91C6, 0,
    16, 0x2FA5, 0x91CC, 0,
    16, 0x2FA6, 0x91D1, 0,
    16, 0x2FA7, 0x9577, 0,
    16, 0x2FA8, 0x9580, 0,
    16, 0x2FA9, 0x961C, 0,
    16, 0x2FAA, 0x96B6, 0,
    16, 0x2FAB, 0x96B9, 0,
    16, 0x2FAC, 0x96E8, 0,
    16, 0x2FAD, 0x9751, 0,
    16, 0x2FAE, 0x975E, 0,
    16, 0x2FAF, 0x9762, 0,
    16, 0x2FB0, 0x9769, 0,
    16, 0x2FB1, 0x97CB, 0,
    16, 0x2FB2, 0x97ED, 0,
    16, 0x2FB3, 0x97F3, 0,
    16, 0x2FB4, 0x9801, 0,
    16, 0x2FB5, 0x98A8, 0,
    16, 0x2FB6, 0x98DB, 0,
    16, 0x2FB7, 0x98DF, 0,
    16, 0x2FB8, 0x9996, 0,
    16, 0x2FB9, 0x9999, 0,
    16, 0x2FBA, 0x99AC, 0,
    16, 0x2FBB, 0x9AA8, 0,
    16, 0x2FBC, 0x9AD8, 0,
    16, 0x2FBD, 0x9ADF, 0,
    16, 0x2FBE, 0x9B25, 0,
    16, 0x2FBF, 0x9B2F, 0,
    16, 0x2FC0, 0x9B32, 0,
    16, 0x2FC1, 0x9B3C, 0,
    16, 0x2FC2, 0x9B5A, 0,
    16, 0x2FC3, 0x9CE5, 0,
    16, 0x2FC4, 0x9E75, 0,
    16, 0x2FC5, 0x9E7F, 0,
    16, 0x2FC6, 0x9EA5, 0,
    16, 0x2FC7, 0x9EBB, 0,
    16, 0x2FC8, 0x9EC3, 0,
    16, 0x2FC9, 0x9ECD, 0,
    16, 0x2FCA, 0x9ED1, 0,
    16, 0x2FCB, 0x9EF9, 0,
    16, 0x2FCC, 0x9EFD, 0,
    16, 0x2FCD, 0x9F0E, 0,
    16, 0x2FCE, 0x9F13, 0,
    16, 0x2FCF, 0x9F20, 0,
    16, 0x2FD0, 0x9F3B, 0,
    16, 0x2FD1, 0x9F4A, 0,
    16, 0x2FD2, 0x9F52, 0,
    16, 0x2FD3, 0x9F8D, 0,
    16, 0x2FD4, 0x9F9C, 0,
    16, 0x2FD5, 0x9FA0, 0,
    12, 0x3000, 0x0020, 0,
    16, 0x3036, 0x3012, 0,
    16, 0x3038, 0x5341, 0,
    16, 0x3039, 0x5344, 0,
    16, 0x303A, 0x5345, 0,
    1, 0x304C, 0x304B, 0x3099, 0,
    1, 0x304E, 0x304D, 0x3099, 0,
    1, 0x3050, 0x304F, 0x3099, 0,
    1, 0x3052, 0x3051, 0x3099, 0,
    1, 0x3054, 0x3053, 0x3099, 0,
    1, 0x3056, 0x3055, 0x3099, 0,
    1, 0x3058, 0x3057, 0x3099, 0,
    1, 0x305A, 0x3059, 0x3099, 0,
    1, 0x305C, 0x305B, 0x3099, 0,
    1, 0x305E, 0x305D, 0x3099, 0,
    1, 0x3060, 0x305F, 0x3099, 0,
    1, 0x3062, 0x3061, 0x3099, 0,
    1, 0x3065, 0x3064, 0x3099, 0,
    1, 0x3067, 0x3066, 0x3099, 0,
    1, 0x3069, 0x3068, 0x3099, 0,
    1, 0x3070, 0x306F, 0x3099, 0,
    1, 0x3071, 0x306F, 0x309A, 0,
    1, 0x3073, 0x3072, 0x3099, 0,
    1, 0x3074, 0x3072, 0x309A, 0,
    1, 0x3076, 0x3075, 0x3099, 0,
    1, 0x3077, 0x3075, 0x309A, 0,
    1, 0x3079, 0x3078, 0x3099, 0,
    1, 0x307A, 0x3078, 0x309A, 0,
    1, 0x307C, 0x307B, 0x3099, 0,
    1, 0x307D, 0x307B, 0x309A, 0,
    1, 0x3094, 0x3046, 0x3099, 0,
    16, 0x309B, 0x0020, 0x3099, 0,
    16, 0x309C, 0x0020, 0x309A, 0,
    1, 0x309E, 0x309D, 0x3099, 0,
    11, 0x309F, 0x3088, 0x308A, 0,
    1, 0x30AC, 0x30AB, 0x3099, 0,
    1, 0x30AE, 0x30AD, 0x3099, 0,
    1, 0x30B0, 0x30AF, 0x3099, 0,
    1, 0x30B2, 0x30B1, 0x3099, 0,
    1, 0x30B4, 0x30B3, 0x3099, 0,
    1, 0x30B6, 0x30B5, 0x3099, 0,
    1, 0x30B8, 0x30B7, 0x3099, 0,
    1, 0x30BA, 0x30B9, 0x3099, 0,
    1, 0x30BC, 0x30BB, 0x3099, 0,
    1, 0x30BE, 0x30BD, 0x3099, 0,
    1, 0x30C0, 0x30BF, 0x3099, 0,
    1, 0x30C2, 0x30C1, 0x3099, 0,
    1, 0x30C5, 0x30C4, 0x3099, 0,
    1, 0x30C7, 0x30C6, 0x3099, 0,
    1, 0x30C9, 0x30C8, 0x3099, 0,
    1, 0x30D0, 0x30CF, 0x3099, 0,
    1, 0x30D1, 0x30CF, 0x309A, 0,
    1, 0x30D3, 0x30D2, 0x3099, 0,
    1, 0x30D4, 0x30D2, 0x309A, 0,
    1, 0x30D6, 0x30D5, 0x3099, 0,
    1, 0x30D7, 0x30D5, 0x309A, 0,
    1, 0x30D9, 0x30D8, 0x3099, 0,
    1, 0x30DA, 0x30D8, 0x309A, 0,
    1, 0x30DC, 0x30DB, 0x3099, 0,
    1, 0x30DD, 0x30DB, 0x309A, 0,
    1, 0x30F4, 0x30A6, 0x3099, 0,
    1, 0x30F7, 0x30EF, 0x3099, 0,
    1, 0x30F8, 0x30F0, 0x3099, 0,
    1, 0x30F9, 0x30F1, 0x3099, 0,
    1, 0x30FA, 0x30F2, 0x3099, 0,
    1, 0x30FE, 0x30FD, 0x3099, 0,
    11, 0x30FF, 0x30B3, 0x30C8, 0,
    16, 0x3131, 0x1100, 0,
    16, 0x3132, 0x1101, 0,
    16, 0x3133, 0x11AA, 0,
    16, 0x3134, 0x1102, 0,
    16, 0x3135, 0x11AC, 0,
    16, 0x3136, 0x11AD, 0,
    16, 0x3137, 0x1103, 0,
    16, 0x3138, 0x1104, 0,
    16, 0x3139, 0x1105, 0,
    16, 0x313A, 0x11B0, 0,
    16, 0x313B, 0x11B1, 0,
    16, 0x313C, 0x11B2, 0,
    16, 0x313D, 0x11B3, 0,
    16, 0x313E, 0x11B4, 0,
    16, 0x313F, 0x11B5, 0,
    16, 0x3140, 0x111A, 0,
    16, 0x3141, 0x1106, 0,
    16, 0x3142, 0x1107, 0,
    16, 0x3143, 0x1108, 0,
    16, 0x3144, 0x1121, 0,
    16, 0x3145, 0x1109, 0,
    16, 0x3146, 0x110A, 0,
    16, 0x3147, 0x110B, 0,
    16, 0x3148, 0x110C, 0,
    16, 0x3149, 0x110D, 0,
    16, 0x314A, 0x110E, 0,
    16, 0x314B, 0x110F, 0,
    16, 0x314C, 0x1110, 0,
    16, 0x314D, 0x1111, 0,
    16, 0x314E, 0x1112, 0,
    16, 0x314F, 0x1161, 0,
    16, 0x3150, 0x1162, 0,
    16, 0x3151, 0x1163, 0,
    16, 0x3152, 0x1164, 0,
    16, 0x3153, 0x1165, 0,
    16, 0x3154, 0x1166, 0,
    16, 0x3155, 0x1167, 0,
    16, 0x3156, 0x1168, 0,
    16, 0x3157, 0x1169, 0,
    16, 0x3158, 0x116A, 0,
    16, 0x3159, 0x116B, 0,
    16, 0x315A, 0x116C, 0,
    16, 0x315B, 0x116D, 0,
    16, 0x315C, 0x116E, 0,
    16, 0x315D, 0x116F, 0,
    16, 0x315E, 0x1170, 0,
    16, 0x315F, 0x1171, 0,
    16, 0x3160, 0x1172, 0,
    16, 0x3161, 0x1173, 0,
    16, 0x3162, 0x1174, 0,
    16, 0x3163, 0x1175, 0,
    16, 0x3164, 0x1160, 0,
    16, 0x3165, 0x1114, 0,
    16, 0x3166, 0x1115, 0,
    16, 0x3167, 0x11C7, 0,
    16, 0x3168, 0x11C8, 0,
    16, 0x3169, 0x11CC, 0,
    16, 0x316A, 0x11CE, 0,
    16, 0x316B, 0x11D3, 0,
    16, 0x316C, 0x11D7, 0,
    16, 0x316D, 0x11D9, 0,
    16, 0x316E, 0x111C, 0,
    16, 0x316F, 0x11DD, 0,
    16, 0x3170, 0x11DF, 0,
    16, 0x3171, 0x111D, 0,
    16, 0x3172, 0x111E, 0,
    16, 0x3173, 0x1120, 0,
    16, 0x3174, 0x1122, 0,
    16, 0x3175, 0x1123, 0,
    16, 0x3176, 0x1127, 0,
    16, 0x3177, 0x1129, 0,
    16, 0x3178, 0x112B, 0,
    16, 0x3179, 0x112C, 0,
    16, 0x317A, 0x112D, 0,
    16, 0x317B, 0x112E, 0,
    16, 0x317C, 0x112F, 0,
    16, 0x317D, 0x1132, 0,
    16, 0x317E, 0x1136, 0,
    16, 0x317F, 0x1140, 0,
    16, 0x3180, 0x1147, 0,
    16, 0x3181, 0x114C, 0,
    16, 0x3182, 0x11F1, 0,
    16, 0x3183, 0x11F2, 0,
    16, 0x3184, 0x1157, 0,
    16, 0x3185, 0x1158, 0,
    16, 0x3186, 0x1159, 0,
    16, 0x3187, 0x1184, 0,
    16, 0x3188, 0x1185, 0,
    16, 0x3189, 0x1188, 0,
    16, 0x318A, 0x1191, 0,
    16, 0x318B, 0x1192, 0,
    16, 0x318C, 0x1194, 0,
    16, 0x318D, 0x119E, 0,
    16, 0x318E, 0x11A1, 0,
    9, 0x3192, 0x4E00, 0,
    9, 0x3193, 0x4E8C, 0,
    9, 0x3194, 0x4E09, 0,
    9, 0x3195, 0x56DB, 0,
    9, 0x3196, 0x4E0A, 0,
    9, 0x3197, 0x4E2D, 0,
    9, 0x3198, 0x4E0B, 0,
    9, 0x3199, 0x7532, 0,
    9, 0x319A, 0x4E59, 0,
    9, 0x319B, 0x4E19, 0,
    9, 0x319C, 0x4E01, 0,
    9, 0x319D, 0x5929, 0,
    9, 0x319E, 0x5730, 0,
    9, 0x319F, 0x4EBA, 0,
    16, 0x3200, 0x0028, 0x1100, 0x0029, 0,
    16, 0x3201, 0x0028, 0x1102, 0x0029, 0,
    16, 0x3202, 0x0028, 0x1103, 0x0029, 0,
    16, 0x3203, 0x0028, 0x1105, 0x0029, 0,
    16, 0x3204, 0x0028, 0x1106, 0x0029, 0,
    16, 0x3205, 0x0028, 0x1107, 0x0029, 0,
    16, 0x3206, 0x0028, 0x1109, 0x0029, 0,
    16, 0x3207, 0x0028, 0x110B, 0x0029, 0,
    16, 0x3208, 0x0028, 0x110C, 0x0029, 0,
    16, 0x3209, 0x0028, 0x110E, 0x0029, 0,
    16, 0x320A, 0x0028, 0x110F, 0x0029, 0,
    16, 0x320B, 0x0028, 0x1110, 0x0029, 0,
    16, 0x320C, 0x0028, 0x1111, 0x0029, 0,
    16, 0x320D, 0x0028, 0x1112, 0x0029, 0,
    16, 0x320E, 0x0028, 0x1100, 0x1161, 0x0029, 0,
    16, 0x320F, 0x0028, 0x1102, 0x1161, 0x0029, 0,
    16, 0x3210, 0x0028, 0x1103, 0x1161, 0x0029, 0,
    16, 0x3211, 0x0028, 0x1105, 0x1161, 0x0029, 0,
    16, 0x3212, 0x0028, 0x1106, 0x1161, 0x0029, 0,
    16, 0x3213, 0x0028, 0x1107, 0x1161, 0x0029, 0,
    16, 0x3214, 0x0028, 0x1109, 0x1161, 0x0029, 0,
    16, 0x3215, 0x0028, 0x110B, 0x1161, 0x0029, 0,
    16, 0x3216, 0x0028, 0x110C, 0x1161, 0x0029, 0,
    16, 0x3217, 0x0028, 0x110E, 0x1161, 0x0029, 0,
    16, 0x3218, 0x0028, 0x110F, 0x1161, 0x0029, 0,
    16, 0x3219, 0x0028, 0x1110, 0x1161, 0x0029, 0,
    16, 0x321A, 0x0028, 0x1111, 0x1161, 0x0029, 0,
    16, 0x321B, 0x0028, 0x1112, 0x1161, 0x0029, 0,
    16, 0x321C, 0x0028, 0x110C, 0x116E, 0x0029, 0,
    16, 0x3220, 0x0028, 0x4E00, 0x0029, 0,
    16, 0x3221, 0x0028, 0x4E8C, 0x0029, 0,
    16, 0x3222, 0x0028, 0x4E09, 0x0029, 0,
    16, 0x3223, 0x0028, 0x56DB, 0x0029, 0,
    16, 0x3224, 0x0028, 0x4E94, 0x0029, 0,
    16, 0x3225, 0x0028, 0x516D, 0x0029, 0,
    16, 0x3226, 0x0028, 0x4E03, 0x0029, 0,
    16, 0x3227, 0x0028, 0x516B, 0x0029, 0,
    16, 0x3228, 0x0028, 0x4E5D, 0x0029, 0,
    16, 0x3229, 0x0028, 0x5341, 0x0029, 0,
    16, 0x322A, 0x0028, 0x6708, 0x0029, 0,
    16, 0x322B, 0x0028, 0x706B, 0x0029, 0,
    16, 0x322C, 0x0028, 0x6C34, 0x0029, 0,
    16, 0x322D, 0x0028, 0x6728, 0x0029, 0,
    16, 0x322E, 0x0028, 0x91D1, 0x0029, 0,
    16, 0x322F, 0x0028, 0x571F, 0x0029, 0,
    16, 0x3230, 0x0028, 0x65E5, 0x0029, 0,
    16, 0x3231, 0x0028, 0x682A, 0x0029, 0,
    16, 0x3232, 0x0028, 0x6709, 0x0029, 0,
    16, 0x3233, 0x0028, 0x793E, 0x0029, 0,
    16, 0x3234, 0x0028, 0x540D, 0x0029, 0,
    16, 0x3235, 0x0028, 0x7279, 0x0029, 0,
    16, 0x3236, 0x0028, 0x8CA1, 0x0029, 0,
    16, 0x3237, 0x0028, 0x795D, 0x0029, 0,
    16, 0x3238, 0x0028, 0x52B4, 0x0029, 0,
    16, 0x3239, 0x0028, 0x4EE3, 0x0029, 0,
    16, 0x323A, 0x0028, 0x547C, 0x0029, 0,
    16, 0x323B, 0x0028, 0x5B66, 0x0029, 0,
    16, 0x323C, 0x0028, 0x76E3, 0x0029, 0,
    16, 0x323D, 0x0028, 0x4F01, 0x0029, 0,
    16, 0x323E, 0x0028, 0x8CC7, 0x0029, 0,
    16, 0x323F, 0x0028, 0x5354, 0x0029, 0,
    16, 0x3240, 0x0028, 0x796D, 0x0029, 0,
    16, 0x3241, 0x0028, 0x4F11, 0x0029, 0,
    16, 0x3242, 0x0028, 0x81EA, 0x0029, 0,
    16, 0x3243, 0x0028, 0x81F3, 0x0029, 0,
    8, 0x3251, 0x0032, 0x0031, 0,
    8, 0x3252, 0x0032, 0x0032, 0,
    8, 0x3253, 0x0032, 0x0033, 0,
    8, 0x3254, 0x0032, 0x0034, 0,
    8, 0x3255, 0x0032, 0x0035, 0,
    8, 0x3256, 0x0032, 0x0036, 0,
    8, 0x3257, 0x0032, 0x0037, 0,
    8, 0x3258, 0x0032, 0x0038, 0,
    8, 0x3259, 0x0032, 0x0039, 0,
    8, 0x325A, 0x0033, 0x0030, 0,
    8, 0x325B, 0x0033, 0x0031, 0,
    8, 0x325C, 0x0033, 0x0032, 0,
    8, 0x325D, 0x0033, 0x0033, 0,
    8, 0x325E, 0x0033, 0x0034, 0,
    8, 0x325F, 0x0033, 0x0035, 0,
    8, 0x3260, 0x1100, 0,
    8, 0x3261, 0x1102, 0,
    8, 0x3262, 0x1103, 0,
    8, 0x3263, 0x1105, 0,
    8, 0x3264, 0x1106, 0,
    8, 0x3265, 0x1107, 0,
    8, 0x3266, 0x1109, 0,
    8, 0x3267, 0x110B, 0,
    8, 0x3268, 0x110C, 0,
    8, 0x3269, 0x110E, 0,
    8, 0x326A, 0x110F, 0,
    8, 0x326B, 0x1110, 0,
    8, 0x326C, 0x1111, 0,
    8, 0x326D, 0x1112, 0,
    8, 0x326E, 0x1100, 0x1161, 0,
    8, 0x326F, 0x1102, 0x1161, 0,
    8, 0x3270, 0x1103, 0x1161, 0,
    8, 0x3271, 0x1105, 0x1161, 0,
    8, 0x3272, 0x1106, 0x1161, 0,
    8, 0x3273, 0x1107, 0x1161, 0,
    8, 0x3274, 0x1109, 0x1161, 0,
    8, 0x3275, 0x110B, 0x1161, 0,
    8, 0x3276, 0x110C, 0x1161, 0,
    8, 0x3277, 0x110E, 0x1161, 0,
    8, 0x3278, 0x110F, 0x1161, 0,
    8, 0x3279, 0x1110, 0x1161, 0,
    8, 0x327A, 0x1111, 0x1161, 0,
    8, 0x327B, 0x1112, 0x1161, 0,
    8, 0x3280, 0x4E00, 0,
    8, 0x3281, 0x4E8C, 0,
    8, 0x3282, 0x4E09, 0,
    8, 0x3283, 0x56DB, 0,
    8, 0x3284, 0x4E94, 0,
    8, 0x3285, 0x516D, 0,
    8, 0x3286, 0x4E03, 0,
    8, 0x3287, 0x516B, 0,
    8, 0x3288, 0x4E5D, 0,
    8, 0x3289, 0x5341, 0,
    8, 0x328A, 0x6708, 0,
    8, 0x328B, 0x706B, 0,
    8, 0x328C, 0x6C34, 0,
    8, 0x328D, 0x6728, 0,
    8, 0x328E, 0x91D1, 0,
    8, 0x328F, 0x571F, 0,
    8, 0x3290, 0x65E5, 0,
    8, 0x3291, 0x682A, 0,
    8, 0x3292, 0x6709, 0,
    8, 0x3293, 0x793E, 0,
    8, 0x3294, 0x540D, 0,
    8, 0x3295, 0x7279, 0,
    8, 0x3296, 0x8CA1, 0,
    8, 0x3297, 0x795D, 0,
    8, 0x3298, 0x52B4, 0,
    8, 0x3299, 0x79D8, 0,
    8, 0x329A, 0x7537, 0,
    8, 0x329B, 0x5973, 0,
    8, 0x329C, 0x9069, 0,
    8, 0x329D, 0x512A, 0,
    8, 0x329E, 0x5370, 0,
    8, 0x329F, 0x6CE8, 0,
    8, 0x32A0, 0x9805, 0,
    8, 0x32A1, 0x4F11, 0,
    8, 0x32A2, 0x5199, 0,
    8, 0x32A3, 0x6B63, 0,
    8, 0x32A4, 0x4E0A, 0,
    8, 0x32A5, 0x4E2D, 0,
    8, 0x32A6, 0x4E0B, 0,
    8, 0x32A7, 0x5DE6, 0,
    8, 0x32A8, 0x53F3, 0,
    8, 0x32A9, 0x533B, 0,
    8, 0x32AA, 0x5B97, 0,
    8, 0x32AB, 0x5B66, 0,
    8, 0x32AC, 0x76E3, 0,
    8, 0x32AD, 0x4F01, 0,
    8, 0x32AE, 0x8CC7, 0,
    8, 0x32AF, 0x5354, 0,
    8, 0x32B0, 0x591C, 0,
    8, 0x32B1, 0x0033, 0x0036, 0,
    8, 0x32B2, 0x0033, 0x0037, 0,
    8, 0x32B3, 0x0033, 0x0038, 0,
    8, 0x32B4, 0x0033, 0x0039, 0,
    8, 0x32B5, 0x0034, 0x0030, 0,
    8, 0x32B6, 0x0034, 0x0031, 0,
    8, 0x32B7, 0x0034, 0x0032, 0,
    8, 0x32B8, 0x0034, 0x0033, 0,
    8, 0x32B9, 0x0034, 0x0034, 0,
    8, 0x32BA, 0x0034, 0x0035, 0,
    8, 0x32BB, 0x0034, 0x0036, 0,
    8, 0x32BC, 0x0034, 0x0037, 0,
    8, 0x32BD, 0x0034, 0x0038, 0,
    8, 0x32BE, 0x0034, 0x0039, 0,
    8, 0x32BF, 0x0035, 0x0030, 0,
    16, 0x32C0, 0x0031, 0x6708, 0,
    16, 0x32C1, 0x0032, 0x6708, 0,
    16, 0x32C2, 0x0033, 0x6708, 0,
    16, 0x32C3, 0x0034, 0x6708, 0,
    16, 0x32C4, 0x0035, 0x6708, 0,
    16, 0x32C5, 0x0036, 0x6708, 0,
    16, 0x32C6, 0x0037, 0x6708, 0,
    16, 0x32C7, 0x0038, 0x6708, 0,
    16, 0x32C8, 0x0039, 0x6708, 0,
    16, 0x32C9, 0x0031, 0x0030, 0x6708, 0,
    16, 0x32CA, 0x0031, 0x0031, 0x6708, 0,
    16, 0x32CB, 0x0031, 0x0032, 0x6708, 0,
    8, 0x32D0, 0x30A2, 0,
    8, 0x32D1, 0x30A4, 0,
    8, 0x32D2, 0x30A6, 0,
    8, 0x32D3, 0x30A8, 0,
    8, 0x32D4, 0x30AA, 0,
    8, 0x32D5, 0x30AB, 0,
    8, 0x32D6, 0x30AD, 0,
    8, 0x32D7, 0x30AF, 0,
    8, 0x32D8, 0x30B1, 0,
    8, 0x32D9, 0x30B3, 0,
    8, 0x32DA, 0x30B5, 0,
    8, 0x32DB, 0x30B7, 0,
    8, 0x32DC, 0x30B9, 0,
    8, 0x32DD, 0x30BB, 0,
    8, 0x32DE, 0x30BD, 0,
    8, 0x32DF, 0x30BF, 0,
    8, 0x32E0, 0x30C1, 0,
    8, 0x32E1, 0x30C4, 0,
    8, 0x32E2, 0x30C6, 0,
    8, 0x32E3, 0x30C8, 0,
    8, 0x32E4, 0x30CA, 0,
    8, 0x32E5, 0x30CB, 0,
    8, 0x32E6, 0x30CC, 0,
    8, 0x32E7, 0x30CD, 0,
    8, 0x32E8, 0x30CE, 0,
    8, 0x32E9, 0x30CF, 0,
    8, 0x32EA, 0x30D2, 0,
    8, 0x32EB, 0x30D5, 0,
    8, 0x32EC, 0x30D8, 0,
    8, 0x32ED, 0x30DB, 0,
    8, 0x32EE, 0x30DE, 0,
    8, 0x32EF, 0x30DF, 0,
    8, 0x32F0, 0x30E0, 0,
    8, 0x32F1, 0x30E1, 0,
    8, 0x32F2, 0x30E2, 0,
    8, 0x32F3, 0x30E4, 0,
    8, 0x32F4, 0x30E6, 0,
    8, 0x32F5, 0x30E8, 0,
    8, 0x32F6, 0x30E9, 0,
    8, 0x32F7, 0x30EA, 0,
    8, 0x32F8, 0x30EB, 0,
    8, 0x32F9, 0x30EC, 0,
    8, 0x32FA, 0x30ED, 0,
    8, 0x32FB, 0x30EF, 0,
    8, 0x32FC, 0x30F0, 0,
    8, 0x32FD, 0x30F1, 0,
    8, 0x32FE, 0x30F2, 0,
    15, 0x3300, 0x30A2, 0x30D1, 0x30FC, 0x30C8, 0,
    15, 0x3301, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0,
    15, 0x3302, 0x30A2, 0x30F3, 0x30DA, 0x30A2, 0,
    15, 0x3303, 0x30A2, 0x30FC, 0x30EB, 0,
    15, 0x3304, 0x30A4, 0x30CB, 0x30F3, 0x30B0, 0,
    15, 0x3305, 0x30A4, 0x30F3, 0x30C1, 0,
    15, 0x3306, 0x30A6, 0x30A9, 0x30F3, 0,
    15, 0x3307, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9, 0,
    15, 0x3308, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0,
    15, 0x3309, 0x30AA, 0x30F3, 0x30B9, 0,
    15, 0x330A, 0x30AA, 0x30FC, 0x30E0, 0,
    15, 0x330B, 0x30AB, 0x30A4, 0x30EA, 0,
    15, 0x330C, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0,
    15, 0x330D, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0,
    15, 0x330E, 0x30AC, 0x30ED, 0x30F3, 0,
    15, 0x330F, 0x30AC, 0x30F3, 0x30DE, 0,
    15, 0x3310, 0x30AE, 0x30AC, 0,
    15, 0x3311, 0x30AE, 0x30CB, 0x30FC, 0,
    15, 0x3312, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0,
    15, 0x3313, 0x30AE, 0x30EB, 0x30C0, 0x30FC, 0,
    15, 0x3314, 0x30AD, 0x30ED, 0,
    15, 0x3315, 0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3316, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x3317, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0,
    15, 0x3318, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3319, 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0,
    15, 0x331A, 0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED, 0,
    15, 0x331B, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0,
    15, 0x331C, 0x30B1, 0x30FC, 0x30B9, 0,
    15, 0x331D, 0x30B3, 0x30EB, 0x30CA, 0,
    15, 0x331E, 0x30B3, 0x30FC, 0x30DD, 0,
    15, 0x331F, 0x30B5, 0x30A4, 0x30AF, 0x30EB, 0,
    15, 0x3320, 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0,
    15, 0x3321, 0x30B7, 0x30EA, 0x30F3, 0x30B0, 0,
    15, 0x3322, 0x30BB, 0x30F3, 0x30C1, 0,
    15, 0x3323, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x3324, 0x30C0, 0x30FC, 0x30B9, 0,
    15, 0x3325, 0x30C7, 0x30B7, 0,
    15, 0x3326, 0x30C9, 0x30EB, 0,
    15, 0x3327, 0x30C8, 0x30F3, 0,
    15, 0x3328, 0x30CA, 0x30CE, 0,
    15, 0x3329, 0x30CE, 0x30C3, 0x30C8, 0,
    15, 0x332A, 0x30CF, 0x30A4, 0x30C4, 0,
    15, 0x332B, 0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x332C, 0x30D1, 0x30FC, 0x30C4, 0,
    15, 0x332D, 0x30D0, 0x30FC, 0x30EC, 0x30EB, 0,
    15, 0x332E, 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0,
    15, 0x332F, 0x30D4, 0x30AF, 0x30EB, 0,
    15, 0x3330, 0x30D4, 0x30B3, 0,
    15, 0x3331, 0x30D3, 0x30EB, 0,
    15, 0x3332, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9, 0,
    15, 0x3333, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0,
    15, 0x3334, 0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0,
    15, 0x3335, 0x30D5, 0x30E9, 0x30F3, 0,
    15, 0x3336, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0,
    15, 0x3337, 0x30DA, 0x30BD, 0,
    15, 0x3338, 0x30DA, 0x30CB, 0x30D2, 0,
    15, 0x3339, 0x30D8, 0x30EB, 0x30C4, 0,
    15, 0x333A, 0x30DA, 0x30F3, 0x30B9, 0,
    15, 0x333B, 0x30DA, 0x30FC, 0x30B8, 0,
    15, 0x333C, 0x30D9, 0x30FC, 0x30BF, 0,
    15, 0x333D, 0x30DD, 0x30A4, 0x30F3, 0x30C8, 0,
    15, 0x333E, 0x30DC, 0x30EB, 0x30C8, 0,
    15, 0x333F, 0x30DB, 0x30F3, 0,
    15, 0x3340, 0x30DD, 0x30F3, 0x30C9, 0,
    15, 0x3341, 0x30DB, 0x30FC, 0x30EB, 0,
    15, 0x3342, 0x30DB, 0x30FC, 0x30F3, 0,
    15, 0x3343, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0,
    15, 0x3344, 0x30DE, 0x30A4, 0x30EB, 0,
    15, 0x3345, 0x30DE, 0x30C3, 0x30CF, 0,
    15, 0x3346, 0x30DE, 0x30EB, 0x30AF, 0,
    15, 0x3347, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0,
    15, 0x3348, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0,
    15, 0x3349, 0x30DF, 0x30EA, 0,
    15, 0x334A, 0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB, 0,
    15, 0x334B, 0x30E1, 0x30AC, 0,
    15, 0x334C, 0x30E1, 0x30AC, 0x30C8, 0x30F3, 0,
    15, 0x334D, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x334E, 0x30E4, 0x30FC, 0x30C9, 0,
    15, 0x334F, 0x30E4, 0x30FC, 0x30EB, 0,
    15, 0x3350, 0x30E6, 0x30A2, 0x30F3, 0,
    15, 0x3351, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0,
    15, 0x3352, 0x30EA, 0x30E9, 0,
    15, 0x3353, 0x30EB, 0x30D4, 0x30FC, 0,
    15, 0x3354, 0x30EB, 0x30FC, 0x30D6, 0x30EB, 0,
    15, 0x3355, 0x30EC, 0x30E0, 0,
    15, 0x3356, 0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3, 0,
    15, 0x3357, 0x30EF, 0x30C3, 0x30C8, 0,
    16, 0x3358, 0x0030, 0x70B9, 0,
    16, 0x3359, 0x0031, 0x70B9, 0,
    16, 0x335A, 0x0032, 0x70B9, 0,
    16, 0x335B, 0x0033, 0x70B9, 0,
    16, 0x335C, 0x0034, 0x70B9, 0,
    16, 0x335D, 0x0035, 0x70B9, 0,
    16, 0x335E, 0x0036, 0x70B9, 0,
    16, 0x335F, 0x0037, 0x70B9, 0,
    16, 0x3360, 0x0038, 0x70B9, 0,
    16, 0x3361, 0x0039, 0x70B9, 0,
    16, 0x3362, 0x0031, 0x0030, 0x70B9, 0,
    16, 0x3363, 0x0031, 0x0031, 0x70B9, 0,
    16, 0x3364, 0x0031, 0x0032, 0x70B9, 0,
    16, 0x3365, 0x0031, 0x0033, 0x70B9, 0,
    16, 0x3366, 0x0031, 0x0034, 0x70B9, 0,
    16, 0x3367, 0x0031, 0x0035, 0x70B9, 0,
    16, 0x3368, 0x0031, 0x0036, 0x70B9, 0,
    16, 0x3369, 0x0031, 0x0037, 0x70B9, 0,
    16, 0x336A, 0x0031, 0x0038, 0x70B9, 0,
    16, 0x336B, 0x0031, 0x0039, 0x70B9, 0,
    16, 0x336C, 0x0032, 0x0030, 0x70B9, 0,
    16, 0x336D, 0x0032, 0x0031, 0x70B9, 0,
    16, 0x336E, 0x0032, 0x0032, 0x70B9, 0,
    16, 0x336F, 0x0032, 0x0033, 0x70B9, 0,
    16, 0x3370, 0x0032, 0x0034, 0x70B9, 0,
    15, 0x3371, 0x0068, 0x0050, 0x0061, 0,
    15, 0x3372, 0x0064, 0x0061, 0,
    15, 0x3373, 0x0041, 0x0055, 0,
    15, 0x3374, 0x0062, 0x0061, 0x0072, 0,
    15, 0x3375, 0x006F, 0x0056, 0,
    15, 0x3376, 0x0070, 0x0063, 0,
    15, 0x337B, 0x5E73, 0x6210, 0,
    15, 0x337C, 0x662D, 0x548C, 0,
    15, 0x337D, 0x5927, 0x6B63, 0,
    15, 0x337E, 0x660E, 0x6CBB, 0,
    15, 0x337F, 0x682A, 0x5F0F, 0x4F1A, 0x793E, 0,
    15, 0x3380, 0x0070, 0x0041, 0,
    15, 0x3381, 0x006E, 0x0041, 0,
    15, 0x3382, 0x03BC, 0x0041, 0,
    15, 0x3383, 0x006D, 0x0041, 0,
    15, 0x3384, 0x006B, 0x0041, 0,
    15, 0x3385, 0x004B, 0x0042, 0,
    15, 0x3386, 0x004D, 0x0042, 0,
    15, 0x3387, 0x0047, 0x0042, 0,
    15, 0x3388, 0x0063, 0x0061, 0x006C, 0,
    15, 0x3389, 0x006B, 0x0063, 0x0061, 0x006C, 0,
    15, 0x338A, 0x0070, 0x0046, 0,
    15, 0x338B, 0x006E, 0x0046, 0,
    15, 0x338C, 0x03BC, 0x0046, 0,
    15, 0x338D, 0x03BC, 0x0067, 0,
    15, 0x338E, 0x006D, 0x0067, 0,
    15, 0x338F, 0x006B, 0x0067, 0,
    15, 0x3390, 0x0048, 0x007A, 0,
    15, 0x3391, 0x006B, 0x0048, 0x007A, 0,
    15, 0x3392, 0x004D, 0x0048, 0x007A, 0,
    15, 0x3393, 0x0047, 0x0048, 0x007A, 0,
    15, 0x3394, 0x0054, 0x0048, 0x007A, 0,
    15, 0x3395, 0x03BC, 0x2113, 0,
    15, 0x3396, 0x006D, 0x2113, 0,
    15, 0x3397, 0x0064, 0x2113, 0,
    15, 0x3398, 0x006B, 0x2113, 0,
    15, 0x3399, 0x0066, 0x006D, 0,
    15, 0x339A, 0x006E, 0x006D, 0,
    15, 0x339B, 0x03BC, 0x006D, 0,
    15, 0x339C, 0x006D, 0x006D, 0,
    15, 0x339D, 0x0063, 0x006D, 0,
    15, 0x339E, 0x006B, 0x006D, 0,
    15, 0x339F, 0x006D, 0x006D, 0x00B2, 0,
    15, 0x33A0, 0x0063, 0x006D, 0x00B2, 0,
    15, 0x33A1, 0x006D, 0x00B2, 0,
    15, 0x33A2, 0x006B, 0x006D, 0x00B2, 0,
    15, 0x33A3, 0x006D, 0x006D, 0x00B3, 0,
    15, 0x33A4, 0x0063, 0x006D, 0x00B3, 0,
    15, 0x33A5, 0x006D, 0x00B3, 0,
    15, 0x33A6, 0x006B, 0x006D, 0x00B3, 0,
    15, 0x33A7, 0x006D, 0x2215, 0x0073, 0,
    15, 0x33A8, 0x006D, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33A9, 0x0050, 0x0061, 0,
    15, 0x33AA, 0x006B, 0x0050, 0x0061, 0,
    15, 0x33AB, 0x004D, 0x0050, 0x0061, 0,
    15, 0x33AC, 0x0047, 0x0050, 0x0061, 0,
    15, 0x33AD, 0x0072, 0x0061, 0x0064, 0,
    15, 0x33AE, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0,
    15, 0x33AF, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33B0, 0x0070, 0x0073, 0,
    15, 0x33B1, 0x006E, 0x0073, 0,
    15, 0x33B2, 0x03BC, 0x0073, 0,
    15, 0x33B3, 0x006D, 0x0073, 0,
    15, 0x33B4, 0x0070, 0x0056, 0,
    15, 0x33B5, 0x006E, 0x0056, 0,
    15, 0x33B6, 0x03BC, 0x0056, 0,
    15, 0x33B7, 0x006D, 0x0056, 0,
    15, 0x33B8, 0x006B, 0x0056, 0,
    15, 0x33B9, 0x004D, 0x0056, 0,
    15, 0x33BA, 0x0070, 0x0057, 0,
    15, 0x33BB, 0x006E, 0x0057, 0,
    15, 0x33BC, 0x03BC, 0x0057, 0,
    15, 0x33BD, 0x006D, 0x0057, 0,
    15, 0x33BE, 0x006B, 0x0057, 0,
    15, 0x33BF, 0x004D, 0x0057, 0,
    15, 0x33C0, 0x006B, 0x03A9, 0,
    15, 0x33C1, 0x004D, 0x03A9, 0,
    15, 0x33C2, 0x0061, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33C3, 0x0042, 0x0071, 0,
    15, 0x33C4, 0x0063, 0x0063, 0,
    15, 0x33C5, 0x0063, 0x0064, 0,
    15, 0x33C6, 0x0043, 0x2215, 0x006B, 0x0067, 0,
    15, 0x33C7, 0x0043, 0x006F, 0x002E, 0,
    15, 0x33C8, 0x0064, 0x0042, 0,
    15, 0x33C9, 0x0047, 0x0079, 0,
    15, 0x33CA, 0x0068, 0x0061, 0,
    15, 0x33CB, 0x0048, 0x0050, 0,
    15, 0x33CC, 0x0069, 0x006E, 0,
    15, 0x33CD, 0x004B, 0x004B, 0,
    15, 0x33CE, 0x004B, 0x004D, 0,
    15, 0x33CF, 0x006B, 0x0074, 0,
    15, 0x33D0, 0x006C, 0x006D, 0,
    15, 0x33D1, 0x006C, 0x006E, 0,
    15, 0x33D2, 0x006C, 0x006F, 0x0067, 0,
    15, 0x33D3, 0x006C, 0x0078, 0,
    15, 0x33D4, 0x006D, 0x0062, 0,
    15, 0x33D5, 0x006D, 0x0069, 0x006C, 0,
    15, 0x33D6, 0x006D, 0x006F, 0x006C, 0,
    15, 0x33D7, 0x0050, 0x0048, 0,
    15, 0x33D8, 0x0070, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33D9, 0x0050, 0x0050, 0x004D, 0,
    15, 0x33DA, 0x0050, 0x0052, 0,
    15, 0x33DB, 0x0073, 0x0072, 0,
    15, 0x33DC, 0x0053, 0x0076, 0,
    15, 0x33DD, 0x0057, 0x0062, 0,
    16, 0x33E0, 0x0031, 0x65E5, 0,
    16, 0x33E1, 0x0032, 0x65E5, 0,
    16, 0x33E2, 0x0033, 0x65E5, 0,
    16, 0x33E3, 0x0034, 0x65E5, 0,
    16, 0x33E4, 0x0035, 0x65E5, 0,
    16, 0x33E5, 0x0036, 0x65E5, 0,
    16, 0x33E6, 0x0037, 0x65E5, 0,
    16, 0x33E7, 0x0038, 0x65E5, 0,
    16, 0x33E8, 0x0039, 0x65E5, 0,
    16, 0x33E9, 0x0031, 0x0030, 0x65E5, 0,
    16, 0x33EA, 0x0031, 0x0031, 0x65E5, 0,
    16, 0x33EB, 0x0031, 0x0032, 0x65E5, 0,
    16, 0x33EC, 0x0031, 0x0033, 0x65E5, 0,
    16, 0x33ED, 0x0031, 0x0034, 0x65E5, 0,
    16, 0x33EE, 0x0031, 0x0035, 0x65E5, 0,
    16, 0x33EF, 0x0031, 0x0036, 0x65E5, 0,
    16, 0x33F0, 0x0031, 0x0037, 0x65E5, 0,
    16, 0x33F1, 0x0031, 0x0038, 0x65E5, 0,
    16, 0x33F2, 0x0031, 0x0039, 0x65E5, 0,
    16, 0x33F3, 0x0032, 0x0030, 0x65E5, 0,
    16, 0x33F4, 0x0032, 0x0031, 0x65E5, 0,
    16, 0x33F5, 0x0032, 0x0032, 0x65E5, 0,
    16, 0x33F6, 0x0032, 0x0033, 0x65E5, 0,
    16, 0x33F7, 0x0032, 0x0034, 0x65E5, 0,
    16, 0x33F8, 0x0032, 0x0035, 0x65E5, 0,
    16, 0x33F9, 0x0032, 0x0036, 0x65E5, 0,
    16, 0x33FA, 0x0032, 0x0037, 0x65E5, 0,
    16, 0x33FB, 0x0032, 0x0038, 0x65E5, 0,
    16, 0x33FC, 0x0032, 0x0039, 0x65E5, 0,
    16, 0x33FD, 0x0033, 0x0030, 0x65E5, 0,
    16, 0x33FE, 0x0033, 0x0031, 0x65E5, 0,
    1, 0xF900, 0x8C48, 0,
    1, 0xF901, 0x66F4, 0,
    1, 0xF902, 0x8ECA, 0,
    1, 0xF903, 0x8CC8, 0,
    1, 0xF904, 0x6ED1, 0,
    1, 0xF905, 0x4E32, 0,
    1, 0xF906, 0x53E5, 0,
    1, 0xF907, 0x9F9C, 0,
    1, 0xF908, 0x9F9C, 0,
    1, 0xF909, 0x5951, 0,
    1, 0xF90A, 0x91D1, 0,
    1, 0xF90B, 0x5587, 0,
    1, 0xF90C, 0x5948, 0,
    1, 0xF90D, 0x61F6, 0,
    1, 0xF90E, 0x7669, 0,
    1, 0xF90F, 0x7F85, 0,
    1, 0xF910, 0x863F, 0,
    1, 0xF911, 0x87BA, 0,
    1, 0xF912, 0x88F8, 0,
    1, 0xF913, 0x908F, 0,
    1, 0xF914, 0x6A02, 0,
    1, 0xF915, 0x6D1B, 0,
    1, 0xF916, 0x70D9, 0,
    1, 0xF917, 0x73DE, 0,
    1, 0xF918, 0x843D, 0,
    1, 0xF919, 0x916A, 0,
    1, 0xF91A, 0x99F1, 0,
    1, 0xF91B, 0x4E82, 0,
    1, 0xF91C, 0x5375, 0,
    1, 0xF91D, 0x6B04, 0,
    1, 0xF91E, 0x721B, 0,
    1, 0xF91F, 0x862D, 0,
    1, 0xF920, 0x9E1E, 0,
    1, 0xF921, 0x5D50, 0,
    1, 0xF922, 0x6FEB, 0,
    1, 0xF923, 0x85CD, 0,
    1, 0xF924, 0x8964, 0,
    1, 0xF925, 0x62C9, 0,
    1, 0xF926, 0x81D8, 0,
    1, 0xF927, 0x881F, 0,
    1, 0xF928, 0x5ECA, 0,
    1, 0xF929, 0x6717, 0,
    1, 0xF92A, 0x6D6A, 0,
    1, 0xF92B, 0x72FC, 0,
    1, 0xF92C, 0x90CE, 0,
    1, 0xF92D, 0x4F86, 0,
    1, 0xF92E, 0x51B7, 0,
    1, 0xF92F, 0x52DE, 0,
    1, 0xF930, 0x64C4, 0,
    1, 0xF931, 0x6AD3, 0,
    1, 0xF932, 0x7210, 0,
    1, 0xF933, 0x76E7, 0,
    1, 0xF934, 0x8001, 0,
    1, 0xF935, 0x8606, 0,
    1, 0xF936, 0x865C, 0,
    1, 0xF937, 0x8DEF, 0,
    1, 0xF938, 0x9732, 0,
    1, 0xF939, 0x9B6F, 0,
    1, 0xF93A, 0x9DFA, 0,
    1, 0xF93B, 0x788C, 0,
    1, 0xF93C, 0x797F, 0,
    1, 0xF93D, 0x7DA0, 0,
    1, 0xF93E, 0x83C9, 0,
    1, 0xF93F, 0x9304, 0,
    1, 0xF940, 0x9E7F, 0,
    1, 0xF941, 0x8AD6, 0,
    1, 0xF942, 0x58DF, 0,
    1, 0xF943, 0x5F04, 0,
    1, 0xF944, 0x7C60, 0,
    1, 0xF945, 0x807E, 0,
    1, 0xF946, 0x7262, 0,
    1, 0xF947, 0x78CA, 0,
    1, 0xF948, 0x8CC2, 0,
    1, 0xF949, 0x96F7, 0,
    1, 0xF94A, 0x58D8, 0,
    1, 0xF94B, 0x5C62, 0,
    1, 0xF94C, 0x6A13, 0,
    1, 0xF94D, 0x6DDA, 0,
    1, 0xF94E, 0x6F0F, 0,
    1, 0xF94F, 0x7D2F, 0,
    1, 0xF950, 0x7E37, 0,
    1, 0xF951, 0x964B, 0,
    1, 0xF952, 0x52D2, 0,
    1, 0xF953, 0x808B, 0,
    1, 0xF954, 0x51DC, 0,
    1, 0xF955, 0x51CC, 0,
    1, 0xF956, 0x7A1C, 0,
    1, 0xF957, 0x7DBE, 0,
    1, 0xF958, 0x83F1, 0,
    1, 0xF959, 0x9675, 0,
    1, 0xF95A, 0x8B80, 0,
    1, 0xF95B, 0x62CF, 0,
    1, 0xF95C, 0x6A02, 0,
    1, 0xF95D, 0x8AFE, 0,
    1, 0xF95E, 0x4E39, 0,
    1, 0xF95F, 0x5BE7, 0,
    1, 0xF960, 0x6012, 0,
    1, 0xF961, 0x7387, 0,
    1, 0xF962, 0x7570, 0,
    1, 0xF963, 0x5317, 0,
    1, 0xF964, 0x78FB, 0,
    1, 0xF965, 0x4FBF, 0,
    1, 0xF966, 0x5FA9, 0,
    1, 0xF967, 0x4E0D, 0,
    1, 0xF968, 0x6CCC, 0,
    1, 0xF969, 0x6578, 0,
    1, 0xF96A, 0x7D22, 0,
    1, 0xF96B, 0x53C3, 0,
    1, 0xF96C, 0x585E, 0,
    1, 0xF96D, 0x7701, 0,
    1, 0xF96E, 0x8449, 0,
    1, 0xF96F, 0x8AAA, 0,
    1, 0xF970, 0x6BBA, 0,
    1, 0xF971, 0x8FB0, 0,
    1, 0xF972, 0x6C88, 0,
    1, 0xF973, 0x62FE, 0,
    1, 0xF974, 0x82E5, 0,
    1, 0xF975, 0x63A0, 0,
    1, 0xF976, 0x7565, 0,
    1, 0xF977, 0x4EAE, 0,
    1, 0xF978, 0x5169, 0,
    1, 0xF979, 0x51C9, 0,
    1, 0xF97A, 0x6881, 0,
    1, 0xF97B, 0x7CE7, 0,
    1, 0xF97C, 0x826F, 0,
    1, 0xF97D, 0x8AD2, 0,
    1, 0xF97E, 0x91CF, 0,
    1, 0xF97F, 0x52F5, 0,
    1, 0xF980, 0x5442, 0,
    1, 0xF981, 0x5973, 0,
    1, 0xF982, 0x5EEC, 0,
    1, 0xF983, 0x65C5, 0,
    1, 0xF984, 0x6FFE, 0,
    1, 0xF985, 0x792A, 0,
    1, 0xF986, 0x95AD, 0,
    1, 0xF987, 0x9A6A, 0,
    1, 0xF988, 0x9E97, 0,
    1, 0xF989, 0x9ECE, 0,
    1, 0xF98A, 0x529B, 0,
    1, 0xF98B, 0x66C6, 0,
    1, 0xF98C, 0x6B77, 0,
    1, 0xF98D, 0x8F62, 0,
    1, 0xF98E, 0x5E74, 0,
    1, 0xF98F, 0x6190, 0,
    1, 0xF990, 0x6200, 0,
    1, 0xF991, 0x649A, 0,
    1, 0xF992, 0x6F23, 0,
    1, 0xF993, 0x7149, 0,
    1, 0xF994, 0x7489, 0,
    1, 0xF995, 0x79CA, 0,
    1, 0xF996, 0x7DF4, 0,
    1, 0xF997, 0x806F, 0,
    1, 0xF998, 0x8F26, 0,
    1, 0xF999, 0x84EE, 0,
    1, 0xF99A, 0x9023, 0,
    1, 0xF99B, 0x934A, 0,
    1, 0xF99C, 0x5217, 0,
    1, 0xF99D, 0x52A3, 0,
    1, 0xF99E, 0x54BD, 0,
    1, 0xF99F, 0x70C8, 0,
    1, 0xF9A0, 0x88C2, 0,
    1, 0xF9A1, 0x8AAA, 0,
    1, 0xF9A2, 0x5EC9, 0,
    1, 0xF9A3, 0x5FF5, 0,
    1, 0xF9A4, 0x637B, 0,
    1, 0xF9A5, 0x6BAE, 0,
    1, 0xF9A6, 0x7C3E, 0,
    1, 0xF9A7, 0x7375, 0,
    1, 0xF9A8, 0x4EE4, 0,
    1, 0xF9A9, 0x56F9, 0,
    1, 0xF9AA, 0x5BE7, 0,
    1, 0xF9AB, 0x5DBA, 0,
    1, 0xF9AC, 0x601C, 0,
    1, 0xF9AD, 0x73B2, 0,
    1, 0xF9AE, 0x7469, 0,
    1, 0xF9AF, 0x7F9A, 0,
    1, 0xF9B0, 0x8046, 0,
    1, 0xF9B1, 0x9234, 0,
    1, 0xF9B2, 0x96F6, 0,
    1, 0xF9B3, 0x9748, 0,
    1, 0xF9B4, 0x9818, 0,
    1, 0xF9B5, 0x4F8B, 0,
    1, 0xF9B6, 0x79AE, 0,
    1, 0xF9B7, 0x91B4, 0,
    1, 0xF9B8, 0x96B8, 0,
    1, 0xF9B9, 0x60E1, 0,
    1, 0xF9BA, 0x4E86, 0,
    1, 0xF9BB, 0x50DA, 0,
    1, 0xF9BC, 0x5BEE, 0,
    1, 0xF9BD, 0x5C3F, 0,
    1, 0xF9BE, 0x6599, 0,
    1, 0xF9BF, 0x6A02, 0,
    1, 0xF9C0, 0x71CE, 0,
    1, 0xF9C1, 0x7642, 0,
    1, 0xF9C2, 0x84FC, 0,
    1, 0xF9C3, 0x907C, 0,
    1, 0xF9C4, 0x9F8D, 0,
    1, 0xF9C5, 0x6688, 0,
    1, 0xF9C6, 0x962E, 0,
    1, 0xF9C7, 0x5289, 0,
    1, 0xF9C8, 0x677B, 0,
    1, 0xF9C9, 0x67F3, 0,
    1, 0xF9CA, 0x6D41, 0,
    1, 0xF9CB, 0x6E9C, 0,
    1, 0xF9CC, 0x7409, 0,
    1, 0xF9CD, 0x7559, 0,
    1, 0xF9CE, 0x786B, 0,
    1, 0xF9CF, 0x7D10, 0,
    1, 0xF9D0, 0x985E, 0,
    1, 0xF9D1, 0x516D, 0,
    1, 0xF9D2, 0x622E, 0,
    1, 0xF9D3, 0x9678, 0,
    1, 0xF9D4, 0x502B, 0,
    1, 0xF9D5, 0x5D19, 0,
    1, 0xF9D6, 0x6DEA, 0,
    1, 0xF9D7, 0x8F2A, 0,
    1, 0xF9D8, 0x5F8B, 0,
    1, 0xF9D9, 0x6144, 0,
    1, 0xF9DA, 0x6817, 0,
    1, 0xF9DB, 0x7387, 0,
    1, 0xF9DC, 0x9686, 0,
    1, 0xF9DD, 0x5229, 0,
    1, 0xF9DE, 0x540F, 0,
    1, 0xF9DF, 0x5C65, 0,
    1, 0xF9E0, 0x6613, 0,
    1, 0xF9E1, 0x674E, 0,
    1, 0xF9E2, 0x68A8, 0,
    1, 0xF9E3, 0x6CE5, 0,
    1, 0xF9E4, 0x7406, 0,
    1, 0xF9E5, 0x75E2, 0,
    1, 0xF9E6, 0x7F79, 0,
    1, 0xF9E7, 0x88CF, 0,
    1, 0xF9E8, 0x88E1, 0,
    1, 0xF9E9, 0x91CC, 0,
    1, 0xF9EA, 0x96E2, 0,
    1, 0xF9EB, 0x533F, 0,
    1, 0xF9EC, 0x6EBA, 0,
    1, 0xF9ED, 0x541D, 0,
    1, 0xF9EE, 0x71D0, 0,
    1, 0xF9EF, 0x7498, 0,
    1, 0xF9F0, 0x85FA, 0,
    1, 0xF9F1, 0x96A3, 0,
    1, 0xF9F2, 0x9C57, 0,
    1, 0xF9F3, 0x9E9F, 0,
    1, 0xF9F4, 0x6797, 0,
    1, 0xF9F5, 0x6DCB, 0,
    1, 0xF9F6, 0x81E8, 0,
    1, 0xF9F7, 0x7ACB, 0,
    1, 0xF9F8, 0x7B20, 0,
    1, 0xF9F9, 0x7C92, 0,
    1, 0xF9FA, 0x72C0, 0,
    1, 0xF9FB, 0x7099, 0,
    1, 0xF9FC, 0x8B58, 0,
    1, 0xF9FD, 0x4EC0, 0,
    1, 0xF9FE, 0x8336, 0,
    1, 0xF9FF, 0x523A, 0,
    1, 0xFA00, 0x5207, 0,
    1, 0xFA01, 0x5EA6, 0,
    1, 0xFA02, 0x62D3, 0,
    1, 0xFA03, 0x7CD6, 0,
    1, 0xFA04, 0x5B85, 0,
    1, 0xFA05, 0x6D1E, 0,
    1, 0xFA06, 0x66B4, 0,
    1, 0xFA07, 0x8F3B, 0,
    1, 0xFA08, 0x884C, 0,
    1, 0xFA09, 0x964D, 0,
    1, 0xFA0A, 0x898B, 0,
    1, 0xFA0B, 0x5ED3, 0,
    1, 0xFA0C, 0x5140, 0,
    1, 0xFA0D, 0x55C0, 0,
    1, 0xFA10, 0x585A, 0,
    1, 0xFA12, 0x6674, 0,
    1, 0xFA15, 0x51DE, 0,
    1, 0xFA16, 0x732A, 0,
    1, 0xFA17, 0x76CA, 0,
    1, 0xFA18, 0x793C, 0,
    1, 0xFA19, 0x795E, 0,
    1, 0xFA1A, 0x7965, 0,
    1, 0xFA1B, 0x798F, 0,
    1, 0xFA1C, 0x9756, 0,
    1, 0xFA1D, 0x7CBE, 0,
    1, 0xFA1E, 0x7FBD, 0,
    1, 0xFA20, 0x8612, 0,
    1, 0xFA22, 0x8AF8, 0,
    1, 0xFA25, 0x9038, 0,
    1, 0xFA26, 0x90FD, 0,
    1, 0xFA2A, 0x98EF, 0,
    1, 0xFA2B, 0x98FC, 0,
    1, 0xFA2C, 0x9928, 0,
    1, 0xFA2D, 0x9DB4, 0,
    1, 0xFA30, 0x4FAE, 0,
    1, 0xFA31, 0x50E7, 0,
    1, 0xFA32, 0x514D, 0,
    1, 0xFA33, 0x52C9, 0,
    1, 0xFA34, 0x52E4, 0,
    1, 0xFA35, 0x5351, 0,
    1, 0xFA36, 0x559D, 0,
    1, 0xFA37, 0x5606, 0,
    1, 0xFA38, 0x5668, 0,
    1, 0xFA39, 0x5840, 0,
    1, 0xFA3A, 0x58A8, 0,
    1, 0xFA3B, 0x5C64, 0,
    1, 0xFA3C, 0x5C6E, 0,
    1, 0xFA3D, 0x6094, 0,
    1, 0xFA3E, 0x6168, 0,
    1, 0xFA3F, 0x618E, 0,
    1, 0xFA40, 0x61F2, 0,
    1, 0xFA41, 0x654F, 0,
    1, 0xFA42, 0x65E2, 0,
    1, 0xFA43, 0x6691, 0,
    1, 0xFA44, 0x6885, 0,
    1, 0xFA45, 0x6D77, 0,
    1, 0xFA46, 0x6E1A, 0,
    1, 0xFA47, 0x6F22, 0,
    1, 0xFA48, 0x716E, 0,
    1, 0xFA49, 0x722B, 0,
    1, 0xFA4A, 0x7422, 0,
    1, 0xFA4B, 0x7891, 0,
    1, 0xFA4C, 0x793E, 0,
    1, 0xFA4D, 0x7949, 0,
    1, 0xFA4E, 0x7948, 0,
    1, 0xFA4F, 0x7950, 0,
    1, 0xFA50, 0x7956, 0,
    1, 0xFA51, 0x795D, 0,
    1, 0xFA52, 0x798D, 0,
    1, 0xFA53, 0x798E, 0,
    1, 0xFA54, 0x7A40, 0,
    1, 0xFA55, 0x7A81, 0,
    1, 0xFA56, 0x7BC0, 0,
    1, 0xFA57, 0x7DF4, 0,
    1, 0xFA58, 0x7E09, 0,
    1, 0xFA59, 0x7E41, 0,
    1, 0xFA5A, 0x7F72, 0,
    1, 0xFA5B, 0x8005, 0,
    1, 0xFA5C, 0x81ED, 0,
    1, 0xFA5D, 0x8279, 0,
    1, 0xFA5E, 0x8279, 0,
    1, 0xFA5F, 0x8457, 0,
    1, 0xFA60, 0x8910, 0,
    1, 0xFA61, 0x8996, 0,
    1, 0xFA62, 0x8B01, 0,
    1, 0xFA63, 0x8B39, 0,
    1, 0xFA64, 0x8CD3, 0,
    1, 0xFA65, 0x8D08, 0,
    1, 0xFA66, 0x8FB6, 0,
    1, 0xFA67, 0x9038, 0,
    1, 0xFA68, 0x96E3, 0,
    1, 0xFA69, 0x97FF, 0,
    1, 0xFA6A, 0x983B, 0,
    16, 0xFB00, 0x0066, 0x0066, 0,
    16, 0xFB01, 0x0066, 0x0069, 0,
    16, 0xFB02, 0x0066, 0x006C, 0,
    16, 0xFB03, 0x0066, 0x0066, 0x0069, 0,
    16, 0xFB04, 0x0066, 0x0066, 0x006C, 0,
    16, 0xFB05, 0x017F, 0x0074, 0,
    16, 0xFB06, 0x0073, 0x0074, 0,
    16, 0xFB13, 0x0574, 0x0576, 0,
    16, 0xFB14, 0x0574, 0x0565, 0,
    16, 0xFB15, 0x0574, 0x056B, 0,
    16, 0xFB16, 0x057E, 0x0576, 0,
    16, 0xFB17, 0x0574, 0x056D, 0,
    1, 0xFB1D, 0x05D9, 0x05B4, 0,
    1, 0xFB1F, 0x05F2, 0x05B7, 0,
    2, 0xFB20, 0x05E2, 0,
    2, 0xFB21, 0x05D0, 0,
    2, 0xFB22, 0x05D3, 0,
    2, 0xFB23, 0x05D4, 0,
    2, 0xFB24, 0x05DB, 0,
    2, 0xFB25, 0x05DC, 0,
    2, 0xFB26, 0x05DD, 0,
    2, 0xFB27, 0x05E8, 0,
    2, 0xFB28, 0x05EA, 0,
    2, 0xFB29, 0x002B, 0,
    1, 0xFB2A, 0x05E9, 0x05C1, 0,
    1, 0xFB2B, 0x05E9, 0x05C2, 0,
    1, 0xFB2C, 0xFB49, 0x05C1, 0,
    1, 0xFB2D, 0xFB49, 0x05C2, 0,
    1, 0xFB2E, 0x05D0, 0x05B7, 0,
    1, 0xFB2F, 0x05D0, 0x05B8, 0,
    1, 0xFB30, 0x05D0, 0x05BC, 0,
    1, 0xFB31, 0x05D1, 0x05BC, 0,
    1, 0xFB32, 0x05D2, 0x05BC, 0,
    1, 0xFB33, 0x05D3, 0x05BC, 0,
    1, 0xFB34, 0x05D4, 0x05BC, 0,
    1, 0xFB35, 0x05D5, 0x05BC, 0,
    1, 0xFB36, 0x05D6, 0x05BC, 0,
    1, 0xFB38, 0x05D8, 0x05BC, 0,
    1, 0xFB39, 0x05D9, 0x05BC, 0,
    1, 0xFB3A, 0x05DA, 0x05BC, 0,
    1, 0xFB3B, 0x05DB, 0x05BC, 0,
    1, 0xFB3C, 0x05DC, 0x05BC, 0,
    1, 0xFB3E, 0x05DE, 0x05BC, 0,
    1, 0xFB40, 0x05E0, 0x05BC, 0,
    1, 0xFB41, 0x05E1, 0x05BC, 0,
    1, 0xFB43, 0x05E3, 0x05BC, 0,
    1, 0xFB44, 0x05E4, 0x05BC, 0,
    1, 0xFB46, 0x05E6, 0x05BC, 0,
    1, 0xFB47, 0x05E7, 0x05BC, 0,
    1, 0xFB48, 0x05E8, 0x05BC, 0,
    1, 0xFB49, 0x05E9, 0x05BC, 0,
    1, 0xFB4A, 0x05EA, 0x05BC, 0,
    1, 0xFB4B, 0x05D5, 0x05B9, 0,
    1, 0xFB4C, 0x05D1, 0x05BF, 0,
    1, 0xFB4D, 0x05DB, 0x05BF, 0,
    1, 0xFB4E, 0x05E4, 0x05BF, 0,
    16, 0xFB4F, 0x05D0, 0x05DC, 0,
    7, 0xFB50, 0x0671, 0,
    6, 0xFB51, 0x0671, 0,
    7, 0xFB52, 0x067B, 0,
    6, 0xFB53, 0x067B, 0,
    4, 0xFB54, 0x067B, 0,
    5, 0xFB55, 0x067B, 0,
    7, 0xFB56, 0x067E, 0,
    6, 0xFB57, 0x067E, 0,
    4, 0xFB58, 0x067E, 0,
    5, 0xFB59, 0x067E, 0,
    7, 0xFB5A, 0x0680, 0,
    6, 0xFB5B, 0x0680, 0,
    4, 0xFB5C, 0x0680, 0,
    5, 0xFB5D, 0x0680, 0,
    7, 0xFB5E, 0x067A, 0,
    6, 0xFB5F, 0x067A, 0,
    4, 0xFB60, 0x067A, 0,
    5, 0xFB61, 0x067A, 0,
    7, 0xFB62, 0x067F, 0,
    6, 0xFB63, 0x067F, 0,
    4, 0xFB64, 0x067F, 0,
    5, 0xFB65, 0x067F, 0,
    7, 0xFB66, 0x0679, 0,
    6, 0xFB67, 0x0679, 0,
    4, 0xFB68, 0x0679, 0,
    5, 0xFB69, 0x0679, 0,
    7, 0xFB6A, 0x06A4, 0,
    6, 0xFB6B, 0x06A4, 0,
    4, 0xFB6C, 0x06A4, 0,
    5, 0xFB6D, 0x06A4, 0,
    7, 0xFB6E, 0x06A6, 0,
    6, 0xFB6F, 0x06A6, 0,
    4, 0xFB70, 0x06A6, 0,
    5, 0xFB71, 0x06A6, 0,
    7, 0xFB72, 0x0684, 0,
    6, 0xFB73, 0x0684, 0,
    4, 0xFB74, 0x0684, 0,
    5, 0xFB75, 0x0684, 0,
    7, 0xFB76, 0x0683, 0,
    6, 0xFB77, 0x0683, 0,
    4, 0xFB78, 0x0683, 0,
    5, 0xFB79, 0x0683, 0,
    7, 0xFB7A, 0x0686, 0,
    6, 0xFB7B, 0x0686, 0,
    4, 0xFB7C, 0x0686, 0,
    5, 0xFB7D, 0x0686, 0,
    7, 0xFB7E, 0x0687, 0,
    6, 0xFB7F, 0x0687, 0,
    4, 0xFB80, 0x0687, 0,
    5, 0xFB81, 0x0687, 0,
    7, 0xFB82, 0x068D, 0,
    6, 0xFB83, 0x068D, 0,
    7, 0xFB84, 0x068C, 0,
    6, 0xFB85, 0x068C, 0,
    7, 0xFB86, 0x068E, 0,
    6, 0xFB87, 0x068E, 0,
    7, 0xFB88, 0x0688, 0,
    6, 0xFB89, 0x0688, 0,
    7, 0xFB8A, 0x0698, 0,
    6, 0xFB8B, 0x0698, 0,
    7, 0xFB8C, 0x0691, 0,
    6, 0xFB8D, 0x0691, 0,
    7, 0xFB8E, 0x06A9, 0,
    6, 0xFB8F, 0x06A9, 0,
    4, 0xFB90, 0x06A9, 0,
    5, 0xFB91, 0x06A9, 0,
    7, 0xFB92, 0x06AF, 0,
    6, 0xFB93, 0x06AF, 0,
    4, 0xFB94, 0x06AF, 0,
    5, 0xFB95, 0x06AF, 0,
    7, 0xFB96, 0x06B3, 0,
    6, 0xFB97, 0x06B3, 0,
    4, 0xFB98, 0x06B3, 0,
    5, 0xFB99, 0x06B3, 0,
    7, 0xFB9A, 0x06B1, 0,
    6, 0xFB9B, 0x06B1, 0,
    4, 0xFB9C, 0x06B1, 0,
    5, 0xFB9D, 0x06B1, 0,
    7, 0xFB9E, 0x06BA, 0,
    6, 0xFB9F, 0x06BA, 0,
    7, 0xFBA0, 0x06BB, 0,
    6, 0xFBA1, 0x06BB, 0,
    4, 0xFBA2, 0x06BB, 0,
    5, 0xFBA3, 0x06BB, 0,
    7, 0xFBA4, 0x06C0, 0,
    6, 0xFBA5, 0x06C0, 0,
    7, 0xFBA6, 0x06C1, 0,
    6, 0xFBA7, 0x06C1, 0,
    4, 0xFBA8, 0x06C1, 0,
    5, 0xFBA9, 0x06C1, 0,
    7, 0xFBAA, 0x06BE, 0,
    6, 0xFBAB, 0x06BE, 0,
    4, 0xFBAC, 0x06BE, 0,
    5, 0xFBAD, 0x06BE, 0,
    7, 0xFBAE, 0x06D2, 0,
    6, 0xFBAF, 0x06D2, 0,
    7, 0xFBB0, 0x06D3, 0,
    6, 0xFBB1, 0x06D3, 0,
    7, 0xFBD3, 0x06AD, 0,
    6, 0xFBD4, 0x06AD, 0,
    4, 0xFBD5, 0x06AD, 0,
    5, 0xFBD6, 0x06AD, 0,
    7, 0xFBD7, 0x06C7, 0,
    6, 0xFBD8, 0x06C7, 0,
    7, 0xFBD9, 0x06C6, 0,
    6, 0xFBDA, 0x06C6, 0,
    7, 0xFBDB, 0x06C8, 0,
    6, 0xFBDC, 0x06C8, 0,
    7, 0xFBDD, 0x0677, 0,
    7, 0xFBDE, 0x06CB, 0,
    6, 0xFBDF, 0x06CB, 0,
    7, 0xFBE0, 0x06C5, 0,
    6, 0xFBE1, 0x06C5, 0,
    7, 0xFBE2, 0x06C9, 0,
    6, 0xFBE3, 0x06C9, 0,
    7, 0xFBE4, 0x06D0, 0,
    6, 0xFBE5, 0x06D0, 0,
    4, 0xFBE6, 0x06D0, 0,
    5, 0xFBE7, 0x06D0, 0,
    4, 0xFBE8, 0x0649, 0,
    5, 0xFBE9, 0x0649, 0,
    7, 0xFBEA, 0x0626, 0x0627, 0,
    6, 0xFBEB, 0x0626, 0x0627, 0,
    7, 0xFBEC, 0x0626, 0x06D5, 0,
    6, 0xFBED, 0x0626, 0x06D5, 0,
    7, 0xFBEE, 0x0626, 0x0648, 0,
    6, 0xFBEF, 0x0626, 0x0648, 0,
    7, 0xFBF0, 0x0626, 0x06C7, 0,
    6, 0xFBF1, 0x0626, 0x06C7, 0,
    7, 0xFBF2, 0x0626, 0x06C6, 0,
    6, 0xFBF3, 0x0626, 0x06C6, 0,
    7, 0xFBF4, 0x0626, 0x06C8, 0,
    6, 0xFBF5, 0x0626, 0x06C8, 0,
    7, 0xFBF6, 0x0626, 0x06D0, 0,
    6, 0xFBF7, 0x0626, 0x06D0, 0,
    4, 0xFBF8, 0x0626, 0x06D0, 0,
    7, 0xFBF9, 0x0626, 0x0649, 0,
    6, 0xFBFA, 0x0626, 0x0649, 0,
    4, 0xFBFB, 0x0626, 0x0649, 0,
    7, 0xFBFC, 0x06CC, 0,
    6, 0xFBFD, 0x06CC, 0,
    4, 0xFBFE, 0x06CC, 0,
    5, 0xFBFF, 0x06CC, 0,
    7, 0xFC00, 0x0626, 0x062C, 0,
    7, 0xFC01, 0x0626, 0x062D, 0,
    7, 0xFC02, 0x0626, 0x0645, 0,
    7, 0xFC03, 0x0626, 0x0649, 0,
    7, 0xFC04, 0x0626, 0x064A, 0,
    7, 0xFC05, 0x0628, 0x062C, 0,
    7, 0xFC06, 0x0628, 0x062D, 0,
    7, 0xFC07, 0x0628, 0x062E, 0,
    7, 0xFC08, 0x0628, 0x0645, 0,
    7, 0xFC09, 0x0628, 0x0649, 0,
    7, 0xFC0A, 0x0628, 0x064A, 0,
    7, 0xFC0B, 0x062A, 0x062C, 0,
    7, 0xFC0C, 0x062A, 0x062D, 0,
    7, 0xFC0D, 0x062A, 0x062E, 0,
    7, 0xFC0E, 0x062A, 0x0645, 0,
    7, 0xFC0F, 0x062A, 0x0649, 0,
    7, 0xFC10, 0x062A, 0x064A, 0,
    7, 0xFC11, 0x062B, 0x062C, 0,
    7, 0xFC12, 0x062B, 0x0645, 0,
    7, 0xFC13, 0x062B, 0x0649, 0,
    7, 0xFC14, 0x062B, 0x064A, 0,
    7, 0xFC15, 0x062C, 0x062D, 0,
    7, 0xFC16, 0x062C, 0x0645, 0,
    7, 0xFC17, 0x062D, 0x062C, 0,
    7, 0xFC18, 0x062D, 0x0645, 0,
    7, 0xFC19, 0x062E, 0x062C, 0,
    7, 0xFC1A, 0x062E, 0x062D, 0,
    7, 0xFC1B, 0x062E, 0x0645, 0,
    7, 0xFC1C, 0x0633, 0x062C, 0,
    7, 0xFC1D, 0x0633, 0x062D, 0,
    7, 0xFC1E, 0x0633, 0x062E, 0,
    7, 0xFC1F, 0x0633, 0x0645, 0,
    7, 0xFC20, 0x0635, 0x062D, 0,
    7, 0xFC21, 0x0635, 0x0645, 0,
    7, 0xFC22, 0x0636, 0x062C, 0,
    7, 0xFC23, 0x0636, 0x062D, 0,
    7, 0xFC24, 0x0636, 0x062E, 0,
    7, 0xFC25, 0x0636, 0x0645, 0,
    7, 0xFC26, 0x0637, 0x062D, 0,
    7, 0xFC27, 0x0637, 0x0645, 0,
    7, 0xFC28, 0x0638, 0x0645, 0,
    7, 0xFC29, 0x0639, 0x062C, 0,
    7, 0xFC2A, 0x0639, 0x0645, 0,
    7, 0xFC2B, 0x063A, 0x062C, 0,
    7, 0xFC2C, 0x063A, 0x0645, 0,
    7, 0xFC2D, 0x0641, 0x062C, 0,
    7, 0xFC2E, 0x0641, 0x062D, 0,
    7, 0xFC2F, 0x0641, 0x062E, 0,
    7, 0xFC30, 0x0641, 0x0645, 0,
    7, 0xFC31, 0x0641, 0x0649, 0,
    7, 0xFC32, 0x0641, 0x064A, 0,
    7, 0xFC33, 0x0642, 0x062D, 0,
    7, 0xFC34, 0x0642, 0x0645, 0,
    7, 0xFC35, 0x0642, 0x0649, 0,
    7, 0xFC36, 0x0642, 0x064A, 0,
    7, 0xFC37, 0x0643, 0x0627, 0,
    7, 0xFC38, 0x0643, 0x062C, 0,
    7, 0xFC39, 0x0643, 0x062D, 0,
    7, 0xFC3A, 0x0643, 0x062E, 0,
    7, 0xFC3B, 0x0643, 0x0644, 0,
    7, 0xFC3C, 0x0643, 0x0645, 0,
    7, 0xFC3D, 0x0643, 0x0649, 0,
    7, 0xFC3E, 0x0643, 0x064A, 0,
    7, 0xFC3F, 0x0644, 0x062C, 0,
    7, 0xFC40, 0x0644, 0x062D, 0,
    7, 0xFC41, 0x0644, 0x062E, 0,
    7, 0xFC42, 0x0644, 0x0645, 0,
    7, 0xFC43, 0x0644, 0x0649, 0,
    7, 0xFC44, 0x0644, 0x064A, 0,
    7, 0xFC45, 0x0645, 0x062C, 0,
    7, 0xFC46, 0x0645, 0x062D, 0,
    7, 0xFC47, 0x0645, 0x062E, 0,
    7, 0xFC48, 0x0645, 0x0645, 0,
    7, 0xFC49, 0x0645, 0x0649, 0,
    7, 0xFC4A, 0x0645, 0x064A, 0,
    7, 0xFC4B, 0x0646, 0x062C, 0,
    7, 0xFC4C, 0x0646, 0x062D, 0,
    7, 0xFC4D, 0x0646, 0x062E, 0,
    7, 0xFC4E, 0x0646, 0x0645, 0,
    7, 0xFC4F, 0x0646, 0x0649, 0,
    7, 0xFC50, 0x0646, 0x064A, 0,
    7, 0xFC51, 0x0647, 0x062C, 0,
    7, 0xFC52, 0x0647, 0x0645, 0,
    7, 0xFC53, 0x0647, 0x0649, 0,
    7, 0xFC54, 0x0647, 0x064A, 0,
    7, 0xFC55, 0x064A, 0x062C, 0,
    7, 0xFC56, 0x064A, 0x062D, 0,
    7, 0xFC57, 0x064A, 0x062E, 0,
    7, 0xFC58, 0x064A, 0x0645, 0,
    7, 0xFC59, 0x064A, 0x0649, 0,
    7, 0xFC5A, 0x064A, 0x064A, 0,
    7, 0xFC5B, 0x0630, 0x0670, 0,
    7, 0xFC5C, 0x0631, 0x0670, 0,
    7, 0xFC5D, 0x0649, 0x0670, 0,
    7, 0xFC5E, 0x0020, 0x064C, 0x0651, 0,
    7, 0xFC5F, 0x0020, 0x064D, 0x0651, 0,
    7, 0xFC60, 0x0020, 0x064E, 0x0651, 0,
    7, 0xFC61, 0x0020, 0x064F, 0x0651, 0,
    7, 0xFC62, 0x0020, 0x0650, 0x0651, 0,
    7, 0xFC63, 0x0020, 0x0651, 0x0670, 0,
    6, 0xFC64, 0x0626, 0x0631, 0,
    6, 0xFC65, 0x0626, 0x0632, 0,
    6, 0xFC66, 0x0626, 0x0645, 0,
    6, 0xFC67, 0x0626, 0x0646, 0,
    6, 0xFC68, 0x0626, 0x0649, 0,
    6, 0xFC69, 0x0626, 0x064A, 0,
    6, 0xFC6A, 0x0628, 0x0631, 0,
    6, 0xFC6B, 0x0628, 0x0632, 0,
    6, 0xFC6C, 0x0628, 0x0645, 0,
    6, 0xFC6D, 0x0628, 0x0646, 0,
    6, 0xFC6E, 0x0628, 0x0649, 0,
    6, 0xFC6F, 0x0628, 0x064A, 0,
    6, 0xFC70, 0x062A, 0x0631, 0,
    6, 0xFC71, 0x062A, 0x0632, 0,
    6, 0xFC72, 0x062A, 0x0645, 0,
    6, 0xFC73, 0x062A, 0x0646, 0,
    6, 0xFC74, 0x062A, 0x0649, 0,
    6, 0xFC75, 0x062A, 0x064A, 0,
    6, 0xFC76, 0x062B, 0x0631, 0,
    6, 0xFC77, 0x062B, 0x0632, 0,
    6, 0xFC78, 0x062B, 0x0645, 0,
    6, 0xFC79, 0x062B, 0x0646, 0,
    6, 0xFC7A, 0x062B, 0x0649, 0,
    6, 0xFC7B, 0x062B, 0x064A, 0,
    6, 0xFC7C, 0x0641, 0x0649, 0,
    6, 0xFC7D, 0x0641, 0x064A, 0,
    6, 0xFC7E, 0x0642, 0x0649, 0,
    6, 0xFC7F, 0x0642, 0x064A, 0,
    6, 0xFC80, 0x0643, 0x0627, 0,
    6, 0xFC81, 0x0643, 0x0644, 0,
    6, 0xFC82, 0x0643, 0x0645, 0,
    6, 0xFC83, 0x0643, 0x0649, 0,
    6, 0xFC84, 0x0643, 0x064A, 0,
    6, 0xFC85, 0x0644, 0x0645, 0,
    6, 0xFC86, 0x0644, 0x0649, 0,
    6, 0xFC87, 0x0644, 0x064A, 0,
    6, 0xFC88, 0x0645, 0x0627, 0,
    6, 0xFC89, 0x0645, 0x0645, 0,
    6, 0xFC8A, 0x0646, 0x0631, 0,
    6, 0xFC8B, 0x0646, 0x0632, 0,
    6, 0xFC8C, 0x0646, 0x0645, 0,
    6, 0xFC8D, 0x0646, 0x0646, 0,
    6, 0xFC8E, 0x0646, 0x0649, 0,
    6, 0xFC8F, 0x0646, 0x064A, 0,
    6, 0xFC90, 0x0649, 0x0670, 0,
    6, 0xFC91, 0x064A, 0x0631, 0,
    6, 0xFC92, 0x064A, 0x0632, 0,
    6, 0xFC93, 0x064A, 0x0645, 0,
    6, 0xFC94, 0x064A, 0x0646, 0,
    6, 0xFC95, 0x064A, 0x0649, 0,
    6, 0xFC96, 0x064A, 0x064A, 0,
    4, 0xFC97, 0x0626, 0x062C, 0,
    4, 0xFC98, 0x0626, 0x062D, 0,
    4, 0xFC99, 0x0626, 0x062E, 0,
    4, 0xFC9A, 0x0626, 0x0645, 0,
    4, 0xFC9B, 0x0626, 0x0647, 0,
    4, 0xFC9C, 0x0628, 0x062C, 0,
    4, 0xFC9D, 0x0628, 0x062D, 0,
    4, 0xFC9E, 0x0628, 0x062E, 0,
    4, 0xFC9F, 0x0628, 0x0645, 0,
    4, 0xFCA0, 0x0628, 0x0647, 0,
    4, 0xFCA1, 0x062A, 0x062C, 0,
    4, 0xFCA2, 0x062A, 0x062D, 0,
    4, 0xFCA3, 0x062A, 0x062E, 0,
    4, 0xFCA4, 0x062A, 0x0645, 0,
    4, 0xFCA5, 0x062A, 0x0647, 0,
    4, 0xFCA6, 0x062B, 0x0645, 0,
    4, 0xFCA7, 0x062C, 0x062D, 0,
    4, 0xFCA8, 0x062C, 0x0645, 0,
    4, 0xFCA9, 0x062D, 0x062C, 0,
    4, 0xFCAA, 0x062D, 0x0645, 0,
    4, 0xFCAB, 0x062E, 0x062C, 0,
    4, 0xFCAC, 0x062E, 0x0645, 0,
    4, 0xFCAD, 0x0633, 0x062C, 0,
    4, 0xFCAE, 0x0633, 0x062D, 0,
    4, 0xFCAF, 0x0633, 0x062E, 0,
    4, 0xFCB0, 0x0633, 0x0645, 0,
    4, 0xFCB1, 0x0635, 0x062D, 0,
    4, 0xFCB2, 0x0635, 0x062E, 0,
    4, 0xFCB3, 0x0635, 0x0645, 0,
    4, 0xFCB4, 0x0636, 0x062C, 0,
    4, 0xFCB5, 0x0636, 0x062D, 0,
    4, 0xFCB6, 0x0636, 0x062E, 0,
    4, 0xFCB7, 0x0636, 0x0645, 0,
    4, 0xFCB8, 0x0637, 0x062D, 0,
    4, 0xFCB9, 0x0638, 0x0645, 0,
    4, 0xFCBA, 0x0639, 0x062C, 0,
    4, 0xFCBB, 0x0639, 0x0645, 0,
    4, 0xFCBC, 0x063A, 0x062C, 0,
    4, 0xFCBD, 0x063A, 0x0645, 0,
    4, 0xFCBE, 0x0641, 0x062C, 0,
    4, 0xFCBF, 0x0641, 0x062D, 0,
    4, 0xFCC0, 0x0641, 0x062E, 0,
    4, 0xFCC1, 0x0641, 0x0645, 0,
    4, 0xFCC2, 0x0642, 0x062D, 0,
    4, 0xFCC3, 0x0642, 0x0645, 0,
    4, 0xFCC4, 0x0643, 0x062C, 0,
    4, 0xFCC5, 0x0643, 0x062D, 0,
    4, 0xFCC6, 0x0643, 0x062E, 0,
    4, 0xFCC7, 0x0643, 0x0644, 0,
    4, 0xFCC8, 0x0643, 0x0645, 0,
    4, 0xFCC9, 0x0644, 0x062C, 0,
    4, 0xFCCA, 0x0644, 0x062D, 0,
    4, 0xFCCB, 0x0644, 0x062E, 0,
    4, 0xFCCC, 0x0644, 0x0645, 0,
    4, 0xFCCD, 0x0644, 0x0647, 0,
    4, 0xFCCE, 0x0645, 0x062C, 0,
    4, 0xFCCF, 0x0645, 0x062D, 0,
    4, 0xFCD0, 0x0645, 0x062E, 0,
    4, 0xFCD1, 0x0645, 0x0645, 0,
    4, 0xFCD2, 0x0646, 0x062C, 0,
    4, 0xFCD3, 0x0646, 0x062D, 0,
    4, 0xFCD4, 0x0646, 0x062E, 0,
    4, 0xFCD5, 0x0646, 0x0645, 0,
    4, 0xFCD6, 0x0646, 0x0647, 0,
    4, 0xFCD7, 0x0647, 0x062C, 0,
    4, 0xFCD8, 0x0647, 0x0645, 0,
    4, 0xFCD9, 0x0647, 0x0670, 0,
    4, 0xFCDA, 0x064A, 0x062C, 0,
    4, 0xFCDB, 0x064A, 0x062D, 0,
    4, 0xFCDC, 0x064A, 0x062E, 0,
    4, 0xFCDD, 0x064A, 0x0645, 0,
    4, 0xFCDE, 0x064A, 0x0647, 0,
    5, 0xFCDF, 0x0626, 0x0645, 0,
    5, 0xFCE0, 0x0626, 0x0647, 0,
    5, 0xFCE1, 0x0628, 0x0645, 0,
    5, 0xFCE2, 0x0628, 0x0647, 0,
    5, 0xFCE3, 0x062A, 0x0645, 0,
    5, 0xFCE4, 0x062A, 0x0647, 0,
    5, 0xFCE5, 0x062B, 0x0645, 0,
    5, 0xFCE6, 0x062B, 0x0647, 0,
    5, 0xFCE7, 0x0633, 0x0645, 0,
    5, 0xFCE8, 0x0633, 0x0647, 0,
    5, 0xFCE9, 0x0634, 0x0645, 0,
    5, 0xFCEA, 0x0634, 0x0647, 0,
    5, 0xFCEB, 0x0643, 0x0644, 0,
    5, 0xFCEC, 0x0643, 0x0645, 0,
    5, 0xFCED, 0x0644, 0x0645, 0,
    5, 0xFCEE, 0x0646, 0x0645, 0,
    5, 0xFCEF, 0x0646, 0x0647, 0,
    5, 0xFCF0, 0x064A, 0x0645, 0,
    5, 0xFCF1, 0x064A, 0x0647, 0,
    5, 0xFCF2, 0x0640, 0x064E, 0x0651, 0,
    5, 0xFCF3, 0x0640, 0x064F, 0x0651, 0,
    5, 0xFCF4, 0x0640, 0x0650, 0x0651, 0,
    7, 0xFCF5, 0x0637, 0x0649, 0,
    7, 0xFCF6, 0x0637, 0x064A, 0,
    7, 0xFCF7, 0x0639, 0x0649, 0,
    7, 0xFCF8, 0x0639, 0x064A, 0,
    7, 0xFCF9, 0x063A, 0x0649, 0,
    7, 0xFCFA, 0x063A, 0x064A, 0,
    7, 0xFCFB, 0x0633, 0x0649, 0,
    7, 0xFCFC, 0x0633, 0x064A, 0,
    7, 0xFCFD, 0x0634, 0x0649, 0,
    7, 0xFCFE, 0x0634, 0x064A, 0,
    7, 0xFCFF, 0x062D, 0x0649, 0,
    7, 0xFD00, 0x062D, 0x064A, 0,
    7, 0xFD01, 0x062C, 0x0649, 0,
    7, 0xFD02, 0x062C, 0x064A, 0,
    7, 0xFD03, 0x062E, 0x0649, 0,
    7, 0xFD04, 0x062E, 0x064A, 0,
    7, 0xFD05, 0x0635, 0x0649, 0,
    7, 0xFD06, 0x0635, 0x064A, 0,
    7, 0xFD07, 0x0636, 0x0649, 0,
    7, 0xFD08, 0x0636, 0x064A, 0,
    7, 0xFD09, 0x0634, 0x062C, 0,
    7, 0xFD0A, 0x0634, 0x062D, 0,
    7, 0xFD0B, 0x0634, 0x062E, 0,
    7, 0xFD0C, 0x0634, 0x0645, 0,
    7, 0xFD0D, 0x0634, 0x0631, 0,
    7, 0xFD0E, 0x0633, 0x0631, 0,
    7, 0xFD0F, 0x0635, 0x0631, 0,
    7, 0xFD10, 0x0636, 0x0631, 0,
    6, 0xFD11, 0x0637, 0x0649, 0,
    6, 0xFD12, 0x0637, 0x064A, 0,
    6, 0xFD13, 0x0639, 0x0649, 0,
    6, 0xFD14, 0x0639, 0x064A, 0,
    6, 0xFD15, 0x063A, 0x0649, 0,
    6, 0xFD16, 0x063A, 0x064A, 0,
    6, 0xFD17, 0x0633, 0x0649, 0,
    6, 0xFD18, 0x0633, 0x064A, 0,
    6, 0xFD19, 0x0634, 0x0649, 0,
    6, 0xFD1A, 0x0634, 0x064A, 0,
    6, 0xFD1B, 0x062D, 0x0649, 0,
    6, 0xFD1C, 0x062D, 0x064A, 0,
    6, 0xFD1D, 0x062C, 0x0649, 0,
    6, 0xFD1E, 0x062C, 0x064A, 0,
    6, 0xFD1F, 0x062E, 0x0649, 0,
    6, 0xFD20, 0x062E, 0x064A, 0,
    6, 0xFD21, 0x0635, 0x0649, 0,
    6, 0xFD22, 0x0635, 0x064A, 0,
    6, 0xFD23, 0x0636, 0x0649, 0,
    6, 0xFD24, 0x0636, 0x064A, 0,
    6, 0xFD25, 0x0634, 0x062C, 0,
    6, 0xFD26, 0x0634, 0x062D, 0,
    6, 0xFD27, 0x0634, 0x062E, 0,
    6, 0xFD28, 0x0634, 0x0645, 0,
    6, 0xFD29, 0x0634, 0x0631, 0,
    6, 0xFD2A, 0x0633, 0x0631, 0,
    6, 0xFD2B, 0x0635, 0x0631, 0,
    6, 0xFD2C, 0x0636, 0x0631, 0,
    4, 0xFD2D, 0x0634, 0x062C, 0,
    4, 0xFD2E, 0x0634, 0x062D, 0,
    4, 0xFD2F, 0x0634, 0x062E, 0,
    4, 0xFD30, 0x0634, 0x0645, 0,
    4, 0xFD31, 0x0633, 0x0647, 0,
    4, 0xFD32, 0x0634, 0x0647, 0,
    4, 0xFD33, 0x0637, 0x0645, 0,
    5, 0xFD34, 0x0633, 0x062C, 0,
    5, 0xFD35, 0x0633, 0x062D, 0,
    5, 0xFD36, 0x0633, 0x062E, 0,
    5, 0xFD37, 0x0634, 0x062C, 0,
    5, 0xFD38, 0x0634, 0x062D, 0,
    5, 0xFD39, 0x0634, 0x062E, 0,
    5, 0xFD3A, 0x0637, 0x0645, 0,
    5, 0xFD3B, 0x0638, 0x0645, 0,
    6, 0xFD3C, 0x0627, 0x064B, 0,
    7, 0xFD3D, 0x0627, 0x064B, 0,
    4, 0xFD50, 0x062A, 0x062C, 0x0645, 0,
    6, 0xFD51, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD52, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD53, 0x062A, 0x062D, 0x0645, 0,
    4, 0xFD54, 0x062A, 0x062E, 0x0645, 0,
    4, 0xFD55, 0x062A, 0x0645, 0x062C, 0,
    4, 0xFD56, 0x062A, 0x0645, 0x062D, 0,
    4, 0xFD57, 0x062A, 0x0645, 0x062E, 0,
    6, 0xFD58, 0x062C, 0x0645, 0x062D, 0,
    4, 0xFD59, 0x062C, 0x0645, 0x062D, 0,
    6, 0xFD5A, 0x062D, 0x0645, 0x064A, 0,
    6, 0xFD5B, 0x062D, 0x0645, 0x0649, 0,
    4, 0xFD5C, 0x0633, 0x062D, 0x062C, 0,
    4, 0xFD5D, 0x0633, 0x062C, 0x062D, 0,
    6, 0xFD5E, 0x0633, 0x062C, 0x0649, 0,
    6, 0xFD5F, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD60, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD61, 0x0633, 0x0645, 0x062C, 0,
    6, 0xFD62, 0x0633, 0x0645, 0x0645, 0,
    4, 0xFD63, 0x0633, 0x0645, 0x0645, 0,
    6, 0xFD64, 0x0635, 0x062D, 0x062D, 0,
    4, 0xFD65, 0x0635, 0x062D, 0x062D, 0,
    6, 0xFD66, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFD67, 0x0634, 0x062D, 0x0645, 0,
    4, 0xFD68, 0x0634, 0x062D, 0x0645, 0,
    6, 0xFD69, 0x0634, 0x062C, 0x064A, 0,
    6, 0xFD6A, 0x0634, 0x0645, 0x062E, 0,
    4, 0xFD6B, 0x0634, 0x0645, 0x062E, 0,
    6, 0xFD6C, 0x0634, 0x0645, 0x0645, 0,
    4, 0xFD6D, 0x0634, 0x0645, 0x0645, 0,
    6, 0xFD6E, 0x0636, 0x062D, 0x0649, 0,
    6, 0xFD6F, 0x0636, 0x062E, 0x0645, 0,
    4, 0xFD70, 0x0636, 0x062E, 0x0645, 0,
    6, 0xFD71, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD72, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD73, 0x0637, 0x0645, 0x0645, 0,
    6, 0xFD74, 0x0637, 0x0645, 0x064A, 0,
    6, 0xFD75, 0x0639, 0x062C, 0x0645, 0,
    6, 0xFD76, 0x0639, 0x0645, 0x0645, 0,
    4, 0xFD77, 0x0639, 0x0645, 0x0645, 0,
    6, 0xFD78, 0x0639, 0x0645, 0x0649, 0,
    6, 0xFD79, 0x063A, 0x0645, 0x0645, 0,
    6, 0xFD7A, 0x063A, 0x0645, 0x064A, 0,
    6, 0xFD7B, 0x063A, 0x0645, 0x0649, 0,
    6, 0xFD7C, 0x0641, 0x062E, 0x0645, 0,
    4, 0xFD7D, 0x0641, 0x062E, 0x0645, 0,
    6, 0xFD7E, 0x0642, 0x0645, 0x062D, 0,
    6, 0xFD7F, 0x0642, 0x0645, 0x0645, 0,
    6, 0xFD80, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFD81, 0x0644, 0x062D, 0x064A, 0,
    6, 0xFD82, 0x0644, 0x062D, 0x0649, 0,
    4, 0xFD83, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD84, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD85, 0x0644, 0x062E, 0x0645, 0,
    4, 0xFD86, 0x0644, 0x062E, 0x0645, 0,
    6, 0xFD87, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD88, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD89, 0x0645, 0x062D, 0x062C, 0,
    4, 0xFD8A, 0x0645, 0x062D, 0x0645, 0,
    6, 0xFD8B, 0x0645, 0x062D, 0x064A, 0,
    4, 0xFD8C, 0x0645, 0x062C, 0x062D, 0,
    4, 0xFD8D, 0x0645, 0x062C, 0x0645, 0,
    4, 0xFD8E, 0x0645, 0x062E, 0x062C, 0,
    4, 0xFD8F, 0x0645, 0x062E, 0x0645, 0,
    4, 0xFD92, 0x0645, 0x062C, 0x062E, 0,
    4, 0xFD93, 0x0647, 0x0645, 0x062C, 0,
    4, 0xFD94, 0x0647, 0x0645, 0x0645, 0,
    4, 0xFD95, 0x0646, 0x062D, 0x0645, 0,
    6, 0xFD96, 0x0646, 0x062D, 0x0649, 0,
    6, 0xFD97, 0x0646, 0x062C, 0x0645, 0,
    4, 0xFD98, 0x0646, 0x062C, 0x0645, 0,
    6, 0xFD99, 0x0646, 0x062C, 0x0649, 0,
    6, 0xFD9A, 0x0646, 0x0645, 0x064A, 0,
    6, 0xFD9B, 0x0646, 0x0645, 0x0649, 0,
    6, 0xFD9C, 0x064A, 0x0645, 0x0645, 0,
    4, 0xFD9D, 0x064A, 0x0645, 0x0645, 0,
    6, 0xFD9E, 0x0628, 0x062E, 0x064A, 0,
    6, 0xFD9F, 0x062A, 0x062C, 0x064A, 0,
    6, 0xFDA0, 0x062A, 0x062C, 0x0649, 0,
    6, 0xFDA1, 0x062A, 0x062E, 0x064A, 0,
    6, 0xFDA2, 0x062A, 0x062E, 0x0649, 0,
    6, 0xFDA3, 0x062A, 0x0645, 0x064A, 0,
    6, 0xFDA4, 0x062A, 0x0645, 0x0649, 0,
    6, 0xFDA5, 0x062C, 0x0645, 0x064A, 0,
    6, 0xFDA6, 0x062C, 0x062D, 0x0649, 0,
    6, 0xFDA7, 0x062C, 0x0645, 0x0649, 0,
    6, 0xFDA8, 0x0633, 0x062E, 0x0649, 0,
    6, 0xFDA9, 0x0635, 0x062D, 0x064A, 0,
    6, 0xFDAA, 0x0634, 0x062D, 0x064A, 0,
    6, 0xFDAB, 0x0636, 0x062D, 0x064A, 0,
    6, 0xFDAC, 0x0644, 0x062C, 0x064A, 0,
    6, 0xFDAD, 0x0644, 0x0645, 0x064A, 0,
    6, 0xFDAE, 0x064A, 0x062D, 0x064A, 0,
    6, 0xFDAF, 0x064A, 0x062C, 0x064A, 0,
    6, 0xFDB0, 0x064A, 0x0645, 0x064A, 0,
    6, 0xFDB1, 0x0645, 0x0645, 0x064A, 0,
    6, 0xFDB2, 0x0642, 0x0645, 0x064A, 0,
    6, 0xFDB3, 0x0646, 0x062D, 0x064A, 0,
    4, 0xFDB4, 0x0642, 0x0645, 0x062D, 0,
    4, 0xFDB5, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFDB6, 0x0639, 0x0645, 0x064A, 0,
    6, 0xFDB7, 0x0643, 0x0645, 0x064A, 0,
    4, 0xFDB8, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDB9, 0x0645, 0x062E, 0x064A, 0,
    4, 0xFDBA, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBB, 0x0643, 0x0645, 0x0645, 0,
    6, 0xFDBC, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBD, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDBE, 0x062C, 0x062D, 0x064A, 0,
    6, 0xFDBF, 0x062D, 0x062C, 0x064A, 0,
    6, 0xFDC0, 0x0645, 0x062C, 0x064A, 0,
    6, 0xFDC1, 0x0641, 0x0645, 0x064A, 0,
    6, 0xFDC2, 0x0628, 0x062D, 0x064A, 0,
    4, 0xFDC3, 0x0643, 0x0645, 0x0645, 0,
    4, 0xFDC4, 0x0639, 0x062C, 0x0645, 0,
    4, 0xFDC5, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFDC6, 0x0633, 0x062E, 0x064A, 0,
    6, 0xFDC7, 0x0646, 0x062C, 0x064A, 0,
    7, 0xFDF0, 0x0635, 0x0644, 0x06D2, 0,
    7, 0xFDF1, 0x0642, 0x0644, 0x06D2, 0,
    7, 0xFDF2, 0x0627, 0x0644, 0x0644, 0x0647, 0,
    7, 0xFDF3, 0x0627, 0x0643, 0x0628, 0x0631, 0,
    7, 0xFDF4, 0x0645, 0x062D, 0x0645, 0x062F, 0,
    7, 0xFDF5, 0x0635, 0x0644, 0x0639, 0x0645, 0,
    7, 0xFDF6, 0x0631, 0x0633, 0x0648, 0x0644, 0,
    7, 0xFDF7, 0x0639, 0x0644, 0x064A, 0x0647, 0,
    7, 0xFDF8, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDF9, 0x0635, 0x0644, 0x0649, 0,
    7, 0xFDFA, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDFB, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0,
    7, 0xFDFC, 0x0631, 0x06CC, 0x0627, 0x0644, 0,
    11, 0xFE30, 0x2025, 0,
    11, 0xFE31, 0x2014, 0,
    11, 0xFE32, 0x2013, 0,
    11, 0xFE33, 0x005F, 0,
    11, 0xFE34, 0x005F, 0,
    11, 0xFE35, 0x0028, 0,
    11, 0xFE36, 0x0029, 0,
    11, 0xFE37, 0x007B, 0,
    11, 0xFE38, 0x007D, 0,
    11, 0xFE39, 0x3014, 0,
    11, 0xFE3A, 0x3015, 0,
    11, 0xFE3B, 0x3010, 0,
    11, 0xFE3C, 0x3011, 0,
    11, 0xFE3D, 0x300A, 0,
    11, 0xFE3E, 0x300B, 0,
    11, 0xFE3F, 0x3008, 0,
    11, 0xFE40, 0x3009, 0,
    11, 0xFE41, 0x300C, 0,
    11, 0xFE42, 0x300D, 0,
    11, 0xFE43, 0x300E, 0,
    11, 0xFE44, 0x300F, 0,
    16, 0xFE49, 0x203E, 0,
    16, 0xFE4A, 0x203E, 0,
    16, 0xFE4B, 0x203E, 0,
    16, 0xFE4C, 0x203E, 0,
    16, 0xFE4D, 0x005F, 0,
    16, 0xFE4E, 0x005F, 0,
    16, 0xFE4F, 0x005F, 0,
    14, 0xFE50, 0x002C, 0,
    14, 0xFE51, 0x3001, 0,
    14, 0xFE52, 0x002E, 0,
    14, 0xFE54, 0x003B, 0,
    14, 0xFE55, 0x003A, 0,
    14, 0xFE56, 0x003F, 0,
    14, 0xFE57, 0x0021, 0,
    14, 0xFE58, 0x2014, 0,
    14, 0xFE59, 0x0028, 0,
    14, 0xFE5A, 0x0029, 0,
    14, 0xFE5B, 0x007B, 0,
    14, 0xFE5C, 0x007D, 0,
    14, 0xFE5D, 0x3014, 0,
    14, 0xFE5E, 0x3015, 0,
    14, 0xFE5F, 0x0023, 0,
    14, 0xFE60, 0x0026, 0,
    14, 0xFE61, 0x002A, 0,
    14, 0xFE62, 0x002B, 0,
    14, 0xFE63, 0x002D, 0,
    14, 0xFE64, 0x003C, 0,
    14, 0xFE65, 0x003E, 0,
    14, 0xFE66, 0x003D, 0,
    14, 0xFE68, 0x005C, 0,
    14, 0xFE69, 0x0024, 0,
    14, 0xFE6A, 0x0025, 0,
    14, 0xFE6B, 0x0040, 0,
    7, 0xFE70, 0x0020, 0x064B, 0,
    5, 0xFE71, 0x0640, 0x064B, 0,
    7, 0xFE72, 0x0020, 0x064C, 0,
    7, 0xFE74, 0x0020, 0x064D, 0,
    7, 0xFE76, 0x0020, 0x064E, 0,
    5, 0xFE77, 0x0640, 0x064E, 0,
    7, 0xFE78, 0x0020, 0x064F, 0,
    5, 0xFE79, 0x0640, 0x064F, 0,
    7, 0xFE7A, 0x0020, 0x0650, 0,
    5, 0xFE7B, 0x0640, 0x0650, 0,
    7, 0xFE7C, 0x0020, 0x0651, 0,
    5, 0xFE7D, 0x0640, 0x0651, 0,
    7, 0xFE7E, 0x0020, 0x0652, 0,
    5, 0xFE7F, 0x0640, 0x0652, 0,
    7, 0xFE80, 0x0621, 0,
    7, 0xFE81, 0x0622, 0,
    6, 0xFE82, 0x0622, 0,
    7, 0xFE83, 0x0623, 0,
    6, 0xFE84, 0x0623, 0,
    7, 0xFE85, 0x0624, 0,
    6, 0xFE86, 0x0624, 0,
    7, 0xFE87, 0x0625, 0,
    6, 0xFE88, 0x0625, 0,
    7, 0xFE89, 0x0626, 0,
    6, 0xFE8A, 0x0626, 0,
    4, 0xFE8B, 0x0626, 0,
    5, 0xFE8C, 0x0626, 0,
    7, 0xFE8D, 0x0627, 0,
    6, 0xFE8E, 0x0627, 0,
    7, 0xFE8F, 0x0628, 0,
    6, 0xFE90, 0x0628, 0,
    4, 0xFE91, 0x0628, 0,
    5, 0xFE92, 0x0628, 0,
    7, 0xFE93, 0x0629, 0,
    6, 0xFE94, 0x0629, 0,
    7, 0xFE95, 0x062A, 0,
    6, 0xFE96, 0x062A, 0,
    4, 0xFE97, 0x062A, 0,
    5, 0xFE98, 0x062A, 0,
    7, 0xFE99, 0x062B, 0,
    6, 0xFE9A, 0x062B, 0,
    4, 0xFE9B, 0x062B, 0,
    5, 0xFE9C, 0x062B, 0,
    7, 0xFE9D, 0x062C, 0,
    6, 0xFE9E, 0x062C, 0,
    4, 0xFE9F, 0x062C, 0,
    5, 0xFEA0, 0x062C, 0,
    7, 0xFEA1, 0x062D, 0,
    6, 0xFEA2, 0x062D, 0,
    4, 0xFEA3, 0x062D, 0,
    5, 0xFEA4, 0x062D, 0,
    7, 0xFEA5, 0x062E, 0,
    6, 0xFEA6, 0x062E, 0,
    4, 0xFEA7, 0x062E, 0,
    5, 0xFEA8, 0x062E, 0,
    7, 0xFEA9, 0x062F, 0,
    6, 0xFEAA, 0x062F, 0,
    7, 0xFEAB, 0x0630, 0,
    6, 0xFEAC, 0x0630, 0,
    7, 0xFEAD, 0x0631, 0,
    6, 0xFEAE, 0x0631, 0,
    7, 0xFEAF, 0x0632, 0,
    6, 0xFEB0, 0x0632, 0,
    7, 0xFEB1, 0x0633, 0,
    6, 0xFEB2, 0x0633, 0,
    4, 0xFEB3, 0x0633, 0,
    5, 0xFEB4, 0x0633, 0,
    7, 0xFEB5, 0x0634, 0,
    6, 0xFEB6, 0x0634, 0,
    4, 0xFEB7, 0x0634, 0,
    5, 0xFEB8, 0x0634, 0,
    7, 0xFEB9, 0x0635, 0,
    6, 0xFEBA, 0x0635, 0,
    4, 0xFEBB, 0x0635, 0,
    5, 0xFEBC, 0x0635, 0,
    7, 0xFEBD, 0x0636, 0,
    6, 0xFEBE, 0x0636, 0,
    4, 0xFEBF, 0x0636, 0,
    5, 0xFEC0, 0x0636, 0,
    7, 0xFEC1, 0x0637, 0,
    6, 0xFEC2, 0x0637, 0,
    4, 0xFEC3, 0x0637, 0,
    5, 0xFEC4, 0x0637, 0,
    7, 0xFEC5, 0x0638, 0,
    6, 0xFEC6, 0x0638, 0,
    4, 0xFEC7, 0x0638, 0,
    5, 0xFEC8, 0x0638, 0,
    7, 0xFEC9, 0x0639, 0,
    6, 0xFECA, 0x0639, 0,
    4, 0xFECB, 0x0639, 0,
    5, 0xFECC, 0x0639, 0,
    7, 0xFECD, 0x063A, 0,
    6, 0xFECE, 0x063A, 0,
    4, 0xFECF, 0x063A, 0,
    5, 0xFED0, 0x063A, 0,
    7, 0xFED1, 0x0641, 0,
    6, 0xFED2, 0x0641, 0,
    4, 0xFED3, 0x0641, 0,
    5, 0xFED4, 0x0641, 0,
    7, 0xFED5, 0x0642, 0,
    6, 0xFED6, 0x0642, 0,
    4, 0xFED7, 0x0642, 0,
    5, 0xFED8, 0x0642, 0,
    7, 0xFED9, 0x0643, 0,
    6, 0xFEDA, 0x0643, 0,
    4, 0xFEDB, 0x0643, 0,
    5, 0xFEDC, 0x0643, 0,
    7, 0xFEDD, 0x0644, 0,
    6, 0xFEDE, 0x0644, 0,
    4, 0xFEDF, 0x0644, 0,
    5, 0xFEE0, 0x0644, 0,
    7, 0xFEE1, 0x0645, 0,
    6, 0xFEE2, 0x0645, 0,
    4, 0xFEE3, 0x0645, 0,
    5, 0xFEE4, 0x0645, 0,
    7, 0xFEE5, 0x0646, 0,
    6, 0xFEE6, 0x0646, 0,
    4, 0xFEE7, 0x0646, 0,
    5, 0xFEE8, 0x0646, 0,
    7, 0xFEE9, 0x0647, 0,
    6, 0xFEEA, 0x0647, 0,
    4, 0xFEEB, 0x0647, 0,
    5, 0xFEEC, 0x0647, 0,
    7, 0xFEED, 0x0648, 0,
    6, 0xFEEE, 0x0648, 0,
    7, 0xFEEF, 0x0649, 0,
    6, 0xFEF0, 0x0649, 0,
    7, 0xFEF1, 0x064A, 0,
    6, 0xFEF2, 0x064A, 0,
    4, 0xFEF3, 0x064A, 0,
    5, 0xFEF4, 0x064A, 0,
    7, 0xFEF5, 0x0644, 0x0622, 0,
    6, 0xFEF6, 0x0644, 0x0622, 0,
    7, 0xFEF7, 0x0644, 0x0623, 0,
    6, 0xFEF8, 0x0644, 0x0623, 0,
    7, 0xFEF9, 0x0644, 0x0625, 0,
    6, 0xFEFA, 0x0644, 0x0625, 0,
    7, 0xFEFB, 0x0644, 0x0627, 0,
    6, 0xFEFC, 0x0644, 0x0627, 0,
    12, 0xFF01, 0x0021, 0,
    12, 0xFF02, 0x0022, 0,
    12, 0xFF03, 0x0023, 0,
    12, 0xFF04, 0x0024, 0,
    12, 0xFF05, 0x0025, 0,
    12, 0xFF06, 0x0026, 0,
    12, 0xFF07, 0x0027, 0,
    12, 0xFF08, 0x0028, 0,
    12, 0xFF09, 0x0029, 0,
    12, 0xFF0A, 0x002A, 0,
    12, 0xFF0B, 0x002B, 0,
    12, 0xFF0C, 0x002C, 0,
    12, 0xFF0D, 0x002D, 0,
    12, 0xFF0E, 0x002E, 0,
    12, 0xFF0F, 0x002F, 0,
    12, 0xFF10, 0x0030, 0,
    12, 0xFF11, 0x0031, 0,
    12, 0xFF12, 0x0032, 0,
    12, 0xFF13, 0x0033, 0,
    12, 0xFF14, 0x0034, 0,
    12, 0xFF15, 0x0035, 0,
    12, 0xFF16, 0x0036, 0,
    12, 0xFF17, 0x0037, 0,
    12, 0xFF18, 0x0038, 0,
    12, 0xFF19, 0x0039, 0,
    12, 0xFF1A, 0x003A, 0,
    12, 0xFF1B, 0x003B, 0,
    12, 0xFF1C, 0x003C, 0,
    12, 0xFF1D, 0x003D, 0,
    12, 0xFF1E, 0x003E, 0,
    12, 0xFF1F, 0x003F, 0,
    12, 0xFF20, 0x0040, 0,
    12, 0xFF21, 0x0041, 0,
    12, 0xFF22, 0x0042, 0,
    12, 0xFF23, 0x0043, 0,
    12, 0xFF24, 0x0044, 0,
    12, 0xFF25, 0x0045, 0,
    12, 0xFF26, 0x0046, 0,
    12, 0xFF27, 0x0047, 0,
    12, 0xFF28, 0x0048, 0,
    12, 0xFF29, 0x0049, 0,
    12, 0xFF2A, 0x004A, 0,
    12, 0xFF2B, 0x004B, 0,
    12, 0xFF2C, 0x004C, 0,
    12, 0xFF2D, 0x004D, 0,
    12, 0xFF2E, 0x004E, 0,
    12, 0xFF2F, 0x004F, 0,
    12, 0xFF30, 0x0050, 0,
    12, 0xFF31, 0x0051, 0,
    12, 0xFF32, 0x0052, 0,
    12, 0xFF33, 0x0053, 0,
    12, 0xFF34, 0x0054, 0,
    12, 0xFF35, 0x0055, 0,
    12, 0xFF36, 0x0056, 0,
    12, 0xFF37, 0x0057, 0,
    12, 0xFF38, 0x0058, 0,
    12, 0xFF39, 0x0059, 0,
    12, 0xFF3A, 0x005A, 0,
    12, 0xFF3B, 0x005B, 0,
    12, 0xFF3C, 0x005C, 0,
    12, 0xFF3D, 0x005D, 0,
    12, 0xFF3E, 0x005E, 0,
    12, 0xFF3F, 0x005F, 0,
    12, 0xFF40, 0x0060, 0,
    12, 0xFF41, 0x0061, 0,
    12, 0xFF42, 0x0062, 0,
    12, 0xFF43, 0x0063, 0,
    12, 0xFF44, 0x0064, 0,
    12, 0xFF45, 0x0065, 0,
    12, 0xFF46, 0x0066, 0,
    12, 0xFF47, 0x0067, 0,
    12, 0xFF48, 0x0068, 0,
    12, 0xFF49, 0x0069, 0,
    12, 0xFF4A, 0x006A, 0,
    12, 0xFF4B, 0x006B, 0,
    12, 0xFF4C, 0x006C, 0,
    12, 0xFF4D, 0x006D, 0,
    12, 0xFF4E, 0x006E, 0,
    12, 0xFF4F, 0x006F, 0,
    12, 0xFF50, 0x0070, 0,
    12, 0xFF51, 0x0071, 0,
    12, 0xFF52, 0x0072, 0,
    12, 0xFF53, 0x0073, 0,
    12, 0xFF54, 0x0074, 0,
    12, 0xFF55, 0x0075, 0,
    12, 0xFF56, 0x0076, 0,
    12, 0xFF57, 0x0077, 0,
    12, 0xFF58, 0x0078, 0,
    12, 0xFF59, 0x0079, 0,
    12, 0xFF5A, 0x007A, 0,
    12, 0xFF5B, 0x007B, 0,
    12, 0xFF5C, 0x007C, 0,
    12, 0xFF5D, 0x007D, 0,
    12, 0xFF5E, 0x007E, 0,
    12, 0xFF5F, 0x2985, 0,
    12, 0xFF60, 0x2986, 0,
    13, 0xFF61, 0x3002, 0,
    13, 0xFF62, 0x300C, 0,
    13, 0xFF63, 0x300D, 0,
    13, 0xFF64, 0x3001, 0,
    13, 0xFF65, 0x30FB, 0,
    13, 0xFF66, 0x30F2, 0,
    13, 0xFF67, 0x30A1, 0,
    13, 0xFF68, 0x30A3, 0,
    13, 0xFF69, 0x30A5, 0,
    13, 0xFF6A, 0x30A7, 0,
    13, 0xFF6B, 0x30A9, 0,
    13, 0xFF6C, 0x30E3, 0,
    13, 0xFF6D, 0x30E5, 0,
    13, 0xFF6E, 0x30E7, 0,
    13, 0xFF6F, 0x30C3, 0,
    13, 0xFF70, 0x30FC, 0,
    13, 0xFF71, 0x30A2, 0,
    13, 0xFF72, 0x30A4, 0,
    13, 0xFF73, 0x30A6, 0,
    13, 0xFF74, 0x30A8, 0,
    13, 0xFF75, 0x30AA, 0,
    13, 0xFF76, 0x30AB, 0,
    13, 0xFF77, 0x30AD, 0,
    13, 0xFF78, 0x30AF, 0,
    13, 0xFF79, 0x30B1, 0,
    13, 0xFF7A, 0x30B3, 0,
    13, 0xFF7B, 0x30B5, 0,
    13, 0xFF7C, 0x30B7, 0,
    13, 0xFF7D, 0x30B9, 0,
    13, 0xFF7E, 0x30BB, 0,
    13, 0xFF7F, 0x30BD, 0,
    13, 0xFF80, 0x30BF, 0,
    13, 0xFF81, 0x30C1, 0,
    13, 0xFF82, 0x30C4, 0,
    13, 0xFF83, 0x30C6, 0,
    13, 0xFF84, 0x30C8, 0,
    13, 0xFF85, 0x30CA, 0,
    13, 0xFF86, 0x30CB, 0,
    13, 0xFF87, 0x30CC, 0,
    13, 0xFF88, 0x30CD, 0,
    13, 0xFF89, 0x30CE, 0,
    13, 0xFF8A, 0x30CF, 0,
    13, 0xFF8B, 0x30D2, 0,
    13, 0xFF8C, 0x30D5, 0,
    13, 0xFF8D, 0x30D8, 0,
    13, 0xFF8E, 0x30DB, 0,
    13, 0xFF8F, 0x30DE, 0,
    13, 0xFF90, 0x30DF, 0,
    13, 0xFF91, 0x30E0, 0,
    13, 0xFF92, 0x30E1, 0,
    13, 0xFF93, 0x30E2, 0,
    13, 0xFF94, 0x30E4, 0,
    13, 0xFF95, 0x30E6, 0,
    13, 0xFF96, 0x30E8, 0,
    13, 0xFF97, 0x30E9, 0,
    13, 0xFF98, 0x30EA, 0,
    13, 0xFF99, 0x30EB, 0,
    13, 0xFF9A, 0x30EC, 0,
    13, 0xFF9B, 0x30ED, 0,
    13, 0xFF9C, 0x30EF, 0,
    13, 0xFF9D, 0x30F3, 0,
    13, 0xFF9E, 0x3099, 0,
    13, 0xFF9F, 0x309A, 0,
    13, 0xFFA0, 0x3164, 0,
    13, 0xFFA1, 0x3131, 0,
    13, 0xFFA2, 0x3132, 0,
    13, 0xFFA3, 0x3133, 0,
    13, 0xFFA4, 0x3134, 0,
    13, 0xFFA5, 0x3135, 0,
    13, 0xFFA6, 0x3136, 0,
    13, 0xFFA7, 0x3137, 0,
    13, 0xFFA8, 0x3138, 0,
    13, 0xFFA9, 0x3139, 0,
    13, 0xFFAA, 0x313A, 0,
    13, 0xFFAB, 0x313B, 0,
    13, 0xFFAC, 0x313C, 0,
    13, 0xFFAD, 0x313D, 0,
    13, 0xFFAE, 0x313E, 0,
    13, 0xFFAF, 0x313F, 0,
    13, 0xFFB0, 0x3140, 0,
    13, 0xFFB1, 0x3141, 0,
    13, 0xFFB2, 0x3142, 0,
    13, 0xFFB3, 0x3143, 0,
    13, 0xFFB4, 0x3144, 0,
    13, 0xFFB5, 0x3145, 0,
    13, 0xFFB6, 0x3146, 0,
    13, 0xFFB7, 0x3147, 0,
    13, 0xFFB8, 0x3148, 0,
    13, 0xFFB9, 0x3149, 0,
    13, 0xFFBA, 0x314A, 0,
    13, 0xFFBB, 0x314B, 0,
    13, 0xFFBC, 0x314C, 0,
    13, 0xFFBD, 0x314D, 0,
    13, 0xFFBE, 0x314E, 0,
    13, 0xFFC2, 0x314F, 0,
    13, 0xFFC3, 0x3150, 0,
    13, 0xFFC4, 0x3151, 0,
    13, 0xFFC5, 0x3152, 0,
    13, 0xFFC6, 0x3153, 0,
    13, 0xFFC7, 0x3154, 0,
    13, 0xFFCA, 0x3155, 0,
    13, 0xFFCB, 0x3156, 0,
    13, 0xFFCC, 0x3157, 0,
    13, 0xFFCD, 0x3158, 0,
    13, 0xFFCE, 0x3159, 0,
    13, 0xFFCF, 0x315A, 0,
    13, 0xFFD2, 0x315B, 0,
    13, 0xFFD3, 0x315C, 0,
    13, 0xFFD4, 0x315D, 0,
    13, 0xFFD5, 0x315E, 0,
    13, 0xFFD6, 0x315F, 0,
    13, 0xFFD7, 0x3160, 0,
    13, 0xFFDA, 0x3161, 0,
    13, 0xFFDB, 0x3162, 0,
    13, 0xFFDC, 0x3163, 0,
    12, 0xFFE0, 0x00A2, 0,
    12, 0xFFE1, 0x00A3, 0,
    12, 0xFFE2, 0x00AC, 0,
    12, 0xFFE3, 0x00AF, 0,
    12, 0xFFE4, 0x00A6, 0,
    12, 0xFFE5, 0x00A5, 0,
    12, 0xFFE6, 0x20A9, 0,
    13, 0xFFE8, 0x2502, 0,
    13, 0xFFE9, 0x2190, 0,
    13, 0xFFEA, 0x2191, 0,
    13, 0xFFEB, 0x2192, 0,
    13, 0xFFEC, 0x2193, 0,
    13, 0xFFED, 0x25A0, 0,
    13, 0xFFEE, 0x25CB, 0,

};

static const Q_UINT16 di_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    5, 0, 10, 0, 0, 0, 0, 14,
    0, 0, 19, 23, 27, 32, 0, 0,
    36, 41, 45, 0, 49, 55, 61, 0,
    67, 72, 77, 82, 87, 92, 0, 97,
    102, 107, 112, 117, 122, 127, 132, 137,
    0, 142, 147, 152, 157, 162, 167, 0,
    0, 172, 177, 182, 187, 192, 0, 0,
    197, 202, 207, 212, 217, 222, 0, 227,
    232, 237, 242, 247, 252, 257, 262, 267,
    0, 272, 277, 282, 287, 292, 297, 0,
    0, 302, 307, 312, 317, 322, 0, 327,
};

static const Q_UINT16 di_01[] = {
    332, 337, 342, 347, 352, 357, 362, 367,
    372, 377, 382, 387, 392, 397, 402, 407,
    0, 0, 412, 417, 422, 427, 432, 437,
    442, 447, 452, 457, 462, 467, 472, 477,
    482, 487, 492, 497, 502, 507, 0, 0,
    512, 517, 522, 527, 532, 537, 542, 547,
    552, 0, 557, 562, 567, 572, 577, 582,
    0, 587, 592, 597, 602, 607, 612, 617,
    622, 0, 0, 627, 632, 637, 642, 647,
    652, 657, 0, 0, 662, 667, 672, 677,
    682, 687, 0, 0, 692, 697, 702, 707,
    712, 717, 722, 727, 732, 737, 742, 747,
    752, 757, 762, 767, 772, 777, 0, 0,
    782, 787, 792, 797, 802, 807, 812, 817,
    822, 827, 832, 837, 842, 847, 852, 857,
    862, 867, 872, 877, 882, 887, 892, 897,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    901, 906, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 911,
    916, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 921, 926, 931, 936,
    941, 946, 951, 956, 961, 966, 971, 976,
    981, 986, 991, 996, 1001, 1006, 1011, 1016,
    1021, 1026, 1031, 1036, 1041, 0, 1046, 1051,
    1056, 1061, 1066, 1071, 0, 0, 1076, 1081,
    1086, 1091, 1096, 1101, 1106, 1111, 1116, 1121,
    1126, 1131, 1136, 1141, 1146, 1151, 0, 0,
    1156, 1161, 1166, 1171, 1176, 1181, 1186, 1191,
};

static const Q_UINT16 di_02[] = {
    1196, 1201, 1206, 1211, 1216, 1221, 1226, 1231,
    1236, 1241, 1246, 1251, 1256, 1261, 1266, 1271,
    1276, 1281, 1286, 1291, 1296, 1301, 1306, 1311,
    1316, 1321, 1326, 1331, 0, 0, 1336, 1341,
    0, 0, 0, 0, 0, 0, 1346, 1351,
    1356, 1361, 1366, 1371, 1376, 1381, 1386, 1391,
    1396, 1401, 1406, 1411, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1416, 1420, 1424, 1428, 1432, 1436, 1440, 1444,
    1448, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1452, 1457, 1462, 1467, 1472, 1477, 0, 0,
    1482, 1486, 1490, 1494, 1498, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_03[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1502, 1506, 0, 1510, 1514, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1519, 0, 0, 0,
    0, 0, 1523, 0, 0, 0, 1528, 0,
    0, 0, 0, 0, 1532, 1537, 1542, 1547,
    1551, 1556, 1561, 0, 1566, 0, 1571, 1576,
    1581, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1586, 1591, 1596, 1601, 1606, 1611,
    1616, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1621, 1626, 1631, 1636, 1641, 0,
    1646, 1650, 1654, 1658, 1663, 1668, 1672, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1676, 1680, 1684, 0, 1688, 1692, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_04[] = {
    1696, 1701, 0, 1706, 0, 0, 0, 1711,
    0, 0, 0, 0, 1716, 1721, 1726, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1731, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1736, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1741, 1746, 0, 1751, 0, 0, 0, 1756,
    0, 0, 0, 0, 1761, 1766, 1771, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1776, 1781,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1786, 1791, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1796, 1801, 1806, 1811, 0, 0, 1816, 1821,
    0, 0, 1826, 1831, 1836, 1841, 1846, 1851,
    0, 0, 1856, 1861, 1866, 1871, 1876, 1881,
    0, 0, 1886, 1891, 1896, 1901, 1906, 1911,
    1916, 1921, 1926, 1931, 1936, 1941, 0, 0,
    1946, 1951, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1956,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1961, 1966, 1971, 1976, 1981, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1986, 1991, 1996,
    2001, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2006, 0, 2011, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2016, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_07[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_09[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2021, 0, 0, 0, 0, 0, 0,
    0, 2026, 0, 0, 2031, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2036, 2041, 2046, 2051, 2056, 2061, 2066, 2071,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2076, 2081, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2086, 2091, 0, 2096,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2101, 0, 0, 2106, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2111, 2116, 2121, 0, 0, 2126, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0B[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2131, 0, 0, 2136, 2141, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2146, 2151, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2156, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2161, 2166, 2171, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2176, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2181, 0, 0, 0, 0, 0, 0, 2186,
    2191, 0, 2196, 2201, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2206, 2211, 2216, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2221, 0, 2226, 2231, 2236, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2241, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2246, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2251, 2256, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2261, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2265, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2270, 0, 0,
    0, 0, 2275, 0, 0, 0, 0, 2280,
    0, 0, 0, 0, 2285, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2290, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2295, 0, 2300, 2305, 2310,
    2315, 2320, 0, 0, 0, 0, 0, 0,
    0, 2325, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2330, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2335, 0, 0,
    0, 0, 2340, 0, 0, 0, 0, 2345,
    0, 0, 0, 0, 2350, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2355, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2360, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_1E[] = {
    2365, 2370, 2375, 2380, 2385, 2390, 2395, 2400,
    2405, 2410, 2415, 2420, 2425, 2430, 2435, 2440,
    2445, 2450, 2455, 2460, 2465, 2470, 2475, 2480,
    2485, 2490, 2495, 2500, 2505, 2510, 2515, 2520,
    2525, 2530, 2535, 2540, 2545, 2550, 2555, 2560,
    2565, 2570, 2575, 2580, 2585, 2590, 2595, 2600,
    2605, 2610, 2615, 2620, 2625, 2630, 2635, 2640,
    2645, 2650, 2655, 2660, 2665, 2670, 2675, 2680,
    2685, 2690, 2695, 2700, 2705, 2710, 2715, 2720,
    2725, 2730, 2735, 2740, 2745, 2750, 2755, 2760,
    2765, 2770, 2775, 2780, 2785, 2790, 2795, 2800,
    2805, 2810, 2815, 2820, 2825, 2830, 2835, 2840,
    2845, 2850, 2855, 2860, 2865, 2870, 2875, 2880,
    2885, 2890, 2895, 2900, 2905, 2910, 2915, 2920,
    2925, 2930, 2935, 2940, 2945, 2950, 2955, 2960,
    2965, 2970, 2975, 2980, 2985, 2990, 2995, 3000,
    3005, 3010, 3015, 3020, 3025, 3030, 3035, 3040,
    3045, 3050, 3055, 3060, 3065, 3070, 3075, 3080,
    3085, 3090, 3095, 3100, 3105, 3110, 3115, 3120,
    3125, 3130, 3135, 3140, 0, 0, 0, 0,
    3145, 3150, 3155, 3160, 3165, 3170, 3175, 3180,
    3185, 3190, 3195, 3200, 3205, 3210, 3215, 3220,
    3225, 3230, 3235, 3240, 3245, 3250, 3255, 3260,
    3265, 3270, 3275, 3280, 3285, 3290, 3295, 3300,
    3305, 3310, 3315, 3320, 3325, 3330, 3335, 3340,
    3345, 3350, 3355, 3360, 3365, 3370, 3375, 3380,
    3385, 3390, 3395, 3400, 3405, 3410, 3415, 3420,
    3425, 3430, 3435, 3440, 3445, 3450, 3455, 3460,
    3465, 3470, 3475, 3480, 3485, 3490, 3495, 3500,
    3505, 3510, 3515, 3520, 3525, 3530, 3535, 3540,
    3545, 3550, 3555, 3560, 3565, 3570, 3575, 3580,
    3585, 3590, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_1F[] = {
    3595, 3600, 3605, 3610, 3615, 3620, 3625, 3630,
    3635, 3640, 3645, 3650, 3655, 3660, 3665, 3670,
    3675, 3680, 3685, 3690, 3695, 3700, 0, 0,
    3705, 3710, 3715, 3720, 3725, 3730, 0, 0,
    3735, 3740, 3745, 3750, 3755, 3760, 3765, 3770,
    3775, 3780, 3785, 3790, 3795, 3800, 3805, 3810,
    3815, 3820, 3825, 3830, 3835, 3840, 3845, 3850,
    3855, 3860, 3865, 3870, 3875, 3880, 3885, 3890,
    3895, 3900, 3905, 3910, 3915, 3920, 0, 0,
    3925, 3930, 3935, 3940, 3945, 3950, 0, 0,
    3955, 3960, 3965, 3970, 3975, 3980, 3985, 3990,
    0, 3995, 0, 4000, 0, 4005, 0, 4010,
    4015, 4020, 4025, 4030, 4035, 4040, 4045, 4050,
    4055, 4060, 4065, 4070, 4075, 4080, 4085, 4090,
    4095, 4100, 4104, 4109, 4113, 4118, 4122, 4127,
    4131, 4136, 4140, 4145, 4149, 4154, 0, 0,
    4158, 4163, 4168, 4173, 4178, 4183, 4188, 4193,
    4198, 4203, 4208, 4213, 4218, 4223, 4228, 4233,
    4238, 4243, 4248, 4253, 4258, 4263, 4268, 4273,
    4278, 4283, 4288, 4293, 4298, 4303, 4308, 4313,
    4318, 4323, 4328, 4333, 4338, 4343, 4348, 4353,
    4358, 4363, 4368, 4373, 4378, 4383, 4388, 4393,
    4398, 4403, 4408, 4413, 4418, 0, 4423, 4428,
    4433, 4438, 4443, 4448, 4452, 4457, 4462, 4466,
    4471, 4476, 4481, 4486, 4491, 0, 4496, 4501,
    4506, 4511, 4515, 4520, 4524, 4529, 4534, 4539,
    4544, 4549, 4554, 4559, 0, 0, 4563, 4568,
    4573, 4578, 4583, 4588, 0, 4592, 4597, 4602,
    4607, 4612, 4617, 4622, 4626, 4631, 4636, 4641,
    4646, 4651, 4656, 4661, 4665, 4670, 4675, 4679,
    0, 0, 4683, 4688, 4693, 0, 4698, 4703,
    4708, 4713, 4717, 4722, 4726, 4731, 4735, 0,
};

static const Q_UINT16 di_20[] = {
    4740, 4744, 4748, 4752, 4756, 4760, 4764, 4768,
    4772, 4776, 4780, 0, 0, 0, 0, 0,
    0, 4784, 0, 0, 0, 0, 0, 4788,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4793, 4797, 4802, 0,
    0, 0, 0, 0, 0, 0, 0, 4808,
    0, 0, 0, 4812, 4817, 0, 4823, 4828,
    0, 0, 0, 0, 4834, 0, 4839, 0,
    0, 0, 0, 0, 0, 0, 0, 4844,
    4849, 4854, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4859,
    0, 0, 0, 0, 0, 0, 0, 4866,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4870, 4874, 0, 0, 4878, 4882, 4886, 4890,
    4894, 4898, 4902, 4906, 4910, 4914, 4918, 4922,
    4926, 4930, 4934, 4938, 4942, 4946, 4950, 4954,
    4958, 4962, 4966, 4970, 4974, 4978, 4982, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4986, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_21[] = {
    4991, 4997, 5003, 5007, 0, 5012, 5018, 5024,
    0, 5028, 5033, 5037, 5041, 5045, 5049, 5053,
    5057, 5061, 5065, 5069, 0, 5073, 5077, 0,
    0, 5082, 5086, 5090, 5094, 5098, 0, 0,
    5102, 5107, 5113, 0, 5118, 0, 5122, 0,
    5126, 0, 5130, 5134, 5138, 5142, 0, 5146,
    5150, 5154, 0, 5158, 5162, 5166, 5170, 5174,
    5178, 5182, 0, 0, 0, 5186, 5190, 5194,
    5198, 0, 0, 0, 0, 5202, 5206, 5210,
    5214, 5218, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5222, 5228, 5234, 5240, 5246,
    5252, 5258, 5264, 5270, 5276, 5282, 5288, 5294,
    5299, 5303, 5308, 5314, 5319, 5323, 5328, 5334,
    5341, 5346, 5350, 5355, 5361, 5365, 5369, 5373,
    5377, 5381, 5386, 5392, 5397, 5401, 5406, 5412,
    5419, 5424, 5428, 5433, 5439, 5443, 5447, 5451,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5455, 5460, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5465, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5470, 5475, 5480,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_22[] = {
    0, 0, 0, 0, 5485, 0, 0, 0,
    0, 5490, 0, 0, 5495, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5500, 0, 5505, 0,
    0, 0, 0, 0, 5510, 5515, 0, 5521,
    5526, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5532, 0, 0, 5537, 0, 0, 5542,
    0, 5547, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5552, 0, 5557, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5562, 5567, 5572,
    5577, 5582, 0, 0, 5587, 5592, 0, 0,
    5597, 5602, 0, 0, 0, 0, 0, 0,
    5607, 5612, 0, 0, 5617, 5622, 0, 0,
    5627, 5632, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5637, 5642, 5647, 5652,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5657, 5662, 5667, 5672, 0, 0, 0, 0,
    0, 0, 5677, 5682, 5687, 5692, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_23[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5697, 5701, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_24[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5705, 5709, 5713, 5717, 5721, 5725, 5729, 5733,
    5737, 5741, 5746, 5751, 5756, 5761, 5766, 5771,
    5776, 5781, 5786, 5791, 5796, 5802, 5808, 5814,
    5820, 5826, 5832, 5838, 5844, 5850, 5857, 5864,
    5871, 5878, 5885, 5892, 5899, 5906, 5913, 5920,
    5927, 5932, 5937, 5942, 5947, 5952, 5957, 5962,
    5967, 5972, 5978, 5984, 5990, 5996, 6002, 6008,
    6014, 6020, 6026, 6032, 6038, 6044, 6050, 6056,
    6062, 6068, 6074, 6080, 6086, 6092, 6098, 6104,
    6110, 6116, 6122, 6128, 6134, 6140, 6146, 6152,
    6158, 6164, 6170, 6176, 6182, 6188, 6194, 6198,
    6202, 6206, 6210, 6214, 6218, 6222, 6226, 6230,
    6234, 6238, 6242, 6246, 6250, 6254, 6258, 6262,
    6266, 6270, 6274, 6278, 6282, 6286, 6290, 6294,
    6298, 6302, 6306, 6310, 6314, 6318, 6322, 6326,
    6330, 6334, 6338, 6342, 6346, 6350, 6354, 6358,
    6362, 6366, 6370, 6374, 6378, 6382, 6386, 6390,
    6394, 6398, 6402, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_2A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6406, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6413, 6419, 6424, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6430, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_2E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6435,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6439, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_2F[] = {
    6443, 6447, 6451, 6455, 6459, 6463, 6467, 6471,
    6475, 6479, 6483, 6487, 6491, 6495, 6499, 6503,
    6507, 6511, 6515, 6519, 6523, 6527, 6531, 6535,
    6539, 6543, 6547, 6551, 6555, 6559, 6563, 6567,
    6571, 6575, 6579, 6583, 6587, 6591, 6595, 6599,
    6603, 6607, 6611, 6615, 6619, 6623, 6627, 6631,
    6635, 6639, 6643, 6647, 6651, 6655, 6659, 6663,
    6667, 6671, 6675, 6679, 6683, 6687, 6691, 6695,
    6699, 6703, 6707, 6711, 6715, 6719, 6723, 6727,
    6731, 6735, 6739, 6743, 6747, 6751, 6755, 6759,
    6763, 6767, 6771, 6775, 6779, 6783, 6787, 6791,
    6795, 6799, 6803, 6807, 6811, 6815, 6819, 6823,
    6827, 6831, 6835, 6839, 6843, 6847, 6851, 6855,
    6859, 6863, 6867, 6871, 6875, 6879, 6883, 6887,
    6891, 6895, 6899, 6903, 6907, 6911, 6915, 6919,
    6923, 6927, 6931, 6935, 6939, 6943, 6947, 6951,
    6955, 6959, 6963, 6967, 6971, 6975, 6979, 6983,
    6987, 6991, 6995, 6999, 7003, 7007, 7011, 7015,
    7019, 7023, 7027, 7031, 7035, 7039, 7043, 7047,
    7051, 7055, 7059, 7063, 7067, 7071, 7075, 7079,
    7083, 7087, 7091, 7095, 7099, 7103, 7107, 7111,
    7115, 7119, 7123, 7127, 7131, 7135, 7139, 7143,
    7147, 7151, 7155, 7159, 7163, 7167, 7171, 7175,
    7179, 7183, 7187, 7191, 7195, 7199, 7203, 7207,
    7211, 7215, 7219, 7223, 7227, 7231, 7235, 7239,
    7243, 7247, 7251, 7255, 7259, 7263, 7267, 7271,
    7275, 7279, 7283, 7287, 7291, 7295, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_30[] = {
    7299, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7303, 0,
    7307, 7311, 7315, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7319, 0, 7324, 0,
    7329, 0, 7334, 0, 7339, 0, 7344, 0,
    7349, 0, 7354, 0, 7359, 0, 7364, 0,
    7369, 0, 7374, 0, 0, 7379, 0, 7384,
    0, 7389, 0, 0, 0, 0, 0, 0,
    7394, 7399, 0, 7404, 7409, 0, 7414, 7419,
    0, 7424, 7429, 0, 7434, 7439, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7444, 0, 0, 0,
    0, 0, 0, 7449, 7454, 0, 7459, 7464,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7469, 0, 7474, 0,
    7479, 0, 7484, 0, 7489, 0, 7494, 0,
    7499, 0, 7504, 0, 7509, 0, 7514, 0,
    7519, 0, 7524, 0, 0, 7529, 0, 7534,
    0, 7539, 0, 0, 0, 0, 0, 0,
    7544, 7549, 0, 7554, 7559, 0, 7564, 7569,
    0, 7574, 7579, 0, 7584, 7589, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7594, 0, 0, 7599,
    7604, 7609, 7614, 0, 0, 0, 7619, 7624,
};

static const Q_UINT16 di_31[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7629, 7633, 7637, 7641, 7645, 7649, 7653,
    7657, 7661, 7665, 7669, 7673, 7677, 7681, 7685,
    7689, 7693, 7697, 7701, 7705, 7709, 7713, 7717,
    7721, 7725, 7729, 7733, 7737, 7741, 7745, 7749,
    7753, 7757, 7761, 7765, 7769, 7773, 7777, 7781,
    7785, 7789, 7793, 7797, 7801, 7805, 7809, 7813,
    7817, 7821, 7825, 7829, 7833, 7837, 7841, 7845,
    7849, 7853, 7857, 7861, 7865, 7869, 7873, 7877,
    7881, 7885, 7889, 7893, 7897, 7901, 7905, 7909,
    7913, 7917, 7921, 7925, 7929, 7933, 7937, 7941,
    7945, 7949, 7953, 7957, 7961, 7965, 7969, 7973,
    7977, 7981, 7985, 7989, 7993, 7997, 8001, 0,
    0, 0, 8005, 8009, 8013, 8017, 8021, 8025,
    8029, 8033, 8037, 8041, 8045, 8049, 8053, 8057,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_32[] = {
    8061, 8067, 8073, 8079, 8085, 8091, 8097, 8103,
    8109, 8115, 8121, 8127, 8133, 8139, 8145, 8152,
    8159, 8166, 8173, 8180, 8187, 8194, 8201, 8208,
    8215, 8222, 8229, 8236, 8243, 0, 0, 0,
    8250, 8256, 8262, 8268, 8274, 8280, 8286, 8292,
    8298, 8304, 8310, 8316, 8322, 8328, 8334, 8340,
    8346, 8352, 8358, 8364, 8370, 8376, 8382, 8388,
    8394, 8400, 8406, 8412, 8418, 8424, 8430, 8436,
    8442, 8448, 8454, 8460, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8466, 8471, 8476, 8481, 8486, 8491, 8496,
    8501, 8506, 8511, 8516, 8521, 8526, 8531, 8536,
    8541, 8545, 8549, 8553, 8557, 8561, 8565, 8569,
    8573, 8577, 8581, 8585, 8589, 8593, 8597, 8602,
    8607, 8612, 8617, 8622, 8627, 8632, 8637, 8642,
    8647, 8652, 8657, 8662, 0, 0, 0, 0,
    8667, 8671, 8675, 8679, 8683, 8687, 8691, 8695,
    8699, 8703, 8707, 8711, 8715, 8719, 8723, 8727,
    8731, 8735, 8739, 8743, 8747, 8751, 8755, 8759,
    8763, 8767, 8771, 8775, 8779, 8783, 8787, 8791,
    8795, 8799, 8803, 8807, 8811, 8815, 8819, 8823,
    8827, 8831, 8835, 8839, 8843, 8847, 8851, 8855,
    8859, 8863, 8868, 8873, 8878, 8883, 8888, 8893,
    8898, 8903, 8908, 8913, 8918, 8923, 8928, 8933,
    8938, 8943, 8948, 8953, 8958, 8963, 8968, 8973,
    8978, 8983, 8989, 8995, 0, 0, 0, 0,
    9001, 9005, 9009, 9013, 9017, 9021, 9025, 9029,
    9033, 9037, 9041, 9045, 9049, 9053, 9057, 9061,
    9065, 9069, 9073, 9077, 9081, 9085, 9089, 9093,
    9097, 9101, 9105, 9109, 9113, 9117, 9121, 9125,
    9129, 9133, 9137, 9141, 9145, 9149, 9153, 9157,
    9161, 9165, 9169, 9173, 9177, 9181, 9185, 0,
};

static const Q_UINT16 di_33[] = {
    9189, 9196, 9203, 9210, 9216, 9223, 9229, 9235,
    9243, 9250, 9256, 9262, 9268, 9275, 9282, 9288,
    9294, 9299, 9305, 9312, 9319, 9324, 9332, 9341,
    9349, 9355, 9363, 9371, 9378, 9384, 9390, 9396,
    9403, 9411, 9418, 9424, 9430, 9436, 9441, 9446,
    9451, 9456, 9462, 9468, 9476, 9482, 9489, 9497,
    9503, 9508, 9513, 9521, 9528, 9536, 9542, 9550,
    9555, 9561, 9567, 9573, 9579, 9585, 9592, 9598,
    9603, 9609, 9615, 9621, 9628, 9634, 9640, 9646,
    9654, 9661, 9666, 9674, 9679, 9686, 9693, 9699,
    9705, 9711, 9718, 9723, 9729, 9736, 9741, 9749,
    9755, 9760, 9765, 9770, 9775, 9780, 9785, 9790,
    9795, 9800, 9805, 9811, 9817, 9823, 9829, 9835,
    9841, 9847, 9853, 9859, 9865, 9871, 9877, 9883,
    9889, 9895, 9901, 9906, 9911, 9917, 9922, 0,
    0, 0, 0, 9927, 9932, 9937, 9942, 9947,
    9954, 9959, 9964, 9969, 9974, 9979, 9984, 9989,
    9994, 10000, 10007, 10012, 10017, 10022, 10027, 10032,
    10037, 10042, 10048, 10054, 10060, 10066, 10071, 10076,
    10081, 10086, 10091, 10096, 10101, 10106, 10111, 10116,
    10122, 10128, 10133, 10139, 10145, 10151, 10156, 10162,
    10168, 10175, 10180, 10186, 10192, 10198, 10204, 10212,
    10221, 10226, 10231, 10236, 10241, 10246, 10251, 10256,
    10261, 10266, 10271, 10276, 10281, 10286, 10291, 10296,
    10301, 10306, 10311, 10318, 10323, 10328, 10333, 10340,
    10346, 10351, 10356, 10361, 10366, 10371, 10376, 10381,
    10386, 10391, 10396, 10402, 10407, 10412, 10418, 10424,
    10429, 10436, 10442, 10447, 10452, 10457, 0, 0,
    10462, 10467, 10472, 10477, 10482, 10487, 10492, 10497,
    10502, 10507, 10513, 10519, 10525, 10531, 10537, 10543,
    10549, 10555, 10561, 10567, 10573, 10579, 10585, 10591,
    10597, 10603, 10609, 10615, 10621, 10627, 10633, 0,
};

static const Q_UINT16 di_F9[] = {
    10639, 10643, 10647, 10651, 10655, 10659, 10663, 10667,
    10671, 10675, 10679, 10683, 10687, 10691, 10695, 10699,
    10703, 10707, 10711, 10715, 10719, 10723, 10727, 10731,
    10735, 10739, 10743, 10747, 10751, 10755, 10759, 10763,
    10767, 10771, 10775, 10779, 10783, 10787, 10791, 10795,
    10799, 10803, 10807, 10811, 10815, 10819, 10823, 10827,
    10831, 10835, 10839, 10843, 10847, 10851, 10855, 10859,
    10863, 10867, 10871, 10875, 10879, 10883, 10887, 10891,
    10895, 10899, 10903, 10907, 10911, 10915, 10919, 10923,
    10927, 10931, 10935, 10939, 10943, 10947, 10951, 10955,
    10959, 10963, 10967, 10971, 10975, 10979, 10983, 10987,
    10991, 10995, 10999, 11003, 11007, 11011, 11015, 11019,
    11023, 11027, 11031, 11035, 11039, 11043, 11047, 11051,
    11055, 11059, 11063, 11067, 11071, 11075, 11079, 11083,
    11087, 11091, 11095, 11099, 11103, 11107, 11111, 11115,
    11119, 11123, 11127, 11131, 11135, 11139, 11143, 11147,
    11151, 11155, 11159, 11163, 11167, 11171, 11175, 11179,
    11183, 11187, 11191, 11195, 11199, 11203, 11207, 11211,
    11215, 11219, 11223, 11227, 11231, 11235, 11239, 11243,
    11247, 11251, 11255, 11259, 11263, 11267, 11271, 11275,
    11279, 11283, 11287, 11291, 11295, 11299, 11303, 11307,
    11311, 11315, 11319, 11323, 11327, 11331, 11335, 11339,
    11343, 11347, 11351, 11355, 11359, 11363, 11367, 11371,
    11375, 11379, 11383, 11387, 11391, 11395, 11399, 11403,
    11407, 11411, 11415, 11419, 11423, 11427, 11431, 11435,
    11439, 11443, 11447, 11451, 11455, 11459, 11463, 11467,
    11471, 11475, 11479, 11483, 11487, 11491, 11495, 11499,
    11503, 11507, 11511, 11515, 11519, 11523, 11527, 11531,
    11535, 11539, 11543, 11547, 11551, 11555, 11559, 11563,
    11567, 11571, 11575, 11579, 11583, 11587, 11591, 11595,
    11599, 11603, 11607, 11611, 11615, 11619, 11623, 11627,
    11631, 11635, 11639, 11643, 11647, 11651, 11655, 11659,
};

static const Q_UINT16 di_FA[] = {
    11663, 11667, 11671, 11675, 11679, 11683, 11687, 11691,
    11695, 11699, 11703, 11707, 11711, 11715, 0, 0,
    11719, 0, 11723, 0, 0, 11727, 11731, 11735,
    11739, 11743, 11747, 11751, 11755, 11759, 11763, 0,
    11767, 0, 11771, 0, 0, 11775, 11779, 0,
    0, 0, 11783, 11787, 11791, 11795, 0, 0,
    11799, 11803, 11807, 11811, 11815, 11819, 11823, 11827,
    11831, 11835, 11839, 11843, 11847, 11851, 11855, 11859,
    11863, 11867, 11871, 11875, 11879, 11883, 11887, 11891,
    11895, 11899, 11903, 11907, 11911, 11915, 11919, 11923,
    11927, 11931, 11935, 11939, 11943, 11947, 11951, 11955,
    11959, 11963, 11967, 11971, 11975, 11979, 11983, 11987,
    11991, 11995, 11999, 12003, 12007, 12011, 12015, 12019,
    12023, 12027, 12031, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_FB[] = {
    12035, 12040, 12045, 12050, 12056, 12062, 12067, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12072, 12077, 12082, 12087, 12092,
    0, 0, 0, 0, 0, 12097, 0, 12102,
    12107, 12111, 12115, 12119, 12123, 12127, 12131, 12135,
    12139, 12143, 12147, 12152, 12157, 12162, 12167, 12172,
    12177, 12182, 12187, 12192, 12197, 12202, 12207, 0,
    12212, 12217, 12222, 12227, 12232, 0, 12237, 0,
    12242, 12247, 0, 12252, 12257, 0, 12262, 12267,
    12272, 12277, 12282, 12287, 12292, 12297, 12302, 12307,
    12312, 12316, 12320, 12324, 12328, 12332, 12336, 12340,
    12344, 12348, 12352, 12356, 12360, 12364, 12368, 12372,
    12376, 12380, 12384, 12388, 12392, 12396, 12400, 12404,
    12408, 12412, 12416, 12420, 12424, 12428, 12432, 12436,
    12440, 12444, 12448, 12452, 12456, 12460, 12464, 12468,
    12472, 12476, 12480, 12484, 12488, 12492, 12496, 12500,
    12504, 12508, 12512, 12516, 12520, 12524, 12528, 12532,
    12536, 12540, 12544, 12548, 12552, 12556, 12560, 12564,
    12568, 12572, 12576, 12580, 12584, 12588, 12592, 12596,
    12600, 12604, 12608, 12612, 12616, 12620, 12624, 12628,
    12632, 12636, 12640, 12644, 12648, 12652, 12656, 12660,
    12664, 12668, 12672, 12676, 12680, 12684, 12688, 12692,
    12696, 12700, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12704, 12708, 12712, 12716, 12720,
    12724, 12728, 12732, 12736, 12740, 12744, 12748, 12752,
    12756, 12760, 12764, 12768, 12772, 12776, 12780, 12784,
    12788, 12792, 12796, 12801, 12806, 12811, 12816, 12821,
    12826, 12831, 12836, 12841, 12846, 12851, 12856, 12861,
    12866, 12871, 12876, 12881, 12886, 12890, 12894, 12898,
};

static const Q_UINT16 di_FC[] = {
    12902, 12907, 12912, 12917, 12922, 12927, 12932, 12937,
    12942, 12947, 12952, 12957, 12962, 12967, 12972, 12977,
    12982, 12987, 12992, 12997, 13002, 13007, 13012, 13017,
    13022, 13027, 13032, 13037, 13042, 13047, 13052, 13057,
    13062, 13067, 13072, 13077, 13082, 13087, 13092, 13097,
    13102, 13107, 13112, 13117, 13122, 13127, 13132, 13137,
    13142, 13147, 13152, 13157, 13162, 13167, 13172, 13177,
    13182, 13187, 13192, 13197, 13202, 13207, 13212, 13217,
    13222, 13227, 13232, 13237, 13242, 13247, 13252, 13257,
    13262, 13267, 13272, 13277, 13282, 13287, 13292, 13297,
    13302, 13307, 13312, 13317, 13322, 13327, 13332, 13337,
    13342, 13347, 13352, 13357, 13362, 13367, 13372, 13378,
    13384, 13390, 13396, 13402, 13408, 13413, 13418, 13423,
    13428, 13433, 13438, 13443, 13448, 13453, 13458, 13463,
    13468, 13473, 13478, 13483, 13488, 13493, 13498, 13503,
    13508, 13513, 13518, 13523, 13528, 13533, 13538, 13543,
    13548, 13553, 13558, 13563, 13568, 13573, 13578, 13583,
    13588, 13593, 13598, 13603, 13608, 13613, 13618, 13623,
    13628, 13633, 13638, 13643, 13648, 13653, 13658, 13663,
    13668, 13673, 13678, 13683, 13688, 13693, 13698, 13703,
    13708, 13713, 13718, 13723, 13728, 13733, 13738, 13743,
    13748, 13753, 13758, 13763, 13768, 13773, 13778, 13783,
    13788, 13793, 13798, 13803, 13808, 13813, 13818, 13823,
    13828, 13833, 13838, 13843, 13848, 13853, 13858, 13863,
    13868, 13873, 13878, 13883, 13888, 13893, 13898, 13903,
    13908, 13913, 13918, 13923, 13928, 13933, 13938, 13943,
    13948, 13953, 13958, 13963, 13968, 13973, 13978, 13983,
    13988, 13993, 13998, 14003, 14008, 14013, 14018, 14023,
    14028, 14033, 14038, 14043, 14048, 14053, 14058, 14063,
    14068, 14073, 14078, 14083, 14088, 14093, 14098, 14103,
    14108, 14113, 14118, 14124, 14130, 14136, 14141, 14146,
    14151, 14156, 14161, 14166, 14171, 14176, 14181, 14186,
};

static const Q_UINT16 di_FD[] = {
    14191, 14196, 14201, 14206, 14211, 14216, 14221, 14226,
    14231, 14236, 14241, 14246, 14251, 14256, 14261, 14266,
    14271, 14276, 14281, 14286, 14291, 14296, 14301, 14306,
    14311, 14316, 14321, 14326, 14331, 14336, 14341, 14346,
    14351, 14356, 14361, 14366, 14371, 14376, 14381, 14386,
    14391, 14396, 14401, 14406, 14411, 14416, 14421, 14426,
    14431, 14436, 14441, 14446, 14451, 14456, 14461, 14466,
    14471, 14476, 14481, 14486, 14491, 14496, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    14501, 14507, 14513, 14519, 14525, 14531, 14537, 14543,
    14549, 14555, 14561, 14567, 14573, 14579, 14585, 14591,
    14597, 14603, 14609, 14615, 14621, 14627, 14633, 14639,
    14645, 14651, 14657, 14663, 14669, 14675, 14681, 14687,
    14693, 14699, 14705, 14711, 14717, 14723, 14729, 14735,
    14741, 14747, 14753, 14759, 14765, 14771, 14777, 14783,
    14789, 14795, 14801, 14807, 14813, 14819, 14825, 14831,
    14837, 14843, 14849, 14855, 14861, 14867, 14873, 14879,
    0, 0, 14885, 14891, 14897, 14903, 14909, 14915,
    14921, 14927, 14933, 14939, 14945, 14951, 14957, 14963,
    14969, 14975, 14981, 14987, 14993, 14999, 15005, 15011,
    15017, 15023, 15029, 15035, 15041, 15047, 15053, 15059,
    15065, 15071, 15077, 15083, 15089, 15095, 15101, 15107,
    15113, 15119, 15125, 15131, 15137, 15143, 15149, 15155,
    15161, 15167, 15173, 15179, 15185, 15191, 15197, 15203,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15209, 15215, 15221, 15228, 15235, 15242, 15249, 15256,
    15263, 15270, 15276, 15297, 15308, 0, 0, 0,
};

static const Q_UINT16 di_FE[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15315, 15319, 15323, 15327, 15331, 15335, 15339, 15343,
    15347, 15351, 15355, 15359, 15363, 15367, 15371, 15375,
    15379, 15383, 15387, 15391, 15395, 0, 0, 0,
    0, 15399, 15403, 15407, 15411, 15415, 15419, 15423,
    15427, 15431, 15435, 0, 15439, 15443, 15447, 15451,
    15455, 15459, 15463, 15467, 15471, 15475, 15479, 15483,
    15487, 15491, 15495, 15499, 15503, 15507, 15511, 0,
    15515, 15519, 15523, 15527, 0, 0, 0, 0,
    15531, 15536, 15541, 0, 15546, 0, 15551, 15556,
    15561, 15566, 15571, 15576, 15581, 15586, 15591, 15596,
    15601, 15605, 15609, 15613, 15617, 15621, 15625, 15629,
    15633, 15637, 15641, 15645, 15649, 15653, 15657, 15661,
    15665, 15669, 15673, 15677, 15681, 15685, 15689, 15693,
    15697, 15701, 15705, 15709, 15713, 15717, 15721, 15725,
    15729, 15733, 15737, 15741, 15745, 15749, 15753, 15757,
    15761, 15765, 15769, 15773, 15777, 15781, 15785, 15789,
    15793, 15797, 15801, 15805, 15809, 15813, 15817, 15821,
    15825, 15829, 15833, 15837, 15841, 15845, 15849, 15853,
    15857, 15861, 15865, 15869, 15873, 15877, 15881, 15885,
    15889, 15893, 15897, 15901, 15905, 15909, 15913, 15917,
    15921, 15925, 15929, 15933, 15937, 15941, 15945, 15949,
    15953, 15957, 15961, 15965, 15969, 15973, 15977, 15981,
    15985, 15989, 15993, 15997, 16001, 16005, 16009, 16013,
    16017, 16021, 16025, 16029, 16033, 16037, 16041, 16045,
    16049, 16053, 16057, 16061, 16065, 16069, 16074, 16079,
    16084, 16089, 16094, 16099, 16104, 0, 0, 0,
};

static const Q_UINT16 di_FF[] = {
    0, 16109, 16113, 16117, 16121, 16125, 16129, 16133,
    16137, 16141, 16145, 16149, 16153, 16157, 16161, 16165,
    16169, 16173, 16177, 16181, 16185, 16189, 16193, 16197,
    16201, 16205, 16209, 16213, 16217, 16221, 16225, 16229,
    16233, 16237, 16241, 16245, 16249, 16253, 16257, 16261,
    16265, 16269, 16273, 16277, 16281, 16285, 16289, 16293,
    16297, 16301, 16305, 16309, 16313, 16317, 16321, 16325,
    16329, 16333, 16337, 16341, 16345, 16349, 16353, 16357,
    16361, 16365, 16369, 16373, 16377, 16381, 16385, 16389,
    16393, 16397, 16401, 16405, 16409, 16413, 16417, 16421,
    16425, 16429, 16433, 16437, 16441, 16445, 16449, 16453,
    16457, 16461, 16465, 16469, 16473, 16477, 16481, 16485,
    16489, 16493, 16497, 16501, 16505, 16509, 16513, 16517,
    16521, 16525, 16529, 16533, 16537, 16541, 16545, 16549,
    16553, 16557, 16561, 16565, 16569, 16573, 16577, 16581,
    16585, 16589, 16593, 16597, 16601, 16605, 16609, 16613,
    16617, 16621, 16625, 16629, 16633, 16637, 16641, 16645,
    16649, 16653, 16657, 16661, 16665, 16669, 16673, 16677,
    16681, 16685, 16689, 16693, 16697, 16701, 16705, 16709,
    16713, 16717, 16721, 16725, 16729, 16733, 16737, 16741,
    16745, 16749, 16753, 16757, 16761, 16765, 16769, 16773,
    16777, 16781, 16785, 16789, 16793, 16797, 16801, 16805,
    16809, 16813, 16817, 16821, 16825, 16829, 16833, 16837,
    16841, 16845, 16849, 16853, 16857, 16861, 16865, 0,
    0, 0, 16869, 16873, 16877, 16881, 16885, 16889,
    0, 0, 16893, 16897, 16901, 16905, 16909, 16913,
    0, 0, 16917, 16921, 16925, 16929, 16933, 16937,
    0, 0, 16941, 16945, 16949, 0, 0, 0,
    16953, 16957, 16961, 16965, 16969, 16973, 16977, 0,
    16981, 16985, 16989, 16993, 16997, 17001, 17005, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 * const decomposition_info[256] = {
    di_00, di_01, di_02, di_03, di_04, di_05, di_06, di_07,
    di_07, di_09, di_0A, di_0B, di_0C, di_0D, di_0E, di_0F,
    di_10, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_1E, di_1F,
    di_20, di_21, di_22, di_23, di_24, di_07, di_07, di_07,
    di_07, di_07, di_2A, di_07, di_07, di_07, di_2E, di_2F,
    di_30, di_31, di_32, di_33, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_F9, di_FA, di_FB, di_FC, di_FD, di_FE, di_FF,
};
// 68832 bytes

static const Q_UINT16 ligature_map[] = {
    0,
    5567, 0,
    5552, 0,
    5572, 0,
    67, 72, 77, 82, 87, 92, 332, 342, 352, 966, 1196, 1206, 1346, 2365, 3145, 3155, 0,
    2375, 2385, 2395, 0,
    97, 362, 372, 382, 392, 0,
    402, 2415, 2425, 2435, 2445, 2455, 0,
    102, 107, 112, 117, 412, 422, 432, 442, 452, 1216, 1226, 1356, 2485, 2495, 3265, 3275, 3285, 0,
    2515, 0,
    462, 472, 482, 492, 1076, 1146, 2525, 0,
    502, 1336, 2535, 2545, 2555, 2565, 2575, 0,
    122, 127, 132, 137, 512, 522, 532, 542, 552, 976, 1236, 1246, 2585, 3345, 3355, 0,
    567, 0,
    577, 1086, 2605, 2615, 2625, 0,
    587, 597, 607, 2635, 2655, 2665, 0,
    2675, 2685, 2695, 0,
    142, 627, 637, 647, 1156, 2705, 2715, 2725, 2735, 0,
    147, 152, 157, 162, 167, 662, 672, 682, 901, 986, 1096, 1256, 1266, 1386, 3365, 3375, 0,
    2785, 2795, 0,
    692, 702, 712, 1276, 1286, 2805, 2815, 2835, 0,
    722, 732, 742, 752, 1316, 2845, 2855, 0,
    762, 772, 1326, 2895, 2905, 2915, 2925, 0,
    172, 177, 182, 187, 782, 792, 802, 812, 822, 832, 911, 996, 1296, 1306, 2935, 2945, 2955, 3485, 3495, 0,
    2985, 2995, 0,
    842, 3005, 3015, 3025, 3035, 3045, 0,
    3055, 3065, 0,
    192, 852, 862, 1406, 3075, 3555, 3565, 3575, 3585, 0,
    867, 877, 887, 3085, 3095, 3105, 0,
    197, 202, 207, 212, 217, 222, 337, 347, 357, 971, 1201, 1211, 1351, 2370, 3150, 3160, 0,
    2380, 2390, 2400, 0,
    227, 367, 377, 387, 397, 0,
    407, 2420, 2430, 2440, 2450, 2460, 0,
    232, 237, 242, 247, 417, 427, 437, 447, 457, 1221, 1231, 1361, 2490, 2500, 3270, 3280, 3290, 0,
    2520, 0,
    467, 477, 487, 497, 1081, 1151, 2530, 0,
    507, 1341, 2540, 2550, 2560, 2570, 2580, 3115, 0,
    252, 257, 262, 267, 517, 527, 537, 547, 981, 1241, 1251, 2590, 3350, 3360, 0,
    572, 1126, 0,
    582, 1091, 2610, 2620, 2630, 0,
    592, 602, 612, 2640, 2660, 2670, 0,
    2680, 2690, 2700, 0,
    272, 632, 642, 652, 1161, 2710, 2720, 2730, 2740, 0,
    277, 282, 287, 292, 297, 667, 677, 687, 906, 991, 1101, 1261, 1271, 1391, 3370, 3380, 0,
    2790, 2800, 0,
    697, 707, 717, 1281, 1291, 2810, 2820, 2840, 0,
    727, 737, 747, 757, 1321, 2850, 2860, 0,
    767, 777, 1331, 2900, 2910, 2920, 2930, 3120, 0,
    302, 307, 312, 317, 787, 797, 807, 817, 827, 837, 916, 1001, 1301, 1311, 2940, 2950, 2960, 3490, 3500, 0,
    2990, 3000, 0,
    847, 3010, 3020, 3030, 3040, 3050, 3125, 0,
    3060, 3070, 0,
    322, 327, 857, 1411, 3080, 3130, 3560, 3570, 3580, 3590, 0,
    872, 882, 892, 3090, 3100, 3110, 0,
    1537, 4476, 4670, 0,
    3165, 3175, 3185, 3195, 0,
    1046, 0,
    1166, 0,
    1066, 1176, 0,
    2405, 0,
    3295, 3305, 3315, 3325, 0,
    2595, 0,
    3385, 3395, 3405, 3415, 0,
    1376, 2745, 2755, 0,
    1366, 0,
    1186, 0,
    1006, 1016, 1026, 1036, 0,
    3170, 3180, 3190, 3200, 0,
    1051, 0,
    1171, 0,
    1071, 1181, 0,
    2410, 0,
    3300, 3310, 3320, 3330, 0,
    2600, 0,
    3390, 3400, 3410, 3420, 0,
    1381, 2750, 2760, 0,
    1371, 0,
    1191, 0,
    1011, 1021, 1031, 1041, 0,
    3215, 3225, 3235, 3245, 0,
    3220, 3230, 3240, 3250, 0,
    2465, 2475, 0,
    2470, 2480, 0,
    2765, 2775, 0,
    2770, 2780, 0,
    2865, 0,
    2870, 0,
    2875, 0,
    2880, 0,
    2965, 0,
    2970, 0,
    2975, 0,
    2980, 0,
    3140, 0,
    3435, 3445, 3455, 3465, 3475, 0,
    3440, 3450, 3460, 3470, 3480, 0,
    3505, 3515, 3525, 3535, 3545, 0,
    3510, 3520, 3530, 3540, 3550, 0,
    1116, 0,
    1106, 0,
    1111, 0,
    1056, 0,
    1061, 0,
    2505, 0,
    2510, 0,
    1396, 0,
    1401, 0,
    1121, 0,
    1514, 0,
    1542, 3635, 3640, 4433, 4438, 4443, 4452, 0,
    1551, 3705, 3710, 4506, 0,
    1556, 3775, 3780, 4515, 4524, 0,
    1561, 1586, 3855, 3860, 4573, 4578, 4583, 0,
    1566, 3925, 3930, 4708, 0,
    4665, 0,
    1571, 1591, 3995, 4646, 4651, 4656, 0,
    1576, 4055, 4060, 4717, 4726, 0,
    4418, 0,
    4491, 0,
    1596, 3595, 3600, 4095, 4398, 4403, 4413, 4423, 0,
    1601, 3675, 3680, 4104, 0,
    1606, 3735, 3740, 4113, 4486, 4496, 0,
    1611, 1621, 3815, 3820, 4122, 4544, 4549, 4563, 0,
    1631, 3895, 3900, 4131, 0,
    4626, 4631, 0,
    1626, 1636, 3955, 3960, 4140, 4607, 4612, 4636, 0,
    1641, 4015, 4020, 4149, 4688, 4698, 0,
    1581, 4554, 4568, 0,
    1616, 4617, 4641, 0,
    4693, 0,
    1658, 1663, 0,
    1711, 0,
    1796, 1806, 0,
    1706, 0,
    1696, 1701, 1816, 0,
    1786, 1836, 0,
    1846, 0,
    1721, 1731, 1856, 1866, 0,
    1716, 0,
    1876, 0,
    1726, 1906, 1916, 1926, 0,
    1936, 0,
    1946, 0,
    1896, 0,
    1801, 1811, 0,
    1751, 0,
    1741, 1746, 1821, 0,
    1791, 1841, 0,
    1851, 0,
    1736, 1766, 1861, 1871, 0,
    1761, 0,
    1881, 0,
    1771, 1911, 1921, 1931, 0,
    1941, 0,
    1951, 0,
    1901, 0,
    1756, 0,
    1776, 0,
    1781, 0,
    1826, 0,
    1831, 0,
    1886, 0,
    1891, 0,
    12167, 12172, 12177, 0,
    12182, 12292, 0,
    12187, 0,
    12192, 0,
    12197, 0,
    12202, 12287, 0,
    12207, 0,
    12212, 0,
    12097, 12217, 0,
    12222, 0,
    12227, 12297, 0,
    12232, 0,
    12237, 0,
    12242, 0,
    12247, 0,
    12252, 0,
    12257, 12302, 0,
    12262, 0,
    12267, 0,
    12272, 0,
    12147, 12152, 12277, 0,
    12282, 0,
    12102, 0,
    1961, 1966, 1976, 0,
    1971, 0,
    1981, 0,
    2011, 0,
    2016, 0,
    2006, 0,
    2036, 0,
    2041, 0,
    2046, 0,
    2051, 0,
    2056, 0,
    2061, 0,
    2021, 0,
    2066, 0,
    2071, 0,
    2026, 0,
    2031, 0,
    2086, 0,
    2091, 0,
    2096, 0,
    2076, 2081, 0,
    2111, 0,
    2116, 0,
    2121, 0,
    2126, 0,
    2101, 0,
    2106, 0,
    2146, 0,
    2151, 0,
    2131, 2136, 2141, 0,
    2156, 0,
    2161, 2171, 0,
    2166, 0,
    2176, 0,
    2181, 0,
    2186, 2191, 2196, 0,
    2201, 0,
    2206, 2216, 0,
    2211, 0,
    2221, 2226, 2236, 0,
    2231, 0,
    2290, 0,
    2265, 0,
    2270, 0,
    2275, 0,
    2280, 0,
    2285, 0,
    2295, 2300, 2325, 0,
    2355, 0,
    2330, 0,
    2335, 0,
    2340, 0,
    2345, 0,
    2350, 0,
    2305, 0,
    2315, 0,
    2360, 0,
    2645, 0,
    2650, 0,
    2825, 0,
    2830, 0,
    2885, 0,
    2890, 0,
    3205, 3255, 0,
    3210, 3260, 0,
    3335, 0,
    3340, 0,
    3425, 0,
    3430, 0,
    3605, 3615, 3625, 4158, 0,
    3610, 3620, 3630, 4163, 0,
    4168, 0,
    4173, 0,
    4178, 0,
    4183, 0,
    4188, 0,
    4193, 0,
    3645, 3655, 3665, 4198, 0,
    3650, 3660, 3670, 4203, 0,
    4208, 0,
    4213, 0,
    4218, 0,
    4223, 0,
    4228, 0,
    4233, 0,
    3685, 3695, 0,
    3690, 3700, 0,
    3715, 3725, 0,
    3720, 3730, 0,
    3745, 3755, 3765, 4238, 0,
    3750, 3760, 3770, 4243, 0,
    4248, 0,
    4253, 0,
    4258, 0,
    4263, 0,
    4268, 0,
    4273, 0,
    3785, 3795, 3805, 4278, 0,
    3790, 3800, 3810, 4283, 0,
    4288, 0,
    4293, 0,
    4298, 0,
    4303, 0,
    4308, 0,
    4313, 0,
    3825, 3835, 3845, 0,
    3830, 3840, 3850, 0,
    3865, 3875, 3885, 0,
    3870, 3880, 3890, 0,
    3905, 3915, 0,
    3910, 3920, 0,
    3935, 3945, 0,
    3940, 3950, 0,
    3965, 3975, 3985, 0,
    3970, 3980, 3990, 0,
    4000, 4005, 4010, 0,
    4025, 4035, 4045, 4318, 0,
    4030, 4040, 4050, 4323, 0,
    4328, 0,
    4333, 0,
    4338, 0,
    4343, 0,
    4348, 0,
    4353, 0,
    4065, 4075, 4085, 4358, 0,
    4070, 4080, 4090, 4363, 0,
    4368, 0,
    4373, 0,
    4378, 0,
    4383, 0,
    4388, 0,
    4393, 0,
    4408, 0,
    4481, 0,
    4683, 0,
    4428, 0,
    4529, 4534, 4539, 0,
    4501, 0,
    4703, 0,
    4592, 4597, 4602, 0,
    5455, 0,
    5460, 0,
    5465, 0,
    5470, 0,
    5480, 0,
    5475, 0,
    5485, 0,
    5490, 0,
    5495, 0,
    5500, 0,
    5505, 0,
    5532, 0,
    5537, 0,
    5542, 0,
    5547, 0,
    5562, 0,
    5557, 0,
    5577, 0,
    5582, 0,
    5587, 0,
    5592, 0,
    5597, 0,
    5602, 0,
    5607, 0,
    5612, 0,
    5657, 0,
    5662, 0,
    5617, 0,
    5622, 0,
    5627, 0,
    5632, 0,
    5667, 0,
    5672, 0,
    5637, 0,
    5642, 0,
    5647, 0,
    5652, 0,
    5677, 0,
    5682, 0,
    5687, 0,
    5692, 0,
    6430, 0,
    7444, 0,
    7319, 0,
    7324, 0,
    7329, 0,
    7334, 0,
    7339, 0,
    7344, 0,
    7349, 0,
    7354, 0,
    7359, 0,
    7364, 0,
    7369, 0,
    7374, 0,
    7379, 0,
    7384, 0,
    7389, 0,
    7394, 7399, 0,
    7404, 7409, 0,
    7414, 7419, 0,
    7424, 7429, 0,
    7434, 7439, 0,
    7459, 0,
    7594, 0,
    7469, 0,
    7474, 0,
    7479, 0,
    7484, 0,
    7489, 0,
    7494, 0,
    7499, 0,
    7504, 0,
    7509, 0,
    7514, 0,
    7519, 0,
    7524, 0,
    7529, 0,
    7534, 0,
    7539, 0,
    7544, 7549, 0,
    7554, 7559, 0,
    7564, 7569, 0,
    7574, 7579, 0,
    7584, 7589, 0,
    7599, 0,
    7604, 0,
    7609, 0,
    7614, 0,
    7619, 0,
    12157, 12162, 0,

};

static const Q_UINT16 li_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 3, 5, 0,
    0, 7, 24, 28, 34, 41, 59, 61,
    69, 77, 93, 95, 101, 108, 112, 122,
    139, 0, 142, 151, 159, 167, 187, 190,
    197, 200, 210, 0, 0, 0, 0, 0,
    0, 217, 234, 238, 244, 251, 269, 271,
    279, 288, 303, 306, 312, 319, 323, 333,
    350, 0, 353, 362, 370, 379, 399, 402,
    410, 413, 424, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    431, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 435, 0, 440, 442, 444, 447,
    0, 0, 449, 0, 0, 0, 0, 454,
    0, 0, 0, 0, 456, 461, 465, 0,
    467, 0, 0, 0, 469, 0, 0, 0,
    0, 0, 474, 0, 479, 481, 483, 486,
    0, 0, 488, 0, 0, 0, 0, 493,
    0, 0, 0, 0, 495, 500, 504, 0,
    506, 0, 0, 0, 508, 0, 0, 0,
};

static const Q_UINT16 li_01[] = {
    0, 0, 513, 518, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 523, 526, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 529, 532, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 535, 537, 0, 0, 0, 0,
    539, 541, 0, 0, 0, 0, 0, 0,
    543, 545, 547, 549, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 551,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    553, 559, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 565,
    571, 0, 0, 0, 0, 0, 0, 577,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 579, 581, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_02[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 583, 585,
    587, 589, 0, 0, 0, 0, 591, 593,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 595, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_03[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    597, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 599, 0, 0, 0, 607, 0, 612,
    0, 618, 0, 0, 0, 0, 0, 626,
    0, 631, 0, 0, 0, 633, 0, 0,
    0, 640, 0, 0, 646, 0, 648, 0,
    0, 650, 0, 0, 0, 659, 0, 664,
    0, 671, 0, 0, 0, 0, 0, 680,
    0, 685, 0, 0, 0, 688, 0, 0,
    0, 697, 704, 708, 0, 0, 712, 0,
    0, 0, 714, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_04[] = {
    0, 0, 0, 0, 0, 0, 717, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    719, 0, 0, 722, 0, 724, 728, 731,
    733, 0, 738, 0, 0, 0, 740, 0,
    0, 0, 0, 742, 0, 0, 0, 747,
    0, 0, 0, 749, 0, 751, 0, 0,
    753, 0, 0, 756, 0, 758, 762, 765,
    767, 0, 772, 0, 0, 0, 774, 0,
    0, 0, 0, 776, 0, 0, 0, 781,
    0, 0, 0, 783, 0, 785, 0, 0,
    0, 0, 0, 0, 0, 0, 787, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 789, 791, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    793, 795, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    797, 799, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    801, 805, 808, 810, 812, 814, 817, 0,
    819, 821, 824, 826, 829, 0, 831, 0,
    833, 835, 0, 837, 839, 0, 842, 844,
    846, 848, 852, 0, 0, 0, 0, 0,
    0, 0, 854, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 856,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    860, 0, 862, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 864, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 866, 0, 0, 868, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_07[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_09[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 870, 872, 874,
    0, 0, 0, 0, 876, 0, 0, 0,
    0, 878, 880, 0, 0, 0, 0, 0,
    882, 0, 0, 884, 0, 0, 0, 886,
    888, 0, 0, 890, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 892, 894, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 896,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 898,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 901, 903,
    0, 0, 0, 0, 905, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 907, 0, 0, 0, 0,
    0, 0, 909, 0, 0, 0, 0, 0,
    911, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0B[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 913, 915, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 917,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 921, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 923, 926,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 928, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 930,
    0, 0, 0, 0, 0, 0, 932, 0,
    0, 0, 936, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 938, 941,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 943, 0, 0, 947, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    949, 0, 951, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 953, 0, 0, 0,
    0, 955, 0, 0, 0, 0, 957, 0,
    0, 0, 0, 959, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 961, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    965, 0, 967, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 969, 0, 0, 0,
    0, 971, 0, 0, 0, 0, 973, 0,
    0, 0, 0, 975, 0, 0, 0, 0,
    0, 0, 977, 979, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 981, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_1E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 983, 985,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 987, 989, 0, 0, 0, 0,
    0, 0, 991, 993, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    995, 998, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1001, 1003, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1005, 1007, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_1F[] = {
    1009, 1014, 1019, 1021, 1023, 1025, 1027, 1029,
    1031, 1036, 1041, 1043, 1045, 1047, 1049, 1051,
    1053, 1056, 0, 0, 0, 0, 0, 0,
    1059, 1062, 0, 0, 0, 0, 0, 0,
    1065, 1070, 1075, 1077, 1079, 1081, 1083, 1085,
    1087, 1092, 1097, 1099, 1101, 1103, 1105, 1107,
    1109, 1113, 0, 0, 0, 0, 0, 0,
    1117, 1121, 0, 0, 0, 0, 0, 0,
    1125, 1128, 0, 0, 0, 0, 0, 0,
    1131, 1134, 0, 0, 0, 0, 0, 0,
    1137, 1141, 0, 0, 0, 0, 0, 0,
    0, 1145, 0, 0, 0, 0, 0, 0,
    1149, 1154, 1159, 1161, 1163, 1165, 1167, 1169,
    1171, 1176, 1181, 1183, 1185, 1187, 1189, 1191,
    1193, 0, 0, 0, 1195, 0, 0, 0,
    0, 0, 0, 0, 1197, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1199, 0,
    0, 0, 0, 0, 0, 0, 0, 1201,
    0, 0, 0, 0, 0, 0, 1205, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1207, 0,
    0, 0, 0, 0, 0, 0, 1209, 0,
};

static const Q_UINT16 li_21[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1213, 0, 1215, 0, 1217, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1219, 0, 1221, 0, 1223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_22[] = {
    0, 0, 0, 1225, 0, 0, 0, 0,
    1227, 0, 0, 1229, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1231, 0, 1233, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1235, 0, 0, 0,
    0, 0, 0, 1237, 0, 1239, 0, 0,
    1241, 0, 0, 0, 0, 1243, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1245, 0, 0, 1247, 1249, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1251, 1253, 0, 0, 1255, 1257,
    0, 0, 1259, 1261, 1263, 1265, 0, 0,
    0, 0, 1267, 1269, 0, 0, 1271, 1273,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1275, 1277, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1279, 0, 0, 0, 0, 0,
    1281, 1283, 0, 1285, 0, 0, 0, 0,
    0, 0, 1287, 1289, 1291, 1293, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_2A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1295, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_30[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1297, 0,
    0, 0, 0, 1299, 0, 1301, 0, 1303,
    0, 1305, 0, 1307, 0, 1309, 0, 1311,
    0, 1313, 0, 1315, 0, 1317, 0, 1319,
    0, 1321, 0, 0, 1323, 0, 1325, 0,
    1327, 0, 0, 0, 0, 0, 0, 1329,
    0, 0, 1332, 0, 0, 1335, 0, 0,
    1338, 0, 0, 1341, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1344, 0, 0,
    0, 0, 0, 0, 0, 0, 1346, 0,
    0, 0, 0, 1348, 0, 1350, 0, 1352,
    0, 1354, 0, 1356, 0, 1358, 0, 1360,
    0, 1362, 0, 1364, 0, 1366, 0, 1368,
    0, 1370, 0, 0, 1372, 0, 1374, 0,
    1376, 0, 0, 0, 0, 0, 0, 1378,
    0, 0, 1381, 0, 0, 1384, 0, 0,
    1387, 0, 0, 1390, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1393,
    1395, 1397, 1399, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1401, 0, 0,
};

static const Q_UINT16 li_FB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1403, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 * const ligature_info[256] = {
    li_00, li_01, li_02, li_03, li_04, li_05, li_06, li_07,
    li_07, li_09, li_0A, li_0B, li_0C, li_0D, li_07, li_0F,
    li_10, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_1E, li_1F,
    li_07, li_21, li_22, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_2A, li_07, li_07, li_07, li_07, li_07,
    li_30, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_FB, li_07, li_07, li_07, li_07,
};
// 15098 bytes

static const Q_UINT8 dir_00[] = {
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 8, 7, 8, 9, 7, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 7, 7, 7, 8,
    9, 10, 10, 4, 4, 4, 10, 10,
    138, 138, 10, 4, 6, 4, 6, 3,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 138, 10, 138, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 18,
    18, 18, 18, 18, 18, 7, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    6, 10, 4, 4, 4, 4, 10, 10,
    10, 10, 0, 138, 10, 10, 10, 10,
    4, 4, 2, 2, 10, 0, 10, 10,
    10, 2, 0, 138, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_01[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_02[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_03[] = {
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 0, 0, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 10, 10, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_04[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 17, 17, 17, 17, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 17, 1, 17,
    1, 17, 17, 1, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 13, 0, 0, 0, 13,
    0, 13, 77, 77, 77, 77, 45, 77,
    45, 77, 45, 45, 45, 45, 45, 77,
    77, 77, 77, 45, 45, 45, 45, 45,
    45, 45, 45, 0, 0, 0, 0, 0,
    109, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 45, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 4, 5, 5, 13, 45, 45,
    17, 77, 77, 77, 13, 77, 77, 77,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 45, 77, 45, 77,
    45, 45, 77, 77, 13, 77, 17, 17,
    17, 17, 17, 17, 17, 13, 17, 17,
    17, 17, 17, 17, 17, 13, 13, 17,
    17, 10, 17, 17, 17, 17, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 45, 45, 45, 13, 13, 0,
};

static const Q_UINT8 dir_07[] = {
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 0, 18,
    77, 17, 45, 45, 45, 77, 77, 77,
    77, 77, 45, 45, 45, 45, 77, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 77, 45, 77, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_09[] = {
    0, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 0, 0, 0, 0, 17, 0, 0,
    0, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0A[] = {
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 0, 0, 0, 0, 17,
    17, 0, 0, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 0, 17,
    17, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0B[] = {
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 17,
    0, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 17,
    17, 0, 0, 0, 0, 0, 17, 17,
    17, 0, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 17, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 17,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 4,
    0, 0, 0, 0, 0, 0, 0, 17,
    17, 17, 17, 17, 17, 17, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 17,
    0, 17, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 0,
    17, 17, 17, 17, 17, 0, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 17, 17,
    17, 0, 17, 0, 0, 0, 17, 17,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_16[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_17[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 17,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_18[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 17, 17, 17, 18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_1F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 0,
};

static const Q_UINT8 dir_20[] = {
    9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 18, 18, 114, 0, 1,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    9, 7, 11, 14, 16, 12, 15, 9,
    4, 4, 4, 4, 4, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 138, 138, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 9,
    18, 18, 18, 18, 0, 0, 0, 0,
    0, 0, 18, 18, 18, 18, 18, 18,
    2, 0, 0, 0, 2, 2, 2, 2,
    2, 2, 4, 4, 10, 138, 138, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 4, 4, 10, 138, 138, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_21[] = {
    10, 10, 0, 10, 10, 10, 10, 0,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 10, 10,
    10, 0, 0, 0, 0, 0, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    0, 10, 0, 0, 0, 0, 4, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    138, 10, 10, 10, 10, 0, 0, 0,
    0, 0, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
};

static const Q_UINT8 dir_22[] = {
    10, 138, 138, 138, 138, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 138, 4, 4, 10, 138, 138, 10,
    10, 10, 138, 138, 138, 138, 10, 138,
    138, 138, 138, 10, 138, 10, 138, 10,
    10, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 138, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 10,
    10, 10, 138, 138, 138, 138, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 138,
    138, 10, 138, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 138,
    138, 138, 138, 10, 10, 10, 10, 10,
    138, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 10, 10, 10, 10, 10, 138, 138,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 10, 10, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
};

static const Q_UINT8 dir_23[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_24[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
};

static const Q_UINT8 dir_25[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
};

static const Q_UINT8 dir_26[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_27[] = {
    0, 10, 10, 10, 10, 0, 10, 10,
    10, 10, 0, 0, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    10, 10, 10, 0, 0, 0, 10, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 138, 138, 10,
    10, 10, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
};

static const Q_UINT8 dir_29[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 138, 10, 10, 10, 10, 138, 138,
    138, 138, 138, 10, 138, 138, 10, 10,
    138, 138, 138, 138, 138, 10, 10, 10,
    10, 138, 10, 138, 138, 138, 10, 10,
    138, 138, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 138, 138, 138, 138,
    138, 138, 10, 10, 138, 138, 10, 10,
};

static const Q_UINT8 dir_2A[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 138, 138,
    138, 138, 10, 10, 138, 10, 138, 10,
    10, 138, 10, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 138, 10, 10,
    10, 10, 10, 10, 138, 138, 138, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 138,
    138, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 138, 138, 10, 10,
    10, 10, 138, 138, 138, 138, 10, 138,
    138, 10, 10, 138, 138, 10, 10, 10,
    10, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 10, 138, 10,
    10, 10, 138, 138, 138, 138, 138, 10,
    10, 10, 10, 10, 138, 138, 138, 10,
    10, 10, 10, 138, 10, 10, 10, 138,
    138, 138, 138, 138, 10, 138, 10, 10,
};

static const Q_UINT8 dir_2E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_2F[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
};

static const Q_UINT8 dir_30[] = {
    9, 10, 10, 10, 10, 0, 0, 0,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 10, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 17, 17, 17,
    10, 0, 0, 0, 0, 0, 10, 10,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 10, 10, 0, 0, 0,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 0, 0, 0, 0,
};

static const Q_UINT8 dir_32[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_A4[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_FB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 17, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 4, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
};

static const Q_UINT8 dir_FC[] = {
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
};

static const Q_UINT8 dir_FD[] = {
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    0, 0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 0, 0, 0,
};

static const Q_UINT8 dir_FE[] = {
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    6, 10, 6, 0, 10, 6, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 4,
    10, 10, 4, 4, 10, 10, 10, 0,
    10, 4, 4, 10, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 0, 0, 18,
};

static const Q_UINT8 dir_FF[] = {
    0, 10, 10, 4, 4, 4, 10, 10,
    138, 138, 10, 4, 6, 4, 6, 3,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 138, 10, 138, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 138,
    138, 10, 138, 138, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 10, 10, 10, 4, 4, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 18, 18, 18, 10, 10, 0, 0,
};

static const Q_UINT8 * const direction_info[256] = {
    dir_00, dir_01, dir_02, dir_03, dir_04, dir_05, dir_06, dir_07,
    dir_01, dir_09, dir_0A, dir_0B, dir_0C, dir_0D, dir_0E, dir_0F,
    dir_10, dir_01, dir_01, dir_01, dir_01, dir_01, dir_16, dir_17,
    dir_18, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_1F,
    dir_20, dir_21, dir_22, dir_23, dir_24, dir_25, dir_26, dir_27,
    dir_25, dir_29, dir_2A, dir_01, dir_01, dir_01, dir_2E, dir_2F,
    dir_30, dir_01, dir_32, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_A4, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_FB, dir_FC, dir_FD, dir_FE, dir_FF,
};
// 26362 bytes

static const Q_UINT8 cmb_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_03[] = {
    230, 230, 230, 230, 230, 230, 230, 230,
    230, 230, 230, 230, 230, 230, 230, 230,
    230, 230, 230, 230, 230, 232, 220, 220,
    220, 220, 232, 216, 220, 220, 220, 220,
    220, 202, 202, 220, 220, 220, 220, 202,
    202, 220, 220, 220, 220, 220, 220, 220,
    220, 220, 220, 220, 1, 1, 1, 1,
    1, 220, 220, 220, 220, 230, 230, 230,
    230, 230, 230, 230, 230, 240, 230, 220,
    220, 220, 230, 230, 230, 220, 220, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    234, 234, 233, 230, 230, 230, 230, 230,
    230, 230, 230, 230, 230, 230, 230, 230,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_04[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 230, 230, 230, 230, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 220, 230, 230, 230, 230, 220, 230,
    230, 230, 222, 220, 230, 230, 230, 230,
    230, 230, 0, 220, 220, 220, 220, 220,
    230, 230, 220, 230, 230, 222, 228, 230,
    10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 0, 20, 21, 22, 0, 23,
    0, 24, 25, 0, 230, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 27, 28, 29, 30, 31,
    32, 33, 34, 230, 230, 220, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    35, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 230, 230,
    230, 230, 230, 230, 230, 0, 0, 230,
    230, 230, 230, 220, 230, 0, 0, 230,
    230, 0, 220, 230, 230, 220, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_07[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 36, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    230, 220, 230, 230, 220, 230, 230, 220,
    220, 220, 230, 220, 220, 230, 220, 230,
    230, 230, 220, 230, 220, 230, 220, 230,
    220, 230, 230, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_09[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 230, 220, 230, 230, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_0A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_0B[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 84, 91, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_0E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    103, 103, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    107, 107, 107, 107, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    118, 118, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    122, 122, 122, 122, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    220, 220, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 220, 0, 220,
    0, 216, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 129, 130, 0, 132, 0, 0, 0,
    0, 0, 130, 130, 130, 130, 0, 0,
    130, 0, 230, 230, 9, 0, 230, 230,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 220, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 9, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_17[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_18[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 228, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_20[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    230, 230, 1, 1, 230, 230, 230, 230,
    1, 1, 1, 230, 230, 0, 0, 0,
    0, 230, 0, 0, 0, 1, 1, 230,
    220, 230, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_30[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 218, 228, 232, 222, 224, 224,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_FB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 cmb_FE[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    230, 230, 230, 230, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 * const combining_info[256] = {
    cmb_00, cmb_00, cmb_00, cmb_03, cmb_04, cmb_05, cmb_06, cmb_07,
    cmb_00, cmb_09, cmb_0A, cmb_0B, cmb_0C, cmb_0D, cmb_0E, cmb_0F,
    cmb_10, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_17,
    cmb_18, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_20, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_30, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00, cmb_00,
    cmb_00, cmb_00, cmb_00, cmb_FB, cmb_00, cmb_00, cmb_FE, cmb_00,
};
// 32506 bytes

static const Q_UINT16 case_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0, 0, 0, 0, 0,
    0, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x39c, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0,
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0,
    0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0x178,
};

static const Q_UINT16 case_01[] = {
    0x101, 0x100, 0x103, 0x102, 0x105, 0x104, 0x107, 0x106,
    0x109, 0x108, 0x10b, 0x10a, 0x10d, 0x10c, 0x10f, 0x10e,
    0x111, 0x110, 0x113, 0x112, 0x115, 0x114, 0x117, 0x116,
    0x119, 0x118, 0x11b, 0x11a, 0x11d, 0x11c, 0x11f, 0x11e,
    0x121, 0x120, 0x123, 0x122, 0x125, 0x124, 0x127, 0x126,
    0x129, 0x128, 0x12b, 0x12a, 0x12d, 0x12c, 0x12f, 0x12e,
    0x69, 0x49, 0x133, 0x132, 0x135, 0x134, 0x137, 0x136,
    0, 0x13a, 0x139, 0x13c, 0x13b, 0x13e, 0x13d, 0x140,
    0x13f, 0x142, 0x141, 0x144, 0x143, 0x146, 0x145, 0x148,
    0x147, 0, 0x14b, 0x14a, 0x14d, 0x14c, 0x14f, 0x14e,
    0x151, 0x150, 0x153, 0x152, 0x155, 0x154, 0x157, 0x156,
    0x159, 0x158, 0x15b, 0x15a, 0x15d, 0x15c, 0x15f, 0x15e,
    0x161, 0x160, 0x163, 0x162, 0x165, 0x164, 0x167, 0x166,
    0x169, 0x168, 0x16b, 0x16a, 0x16d, 0x16c, 0x16f, 0x16e,
    0x171, 0x170, 0x173, 0x172, 0x175, 0x174, 0x177, 0x176,
    0xff, 0x17a, 0x179, 0x17c, 0x17b, 0x17e, 0x17d, 0x53,
    0, 0x253, 0x183, 0x182, 0x185, 0x184, 0x254, 0x188,
    0x187, 0x256, 0x257, 0x18c, 0x18b, 0, 0x1dd, 0x259,
    0x25b, 0x192, 0x191, 0x260, 0x263, 0x1f6, 0x269, 0x268,
    0x199, 0x198, 0, 0, 0x26f, 0x272, 0x220, 0x275,
    0x1a1, 0x1a0, 0x1a3, 0x1a2, 0x1a5, 0x1a4, 0x280, 0x1a8,
    0x1a7, 0x283, 0, 0, 0x1ad, 0x1ac, 0x288, 0x1b0,
    0x1af, 0x28a, 0x28b, 0x1b4, 0x1b3, 0x1b6, 0x1b5, 0x292,
    0x1b9, 0x1b8, 0, 0, 0x1bd, 0x1bc, 0, 0x1f7,
    0, 0, 0, 0, 0x1c6, 0x1c4, 0x1c4, 0x1c9,
    0x1c7, 0x1c7, 0x1cc, 0x1ca, 0x1ca, 0x1ce, 0x1cd, 0x1d0,
    0x1cf, 0x1d2, 0x1d1, 0x1d4, 0x1d3, 0x1d6, 0x1d5, 0x1d8,
    0x1d7, 0x1da, 0x1d9, 0x1dc, 0x1db, 0x18e, 0x1df, 0x1de,
    0x1e1, 0x1e0, 0x1e3, 0x1e2, 0x1e5, 0x1e4, 0x1e7, 0x1e6,
    0x1e9, 0x1e8, 0x1eb, 0x1ea, 0x1ed, 0x1ec, 0x1ef, 0x1ee,
    0, 0x1f3, 0x1f1, 0x1f1, 0x1f5, 0x1f4, 0x195, 0x1bf,
    0x1f9, 0x1f8, 0x1fb, 0x1fa, 0x1fd, 0x1fc, 0x1ff, 0x1fe,
};

static const Q_UINT16 case_02[] = {
    0x201, 0x200, 0x203, 0x202, 0x205, 0x204, 0x207, 0x206,
    0x209, 0x208, 0x20b, 0x20a, 0x20d, 0x20c, 0x20f, 0x20e,
    0x211, 0x210, 0x213, 0x212, 0x215, 0x214, 0x217, 0x216,
    0x219, 0x218, 0x21b, 0x21a, 0x21d, 0x21c, 0x21f, 0x21e,
    0x19e, 0, 0x223, 0x222, 0x225, 0x224, 0x227, 0x226,
    0x229, 0x228, 0x22b, 0x22a, 0x22d, 0x22c, 0x22f, 0x22e,
    0x231, 0x230, 0x233, 0x232, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x181, 0x186, 0, 0x189, 0x18a,
    0, 0x18f, 0, 0x190, 0, 0, 0, 0,
    0x193, 0, 0, 0x194, 0, 0, 0, 0,
    0x197, 0x196, 0, 0, 0, 0, 0, 0x19c,
    0, 0, 0x19d, 0, 0, 0x19f, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x1a6, 0, 0, 0x1a9, 0, 0, 0, 0,
    0x1ae, 0, 0x1b1, 0x1b2, 0, 0, 0, 0,
    0, 0, 0x1b7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_03[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x399, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x3ac, 0,
    0x3ad, 0x3ae, 0x3af, 0, 0x3cc, 0, 0x3cd, 0x3ce,
    0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
    0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
    0x3c0, 0x3c1, 0, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
    0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x386, 0x388, 0x389, 0x38a,
    0, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
    0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
    0x3a0, 0x3a1, 0x3a3, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
    0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x38c, 0x38e, 0x38f, 0,
    0x392, 0x398, 0, 0, 0, 0x3a6, 0x3a0, 0,
    0x3d9, 0x3d8, 0x3db, 0x3da, 0x3dd, 0x3dc, 0x3df, 0x3de,
    0x3e1, 0x3e0, 0x3e3, 0x3e2, 0x3e5, 0x3e4, 0x3e7, 0x3e6,
    0x3e9, 0x3e8, 0x3eb, 0x3ea, 0x3ed, 0x3ec, 0x3ef, 0x3ee,
    0x39a, 0x3a1, 0x3a3, 0, 0x3b8, 0x395, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_04[] = {
    0x450, 0x451, 0x452, 0x453, 0x454, 0x455, 0x456, 0x457,
    0x458, 0x459, 0x45a, 0x45b, 0x45c, 0x45d, 0x45e, 0x45f,
    0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
    0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
    0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
    0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
    0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
    0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
    0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
    0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
    0x400, 0x401, 0x402, 0x403, 0x404, 0x405, 0x406, 0x407,
    0x408, 0x409, 0x40a, 0x40b, 0x40c, 0x40d, 0x40e, 0x40f,
    0x461, 0x460, 0x463, 0x462, 0x465, 0x464, 0x467, 0x466,
    0x469, 0x468, 0x46b, 0x46a, 0x46d, 0x46c, 0x46f, 0x46e,
    0x471, 0x470, 0x473, 0x472, 0x475, 0x474, 0x477, 0x476,
    0x479, 0x478, 0x47b, 0x47a, 0x47d, 0x47c, 0x47f, 0x47e,
    0x481, 0x480, 0, 0, 0, 0, 0, 0,
    0, 0, 0x48b, 0x48a, 0x48d, 0x48c, 0x48f, 0x48e,
    0x491, 0x490, 0x493, 0x492, 0x495, 0x494, 0x497, 0x496,
    0x499, 0x498, 0x49b, 0x49a, 0x49d, 0x49c, 0x49f, 0x49e,
    0x4a1, 0x4a0, 0x4a3, 0x4a2, 0x4a5, 0x4a4, 0x4a7, 0x4a6,
    0x4a9, 0x4a8, 0x4ab, 0x4aa, 0x4ad, 0x4ac, 0x4af, 0x4ae,
    0x4b1, 0x4b0, 0x4b3, 0x4b2, 0x4b5, 0x4b4, 0x4b7, 0x4b6,
    0x4b9, 0x4b8, 0x4bb, 0x4ba, 0x4bd, 0x4bc, 0x4bf, 0x4be,
    0, 0x4c2, 0x4c1, 0x4c4, 0x4c3, 0x4c6, 0x4c5, 0x4c8,
    0x4c7, 0x4ca, 0x4c9, 0x4cc, 0x4cb, 0x4ce, 0x4cd, 0,
    0x4d1, 0x4d0, 0x4d3, 0x4d2, 0x4d5, 0x4d4, 0x4d7, 0x4d6,
    0x4d9, 0x4d8, 0x4db, 0x4da, 0x4dd, 0x4dc, 0x4df, 0x4de,
    0x4e1, 0x4e0, 0x4e3, 0x4e2, 0x4e5, 0x4e4, 0x4e7, 0x4e6,
    0x4e9, 0x4e8, 0x4eb, 0x4ea, 0x4ed, 0x4ec, 0x4ef, 0x4ee,
    0x4f1, 0x4f0, 0x4f3, 0x4f2, 0x4f5, 0x4f4, 0, 0,
    0x4f9, 0x4f8, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_05[] = {
    0x501, 0x500, 0x503, 0x502, 0x505, 0x504, 0x507, 0x506,
    0x509, 0x508, 0x50b, 0x50a, 0x50d, 0x50c, 0x50f, 0x50e,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x561, 0x562, 0x563, 0x564, 0x565, 0x566, 0x567,
    0x568, 0x569, 0x56a, 0x56b, 0x56c, 0x56d, 0x56e, 0x56f,
    0x570, 0x571, 0x572, 0x573, 0x574, 0x575, 0x576, 0x577,
    0x578, 0x579, 0x57a, 0x57b, 0x57c, 0x57d, 0x57e, 0x57f,
    0x580, 0x581, 0x582, 0x583, 0x584, 0x585, 0x586, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x531, 0x532, 0x533, 0x534, 0x535, 0x536, 0x537,
    0x538, 0x539, 0x53a, 0x53b, 0x53c, 0x53d, 0x53e, 0x53f,
    0x540, 0x541, 0x542, 0x543, 0x544, 0x545, 0x546, 0x547,
    0x548, 0x549, 0x54a, 0x54b, 0x54c, 0x54d, 0x54e, 0x54f,
    0x550, 0x551, 0x552, 0x553, 0x554, 0x555, 0x556, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_1E[] = {
    0x1e01, 0x1e00, 0x1e03, 0x1e02, 0x1e05, 0x1e04, 0x1e07, 0x1e06,
    0x1e09, 0x1e08, 0x1e0b, 0x1e0a, 0x1e0d, 0x1e0c, 0x1e0f, 0x1e0e,
    0x1e11, 0x1e10, 0x1e13, 0x1e12, 0x1e15, 0x1e14, 0x1e17, 0x1e16,
    0x1e19, 0x1e18, 0x1e1b, 0x1e1a, 0x1e1d, 0x1e1c, 0x1e1f, 0x1e1e,
    0x1e21, 0x1e20, 0x1e23, 0x1e22, 0x1e25, 0x1e24, 0x1e27, 0x1e26,
    0x1e29, 0x1e28, 0x1e2b, 0x1e2a, 0x1e2d, 0x1e2c, 0x1e2f, 0x1e2e,
    0x1e31, 0x1e30, 0x1e33, 0x1e32, 0x1e35, 0x1e34, 0x1e37, 0x1e36,
    0x1e39, 0x1e38, 0x1e3b, 0x1e3a, 0x1e3d, 0x1e3c, 0x1e3f, 0x1e3e,
    0x1e41, 0x1e40, 0x1e43, 0x1e42, 0x1e45, 0x1e44, 0x1e47, 0x1e46,
    0x1e49, 0x1e48, 0x1e4b, 0x1e4a, 0x1e4d, 0x1e4c, 0x1e4f, 0x1e4e,
    0x1e51, 0x1e50, 0x1e53, 0x1e52, 0x1e55, 0x1e54, 0x1e57, 0x1e56,
    0x1e59, 0x1e58, 0x1e5b, 0x1e5a, 0x1e5d, 0x1e5c, 0x1e5f, 0x1e5e,
    0x1e61, 0x1e60, 0x1e63, 0x1e62, 0x1e65, 0x1e64, 0x1e67, 0x1e66,
    0x1e69, 0x1e68, 0x1e6b, 0x1e6a, 0x1e6d, 0x1e6c, 0x1e6f, 0x1e6e,
    0x1e71, 0x1e70, 0x1e73, 0x1e72, 0x1e75, 0x1e74, 0x1e77, 0x1e76,
    0x1e79, 0x1e78, 0x1e7b, 0x1e7a, 0x1e7d, 0x1e7c, 0x1e7f, 0x1e7e,
    0x1e81, 0x1e80, 0x1e83, 0x1e82, 0x1e85, 0x1e84, 0x1e87, 0x1e86,
    0x1e89, 0x1e88, 0x1e8b, 0x1e8a, 0x1e8d, 0x1e8c, 0x1e8f, 0x1e8e,
    0x1e91, 0x1e90, 0x1e93, 0x1e92, 0x1e95, 0x1e94, 0, 0,
    0, 0, 0, 0x1e60, 0, 0, 0, 0,
    0x1ea1, 0x1ea0, 0x1ea3, 0x1ea2, 0x1ea5, 0x1ea4, 0x1ea7, 0x1ea6,
    0x1ea9, 0x1ea8, 0x1eab, 0x1eaa, 0x1ead, 0x1eac, 0x1eaf, 0x1eae,
    0x1eb1, 0x1eb0, 0x1eb3, 0x1eb2, 0x1eb5, 0x1eb4, 0x1eb7, 0x1eb6,
    0x1eb9, 0x1eb8, 0x1ebb, 0x1eba, 0x1ebd, 0x1ebc, 0x1ebf, 0x1ebe,
    0x1ec1, 0x1ec0, 0x1ec3, 0x1ec2, 0x1ec5, 0x1ec4, 0x1ec7, 0x1ec6,
    0x1ec9, 0x1ec8, 0x1ecb, 0x1eca, 0x1ecd, 0x1ecc, 0x1ecf, 0x1ece,
    0x1ed1, 0x1ed0, 0x1ed3, 0x1ed2, 0x1ed5, 0x1ed4, 0x1ed7, 0x1ed6,
    0x1ed9, 0x1ed8, 0x1edb, 0x1eda, 0x1edd, 0x1edc, 0x1edf, 0x1ede,
    0x1ee1, 0x1ee0, 0x1ee3, 0x1ee2, 0x1ee5, 0x1ee4, 0x1ee7, 0x1ee6,
    0x1ee9, 0x1ee8, 0x1eeb, 0x1eea, 0x1eed, 0x1eec, 0x1eef, 0x1eee,
    0x1ef1, 0x1ef0, 0x1ef3, 0x1ef2, 0x1ef5, 0x1ef4, 0x1ef7, 0x1ef6,
    0x1ef9, 0x1ef8, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_1F[] = {
    0x1f08, 0x1f09, 0x1f0a, 0x1f0b, 0x1f0c, 0x1f0d, 0x1f0e, 0x1f0f,
    0x1f00, 0x1f01, 0x1f02, 0x1f03, 0x1f04, 0x1f05, 0x1f06, 0x1f07,
    0x1f18, 0x1f19, 0x1f1a, 0x1f1b, 0x1f1c, 0x1f1d, 0, 0,
    0x1f10, 0x1f11, 0x1f12, 0x1f13, 0x1f14, 0x1f15, 0, 0,
    0x1f28, 0x1f29, 0x1f2a, 0x1f2b, 0x1f2c, 0x1f2d, 0x1f2e, 0x1f2f,
    0x1f20, 0x1f21, 0x1f22, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x1f27,
    0x1f38, 0x1f39, 0x1f3a, 0x1f3b, 0x1f3c, 0x1f3d, 0x1f3e, 0x1f3f,
    0x1f30, 0x1f31, 0x1f32, 0x1f33, 0x1f34, 0x1f35, 0x1f36, 0x1f37,
    0x1f48, 0x1f49, 0x1f4a, 0x1f4b, 0x1f4c, 0x1f4d, 0, 0,
    0x1f40, 0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0, 0,
    0, 0x1f59, 0, 0x1f5b, 0, 0x1f5d, 0, 0x1f5f,
    0, 0x1f51, 0, 0x1f53, 0, 0x1f55, 0, 0x1f57,
    0x1f68, 0x1f69, 0x1f6a, 0x1f6b, 0x1f6c, 0x1f6d, 0x1f6e, 0x1f6f,
    0x1f60, 0x1f61, 0x1f62, 0x1f63, 0x1f64, 0x1f65, 0x1f66, 0x1f67,
    0x1fba, 0x1fbb, 0x1fc8, 0x1fc9, 0x1fca, 0x1fcb, 0x1fda, 0x1fdb,
    0x1ff8, 0x1ff9, 0x1fea, 0x1feb, 0x1ffa, 0x1ffb, 0, 0,
    0x1f88, 0x1f89, 0x1f8a, 0x1f8b, 0x1f8c, 0x1f8d, 0x1f8e, 0x1f8f,
    0x1f80, 0x1f81, 0x1f82, 0x1f83, 0x1f84, 0x1f85, 0x1f86, 0x1f87,
    0x1f98, 0x1f99, 0x1f9a, 0x1f9b, 0x1f9c, 0x1f9d, 0x1f9e, 0x1f9f,
    0x1f90, 0x1f91, 0x1f92, 0x1f93, 0x1f94, 0x1f95, 0x1f96, 0x1f97,
    0x1fa8, 0x1fa9, 0x1faa, 0x1fab, 0x1fac, 0x1fad, 0x1fae, 0x1faf,
    0x1fa0, 0x1fa1, 0x1fa2, 0x1fa3, 0x1fa4, 0x1fa5, 0x1fa6, 0x1fa7,
    0x1fb8, 0x1fb9, 0, 0x1fbc, 0, 0, 0, 0,
    0x1fb0, 0x1fb1, 0x1f70, 0x1f71, 0x1fb3, 0, 0x399, 0,
    0, 0, 0, 0x1fcc, 0, 0, 0, 0,
    0x1f72, 0x1f73, 0x1f74, 0x1f75, 0x1fc3, 0, 0, 0,
    0x1fd8, 0x1fd9, 0, 0, 0, 0, 0, 0,
    0x1fd0, 0x1fd1, 0x1f76, 0x1f77, 0, 0, 0, 0,
    0x1fe8, 0x1fe9, 0, 0, 0, 0x1fec, 0, 0,
    0x1fe0, 0x1fe1, 0x1f7a, 0x1f7b, 0x1fe5, 0, 0, 0,
    0, 0, 0, 0x1ffc, 0, 0, 0, 0,
    0x1f78, 0x1f79, 0x1f7c, 0x1f7d, 0x1ff3, 0, 0, 0,
};

static const Q_UINT16 case_21[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x3c9, 0,
    0, 0, 0x6b, 0xe5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
    0x2178, 0x2179, 0x217a, 0x217b, 0x217c, 0x217d, 0x217e, 0x217f,
    0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167,
    0x2168, 0x2169, 0x216a, 0x216b, 0x216c, 0x216d, 0x216e, 0x216f,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_24[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x24d0, 0x24d1,
    0x24d2, 0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7, 0x24d8, 0x24d9,
    0x24da, 0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df, 0x24e0, 0x24e1,
    0x24e2, 0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7, 0x24e8, 0x24e9,
    0x24b6, 0x24b7, 0x24b8, 0x24b9, 0x24ba, 0x24bb, 0x24bc, 0x24bd,
    0x24be, 0x24bf, 0x24c0, 0x24c1, 0x24c2, 0x24c3, 0x24c4, 0x24c5,
    0x24c6, 0x24c7, 0x24c8, 0x24c9, 0x24ca, 0x24cb, 0x24cc, 0x24cd,
    0x24ce, 0x24cf, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_FF[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47,
    0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
    0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57,
    0xff58, 0xff59, 0xff5a, 0, 0, 0, 0, 0,
    0, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27,
    0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f,
    0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37,
    0xff38, 0xff39, 0xff3a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 * const case_info[256] = {
    case_00, case_01, case_02, case_03, case_04, case_05, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, case_1E, case_1F,
    0, case_21, 0, 0, case_24, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, case_FF,
};
// 39162 bytes

static const Q_INT8 num_00[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 2, 3, -1, -1, -1, -1,
    -1, 1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_06[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_09[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_0B[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_0D[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_0E[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_0F[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_10[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_13[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_17[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_18[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_20[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, -1, -1, -1, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_24[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, 1, 2, 3,
    4, 5, 6, 7, 8, 9, -1, -1,
};

static const Q_INT8 num_27[] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 1, 2,
    3, 4, 5, 6, 7, 8, 9, -1,
    1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 * const decimal_info[256] = {
    num_00, 0, 0, 0, 0, 0, num_06, 0,
    0, num_09, num_09, num_0B, num_09, num_0D, num_0E, num_0F,
    num_10, 0, 0, num_13, 0, 0, 0, num_17,
    num_18, 0, 0, 0, 0, 0, 0, 0,
    num_20, 0, 0, 0, num_24, 0, 0, num_27,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, num_18,
};
// 47354 bytes

// END OF GENERATED DATA

#endif

static inline QChar::Category category( const QChar &c )
{
#ifndef QT_NO_UNICODETABLES
    return (QChar::Category)(unicode_info[c.row()][c.cell()]);
#else
// ### just ASCII
    if ( c.unicode() < 0x100 ) {
	return (QChar::Category)(ui_00[c.unicode()]);
    }
    return QChar::Letter_Uppercase; //#######
#endif
}

static inline QChar lower( const QChar &c )
{
#ifndef QT_NO_UNICODETABLES
    uchar row = c.row();
    uchar cell = c.cell();
    if ( unicode_info[row][cell] != QChar::Letter_Uppercase )
	return c;
    Q_UINT16 lower = *( case_info[row] + cell );
    if ( lower == 0 )
	return c;
    return lower;
#else
    if ( c.row() )
	return c;
    else
	return QChar( tolower((uchar) c.latin1()) );
#endif
}

static inline QChar upper( const QChar &c )
{
#ifndef QT_NO_UNICODETABLES
    uchar row = c.row();
    uchar cell = c.cell();
    if ( unicode_info[row][cell] != QChar::Letter_Lowercase )
	return c;
    Q_UINT16 upper = *(case_info[row]+cell);
    if ( upper == 0 )
	return c;
    return upper;
#else
    if ( c.row() )
	return c;
    else
	return QChar( toupper((uchar) c.latin1()) );
#endif
}

static inline QChar::Direction direction( const QChar &c )
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT8 *rowp = direction_info[c.row()];
    if(!rowp) return QChar::DirL;
    return (QChar::Direction) ( *(rowp+c.cell()) & 0x1f );
#else
    return QChar::DirL;
#endif
}

static inline bool mirrored( const QChar &c )
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT8 *rowp = direction_info[c.row()];
    if ( !rowp )
	return FALSE;
    return *(rowp+c.cell())>128;
#else
    return FALSE;
#endif
}

#ifndef QT_NO_UNICODETABLES
static const Q_UINT16 symmetricPairs[] = {
    0x0028, 0x0029, 0x003C, 0x003E, 0x005B, 0x005D, 0x007B, 0x007D,
    0x00AB, 0x00BB, 0x2039, 0x203A, 0x2045, 0x2046, 0x207D, 0x207E,
    0x208D, 0x208E, 0x2208, 0x220B, 0x2209, 0x220C, 0x220A, 0x220D,
    0x2215, 0x29F5, 0x223C, 0x223D, 0x2243, 0x22CD, 0x2252, 0x2253,
    0x2254, 0x2255, 0x2264, 0x2265, 0x2266, 0x2267, 0x2268, 0x2269,
    0x226A, 0x226B, 0x226E, 0x226F, 0x2270, 0x2271, 0x2272, 0x2273,
    0x2274, 0x2275, 0x2276, 0x2277, 0x2278, 0x2279, 0x227A, 0x227B,
    0x227C, 0x227D, 0x227E, 0x227F, 0x2280, 0x2281, 0x2282, 0x2283,
    0x2284, 0x2285, 0x2286, 0x2287, 0x2288, 0x2289, 0x228A, 0x228B,
    0x228F, 0x2290, 0x2291, 0x2292, 0x2298, 0x29B8, 0x22A2, 0x22A3,
    0x22A6, 0x2ADE, 0x22A8, 0x2AE4, 0x22A9, 0x2AE3, 0x22AB, 0x2AE5,
    0x22B0, 0x22B1, 0x22B2, 0x22B3, 0x22B4, 0x22B5, 0x22B6, 0x22B7,
    0x22C9, 0x22CA, 0x22CB, 0x22CC, 0x22D0, 0x22D1, 0x22D6, 0x22D7,
    0x22D8, 0x22D9, 0x22DA, 0x22DB, 0x22DC, 0x22DD, 0x22DE, 0x22DF,
    0x22E0, 0x22E1, 0x22E2, 0x22E3, 0x22E4, 0x22E5, 0x22E6, 0x22E7,
    0x22E8, 0x22E9, 0x22EA, 0x22EB, 0x22EC, 0x22ED, 0x22F0, 0x22F1,
    0x22F2, 0x22FA, 0x22F3, 0x22FB, 0x22F4, 0x22FC, 0x22F6, 0x22FD,
    0x22F7, 0x22FE, 0x2308, 0x2309, 0x230A, 0x230B, 0x2329, 0x232A,
    0x2768, 0x2769, 0x276A, 0x276B, 0x276C, 0x276D, 0x276E, 0x276F,
    0x2770, 0x2771, 0x2772, 0x2773, 0x2774, 0x2775, 0x27D5, 0x27D6,
    0x27DD, 0x27DE, 0x27E2, 0x27E3, 0x27E4, 0x27E5, 0x27E6, 0x27E7,
    0x27E8, 0x27E9, 0x27EA, 0x27EB, 0x2983, 0x2984, 0x2985, 0x2986,
    0x2987, 0x2988, 0x2989, 0x298A, 0x298B, 0x298C, 0x298D, 0x2990,
    0x298E, 0x298F, 0x2991, 0x2992, 0x2993, 0x2994, 0x2995, 0x2996,
    0x2997, 0x2998, 0x29C0, 0x29C1, 0x29C4, 0x29C5, 0x29CF, 0x29D0,
    0x29D1, 0x29D2, 0x29D4, 0x29D5, 0x29D8, 0x29D9, 0x29DA, 0x29DB,
    0x29F8, 0x29F9, 0x29FC, 0x29FD, 0x2A2B, 0x2A2C, 0x2A34, 0x2A35,
    0x2A3C, 0x2A3D, 0x2A64, 0x2A65, 0x2A79, 0x2A7A, 0x2A7D, 0x2A7E,
    0x2A7F, 0x2A80, 0x2A81, 0x2A82, 0x2A83, 0x2A84, 0x2A8B, 0x2A8C,
    0x2A91, 0x2A92, 0x2A93, 0x2A94, 0x2A95, 0x2A96, 0x2A97, 0x2A98,
    0x2A99, 0x2A9A, 0x2A9B, 0x2A9C, 0x2AA1, 0x2AA2, 0x2AA6, 0x2AA7,
    0x2AA8, 0x2AA9, 0x2AAA, 0x2AAB, 0x2AAC, 0x2AAD, 0x2AAF, 0x2AB0,
    0x2AB3, 0x2AB4, 0x2ABB, 0x2ABC, 0x2ABD, 0x2ABE, 0x2ABF, 0x2AC0,
    0x2AC1, 0x2AC2, 0x2AC3, 0x2AC4, 0x2AC5, 0x2AC6, 0x2ACD, 0x2ACE,
    0x2ACF, 0x2AD0, 0x2AD1, 0x2AD2, 0x2AD3, 0x2AD4, 0x2AD5, 0x2AD6,
    0x2AEC, 0x2AED, 0x2AF7, 0x2AF8, 0x2AF9, 0x2AFA, 0x3008, 0x3009,
    0x300A, 0x300B, 0x300C, 0x300D, 0x300E, 0x300F, 0x3010, 0x3011,
    0x3014, 0x3015, 0x3016, 0x3017, 0x3018, 0x3019, 0x301A, 0x301B,
    0xFF08, 0xFF09, 0xFF1C, 0xFF1E, 0xFF3B, 0xFF3D, 0xFF5B, 0xFF5D,
    0xFF5F, 0xFF60, 0xFF62, 0xFF63,
};

// ### shouldn't this be const?
static const int symmetricPairsSize =
   sizeof(symmetricPairs)/sizeof(symmetricPairs[0]);

/*
 * ----------------------------------------------------------------------
 * End of unicode tables
 * ----------------------------------------------------------------------
 */

#endif

static int ucstrcmp( const QString &as, const QString &bs )
{
    const QChar *a = as.unicode();
    const QChar *b = bs.unicode();
    if ( a == b )
	return 0;
    if ( a == 0 )
	return 1;
    if ( b == 0 )
	return -1;
    int l=QMIN(as.length(),bs.length());
    while ( l-- && *a == *b )
	a++,b++;
    if ( l==-1 )
	return ( as.length()-bs.length() );
    return a->unicode() - b->unicode();
}

static int ucstrncmp( const QChar *a, const QChar *b, int l )
{
    while ( l-- && *a == *b )
	a++,b++;
    if ( l==-1 )
	return 0;
    return a->unicode() - b->unicode();
}

static int ucstrnicmp( const QChar *a, const QChar *b, int l )
{
    while ( l-- && ::lower( *a ) == ::lower( *b ) )
	a++,b++;
    if ( l==-1 )
	return 0;
    return ::lower( *a ).unicode() - ::lower( *b ).unicode();
}

static uint computeNewMax( uint len )
{
    uint newMax = 4;
    while ( newMax < len )
	newMax *= 2;
    // try to save some memory
    if ( newMax >= 1024 * 1024 && len <= newMax - (newMax >> 2) )
	newMax -= newMax >> 2;
    return newMax;
}

/*!
    \class QCharRef qstring.h
    \reentrant
    \brief The QCharRef class is a helper class for QString.

    \ingroup text

    When you get an object of type QCharRef, if you can assign to it,
    the assignment will apply to the character in the string from
    which you got the reference. That is its whole purpose in life.
    The QCharRef becomes invalid once modifications are made to the
    string: if you want to keep the character, copy it into a QChar.

    Most of the QChar member functions also exist in QCharRef.
    However, they are not explicitly documented here.

    \sa QString::operator[]() QString::at() QChar
*/

/*!
    \class QChar qstring.h
    \reentrant
    \brief The QChar class provides a lightweight Unicode character.

    \ingroup text

    Unicode characters are (so far) 16-bit entities without any markup
    or structure. This class represents such an entity. It is
    lightweight, so it can be used everywhere. Most compilers treat it
    like a "short int".  (In a few years it may be necessary to make
    QChar 32-bit when more than 65536 Unicode code points have been
    defined and come into use.)

    QChar provides a full complement of testing/classification
    functions, converting to and from other formats, converting from
    composed to decomposed Unicode, and trying to compare and
    case-convert if you ask it to.

    The classification functions include functions like those in
    ctype.h, but operating on the full range of Unicode characters.
    They all return TRUE if the character is a certain type of
    character; otherwise they return FALSE. These classification
    functions are isNull() (returns TRUE if the character is U+0000),
    isPrint() (TRUE if the character is any sort of printable
    character, including whitespace), isPunct() (any sort of
    punctation), isMark() (Unicode Mark), isLetter (a letter),
    isNumber() (any sort of numeric character), isLetterOrNumber(),
    and isDigit() (decimal digits). All of these are wrappers around
    category() which return the Unicode-defined category of each
    character.

    QChar further provides direction(), which indicates the "natural"
    writing direction of this character. The joining() function
    indicates how the character joins with its neighbors (needed
    mostly for Arabic) and finally mirrored(), which indicates whether
    the character needs to be mirrored when it is printed in its
    "unnatural" writing direction.

    Composed Unicode characters (like &aring;) can be converted to
    decomposed Unicode ("a" followed by "ring above") by using
    decomposition().

    In Unicode, comparison is not necessarily possible and case
    conversion is very difficult at best. Unicode, covering the
    "entire" world, also includes most of the world's case and sorting
    problems. Qt tries, but not very hard: operator==() and friends
    will do comparison based purely on the numeric Unicode value (code
    point) of the characters, and upper() and lower() will do case
    changes when the character has a well-defined upper/lower-case
    equivalent. There is no provision for locale-dependent case
    folding rules or comparison; these functions are meant to be fast
    so they can be used unambiguously in data structures. (See
    QString::localeAwareCompare() though.)

    The conversion functions include unicode() (to a scalar), latin1()
    (to scalar, but converts all non-Latin1 characters to 0), row()
    (gives the Unicode row), cell() (gives the Unicode cell),
    digitValue() (gives the integer value of any of the numerous digit
    characters), and a host of constructors.

    More information can be found in the document \link unicode.html
    About Unicode. \endlink

    \sa QString QCharRef
*/

/*!
    \enum QChar::Category

    This enum maps the Unicode character categories.

    The following characters are normative in Unicode:

    \value Mark_NonSpacing  Unicode class name Mn

    \value Mark_SpacingCombining  Unicode class name Mc

    \value Mark_Enclosing  Unicode class name Me

    \value Number_DecimalDigit  Unicode class name Nd

    \value Number_Letter  Unicode class name Nl

    \value Number_Other  Unicode class name No

    \value Separator_Space  Unicode class name Zs

    \value Separator_Line  Unicode class name Zl

    \value Separator_Paragraph  Unicode class name Zp

    \value Other_Control  Unicode class name Cc

    \value Other_Format  Unicode class name Cf

    \value Other_Surrogate  Unicode class name Cs

    \value Other_PrivateUse  Unicode class name Co

    \value Other_NotAssigned  Unicode class name Cn


    The following categories are informative in Unicode:

    \value Letter_Uppercase  Unicode class name Lu

    \value Letter_Lowercase  Unicode class name Ll

    \value Letter_Titlecase  Unicode class name Lt

    \value Letter_Modifier  Unicode class name Lm

    \value Letter_Other Unicode class name Lo

    \value Punctuation_Connector  Unicode class name Pc

    \value Punctuation_Dash  Unicode class name Pd

    \value Punctuation_Open  Unicode class name Ps

    \value Punctuation_Close  Unicode class name Pe

    \value Punctuation_InitialQuote  Unicode class name Pi

    \value Punctuation_FinalQuote  Unicode class name Pf

    \value Punctuation_Other  Unicode class name Po

    \value Symbol_Math  Unicode class name Sm

    \value Symbol_Currency  Unicode class name Sc

    \value Symbol_Modifier  Unicode class name Sk

    \value Symbol_Other  Unicode class name So


    There are two categories that are specific to Qt:

    \value NoCategory  used when Qt is dazed and confused and cannot
    make sense of anything.

    \value Punctuation_Dask  old typo alias for Punctuation_Dash

*/

/*!
    \enum QChar::Direction

    This enum type defines the Unicode direction attributes. See \link
    http://www.unicode.org/ the Unicode Standard\endlink for a
    description of the values.

    In order to conform to C/C++ naming conventions "Dir" is prepended
    to the codes used in the Unicode Standard.
*/

/*!
    \enum QChar::Decomposition

    This enum type defines the Unicode decomposition attributes. See
    \link http://www.unicode.org/ the Unicode Standard\endlink for a
    description of the values.
*/

/*!
    \enum QChar::Joining

    This enum type defines the Unicode joining attributes. See \link
    http://www.unicode.org/ the Unicode Standard\endlink for a
    description of the values.
*/

/*!
    \enum QChar::CombiningClass

    This enum type defines names for some of the Unicode combining
    classes. See \link http://www.unicode.org/ the Unicode
    Standard\endlink for a description of the values.
*/

/*!
    \fn void QChar::setCell( uchar cell )
    \internal
*/

/*!
    \fn void QChar::setRow( uchar row )
    \internal
*/


/*!
    \fn QChar::QChar()

    Constructs a null QChar (one that isNull()).
*/


/*!
    \fn QChar::QChar( char c )

    Constructs a QChar corresponding to ASCII/Latin1 character \a c.
*/


/*!
    \fn QChar::QChar( uchar c )

    Constructs a QChar corresponding to ASCII/Latin1 character \a c.
*/


/*!
    \fn QChar::QChar( uchar c, uchar r )

    Constructs a QChar for Unicode cell \a c in row \a r.
*/


/*!
    \fn QChar::QChar( const QChar& c )

    Constructs a copy of \a c. This is a deep copy, if such a
    lightweight object can be said to have deep copies.
*/


/*!
    \fn QChar::QChar( ushort rc )

    Constructs a QChar for the character with Unicode code point \a rc.
*/


/*!
    \fn QChar::QChar( short rc )

    Constructs a QChar for the character with Unicode code point \a rc.
*/


/*!
    \fn QChar::QChar( uint rc )

    Constructs a QChar for the character with Unicode code point \a rc.
*/


/*!
    \fn QChar::QChar( int rc )

    Constructs a QChar for the character with Unicode code point \a rc.
*/


/*!
    \fn bool  QChar::networkOrdered ()

    \obsolete

    Returns TRUE if this character is in network byte order (MSB
    first); otherwise returns FALSE. This is platform dependent.
*/


/*!
    \fn bool QChar::isNull() const

    Returns TRUE if the character is the Unicode character 0x0000,
    i.e. ASCII NUL; otherwise returns FALSE.
*/

/*!
    \fn uchar QChar::cell () const

    Returns the cell (least significant byte) of the Unicode
    character.
*/

/*!
    \fn uchar QChar::row () const

    Returns the row (most significant byte) of the Unicode character.
*/

/*!
    Returns TRUE if the character is a printable character; otherwise
    returns FALSE. This is any character not of category Cc or Cn.

    Note that this gives no indication of whether the character is
    available in a particular \link QFont font\endlink.
*/
bool QChar::isPrint() const
{
    Category c = ::category( *this );
    return !(c == Other_Control || c == Other_NotAssigned);
}

/*!
    Returns TRUE if the character is a separator character
    (Separator_* categories); otherwise returns FALSE.
*/
bool QChar::isSpace() const
{
    if( ucs >= 9 && ucs <=13 ) return TRUE;
    Category c = ::category( *this );
    return c >= Separator_Space && c <= Separator_Paragraph;
}

/*!
    Returns TRUE if the character is a mark (Mark_* categories);
    otherwise returns FALSE.
*/
bool QChar::isMark() const
{
    Category c = ::category( *this );
    return c >= Mark_NonSpacing && c <= Mark_Enclosing;
}

/*!
    Returns TRUE if the character is a punctuation mark (Punctuation_*
    categories); otherwise returns FALSE.
*/
bool QChar::isPunct() const
{
    Category c = ::category( *this );
    return (c >= Punctuation_Connector && c <= Punctuation_Other);
}

/*!
    Returns TRUE if the character is a letter (Letter_* categories);
    otherwise returns FALSE.
*/
bool QChar::isLetter() const
{
    Category c = ::category( *this );
    return (c >= Letter_Uppercase && c <= Letter_Other);
}

/*!
    Returns TRUE if the character is a number (of any sort - Number_*
    categories); otherwise returns FALSE.

    \sa isDigit()
*/
bool QChar::isNumber() const
{
    Category c = ::category( *this );
    return c >= Number_DecimalDigit && c <= Number_Other;
}

/*!
    Returns TRUE if the character is a letter or number (Letter_* or
    Number_* categories); otherwise returns FALSE.
*/
bool QChar::isLetterOrNumber() const
{
    Category c = ::category( *this );
    return (c >= Letter_Uppercase && c <= Letter_Other)
	|| (c >= Number_DecimalDigit && c <= Number_Other);
}


/*!
    Returns TRUE if the character is a decimal digit
    (Number_DecimalDigit); otherwise returns FALSE.
*/
bool QChar::isDigit() const
{
    return (::category( *this ) == Number_DecimalDigit);
}


/*!
    Returns TRUE if the character is a symbol (Symbol_* categories);
    otherwise returns FALSE.
*/
bool QChar::isSymbol() const
{
    Category c = ::category( *this );
    return c >= Symbol_Math && c <= Symbol_Other;
}

/*!
    Returns the numeric value of the digit, or -1 if the character is
    not a digit.
*/
int QChar::digitValue() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_INT8 *dec_row = decimal_info[row()];
    if( !dec_row )
	return -1;
    return dec_row[cell()];
#else
    // ##### just latin1
    if ( ucs < '0' || ucs > '9' )
	return -1;
    else
	return ucs - '0';
#endif
}

/*!
    Returns the character category.

    \sa Category
*/
QChar::Category QChar::category() const
{
     return ::category( *this );
}

/*!
    Returns the character's direction.

    \sa Direction
*/
QChar::Direction QChar::direction() const
{
     return ::direction( *this );
}

/*!
    \warning This function is not supported (it may change to use
    Unicode character classes).

    Returns information about the joining properties of the character
    (needed for example, for Arabic).
*/
QChar::Joining QChar::joining() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT8 *rowp = direction_info[row()];
    if ( !rowp )
	return QChar::OtherJoining;
    return (Joining) ((*(rowp+cell()) >> 5) &0x3);
#else
    return OtherJoining;
#endif
}


/*!
    Returns TRUE if the character is a mirrored character (one that
    should be reversed if the text direction is reversed); otherwise
    returns FALSE.
*/
bool QChar::mirrored() const
{
    return ::mirrored( *this );
}

/*!
    Returns the mirrored character if this character is a mirrored
    character, otherwise returns the character itself.
*/
QChar QChar::mirroredChar() const
{
#ifndef QT_NO_UNICODETABLES
    if(!::mirrored( *this ))
	return *this;

    int i;
    int c = unicode();
    for (i = 0; i < symmetricPairsSize; i ++) {
	if (symmetricPairs[i] == c)
	  return symmetricPairs[(i%2) ? (i-1) : (i+1)];
    }
#endif
    return *this;
}

#ifndef QT_NO_UNICODETABLES
// ### REMOVE ME 4.0
static QString shared_decomp;
#endif
/*!
    \nonreentrant

    Decomposes a character into its parts. Returns QString::null if no
    decomposition exists.
*/
const QString &QChar::decomposition() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT16 *r = decomposition_info[row()];
    if(!r) return QString::null;

    Q_UINT16 pos = r[cell()];
    if(!pos) return QString::null;
    pos+=2;

    QString s;
    Q_UINT16 c;
    while((c = decomposition_map[pos++]) != 0) s += QChar(c);
    // ### In 4.0, return s, and not shared_decomp.  shared_decomp
    // prevents this function from being reentrant.
    shared_decomp = s;
    return shared_decomp;
#else
    return QString::null;
#endif
}

/*!
    Returns the tag defining the composition of the character. Returns
    QChar::Single if no decomposition exists.
*/
QChar::Decomposition QChar::decompositionTag() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT16 *r = decomposition_info[row()];
    if(!r) return QChar::Single;

    Q_UINT16 pos = r[cell()];
    if(!pos) return QChar::Single;

    return (QChar::Decomposition) decomposition_map[pos];
#else
    return Single; // ########### FIX eg. just latin1
#endif
}

/*!
    Returns the combining class for the character as defined in the
    Unicode standard. This is mainly useful as a positioning hint for
    marks attached to a base character.

    The Qt text rendering engine uses this information to correctly
    position non spacing marks around a base character.
*/
unsigned char QChar::combiningClass() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT8 *rowp = combining_info[row()];
    if ( !rowp )
	return 0;
    return *(rowp+cell());
#else
    return 0;
#endif
}


/*!
    Returns the lowercase equivalent if the character is uppercase;
    otherwise returns the character itself.
*/
QChar QChar::lower() const
{
     return ::lower( *this );
}

/*!
    Returns the uppercase equivalent if the character is lowercase;
    otherwise returns the character itself.
*/
QChar QChar::upper() const
{
     return ::upper( *this );
}

/*!
    \fn QChar::operator char() const

    Returns the Latin1 character equivalent to the QChar, or 0. This
    is mainly useful for non-internationalized software.

    \sa unicode()
*/

/*!
    \fn ushort QChar::unicode() const

    Returns the numeric Unicode value equal to the QChar. Normally,
    you should use QChar objects as they are equivalent, but for some
    low-level tasks (e.g. indexing into an array of Unicode
    information), this function is useful.
*/

/*!
    \fn ushort & QChar::unicode()

    \overload

    Returns a reference to the numeric Unicode value equal to the
    QChar.
*/

/*****************************************************************************
  Documentation of QChar related functions
 *****************************************************************************/

/*!
    \fn bool operator==( QChar c1, QChar c2 )

    \relates QChar

    Returns TRUE if \a c1 and \a c2 are the same Unicode character;
    otherwise returns FALSE.
*/

/*!
    \fn bool operator==( char ch, QChar c )

    \overload
    \relates QChar

    Returns TRUE if \a c is the ASCII/Latin1 character \a ch;
    otherwise returns FALSE.
*/

/*!
    \fn bool operator==( QChar c, char ch )

    \overload
    \relates QChar

    Returns TRUE if \a c is the ASCII/Latin1 character \a ch;
    otherwise returns FALSE.
*/

/*!
    \fn int operator!=( QChar c1, QChar c2 )

    \relates QChar

    Returns TRUE if \a c1 and \a c2 are not the same Unicode
    character; otherwise returns FALSE.
*/

/*!
    \fn int operator!=( char ch, QChar c )

    \overload
    \relates QChar

    Returns TRUE if \a c is not the ASCII/Latin1 character \a ch;
    otherwise returns FALSE.
*/

/*!
    \fn int operator!=( QChar c, char ch )

    \overload
    \relates QChar

    Returns TRUE if \a c is not the ASCII/Latin1 character \a ch;
    otherwise returns FALSE.
*/

/*!
    \fn int operator<=( QChar c1, QChar c2 )

    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c1 is less than
    that of \a c2, or they are the same Unicode character; otherwise
    returns FALSE.
*/

/*!
    \fn int operator<=( QChar c, char ch )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c is less than or
    equal to that of the ASCII/Latin1 character \a ch; otherwise
    returns FALSE.
*/

/*!
    \fn int operator<=( char ch, QChar c )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of the ASCII/Latin1
    character \a ch is less than or equal to that of \a c; otherwise
    returns FALSE.
*/

/*!
    \fn int operator>=( QChar c1, QChar c2 )

    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c1 is greater than
    that of \a c2, or they are the same Unicode character; otherwise
    returns FALSE.
*/

/*!
    \fn int operator>=( QChar c, char ch )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c is greater than
    or equal to that of the ASCII/Latin1 character \a ch; otherwise
    returns FALSE.
*/

/*!
    \fn int operator>=( char ch, QChar c )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of the ASCII/Latin1
    character \a ch is greater than or equal to that of \a c;
    otherwise returns FALSE.
*/

/*!
    \fn int operator<( QChar c1, QChar c2 )

    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c1 is less than
    that of \a c2; otherwise returns FALSE.
*/

/*!
    \fn int operator<( QChar c, char ch )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c is less than that
    of the ASCII/Latin1 character \a ch; otherwise returns FALSE.
*/

/*!
    \fn int operator<( char ch, QChar c )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of the ASCII/Latin1
    character \a ch is less than that of \a c; otherwise returns
    FALSE.
*/

/*!
    \fn int operator>( QChar c1, QChar c2 )

    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c1 is greater than
    that of \a c2; otherwise returns FALSE.
*/

/*!
    \fn int operator>( QChar c, char ch )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of \a c is greater than
    that of the ASCII/Latin1 character \a ch; otherwise returns FALSE.
*/

/*!
    \fn int operator>( char ch, QChar c )

    \overload
    \relates QChar

    Returns TRUE if the numeric Unicode value of the ASCII/Latin1
    character \a ch is greater than that of \a c; otherwise returns
    FALSE.
*/

#ifndef QT_NO_UNICODETABLES

// small class used internally in QString::Compose()
class QLigature
{
public:
    QLigature( QChar c );

    Q_UINT16 first() { cur = ligatures; return cur ? *cur : 0; }
    Q_UINT16 next() { return cur && *cur ? *(cur++) : 0; }
    Q_UINT16 current() { return cur ? *cur : 0; }

    int match(QString & str, unsigned int index);
    QChar head();
    QChar::Decomposition tag();

private:
    Q_UINT16 *ligatures;
    Q_UINT16 *cur;
};

QLigature::QLigature( QChar c )
{
    const Q_UINT16 *r = ligature_info[c.row()];
    if( !r )
	ligatures = 0;
    else
    {
	const Q_UINT16 pos = r[c.cell()];
	ligatures = (Q_UINT16 *)&(ligature_map[pos]);
    }
    cur = ligatures;
}

QChar QLigature::head()
{
    if(current())
	return QChar(decomposition_map[current()+1]);

    return QChar::null;
}

QChar::Decomposition QLigature::tag()
{
    if(current())
	return (QChar::Decomposition) decomposition_map[current()];

    return QChar::Canonical;
}

int QLigature::match(QString & str, unsigned int index)
{
    unsigned int i=index;

    if(!current()) return 0;

    Q_UINT16 lig = current() + 2;
    Q_UINT16 ch;

    while ((i < str.length()) && (ch = decomposition_map[lig])) {
	if (str[(int)i] != QChar(ch))
	    return 0;
	i++;
	lig++;
    }

    if (!decomposition_map[lig])
    {
	return i-index;
    }
    return 0;
}


// this function is just used in QString::compose()
static inline bool format(QChar::Decomposition tag, QString & str,
			  int index, int len)
{
    unsigned int l = index + len;
    unsigned int r = index;

    bool left = FALSE, right = FALSE;

    left = ((l < str.length()) &&
	    ((str[(int)l].joining() == QChar::Dual) ||
	     (str[(int)l].joining() == QChar::Right)));
    if (r > 0) {
	r--;
	//printf("joining(right) = %d\n", str[(int)r].joining());
	right = (str[(int)r].joining() == QChar::Dual);
    }


    switch (tag) {
    case QChar::Medial:
	return (left & right);
    case QChar::Initial:
	return (left && !right);
    case QChar::Final:
	return (right);// && !left);
    case QChar::Isolated:
    default:
	return (!right && !left);
    }
} // format()
#endif

/*
  QString::compose() and visual() were developed by Gordon Tisher
  <tisher@uniserve.ca>, with input from Lars Knoll <knoll@mpi-hd.mpg.de>,
  who developed the unicode data tables.
*/
/*!
    \warning This function is not supported in Qt 3.x. It is provided
    for experimental and illustrative purposes only. It is mainly of
    interest to those experimenting with Arabic and other
    composition-rich texts.

    Applies possible ligatures to a QString. Useful when
    composition-rich text requires rendering with glyph-poor fonts,
    but it also makes compositions such as QChar(0x0041) ('A') and
    QChar(0x0308) (Unicode accent diaresis), giving QChar(0x00c4)
    (German A Umlaut).
*/
void QString::compose()
{
#ifndef QT_NO_UNICODETABLES
    unsigned int index=0, len;
    unsigned int cindex = 0;

    QChar code, head;

    QMemArray<QChar> dia;

    QString composed = *this;

    while (index < length()) {
	code = at(index);
	//printf("\n\nligature for 0x%x:\n", code.unicode());
	QLigature ligature(code);
	ligature.first();
	while(ligature.current()) {
	    if ((len = ligature.match(*this, index)) != 0) {
		head = ligature.head();
		unsigned short code = head.unicode();
		// we exclude Arabic presentation forms A and a few
		// other ligatures, which are undefined in most fonts
		if(!(code > 0xfb50 && code < 0xfe80) &&
		   !(code > 0xfb00 && code < 0xfb2a)) {
				// joining info is only needed for Arabic
		    if (format(ligature.tag(), *this, index, len)) {
			//printf("using ligature 0x%x, len=%d\n",code,len);
			// replace letter
			composed.replace(cindex, len, QChar(head));
			index += len-1;
			// we continue searching in case we have a final
			// form because medial ones are preferred.
			if ( len != 1 || ligature.tag() !=QChar::Final )
			    break;
		    }
		}
	    }
	    ligature.next();
	}
	cindex++;
	index++;
    }
    *this = composed;
#endif
}


// These macros are used for efficient allocation of QChar strings.
// IMPORTANT! If you change these, make sure you also change the
// "delete unicode" statement in ~QStringData() in qstring.h correspondingly!

#define QT_ALLOC_QCHAR_VEC( N ) (QChar*) new char[ sizeof(QChar)*( N ) ]
#define QT_DELETE_QCHAR_VEC( P ) delete[] ((char*)( P ))


/*!
    This utility function converts the 8-bit string \a ba to Unicode,
    returning the result.

    The caller is responsible for deleting the return value with
    delete[].
*/

QChar* QString::latin1ToUnicode( const QByteArray& ba, uint* len )
{
    if ( ba.isNull() ) {
	*len = 0;
	return 0;
    }
    int l = 0;
    while ( l < (int)ba.size() && ba[l] )
	l++;
    char* str = ba.data();
    QChar *uc = new QChar[ l ];   // Can't use macro, since function is public
    QChar *result = uc;
    if ( len )
	*len = l;
    while (l--)
	*uc++ = *str++;
    return result;
}

static QChar* internalLatin1ToUnicode( const QByteArray& ba, uint* len )
{
    if ( ba.isNull() ) {
	*len = 0;
	return 0;
    }
    int l = 0;
    while ( l < (int)ba.size() && ba[l] )
	l++;
    char* str = ba.data();
    QChar *uc = QT_ALLOC_QCHAR_VEC( l );
    QChar *result = uc;
    if ( len )
	*len = l;
    while (l--)
	*uc++ = *str++;
    return result;
}

/*!
    \overload

    This utility function converts the '\0'-terminated 8-bit string \a
    str to Unicode, returning the result and setting \a *len to the
    length of the Unicode string.

    The caller is responsible for deleting the return value with
    delete[].
*/

QChar* QString::latin1ToUnicode( const char *str, uint* len, uint maxlen )
{
    QChar* result = 0;
    uint l = 0;
    if ( str ) {
	if ( maxlen != (uint)-1 ) {
	    while ( l < maxlen && str[l] )
		l++;
	} else {
	    // Faster?
	    l = strlen( str );
	}
	QChar *uc = new QChar[ l ]; // Can't use macro since function is public
	result = uc;
	uint i = l;
	while ( i-- )
	    *uc++ = *str++;
    }
    if ( len )
	*len = l;
    return result;
}

static QChar* internalLatin1ToUnicode( const char *str, uint* len,
				      uint maxlen = (uint)-1 )
{
    QChar* result = 0;
    uint l = 0;
    if ( str ) {
	if ( maxlen != (uint)-1 ) {
	    while ( l < maxlen && str[l] )
		l++;
	} else {
	    // Faster?
	    l = strlen( str );
	}
	QChar *uc = QT_ALLOC_QCHAR_VEC( l );
	result = uc;
	uint i = l;
	while ( i-- )
	    *uc++ = *str++;
    }
    if ( len )
	*len = l;
    return result;
}

/*!
    This utility function converts \a l 16-bit characters from \a uc
    to ASCII, returning a '\0'-terminated string.

    The caller is responsible for deleting the resultant string with
    delete[].
*/
char* QString::unicodeToLatin1(const QChar *uc, uint l)
{
    if (!uc) {
	return 0;
    }
    char *a = new char[l+1];
    char *result = a;
    while (l--) {
	*a++ = (uc->unicode() > 0xff) ? '?' : (char)uc->unicode();
	uc++;
    }
    *a = '\0';
    return result;
}

/*****************************************************************************
  QString member functions
 *****************************************************************************/

/*!
    \class QString qstring.h
    \reentrant

    \brief The QString class provides an abstraction of Unicode text
    and the classic C '\0'-terminated char array.

    \ingroup tools
    \ingroup shared
    \ingroup text
    \mainclass

    QString uses \link shclass.html implicit sharing\endlink, which
    makes it very efficient and easy to use.

    In all of the QString methods that take \c {const char *}
    parameters, the \c {const char *} is interpreted as a classic
    C-style '\0'-terminated ASCII string. It is legal for the \c
    {const char *} parameter to be 0. If the \c {const char *} is not
    '\0'-terminated, the results are undefined. Functions that copy
    classic C strings into a QString will not copy the terminating
    '\0' character. The QChar array of the QString (as returned by
    unicode()) is generally not terminated by a '\0'. If you need to
    pass a QString to a function that requires a C '\0'-terminated
    string use latin1().

    \keyword QString::null
    A QString that has not been assigned to anything is \e null, i.e.
    both the length and data pointer is 0. A QString that references
    the empty string ("", a single '\0' char) is \e empty. Both null
    and empty QStrings are legal parameters to the methods. Assigning
    \c{(const char *) 0} to QString gives a null QString. For
    convenience, \c QString::null is a null QString. When sorting,
    empty strings come first, followed by non-empty strings, followed
    by null strings. We recommend using \c{if ( !str.isNull() )} to
    check for a non-null string rather than \c{if ( !str )}; see \l
    operator!() for an explanation.

    Note that if you find that you are mixing usage of \l QCString,
    QString, and \l QByteArray, this causes lots of unnecessary
    copying and might indicate that the true nature of the data you
    are dealing with is uncertain. If the data is '\0'-terminated 8-bit
    data, use \l QCString; if it is unterminated (i.e. contains '\0's)
    8-bit data, use \l QByteArray; if it is text, use QString.

    Lists of strings are handled by the QStringList class. You can
    split a string into a list of strings using QStringList::split(),
    and join a list of strings into a single string with an optional
    separator using QStringList::join(). You can obtain a list of
    strings from a string list that contain a particular substring or
    that match a particular \link qregexp.html regex\endlink using
    QStringList::grep().

    <b>Note for C programmers</b>

    Due to C++'s type system and the fact that QString is implicitly
    shared, QStrings may be treated like ints or other simple base
    types. For example:

    \code
    QString boolToString( bool b )
    {
	QString result;
	if ( b )
	    result = "True";
	else
	    result = "False";
	return result;
    }
    \endcode

    The variable, result, is an auto variable allocated on the stack.
    When return is called, because we're returning by value, The copy
    constructor is called and a copy of the string is returned. (No
    actual copying takes place thanks to the implicit sharing, see
    below.)

    Throughout Qt's source code you will encounter QString usages like
    this:
    \code
    QString func( const QString& input )
    {
	QString output = input;
	// process output
	return output;
    }
    \endcode

    The 'copying' of input to output is almost as fast as copying a
    pointer because behind the scenes copying is achieved by
    incrementing a reference count. QString (like all Qt's implicitly
    shared classes) operates on a copy-on-write basis, only copying if
    an instance is actually changed.

    If you wish to create a deep copy of a QString without losing any
    Unicode information then you should use QDeepCopy.

    \sa QChar QCString QByteArray QConstString
*/

/*! \enum Qt::ComparisonFlags
\internal
*/
/*!
    \enum Qt::StringComparisonMode

    This enum type is used to set the string comparison mode when
    searching for an item. It is used by QListBox, QListView and
    QIconView, for example. We'll refer to the string being searched
    as the 'target' string.

    \value CaseSensitive The strings must match case sensitively.
    \value ExactMatch The target and search strings must match exactly.
    \value BeginsWith The target string begins with the search string.
    \value EndsWith The target string ends with the search string.
    \value Contains The target string contains the search string.

    If you OR these flags together (excluding \c CaseSensitive), the
    search criteria be applied in the following order: \c ExactMatch,
    \c BeginsWith, \c EndsWith, \c Contains.

    Matching is case-insensitive unless \c CaseSensitive is set. \c
    CaseSensitive may be OR-ed with any combination of the other
    flags.

*/
Q_EXPORT QStringData *QString::shared_null = 0;
QT_STATIC_CONST_IMPL QString QString::null;
QT_STATIC_CONST_IMPL QChar QChar::null;
QT_STATIC_CONST_IMPL QChar QChar::replacement((ushort)0xfffd);
QT_STATIC_CONST_IMPL QChar QChar::byteOrderMark((ushort)0xfeff);
QT_STATIC_CONST_IMPL QChar QChar::byteOrderSwapped((ushort)0xfffe);
QT_STATIC_CONST_IMPL QChar QChar::nbsp((ushort)0x00a0);

QStringData* QString::makeSharedNull()
{
    QString::shared_null = new QStringData;
#if defined( Q_OS_MAC )
    QString *that = const_cast<QString *>(&QString::null);
    that->d = QString::shared_null;
#endif
    return QString::shared_null;
}

/*!
    \fn QString::QString()

    Constructs a null string, i.e. both the length and data pointer
    are 0.

    \sa isNull()
*/

/*!
    Constructs a string of length one, containing the character \a ch.
*/
QString::QString( QChar ch )
{
    d = new QStringData( QT_ALLOC_QCHAR_VEC( 1 ), 1, 1 );
    d->unicode[0] = ch;
}

/*!
    Constructs an implicitly shared copy of \a s. This is very fast
    since it only involves incrementing a reference count.
*/
QString::QString( const QString &s ) :
    d(s.d)
{
    d->ref();
}

/*!
  \internal

  Private function.

  Constructs a string with preallocated space for \a size characters.

  The string is empty.

  \sa isNull()
*/

QString::QString( int size, bool /*dummy*/ )
{
    if ( size ) {
	int l = size;
	QChar* uc = QT_ALLOC_QCHAR_VEC( l );
	d = new QStringData( uc, 0, l );
    } else {
	d = shared_null ? shared_null : (shared_null=new QStringData);
	d->ref();
    }
}

/*!
    Constructs a string that is a deep copy of \a ba interpreted as a
    classic C string.
*/

QString::QString( const QByteArray& ba )
{
#ifndef QT_NO_TEXTCODEC
    if ( QTextCodec::codecForCStrings() ) {
	d = 0;
	*this = fromAscii( ba.data() );
	return;
    }
#endif
    uint l;
    QChar *uc = internalLatin1ToUnicode(ba,&l);
    d = new QStringData(uc,l,l);
}

/*!
    Constructs a string that is a deep copy of the first \a length
    characters in the QChar array.

    If \a unicode and \a length are 0, then a null string is created.

    If only \a unicode is 0, the string is empty but has \a length
    characters of space preallocated: QString expands automatically
    anyway, but this may speed up some cases a little. We recommend
    using the plain constructor and setLength() for this purpose since
    it will result in more readable code.

    \sa isNull() setLength()
*/

QString::QString( const QChar* unicode, uint length )
{
    if ( !unicode && !length ) {
	d = shared_null ? shared_null : makeSharedNull();
	d->ref();
    } else {
	QChar* uc = QT_ALLOC_QCHAR_VEC( length );
	if ( unicode )
	    memcpy(uc, unicode, length*sizeof(QChar));
	d = new QStringData(uc,unicode ? length : 0,length);
    }
}

/*!
    Constructs a string that is a deep copy of \a str, interpreted as
    a classic C string.

    If \a str is 0, then a null string is created.

    This is a cast constructor, but it is perfectly safe: converting a
    Latin1 const char* to QString preserves all the information. You
    can disable this constructor by defining \c QT_NO_CAST_ASCII when
    you compile your applications. You can also make QString objects
    by using setLatin1(), fromLatin1(), fromLocal8Bit(), and
    fromUtf8(). Or whatever encoding is appropriate for the 8-bit data
    you have.

    \sa isNull()
*/

QString::QString( const char *str )
{
#ifndef QT_NO_TEXTCODEC
    if ( QTextCodec::codecForCStrings() ) {
	d = 0;
	*this = fromAscii( str );
	return;
    }
#endif
    uint l;
    QChar *uc = internalLatin1ToUnicode(str,&l);
    d = new QStringData(uc,l,l);
}

#ifndef QT_NO_STL
/*!
    Constructs a string that is a deep copy of \a str.

    This is the same as fromAscii(\a str).
*/

QString::QString( const std::string &str )
{
#ifndef QT_NO_TEXTCODEC
    if ( QTextCodec::codecForCStrings() ) {
	d = 0;
	*this = fromAscii( str.c_str() );
	return;
    }
#endif
    uint l;
    QChar *uc = internalLatin1ToUnicode(str.c_str(),&l);
    d = new QStringData(uc,l,l);
}
#endif

/*!
    \fn QString::~QString()

    Destroys the string and frees the string's data if this is the
    last reference to the string.
*/


/*!
    Deallocates any space reserved solely by this QString.

    If the string does not share its data with another QString
    instance, nothing happens; otherwise the function creates a new,
    unique copy of this string. This function is called whenever the
    string is modified.
*/

void QString::real_detach()
{
    setLength( length() );
}

void QString::deref()
{
    if ( d && d->deref() ) {
	if ( d != shared_null )
	    delete d;
	d = 0;
    }
}

void QStringData::deleteSelf()
{
    delete this;
}

/*!
    \fn QString& QString::operator=( QChar c )

    Sets the string to contain just the single character \a c.
*/

/*!
    \fn QString& QString::operator=( const std::string& s )

    \overload

    Makes a deep copy of \a s and returns a reference to the deep
    copy.
*/

/*!
    \fn QString& QString::operator=( char c )

    \overload

    Sets the string to contain just the single character \a c.
*/

/*!
    \overload

    Assigns a shallow copy of \a s to this string and returns a
    reference to this string. This is very fast because the string
    isn't actually copied.
*/
QString &QString::operator=( const QString &s )
{
    s.d->ref();
    deref();
    d = s.d;
    return *this;
}

/*!
    \overload

    Assigns a deep copy of \a cs, interpreted as a classic C string,
    to this string and returns a reference to this string.
*/
QString &QString::operator=( const QCString& cs )
{
    return setAscii(cs);
}


/*!
    \overload

    Assigns a deep copy of \a str, interpreted as a classic C string
    to this string and returns a reference to this string.

    If \a str is 0, then a null string is created.

    \sa isNull()
*/
QString &QString::operator=( const char *str )
{
    return setAscii(str);
}


/*!
    \fn bool QString::isNull() const

    Returns TRUE if the string is null; otherwise returns FALSE. A
    null string is always empty.

    \code
	QString a;          // a.unicode() == 0, a.length() == 0
	a.isNull();         // TRUE, because a.unicode() == 0
	a.isEmpty();        // TRUE
    \endcode

    \sa isEmpty(), length()
*/

/*!
    \fn bool QString::isEmpty() const

    Returns TRUE if the string is empty, i.e. if length() == 0;
    otherwise returns FALSE. Null strings are also empty.

    \code
	QString a( "" );
	a.isEmpty();        // TRUE
	a.isNull();         // FALSE

	QString b;
	b.isEmpty();        // TRUE
	b.isNull();         // TRUE
    \endcode

    \sa isNull(), length()
*/

/*!
    \fn uint QString::length() const

    Returns the length of the string.

    Null strings and empty strings have zero length.

    \sa isNull(), isEmpty()
*/

/*!
    If \a newLen is less than the length of the string, then the
    string is truncated at position \a newLen. Otherwise nothing
    happens.

    \code
	QString s = "truncate me";
	s.truncate( 5 );            // s == "trunc"
    \endcode

    \sa setLength()
*/

void QString::truncate( uint newLen )
{
    if ( newLen < d->len )
	setLength( newLen );
}

/*!
    Ensures that at least \a newLen characters are allocated to the
    string, and sets the length of the string to \a newLen. Any new
    space allocated contains arbitrary data.

    If \a newLen is 0, then the string becomes empty, unless the
    string is null, in which case it remains null.

    If it is not possible to allocate enough memory, the string
    remains unchanged.

    This function always detaches the string from other references to
    the same data.

    This function is useful for code that needs to build up a long
    string and wants to avoid repeated reallocation. In this example,
    we want to add to the string until some condition is true, and
    we're fairly sure that size is big enough:
    \code
	QString result;
	int resultLength = 0;
	result.setLength( newLen ) // allocate some space
	while ( ... ) {
	    result[resultLength++] = ... // fill (part of) the space with data
	}
	result.truncate[resultLength]; // and get rid of the undefined junk
    \endcode

    If \a newLen is an underestimate, the worst that will happen is
    that the loop will slow down.

    \sa truncate(), isNull(), isEmpty(), length()
*/

void QString::setLength( uint newLen )
{
    if ( d->count != 1 || newLen > d->maxl ||
	 ( newLen * 4 < d->maxl && d->maxl > 4 ) ) {
	// detach, grow or shrink
	uint newMax = computeNewMax( newLen );
	QChar* nd = QT_ALLOC_QCHAR_VEC( newMax );
	if ( nd ) {
	    uint len = QMIN( d->len, newLen );
	    if ( d->unicode )
		memcpy( nd, d->unicode, sizeof(QChar)*len );
	    deref();
	    d = new QStringData( nd, newLen, newMax );
	}
    } else {
	d->len = newLen;
	d->setDirty();
    }
}

/*!
    This function will return a string that replaces the lowest
    numbered occurrence of \c %1, \c %2, ..., \c %9 with \a a.

    The \a fieldwidth value specifies the minimum amount of space that
    \a a is padded to. A positive value will produce right-aligned
    text, whereas a negative value will produce left-aligned text.

    \code
	QString firstName( "Joe" );
	QString lastName( "Bloggs" );
	QString fullName;
	fullName = QString( "First name is '%1', last name is '%2'" )
		    .arg( firstName )
		    .arg( lastName );

	// fullName == First name is 'Joe', last name is 'Bloggs'
    \endcode

    Note that using arg() to construct sentences as we've done in the
    example above does not usually translate well into other languages
    because sentence structure and word order often differ between
    languages.

    If there is no place marker (\c %1 or \c %2, etc.), a warning
    message (qWarning()) is output and the text is appended at the
    end of the string. We recommend that the correct number of place
    markers is always used in production code.
*/
QString QString::arg( const QString& a, int fieldwidth ) const
{
    int pos, len;
    QString r = *this;

    if ( !findArg( pos, len ) ) {
	qWarning( "QString::arg(): Argument missing: %s, %s",
		  latin1(), a.latin1() );
	// Make sure the text at least appears SOMEWHERE
	r += ' ';
	pos = r.length();
	len = 0;
    }

    r.replace( pos, len, a );
    if ( fieldwidth < 0 ) {
	QString s;
	while ( (uint)-fieldwidth > a.length() ) {
	    s += ' ';
	    fieldwidth++;
	}
	r.insert( pos + a.length(), s );
    } else if ( fieldwidth ) {
	QString s;
	while ( (uint)fieldwidth > a.length() ) {
	    s += ' ';
	    fieldwidth--;
	}
	r.insert( pos, s );
    }

    return r;
}


/*!
    \overload

    The \a fieldwidth value specifies the minimum amount of space that
    \a a is padded to. A positive value will produce a right-aligned
    number, whereas a negative value will produce a left-aligned
    number.

    \a a is expressed in base \a base, which is 10 by default and must
    be between 2 and 36.

    \code
	QString str;
	str = QString( "Decimal 63 is %1 in hexadecimal" )
		.arg( 63, 0, 16 );
	// str == "Decimal 63 is 3f in hexadecimal"
    \endcode
*/
QString QString::arg( long a, int fieldwidth, int base ) const
{
    return arg( QString::number(a, base), fieldwidth );
}

/*!
    \overload

    \a a is expressed in base \a base, which is 10 by default and must
    be between 2 and 36.
*/
QString QString::arg( ulong a, int fieldwidth, int base ) const
{
    return arg( QString::number(a, base), fieldwidth );
}

/*!
    \fn QString QString::arg( int a, int fieldwidth, int base ) const

    \overload

    \a a is expressed in base \a base, which is 10 by default and must
    be between 2 and 36.
*/

/*!
    \fn QString QString::arg( uint a, int fieldwidth, int base ) const

    \overload

    \a a is expressed in base \a base, which is 10 by default and must
    be between 2 and 36.
*/

/*!
    \fn QString QString::arg( short a, int fieldwidth, int base ) const

    \overload

    \a a is expressed in base \a base, which is 10 by default and must
    be between 2 and 36.
*/

/*!
    \fn QString QString::arg( ushort a, int fieldwidth, int base ) const

    \overload

    \a a is expressed in base \a base, which is 10 by default and must
    be between 2 and 36.
*/


/*!
    \overload

    \a a is assumed to be in the Latin1 character set.
*/
QString QString::arg( char a, int fieldwidth ) const
{
    QString c;
    c += a;
    return arg( c, fieldwidth );
}

/*!
    \overload
*/
QString QString::arg( QChar a, int fieldwidth ) const
{
    QString c;
    c += a;
    return arg( c, fieldwidth );
}

/*!
    \overload

    \target arg-formats

    Argument \a a is formatted according to the \a fmt format specified,
    which is 'g' by default and can be any of the following:

    \table
    \header \i Format \i Meaning
    \row \i \c e \i format as [-]9.9e[+|-]999
    \row \i \c E \i format as [-]9.9E[+|-]999
    \row \i \c f \i format as [-]9.9
    \row \i \c g \i use \c e or \c f format, whichever is the most concise
    \row \i \c G \i use \c E or \c f format, whichever is the most concise
    \endtable

    With 'e', 'E', and 'f', \a prec is the number of digits after the
    decimal point. With 'g' and 'G', \a prec is the maximum number of
    significant digits (trailing zeroes are omitted).

    \code
	double d = 12.34;
	QString ds = QString( "'E' format, precision 3, gives %1" )
			.arg( d, 0, 'E', 3 );
	// ds == "1.234E+001"
    \endcode
*/
QString QString::arg( double a, int fieldwidth, char fmt, int prec ) const
{
    return arg( QString::number( a, fmt, prec ), fieldwidth );
}


/*
    Just 1-digit arguments.
*/
bool QString::findArg( int& pos, int& len ) const
{
    char lowest=0;
    register const QChar *uc = d->unicode;
    const uint l = length();
    for (uint i = 0; i < l; i++) {
	if ( uc[i] == '%' && i+1<l ) {
	    QChar dig = uc[i+1];
	    if ( dig >= '0' && dig <= '9' ) {
		if ( !lowest || dig < lowest ) {
		    lowest = dig;
		    pos = i;
		    len = 2;
		}
	    }
	}
    }
    return lowest != 0;
}

/*!
    Safely builds a formatted string from the format string \a cformat
    and an arbitrary list of arguments. The format string supports all
    the escape sequences of printf() in the standard C library.

    The %s escape sequence expects a utf8() encoded string. The format
    string \e cformat is expected to be in latin1. If you need a
    Unicode format string, use arg() instead. For typesafe string
    building, with full Unicode support, you can use QTextOStream like
    this:

    \code
	QString str;
	QString s = ...;
	int x = ...;
	QTextOStream( &str ) << s << " : " << x;
    \endcode

    For \link QObject::tr() translations,\endlink especially if the
    strings contains more than one escape sequence, you should
    consider using the arg() function instead. This allows the order
    of the replacements to be controlled by the translator, and has
    Unicode support.

    \sa arg()
*/

#ifndef QT_NO_SPRINTF
QString &QString::sprintf( const char* cformat, ... )
{
    va_list ap;
    va_start( ap, cformat );

    if ( !cformat || !*cformat ) {
	// Qt 1.x compat
	*this = fromLatin1( "" );
	return *this;
    }
    QString format = fromAscii( cformat );

    QRegExp escape( "%#?0?-? ?\\+?'?[0-9*]*\\.?[0-9*]*h?l?L?q?Z?" );
    QString result;
    uint last = 0;
    int pos;
    int len = 0;

    for (;;) {
	pos = escape.search( format, last );
	len = escape.matchedLength();
	// Non-escaped text
	if ( pos > (int)last )
	    result += format.mid( last, pos - last );
	if ( pos < 0 ) {
	    // The rest
	    if ( last < format.length() )
		result += format.mid( last );
	    break;
	}
	last = pos + len + 1;

	// Escape
	QString f = format.mid( pos, len );
	uint width, decimals;
	int params = 0;
	int wpos = f.find('*');
	if ( wpos >= 0 ) {
	    params++;
	    width = va_arg( ap, int );
	    if ( f.find('*', wpos + 1) >= 0 ) {
		decimals = va_arg( ap, int );
		params++;
	    } else {
		decimals = 0;
	    }
	} else {
	    decimals = width = 0;
	}
	QString replacement;
	if ( format[pos + len] == 's' || format[pos + len] == 'S' ||
	     format[pos + len] == 'c' )
	{
	    bool rightjust = ( f.find('-') < 0 );
	    // %-5s really means left adjust in sprintf

	    if ( wpos < 0 ) {
		QRegExp num( fromLatin1("[0-9]+") );
		int p = num.search( f );
		int nlen = num.matchedLength();
		int q = f.find( '.' );
		if ( q < 0 || (p < q && p >= 0) )
		    width = f.mid( p, nlen ).toInt();
		if ( q >= 0 ) {
		    p = num.search( f, q );
		    // "decimals" is used to specify string truncation
		    if ( p >= 0 )
			decimals = f.mid( p, nlen ).toInt();
		}
	    }

	    if ( format[pos + len] == 's' ) {
		QString s = QString::fromUtf8( va_arg(ap, char*) );
		replacement = ( decimals <= 0 ) ? s : s.left( decimals );
	    } else {
		int ch = va_arg(ap, int);
		replacement = QChar((ushort)ch);
	    }
	    if ( replacement.length() < width ) {
		replacement = rightjust
		    ? replacement.rightJustify(width)
		    : replacement.leftJustify(width);
	    }
	} else if ( format[pos+len] == '%' ) {
	    replacement = '%';
	} else if ( format[pos+len] == 'n' ) {
	    int* n = va_arg(ap, int*);
	    *n = result.length();
	} else {
	    char in[64], out[330];
	    strncpy(in,f.latin1(),63);
	    out[0] = '\0';
	    char fch = format[pos+len].latin1();
	    in[f.length()] = fch;
	    switch ( fch ) {
	    case 'd':
	    case 'i':
	    case 'o':
	    case 'u':
	    case 'x':
	    case 'X':
		{
		    int value = va_arg( ap, int );
		    switch ( params ) {
		    case 0:
			::sprintf( out, in, value );
			break;
		    case 1:
			::sprintf( out, in, width, value );
			break;
		    case 2:
			::sprintf( out, in, width, decimals, value );
		    }
		}
		break;
	    case 'e':
	    case 'E':
	    case 'f':
	    case 'g':
	    case 'G':
		{
		    double value = va_arg( ap, double );
		    switch ( params ) {
		    case 0:
			::sprintf( out, in, value );
			break;
		    case 1:
			::sprintf( out, in, width, value );
			break;
		    case 2:
			::sprintf( out, in, width, decimals, value );
		    }
		}
		break;
	    case 'p':
		{
		    void* value = va_arg( ap, void * );
		    switch ( params ) {
		    case 0:
			::sprintf( out, in, value );
			break;
		    case 1:
			::sprintf( out, in, width, value );
			break;
		    case 2:
			::sprintf( out, in, width, decimals, value );
		    }
		}
	    }
	    replacement = fromAscii( out );
	}
	result += replacement;
    }
    *this = result;

    va_end( ap );
    return *this;
}
#endif

/*!
    Fills the string with \a len characters of value \a c, and returns
    a reference to the string.

    If \a len is negative (the default), the current string length is
    used.

    \code
	QString str;
	str.fill( 'g', 5 );      // string == "ggggg"
    \endcode
*/

QString& QString::fill( QChar c, int len )
{
    if ( len < 0 )
	len = length();
    if ( len == 0 ) {
	*this = "";
    } else {
	deref();
	QChar * nd = QT_ALLOC_QCHAR_VEC( len );
	d = new QStringData(nd,len,len);
	while (len--) *nd++ = c;
    }
    return *this;
}


/*!
  \fn QString QString::copy() const

  \obsolete

  In Qt 2.0 and later, all calls to this function are needless. Just
  remove them.
*/

/*!
    \overload

    Finds the first occurrence of the character \a c, starting at
    position \a index. If \a index is -1, the search starts at the
    last character; if -2, at the next to last character and so on.
    (See findRev() for searching backwards.)

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.

    Returns the position of \a c or -1 if \a c could not be found.
*/

int QString::find( QChar c, int index, bool cs ) const
{
#ifdef MACOSX_101
    return find( QString( c ), index, cs );
#else
    const uint l = length();
    if ( index < 0 )
	index += l;
    if ( (uint)index >= l )
	return -1;
    register const QChar *uc = unicode()+index;
    const QChar *end = unicode() + l;
    if ( cs ) {
	while ( uc < end && *uc != c )
	    uc++;
    } else {
	c = ::lower( c );
	while ( uc < end && ::lower( *uc ) != c )
	    uc++;
    }
    if ( uint(uc - unicode()) >= l )
	return -1;
    return (int)(uc - unicode());
#endif
}

/* an implementation of the Boyer-Moore search algorithm
*/

/* initializes the skiptable to know haw far ahead we can skip on a wrong match
*/
static void bm_init_skiptable( const QString &pattern, uint *skiptable, bool cs )
{
    int i = 0;
    register uint *st = skiptable;
    int l = pattern.length();
    while ( i++ < 0x100/8 ) {
	*(st++) = l;
	*(st++) = l;
	*(st++) = l;
	*(st++) = l;
	*(st++) = l;
	*(st++) = l;
	*(st++) = l;
	*(st++) = l;
    }
    const QChar *uc = pattern.unicode();
    if ( cs ) {
	while( l-- ) {
	    skiptable[ uc->cell() ] = l;
	    uc++;
	}
    } else {
	while( l-- ) {
	    skiptable[ ::lower( *uc ).cell() ] = l;
	    uc++;
	}
    }
}

static int bm_find( const QString &str, int index, const QString &pattern, uint *skiptable, bool cs )
{
    const uint l = str.length();
    if ( pattern.isEmpty() )
	return index > (int)l ? -1 : index;

    const QChar *uc = str.unicode();
    const QChar *puc = pattern.unicode();
    const uint pl = pattern.length();
    const uint pl_minus_one = pl - 1;

    register const QChar *current = uc + index + pl_minus_one;
    const QChar *end = uc + l;
    if ( cs ) {
	while( current < end ) {
	    uint skip = skiptable[ current->cell() ];
	    if ( !skip ) {
		// possible match
		while( skip < pl ) {
		    if ( *(current - skip ) != puc[pl_minus_one-skip] )
			break;
		    skip++;
		}
		if ( skip > pl_minus_one ) { // we have a match
		    return (current - uc) - skip + 1;
		}
		// in case we don't have a match we are a bit inefficient as we only skip by one
		// when we have the non matching char in the string.
		if ( skiptable[ (current-skip)->cell() ] == pl )
		    skip = pl - skip;
		else
		    skip = 1;
	    }
	    current += skip;
	}
    } else {
	while( current < end ) {
	    uint skip = skiptable[ ::lower( *current ).cell() ];
	    if ( !skip ) {
		// possible match
		while( skip < pl ) {
		    if ( ::lower( *(current - skip) ) != ::lower( puc[pl_minus_one-skip] ) )
			break;
		    skip++;
		}
		if ( skip > pl_minus_one ) // we have a match
		    return (current - uc) - skip + 1;
		// in case we don't have a match we are a bit inefficient as we only skip by one
		// when we have the non matching char in the string.
		if ( skiptable[ ::lower( (current - skip)->cell() ) ] == pl )
		    skip = pl - skip;
		else
		    skip = 1;
	    }
	    current += skip;
	}
    }
    // not found
    return -1;
}


#define REHASH( a ) \
    if ( sl_minus_1 < sizeof(uint) * CHAR_BIT ) \
	hashHaystack -= (a) << sl_minus_1; \
    hashHaystack <<= 1

/*!
    \overload

    Finds the first occurrence of the string \a str, starting at
    position \a index. If \a index is -1, the search starts at the
    last character, if it is -2, at the next to last character and so
    on. (See findRev() for searching backwards.)

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.

    Returns the position of \a str or -1 if \a str could not be found.
*/

int QString::find( const QString& str, int index, bool cs ) const
{
    const uint l = length();
    const uint sl = str.length();
    if ( index < 0 )
	index += l;
    if ( sl + index > l )
	return -1;
    if ( !sl )
	return index;

#ifndef MACOSX_101
    if ( sl == 1 )
	return find( *str.unicode(), index, cs );
#endif

    // we use the Boyer-Moore algorithm in cases where the overhead
    // for the hash table should pay off, otherwise we use a simple
    // hash function
    if ( l > 500 && sl > 5 ) {
	uint skiptable[0x100];
	bm_init_skiptable( str, skiptable, cs );
	return bm_find( *this, index, str, skiptable, cs );
    }

    /*
      We use some hashing for efficiency's sake. Instead of
      comparing strings, we compare the hash value of str with that of
      a part of this QString. Only if that matches, we call ucstrncmp
      or ucstrnicmp.
    */
    const QChar* needle = str.unicode();
    const QChar* haystack = unicode() + index;
    const QChar* end = unicode() + (l-sl);
    const uint sl_minus_1 = sl-1;
    uint hashNeedle = 0, hashHaystack = 0, i;

    if ( cs ) {
	for ( i = 0; i < sl; ++i ) {
	    hashNeedle = ((hashNeedle<<1) + needle[i].unicode() );
	    hashHaystack = ((hashHaystack<<1) + haystack[i].unicode() );
	}
	hashHaystack -= (haystack+sl_minus_1)->unicode();

	while ( haystack <= end ) {
	    hashHaystack += (haystack+sl_minus_1)->unicode();
 	    if ( hashHaystack == hashNeedle
		 && ucstrncmp( needle, haystack, sl ) == 0 )
		return haystack-unicode();

	    REHASH( haystack->unicode() );
	    ++haystack;
	}
    } else {
	for ( i = 0; i < sl; ++i ) {
	    hashNeedle = ((hashNeedle<<1) +
			  ::lower( needle[i].unicode() ).unicode() );
	    hashHaystack = ((hashHaystack<<1) +
			    ::lower( haystack[i].unicode() ).unicode() );
	}

	hashHaystack -= ::lower(*(haystack+sl_minus_1)).unicode();
	while ( haystack <= end ) {
	    hashHaystack += ::lower(*(haystack+sl_minus_1)).unicode();
	    if ( hashHaystack == hashNeedle
		 && ucstrnicmp( needle, haystack, sl ) == 0 )
		return haystack-unicode();

	    REHASH( ::lower(*haystack).unicode() );
	    ++haystack;
	}
    }
    return -1;
}

/*!
    \fn int QString::findRev( const char* str, int index ) const

    Equivalent to findRev(QString(\a str), \a index).
*/

/*!
    \fn int QString::find( const char* str, int index ) const

    \overload

    Equivalent to find(QString(\a str), \a index).
*/

/*!
    \overload

    Finds the first occurrence of the character \a c, starting at
    position \a index and searching backwards. If the index is -1, the
    search starts at the last character, if it is -2, at the next to
    last character and so on.

    Returns the position of \a c or -1 if \a c could not be found.

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.

    \code
	QString string( "bananas" );
	int i = string.findRev( 'a' );      // i == 5
    \endcode
*/

int QString::findRev( QChar c, int index, bool cs ) const
{
#ifdef MACOSX_101
    return findRev( QString( c ), index, cs );
#else
    const uint l = length();
    if ( index < 0 )
	index += l;
    if ( (uint)index >= l )
	return -1;
    const QChar *end = unicode();
    register const QChar *uc = end + index;
    if ( cs ) {
	while ( uc >= end && *uc != c )
	    uc--;
    } else {
	c = ::lower( c );
	while ( uc >= end && ::lower( *uc ) != c )
	    uc--;
    }
    return uc - end;
#endif
}

/*!
    \overload

    Finds the first occurrence of the string \a str, starting at
    position \a index and searching backwards. If the index is -1, the
    search starts at the last character, if it is -2, at the next to
    last character and so on.

    Returns the position of \a str or -1 if \a str could not be found.

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.

    \code
    QString string("bananas");
    int i = string.findRev( "ana" );      // i == 3
    \endcode
*/

int QString::findRev( const QString& str, int index, bool cs ) const
{
    /*
      See QString::find() for explanations.
    */
    const uint l = length();
    if ( index < 0 )
	index += l;
    const uint sl = str.length();
    int delta = l-sl;
    if ( index < 0 || index > (int)l || delta < 0 )
	return -1;
    if ( index > delta )
	index = delta;

#ifndef MACOSX_101
    if ( sl == 1 )
	return findRev( *str.unicode(), index, cs );
#endif

    const QChar* needle = str.unicode();
    const QChar* haystack = unicode() + index;
    const QChar* end = unicode();
    const uint sl_minus_1 = sl-1;
    const QChar* n = needle+sl_minus_1;
    const QChar* h = haystack+sl_minus_1;
    uint hashNeedle = 0, hashHaystack = 0, i;

    if ( cs ) {
	for ( i = 0; i < sl; ++i ) {
	    hashNeedle = ((hashNeedle<<1) + (n-i)->unicode() );
	    hashHaystack = ((hashHaystack<<1) + (h-i)->unicode() );
	}
	hashHaystack -= haystack->unicode();

	while ( haystack >= end ) {
	    hashHaystack += haystack->unicode();
 	    if ( hashHaystack == hashNeedle
		 && ucstrncmp( needle, haystack, sl ) == 0 )
		return haystack-unicode();
	    --haystack;
	    REHASH( (haystack+sl)->unicode() );
	}
    } else {
	for ( i = 0; i < sl; ++i ) {
	    hashNeedle = ((hashNeedle<<1)
			  + ::lower( (n-i)->unicode() ).unicode() );
	    hashHaystack = ((hashHaystack<<1)
			    + ::lower( (h-i)->unicode() ).unicode() );
	}
	hashHaystack -= ::lower(*haystack).unicode();

	while ( haystack >= end ) {
	    hashHaystack += ::lower(*haystack).unicode();
	    if ( hashHaystack == hashNeedle
		 && ucstrnicmp( needle, haystack, sl ) == 0 )
		return haystack-unicode();
	    --haystack;
	    REHASH( ::lower(*(haystack+sl)).unicode() );
	}
    }
    return -1;
}

#undef REHASH

/*!
    \enum QString::SectionFlags

    \value SectionDefault Empty fields are counted, leading and
    trailing separators are not included, and the separator is
    compared case sensitively.

    \value SectionSkipEmpty Treat empty fields as if they don't exist,
    i.e. they are not considered as far as \e start and \e end are
    concerned.

    \value SectionIncludeLeadingSep Include the leading separator (if
    any) in the result string.

    \value SectionIncludeTrailingSep Include the trailing separator
    (if any) in the result string.

    \value SectionCaseInsensitiveSeps Compare the separator
    case-insensitively.

    Any of the last four values can be OR-ed together to form a flag.

    \sa section()
*/

/*!
    \fn QString QString::section( QChar sep, int start, int end = 0xffffffff, int flags = SectionDefault ) const

    This function returns a section of the string.

    This string is treated as a sequence of fields separated by the
    character, \a sep. The returned string consists of the fields from
    position \a start to position \a end inclusive. If \a end is not
    specified, all fields from position \a start to the end of the
    string are included. Fields are numbered 0, 1, 2, etc., counting
    from the left, and -1, -2, etc., counting from right to left.

    The \a flags argument can be used to affect some aspects of the
    function's behaviour, e.g. whether to be case sensitive, whether
    to skip empty fields and how to deal with leading and trailing
    separators; see \l{SectionFlags}.

    \code
    QString csv( "forename,middlename,surname,phone" );
    QString s = csv.section( ',', 2, 2 );   // s == "surname"

    QString path( "/usr/local/bin/myapp" ); // First field is empty
    QString s = path.section( '/', 3, 4 );  // s == "bin/myapp"
    QString s = path.section( '/', 3, 3, SectionSkipEmpty ); // s == "myapp"
    \endcode

    If \a start or \a end is negative, we count fields from the right
    of the string, the right-most field being -1, the one from
    right-most field being -2, and so on.

    \code
    QString csv( "forename,middlename,surname,phone" );
    QString s = csv.section( ',', -3, -2 );  // s == "middlename,surname"

    QString path( "/usr/local/bin/myapp" ); // First field is empty
    QString s = path.section( '/', -1 ); // s == "myapp"
    \endcode

    \sa QStringList::split()
*/

/*!
    \overload

    This function returns a section of the string.

    This string is treated as a sequence of fields separated by the
    string, \a sep. The returned string consists of the fields from
    position \a start to position \a end inclusive. If \a end is not
    specified, all fields from position \a start to the end of the
    string are included. Fields are numbered 0, 1, 2, etc., counting
    from the left, and -1, -2, etc., counting from right to left.

    The \a flags argument can be used to affect some aspects of the
    function's behaviour, e.g. whether to be case sensitive, whether
    to skip empty fields and how to deal with leading and trailing
    separators; see \l{SectionFlags}.

    \code
    QString data( "forename**middlename**surname**phone" );
    QString s = data.section( "**", 2, 2 ); // s == "surname"
    \endcode

    If \a start or \a end is negative, we count fields from the right
    of the string, the right-most field being -1, the one from
    right-most field being -2, and so on.

    \code
    QString data( "forename**middlename**surname**phone" );
    QString s = data.section( "**", -3, -2 ); // s == "middlename**surname"
    \endcode

    \sa QStringList::split()
*/

QString QString::section( const QString &sep, int start, int end, int flags ) const
{
    const QChar *uc = unicode();
    if ( !uc )
	return QString();
    QString _sep = (flags & SectionCaseInsensitiveSeps) ? sep.lower() : sep;
    const QChar *uc_sep = _sep.unicode();
    if(!uc_sep)
	return QString();
    bool match = FALSE, last_match = TRUE;

    //find start
    int n = length(), sep_len = _sep.length();
    const QChar *begin = start < 0 ? uc + n : uc;
    while(start) {
	match = FALSE;
	int c = 0;
	for(const QChar *tmp = start < 0 ? begin - sep_len : begin;
	    c < sep_len && tmp < uc + n && tmp >= uc; tmp++, c++) {
	    if(flags & SectionCaseInsensitiveSeps) {
		if( ::lower( *tmp ) != *(uc_sep + c))
		    break;
	    } else {
		if( *tmp != *(uc_sep + c) )
		    break;
	    }
	    if(c == sep_len - 1) {
		match = TRUE;
		break;
	    }
	}
	if(start > 0 && (flags & SectionSkipEmpty) && match && last_match)
	    match = FALSE;
	last_match = match;

	if(start < 0) {
	    if(match) {
		begin -= sep_len;
		if(!++start)
		    break;
	    } else {
		if(start == -1 && begin == uc)
		    break;
		begin--;
	    }
	} else {
	    if(match) {
		if(!--start)
		    break;
		begin += sep_len;
	    } else {
		if(start == 1 && begin == uc + n)
		    break;
		begin++;
	    }
	}
	if(begin > uc + n || begin < uc)
	    return QString();
    }
    if(match && !(flags & SectionIncludeLeadingSep))
	begin+=sep_len;
    if(begin > uc + n || begin < uc)
	return QString();

    //now find last
    match = FALSE;
    const QChar *last = end < 0 ? uc + n : uc;
    if(end == -1) {
	int c = 0;
	for(const QChar *tmp = end < 0 ? last - sep_len : last;
	    c < sep_len && tmp < uc + n && tmp >= uc; tmp++, c++) {
	    if(flags & SectionCaseInsensitiveSeps) {
		if( ::lower( *tmp ) != *(uc_sep + c))
		    break;
	    } else {
		if( *tmp != *(uc_sep + c) )
		    break;
	    }
	    if(c == sep_len - 1) {
		match = TRUE;
		break;
	    }
	}
    } else {
	end++;
	last_match = TRUE;
	while(end) {
	    match = FALSE;
	    int c = 0;
	    for(const QChar *tmp = end < 0 ? last - sep_len : last;
		c < sep_len && tmp < uc + n && tmp >= uc; tmp++, c++) {
		if(flags & SectionCaseInsensitiveSeps) {
		    if( ::lower( *tmp ) != *(uc_sep + c))
			break;
		} else {
		    if( *tmp != *(uc_sep + c) )
			break;
		}
		if(c == sep_len - 1) {
		    match = TRUE;
		    break;
		}
	    }
	    if(end > 0 && (flags & SectionSkipEmpty) && match && last_match)
		match = FALSE;
	    last_match = match;

	    if(end < 0) {
		if(match) {
		    if(!++end)
			break;
		    last -= sep_len;
		} else {
		    last--;
		}
	    } else {
		if(match) {
		    last += sep_len;
		    if(!--end)
			break;
		} else {
		    last++;
		}
	    }
	    if(last >= uc + n) {
		last = uc + n;
		break;
	    } else if(last < uc) {
		return QString();
	    }
	}
    }
    if(match && !(flags & SectionIncludeTrailingSep))
	last -= sep_len;
    if(last < uc || last > uc + n || begin >= last)
	return QString();

    //done
    return QString(begin, last - begin);
}

#ifndef QT_NO_REGEXP
class section_chunk {
public:
    section_chunk(int l, QString s) { length = l; string = s; }
    int length;
    QString string;
};
/*!
    \overload

    This function returns a section of the string.

    This string is treated as a sequence of fields separated by the
    regular expression, \a reg. The returned string consists of the
    fields from position \a start to position \a end inclusive. If \a
    end is not specified, all fields from position \a start to the end
    of the string are included. Fields are numbered 0, 1, 2, etc., counting
    from the left, and -1, -2, etc., counting from right to left.

    The \a flags argument can be used to affect some aspects of the
    function's behaviour, e.g. whether to be case sensitive, whether
    to skip empty fields and how to deal with leading and trailing
    separators; see \l{SectionFlags}.

    \code
    QString line( "forename\tmiddlename  surname \t \t phone" );
    QRegExp sep( "\s+" );
    QString s = line.section( sep, 2, 2 ); // s == "surname"
    \endcode

    If \a start or \a end is negative, we count fields from the right
    of the string, the right-most field being -1, the one from
    right-most field being -2, and so on.

    \code
    QString line( "forename\tmiddlename  surname \t \t phone" );
    QRegExp sep( "\\s+" );
    QString s = line.section( sep, -3, -2 ); // s == "middlename  surname"
    \endcode

    \warning Using this QRegExp version is much more expensive than
    the overloaded string and character versions.

    \sa QStringList::split() simplifyWhiteSpace()
*/

QString QString::section( const QRegExp &reg, int start, int end, int flags ) const
{
    const QChar *uc = unicode();
    if(!uc)
	return QString();

    QRegExp sep(reg);
    sep.setCaseSensitive(!(flags & SectionCaseInsensitiveSeps));

    QPtrList<section_chunk> l;
    l.setAutoDelete(TRUE);
    int n = length(), m = 0, last_m = 0, last = 0, last_len = 0;

    while( ( m = sep.search( *this, m ) ) != -1 ) {
	l.append(new section_chunk(last_len, QString(uc + last_m, m - last_m)));
	last_m = m;
	last_len = sep.matchedLength();
	if((m += sep.matchedLength()) >= n) {
	    last = 1;
	    break;
	}
    }
    if(!last)
	l.append(new section_chunk(last_len, QString(uc + last_m, n - last_m)));

    if(start < 0)
	start = l.count() + start;
    if(end == -1)
	end = l.count();
    else if(end < 0)
	end = l.count() + end;

    int i = 0;
    QString ret;
    for ( section_chunk *chk=l.first(); chk; chk=l.next(), i++ ) {
	if((flags & SectionSkipEmpty) && chk->length == (int)chk->string.length()) {
	    if(i <= start)
		start++;
	    end++;
	}
	if(i == start) {
	    ret = (flags & SectionIncludeLeadingSep) ? chk->string : chk->string.mid(chk->length);
	} else if(i > start) {
	    ret += chk->string;
	}
	if(i == end) {
	    if((chk=l.next()) && flags & SectionIncludeTrailingSep)
		ret += chk->string.left(chk->length);
	    break;
	}
    }
    return ret;
}
#endif

/*!
    \fn QString QString::section( char sep, int start, int end = 0xffffffff, int flags = SectionDefault ) const

    \overload
*/

/*!
    \fn QString QString::section( const char *sep, int start, int end = 0xffffffff, int flags = SectionDefault ) const

    \overload
*/


/*!
    Returns the number of times the character \a c occurs in the
    string.

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.

    \code
    QString string( "Trolltech and Qt" );
    int i = string.contains( 't', FALSE );  // i == 3
    \endcode
*/

int QString::contains( QChar c, bool cs ) const
{
    int count = 0;
    const QChar *uc = unicode();
    if ( !uc )
	return 0;
    int n = length();
    if ( cs ) {
	while ( n-- )
	    if ( *uc++ == c )
		count++;
    } else {
	c = ::lower( c );
	while ( n-- ) {
	    if ( ::lower( *uc ) == c )
		count++;
	    uc++;
	}
    }
    return count;
}

/*!
    \overload

    Returns the number of times the string \a str occurs in the string.

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.
*/
int QString::contains( const char* str, bool cs ) const
{
    return contains( QString(str), cs );
}

/*!
    \fn int QString::contains( char c, bool cs ) const

    \overload
*/

/*!
    \fn int QString::find( char c, int index, bool cs ) const

    \overload

    Find character \a c starting from position \a index.

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.
*/

/*!
    \fn int QString::findRev( char c, int index, bool cs ) const

    \overload

    Find character \a c starting from position \a index and working
    backwards.

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.
*/

/*!
    \overload

    Returns the number of times \a str occurs in the string.

    If \a cs is TRUE, the search is case sensitive; otherwise the
    search is case insensitive.

    This function counts overlapping strings, so in the example below,
    there are two instances of "ana" in "bananas".

    \code
    QString str( "bananas" );
    int i = str.contains( "ana" );  // i == 2
    \endcode

    \sa findRev()
*/

int QString::contains( const QString &str, bool cs ) const
{
    if ( isNull() )
	return 0;
    int count = 0;
    uint skiptable[0x100];
    bm_init_skiptable( str, skiptable, cs );
    int i = -1;
    // use boyer-moore for the ultimate speed experience
    while ( ( i = bm_find( *this, i+1, str, skiptable, cs ) ) != -1 )
	count++;
    return count;
}

/*!
    Returns a substring that contains the \a len leftmost characters
    of the string.

    The whole string is returned if \a len exceeds the length of the
    string.

    \code
	QString s = "Pineapple";
	QString t = s.left( 4 );    // t == "Pine"
    \endcode

    \sa right(), mid(), isEmpty()
*/

QString QString::left( uint len ) const
{
    if ( isEmpty() ) {
	return QString();
    } else if ( len == 0 ) {                    // ## just for 1.x compat:
	return fromLatin1( "" );
    } else if ( len >= length() ) {
	return *this;
    } else {
	QString s( len, TRUE );
	memcpy( s.d->unicode, d->unicode, len * sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
    Returns a string that contains the \a len rightmost characters of
    the string.

    If \a len is greater than the length of the string then the whole
    string is returned.

    \code
	QString string( "Pineapple" );
	QString t = string.right( 5 );   // t == "apple"
    \endcode

    \sa left(), mid(), isEmpty()
*/

QString QString::right( uint len ) const
{
    if ( isEmpty() ) {
	return QString();
    } else if ( len == 0 ) {                    // ## just for 1.x compat:
	return fromLatin1( "" );
    } else {
	uint l = length();
	if ( len >= l )
	    return *this;
	QString s( len, TRUE );
	memcpy( s.d->unicode, d->unicode+(l-len), len*sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
    Returns a string that contains the \a len characters of this
    string, starting at position \a index.

    Returns a null string if the string is empty or \a index is out of
    range. Returns the whole string from \a index if \a index + \a len
    exceeds the length of the string.

    \code
	QString s( "Five pineapples" );
	QString t = s.mid( 5, 4 );                  // t == "pine"
    \endcode

    \sa left(), right()
*/

QString QString::mid( uint index, uint len ) const
{
    uint slen = length();
    if ( isEmpty() || index >= slen ) {
	return QString();
    } else if ( len == 0 ) {                    // ## just for 1.x compat:
	return fromLatin1( "" );
    } else {
	if ( len > slen-index )
	    len = slen - index;
	if ( index == 0 && len == slen )
	    return *this;
	register const QChar *p = unicode()+index;
	QString s( len, TRUE );
	memcpy( s.d->unicode, p, len * sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
    Returns a string of length \a width that contains this string
    padded by the \a fill character.

    If \a truncate is FALSE and the length of the string is more than
    \a width, then the returned string is a copy of the string.

    If \a truncate is TRUE and the length of the string is more than
    \a width, then any characters in a copy of the string after length
    \a width are removed, and the copy is returned.

    \code
	QString s( "apple" );
	QString t = s.leftJustify( 8, '.' );        // t == "apple..."
    \endcode

    \sa rightJustify()
*/

QString QString::leftJustify( uint width, QChar fill, bool truncate ) const
{
    QString result;
    int len = length();
    int padlen = width - len;
    if ( padlen > 0 ) {
	result.setLength(len+padlen);
	if ( len )
	    memcpy( result.d->unicode, unicode(), sizeof(QChar)*len );
	QChar* uc = result.d->unicode + len;
	while (padlen--)
	    *uc++ = fill;
    } else {
	if ( truncate )
	    result = left( width );
	else
	    result = *this;
    }
    return result;
}

/*!
    Returns a string of length \a width that contains the \a fill
    character followed by the string.

    If \a truncate is FALSE and the length of the string is more than
    \a width, then the returned string is a copy of the string.

    If \a truncate is TRUE and the length of the string is more than
    \a width, then the resulting string is truncated at position \a
    width.

    \code
	QString string( "apple" );
	QString t = string.rightJustify( 8, '.' );  // t == "...apple"
    \endcode

    \sa leftJustify()
*/

QString QString::rightJustify( uint width, QChar fill, bool truncate ) const
{
    QString result;
    int len = length();
    int padlen = width - len;
    if ( padlen > 0 ) {
	result.setLength( len+padlen );
	QChar* uc = result.d->unicode;
	while (padlen--)
	    *uc++ = fill;
	if ( len )
	    memcpy( uc, unicode(), sizeof(QChar)*len );
    } else {
	if ( truncate )
	    result = left( width );
	else
	    result = *this;
    }
    return result;
}

/*!
    Returns a lowercase copy of the string.

    \code
	QString string( "TROlltECH" );
	str = string.lower();   // str == "trolltech"
    \endcode

    \sa upper()
*/

QString QString::lower() const
{
    QString s(*this);
    int l=length();
    if ( l ) {
	s.real_detach(); // could do this only when we find a change
	register QChar *p=s.d->unicode;
	if ( p ) {
	    while ( l-- ) {
		*p = ::lower( *p );
		p++;
	    }
	}
    }
    return s;
}

/*!
    Returns an uppercase copy of the string.

    \code
	QString string( "TeXt" );
	str = string.upper();     // t == "TEXT"
    \endcode

    \sa lower()
*/

QString QString::upper() const
{
    QString s(*this);
    int l=length();
    if ( l ) {
	s.real_detach(); // could do this only when we find a change
	register QChar *p=s.d->unicode;
	if ( p ) {
	    while ( l-- ) {
		*p = ::upper( *p );
		p++;
	    }
	}
    }
    return s;
}


/*!
    Returns a string that has whitespace removed from the start and
    the end.

    Whitespace means any character for which QChar::isSpace() returns
    TRUE. This includes Unicode characters with decimal values 9
    (TAB), 10 (LF), 11 (VT), 12 (FF), 13 (CR) and 32 (Space), and may
    also include other Unicode characters.

    \code
	QString string = "   white space   ";
	QString s = string.stripWhiteSpace();       // s == "white space"
    \endcode

    \sa simplifyWhiteSpace()
*/

QString QString::stripWhiteSpace() const
{
    if ( isEmpty() )                            // nothing to do
	return *this;
    register const QChar *s = unicode();
    if ( !s->isSpace() && !s[length()-1].isSpace() )
	return *this;

    int start = 0;
    int end = length() - 1;
    while ( start<=end && s[start].isSpace() )  // skip white space from start
	start++;
    if ( start <= end ) {                          // only white space
	while ( end && s[end].isSpace() )           // skip white space from end
	    end--;
    }
    int l = end - start + 1;
    if ( l <= 0 )
    	return QString::fromLatin1("");

    QString result( l, TRUE );
    memcpy( result.d->unicode, &s[start], sizeof(QChar)*l );
    result.d->len = l;
    return result;
}


/*!
    Returns a string that has whitespace removed from the start and
    the end, and which has each sequence of internal whitespace
    replaced with a single space.

    Whitespace means any character for which QChar::isSpace() returns
    TRUE. This includes Unicode characters with decimal values 9
    (TAB), 10 (LF), 11 (VT), 12 (FF), 13 (CR), and 32 (Space).

    \code
	QString string = "  lots\t of\nwhite    space ";
	QString t = string.simplifyWhiteSpace();
	// t == "lots of white space"
    \endcode

    \sa stripWhiteSpace()
*/

QString QString::simplifyWhiteSpace() const
{
    if ( isEmpty() )
	return *this;
    QString result;
    result.setLength( length() );
    const QChar *from = unicode();
    const QChar *fromend = from+length();
    int outc=0;
    QChar *to   = result.d->unicode;
    for (;;) {
	while ( from!=fromend && from->isSpace() )
	    from++;
	while ( from!=fromend && !from->isSpace() )
	    to[outc++] = *from++;
	if ( from!=fromend )
	    to[outc++] = ' ';
	else
	    break;
    }
    if ( outc > 0 && to[outc-1] == ' ' )
	outc--;
    result.truncate( outc );
    return result;
}


/*!
    Inserts \a s into the string at position \a index.

    If \a index is beyond the end of the string, the string is
    extended with spaces to length \a index and \a s is then appended
    and returns a reference to the string.

    \code
	QString string( "I like fish" );
	str = string.insert( 2, "don't " );
	// str == "I don't like fish"
    \endcode

    \sa remove(), replace()
*/

QString &QString::insert( uint index, const QString &s )
{
    // the sub function takes care of &s == this case.
    return insert( index, s.unicode(), s.length() );
}

/*!
    \overload

    Inserts the character in \a s into the string at position \a index
    \a len number of times and returns a reference to the string.
*/

QString &QString::insert( uint index, const QChar* s, uint len )
{
    if ( len == 0 )
	return *this;
    uint olen = length();
    int nlen = olen + len;

    if ( s >= d->unicode && (uint)(s - d->unicode) < d->maxl ) {
	// Part of me - take a copy.
	QChar *tmp = QT_ALLOC_QCHAR_VEC( len );
	memcpy(tmp,s,len*sizeof(QChar));
	insert(index,tmp,len);
	QT_DELETE_QCHAR_VEC( tmp );
	return *this;
    }

    if ( index >= olen ) {                      // insert after end of string
	setLength( len + index );
	int n = index - olen;
	QChar* uc = d->unicode+olen;
	while (n--)
	    *uc++ = ' ';
	memcpy( d->unicode+index, s, sizeof(QChar)*len );
    } else {                                    // normal insert
	setLength( nlen );
	memmove( d->unicode + index + len, unicode() + index,
		 sizeof(QChar) * (olen - index) );
	memcpy( d->unicode + index, s, sizeof(QChar) * len );
    }
    return *this;
}

/*!
    \overload

    Insert \a c into the string at position \a index and returns a
    reference to the string.

    If \a index is beyond the end of the string, the string is
    extended with spaces (ASCII 32) to length \a index and \a c is
    then appended.
*/

QString &QString::insert( uint index, QChar c ) // insert char
{
    QString s( c );
    return insert( index, s );
}

/*!
    \fn QString& QString::insert( uint index, char c )

    \overload

    Insert character \a c at position \a index.
*/

/*!
    \fn QString &QString::prepend( const QString &s )

    Inserts \a s at the beginning of the string and returns a
    reference to the string.

    Equivalent to insert(0, \a s).

    \code
	QString string = "42";
	string.prepend( "The answer is " );
	// string == "The answer is 42"
    \endcode

    \sa insert()
*/

/*!
    \fn QString& QString::prepend( char ch )

    \overload

    Inserts \a ch at the beginning of the string and returns a
    reference to the string.

    Equivalent to insert(0, \a ch).

    \sa insert()
*/

/*!
    \fn QString& QString::prepend( QChar ch )

    \overload

    Inserts \a ch at the beginning of the string and returns a
    reference to the string.

    Equivalent to insert(0, \a ch).

    \sa insert()
*/

/*! \fn QString& QString::prepend( const QByteArray &s )
  \overload

  Inserts \a s at the beginning of the string and returns a reference to the string.

  Equivalent to insert(0, \a s).

  \sa insert()
 */

/*! \fn QString& QString::prepend( const std::string &s )
  \overload

  Inserts \a s at the beginning of the string and returns a reference to the string.

  Equivalent to insert(0, \a s).

  \sa insert()
 */

/*!
  \overload

  Inserts \a s at the beginning of the string and returns a reference to the string.

  Equivalent to insert(0, \a s).

  \sa insert()
 */
QString &QString::prepend( const char *s )
{
    return insert( 0, QString(s) );
}

/*!
    Removes \a len characters from the string starting at position \a
    index, and returns a reference to the string.

    If \a index is beyond the length of the string, nothing happens.
    If \a index is within the string, but \a index + \a len is beyond
    the end of the string, the string is truncated at position \a
    index.

    \code
	QString string( "Montreal" );
	string.remove( 1, 4 );      // string == "Meal"
    \endcode

    \sa insert(), replace()
*/

QString &QString::remove( uint index, uint len )
{
    uint olen = length();
    if ( index >= olen  ) {
	// range problems
    } else if ( index + len >= olen ) {  // index ok
	setLength( index );
    } else if ( len != 0 ) {
	real_detach();
	memmove( d->unicode+index, d->unicode+index+len,
		 sizeof(QChar)*(olen-index-len) );
	setLength( olen-len );
    }
    return *this;
}

/*! \overload

    Removes every occurrence of the character \a c in the string.
    Returns a reference to the string.

    This is the same as replace(\a c, "").
*/
QString &QString::remove( QChar c )
{
    int i = 0;
    while ( i < (int) length() ) {
	if ( constref(i) == c ) {
	    remove( i, 1 );
	} else {
	    i++;
	}
    }
    return *this;
}

/*! \overload

    \fn QString &QString::remove( char c )

    Removes every occurrence of the character \a c in the string.
    Returns a reference to the string.

    This is the same as replace(\a c, "").
*/

/*! \overload

    Removes every occurrence of \a str in the string. Returns a
    reference to the string.

    This is the same as replace(\a str, "").
*/
QString &QString::remove( const QString & str )
{
    int index = 0;
    if ( !str.isEmpty() ) {
	while ( (index = find(str, index)) != -1 )
	    remove( index, str.length() );
    }
    return *this;
}

/*! \overload

  Replaces every occurrence of \a c1 with the char \a c2.
  Returns a reference to the string.
*/
QString &QString::replace( QChar c1, QChar c2 )
{
     real_detach();
     uint i = 0;
     while ( i < d->len ) {
	  if ( d->unicode[i] == c1 )
	       d->unicode[i] = c2;
	  i++;
     }
     return *this;
}


#ifndef QT_NO_REGEXP_CAPTURE

/*! \overload

    Removes every occurrence of the regular expression \a rx in the
    string. Returns a reference to the string.

    This is the same as replace(\a rx, "").
*/

QString &QString::remove( const QRegExp & rx )
{
    return replace( rx, QString::null );
}

#endif

/*! \overload

    Removes every occurrence of \a str in the string. Returns a
    reference to the string.
*/
QString &QString::remove( const char *str )
{
    return remove( QString::fromLatin1(str) );
}

/*!
    Replaces \a len characters from the string with \a s, starting at
    position \a index, and returns a reference to the string.

    If \a index is beyond the length of the string, nothing is deleted
    and \a s is appended at the end of the string. If \a index is
    valid, but \a index + \a len is beyond the end of the string,
    the string is truncated at position \a index, then \a s is
    appended at the end.

    \code
	QString string( "Say yes!" );
	string = string.replace( 4, 3, "NO" );
	// string == "Say NO!"
    \endcode

    \sa insert(), remove()
*/

QString &QString::replace( uint index, uint len, const QString &s )
{
    return replace( index, len, s.unicode(), s.length() );
}

/*! \overload

    This is the same as replace(\a index, \a len, QString(\a c)).
*/
QString &QString::replace( uint index, uint len, QChar c )
{
    return replace( index, len, &c, 1 );
}

/*! \overload
    \fn QString &QString::replace( uint index, uint len, char c )

    This is the same as replace(\a index, \a len, QChar(\a c)).
*/

/*!
    \overload

    Replaces \a len characters with \a slen characters of QChar data
    from \a s, starting at position \a index, and returns a reference
    to the string.

    \sa insert(), remove()
*/

QString &QString::replace( uint index, uint len, const QChar* s, uint slen )
{
    real_detach();
    if ( len == slen && index + len <= length() ) {
	// Optimized common case: replace without size change
	memcpy( d->unicode+index, s, len * sizeof(QChar) );
    } else if ( s >= d->unicode && (uint)(s - d->unicode) < d->maxl ) {
	// Part of me - take a copy.
	QChar *tmp = QT_ALLOC_QCHAR_VEC( slen );
	memcpy( tmp, s, slen * sizeof(QChar) );
	replace( index, len, tmp, slen );
	QT_DELETE_QCHAR_VEC( tmp );
    } else {
	remove( index, len );
	insert( index, s, slen );
    }
    return *this;
}

/*! \overload

    Replaces every occurrence of the character \a c in the string
    with \a after. Returns a reference to the string.

    Example:
    \code
    QString s = "a,b,c";
    s.replace( QChar(','), " or " );
    // s == "a or b or c"
    \endcode
*/
QString &QString::replace( QChar c, const QString & after )
{
    return replace( QString( c ), after );
}

/*! \overload
    \fn QString &QString::replace( char c, const QString & after )

    Replaces every occurrence of the character \a c in the string
    with \a after. Returns a reference to the string.
*/

/*! \overload

    Replaces every occurrence of the string \a before in the string
    with the string \a after. Returns a reference to the string.

    Example:
    \code
    QString s = "Greek is Greek";
    s.replace( "Greek", "English" );
    // s == "English is English"
    \endcode
*/
QString &QString::replace( const QString & before, const QString & after )
{
    if ( before == after || isNull() )
	return *this;

    real_detach();

    int index = 0;
    uint skiptable[256];
    bm_init_skiptable( before, skiptable, TRUE );
    const int bl = before.length();
    const int al = after.length();

    if ( bl == al ) {
	if ( bl ) {
	    const QChar *auc = after.unicode();
	    while( (index = bm_find(*this, index, before, skiptable, TRUE) ) != -1 ) {
		memcpy( d->unicode+index, auc, al*sizeof(QChar) );
		index += bl;
	    }
	}
    } else if ( al < bl ) {
	const QChar *auc = after.unicode();
	uint to = 0;
	uint movestart = 0;
	uint num = 0;
	while( (index = bm_find(*this, index, before, skiptable, TRUE) ) != -1 ) {
	    if ( num ) {
		int msize = index - movestart;
		if ( msize > 0 ) {
		    memmove( d->unicode + to, d->unicode + movestart, msize*sizeof(QChar) );
		    to += msize;
		}
	    } else {
		to = index;
	    }
	    if ( al ) {
		memcpy( d->unicode+to, auc, al*sizeof(QChar) );
		to += al;
	    }
	    index += bl;
	    movestart = index;
	    num++;
	}
	if ( num ) {
	    int msize = d->len - movestart;
	    if ( msize > 0 )
		memmove( d->unicode + to, d->unicode + movestart, msize*sizeof(QChar) );
	    setLength( d->len - num*(bl-al) );
	}
    } else {
	// the most complex case. We don't want to loose performance by doing repeated
	// copies and reallocs of the string.
	while( index != -1 ) {
	    uint indices[4096];
	    uint pos = 0;
	    while( pos < 4095 ) {
		index = bm_find(*this, index, before, skiptable, TRUE);
		if ( index == -1 )
		    break;
		indices[pos++] = index;
		index += bl;
		// avoid infinite loop
		if ( !bl )
		    index++;
	    }
	    if ( !pos )
		break;

	    // we have a table of replacement positions, use them for fast replacing
	    int adjust = pos*(al-bl);
	    // index has to be adjusted in case we get back into the loop above.
	    if ( index != -1 )
		index += adjust;
	    uint newlen = d->len + adjust;
	    int moveend = d->len;
	    if ( newlen > d->len )
		setLength( newlen );

	    while( pos ) {
		pos--;
		int movestart = indices[pos] + bl;
		int insertstart = indices[pos] + pos*(al-bl);
		int moveto = insertstart + al;
		memmove( d->unicode + moveto, d->unicode + movestart, (moveend - movestart)*sizeof(QChar) );
		memcpy( d->unicode + insertstart, after.unicode(), al*sizeof(QChar) );
		moveend = movestart-bl;
	    }
	}
    }
    return *this;
}

#ifndef QT_NO_REGEXP_CAPTURE
/*! \overload

  Replaces every occurrence of the regexp \a rx in the string with \a str.
  Returns a reference to the string. For example:
  \code
    QString s = "banana";
    s.replace( QRegExp("an"), "" );
    // s == "ba"
  \endcode

  For regexps containing \link qregexp.html#capturing-text capturing
  parentheses \endlink, occurrences of <b>\\1</b>, <b>\\2</b>, ...,
  in \a str are replaced with \a{rx}.cap(1), cap(2), ...

  \code
    QString t = "A <i>bon mot</i>.";
    t.replace( QRegExp("<i>([^<]*)</i>"), "\\emph{\\1}" );
    // t == "A \\emph{bon mot}."
  \endcode

  \sa find(), findRev(), QRegExp::cap()
*/

QString &QString::replace( const QRegExp &rx, const QString &str )
{
    if ( isNull() )
	return *this;

    real_detach();

    QRegExp rx2 = rx;
    int index = 0;
    int numCaptures = rx2.numCaptures();
    int al = str.length();
    QRegExp::CaretMode caretMode = QRegExp::CaretAtZero;

    if ( numCaptures > 0 ) {
	if ( numCaptures > 9 )
	    numCaptures = 9;

	const QChar *uc = str.unicode();
	int numBackRefs = 0;

	for ( int i = 0; i < al - 1; i++ ) {
	    if ( uc[i] == '\\' ) {
		int no = uc[i + 1].digitValue();
		if ( no > 0 && no <= numCaptures )
		    numBackRefs++;
	    }
	}

	/*
	  This is the harder case where we have back-references. We
	  don't try to optimize it.
	*/
	if ( numBackRefs > 0 ) {
	    int *capturePositions = new int[numBackRefs];
	    int *captureNumbers = new int[numBackRefs];
	    int j = 0;

	    for ( int i = 0; i < al - 1; i++ ) {
		if ( uc[i] == '\\' ) {
		    int no = uc[i + 1].digitValue();
		    if ( no > 0 && no <= numCaptures ) {
			capturePositions[j] = i;
			captureNumbers[j] = no;
			j++;
		    }
		}
	    }

	    while ( index <= (int)length() ) {
		index = rx2.search( *this, index, caretMode );
		if ( index == -1 )
		    break;

		QString str2 = str;
		for ( j = numBackRefs - 1; j >= 0; j-- )
		    str2.replace( capturePositions[j], 2,
				  rx2.cap(captureNumbers[j]) );

		replace( index, rx2.matchedLength(), str2 );
		index += str2.length();

		if ( rx2.matchedLength() == 0 ) {
		    // avoid infinite loop on 0-length matches (e.g., [a-z]*)
		    index++;
		} else if ( index == 0 ) {
		    caretMode = QRegExp::CaretWontMatch;
		}
	    }
	    delete[] capturePositions;
	    delete[] captureNumbers;
	    return *this;
	}
    }

    /*
      This is the simple and optimized case where we don't have
      back-references.
    */
    while ( index != -1 ) {
	struct {
	    int pos;
	    int length;
	} replacements[2048];

	uint pos = 0;
	int adjust = 0;
	while( pos < 2047 ) {
	    index = rx2.search( *this, index, caretMode );
	    if ( index == -1 )
		break;
	    int ml = rx2.matchedLength();
	    replacements[pos].pos = index;
	    replacements[pos++].length = ml;
	    index += ml;
	    adjust += al - ml;
	    // avoid infinite loop
	    if ( !ml )
		index++;
	}
	if ( !pos )
	    break;
	replacements[pos].pos = d->len;
	uint newlen = d->len + adjust;

	// to continue searching at the right position after we did
	// the first round of replacements
	if ( index != -1 )
	    index += adjust;
	QChar *newuc = QT_ALLOC_QCHAR_VEC( newlen + 1 );
	QChar *uc = newuc;
	int copystart = 0;
	uint i = 0;
	while( i < pos ) {
	    int copyend = replacements[i].pos;
	    int size = copyend - copystart;
	    memcpy( uc, d->unicode + copystart, size*sizeof(QChar) );
	    uc += size;
	    memcpy( uc, str.unicode(), al*sizeof( QChar ) );
	    uc += al;
	    copystart = copyend + replacements[i].length;
	    i++;
	}
	memcpy( uc, d->unicode + copystart,
		(d->len - copystart) * sizeof(QChar) );
	QT_DELETE_QCHAR_VEC( d->unicode );
	d->unicode = newuc;
	d->len = newlen;
	d->maxl = newlen + 1;
	d->setDirty();
	caretMode = QRegExp::CaretWontMatch;
    }
    return *this;
}
#endif

#ifndef QT_NO_REGEXP
/*!
    Finds the first match of the regular expression \a rx, starting
    from position \a index. If \a index is -1, the search starts at
    the last character; if -2, at the next to last character and so
    on. (See findRev() for searching backwards.)

    Returns the position of the first match of \a rx or -1 if no match
    was found.

    \code
	QString string( "bananas" );
	int i = string.find( QRegExp("an"), 0 );    // i == 1
    \endcode

    \sa findRev() replace() contains()
*/

int QString::find( const QRegExp &rx, int index ) const
{
    return rx.search( *this, index );
}

/*!
    \overload

    Finds the first match of the regexp \a rx, starting at position \a
    index and searching backwards. If the index is -1, the search
    starts at the last character, if it is -2, at the next to last
    character and so on. (See findRev() for searching backwards.)

    Returns the position of the match or -1 if no match was found.

    \code
	QString string( "bananas" );
	int i = string.findRev( QRegExp("an") );      // i == 3
    \endcode

    \sa find()
*/

int QString::findRev( const QRegExp &rx, int index ) const
{
    return rx.searchRev( *this, index );
}

/*!
    \overload

    Returns the number of times the regexp, \a rx, matches in the
    string.

    This function counts overlapping matches, so in the example below,
    there are four instances of "ana" or "ama".

    \code
	QString str = "banana and panama";
	QRegExp rxp = QRegExp( "a[nm]a", TRUE, FALSE );
	int i = str.contains( rxp );    // i == 4
    \endcode

    \sa find() findRev()
*/

int QString::contains( const QRegExp &rx ) const
{
    int count = 0;
    int index = -1;
    int len = length();
    while ( index < len - 1 ) {                 // count overlapping matches
	index = rx.search( *this, index + 1 );
	if ( index == -1 )
	    break;
	count++;
    }
    return count;
}

#endif //QT_NO_REGEXP

static bool ok_in_base( QChar c, int base )
{
    if ( base <= 10 )
	return c.isDigit() && c.digitValue() < base;
    else
	return c.isDigit() || (c >= 'a' && c < char('a'+base-10))
			   || (c >= 'A' && c < char('A'+base-10));
}

/*!
    Returns the string converted to a \c long value to the base \a
    base, which is 10 by default and must be between 2 and 36.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.

    \sa number()
*/

long QString::toLong( bool *ok, int base ) const
{
    const QChar *p = unicode();
    long val = 0;
    int l = length();
    const long max_mult = INT_MAX / base;
    bool is_ok = FALSE;
    int neg = 0;
    if ( !p )
	goto bye;
    while ( l && p->isSpace() )                 // skip leading space
	l--,p++;
    if ( !l )
	goto bye;
    if ( *p == '-' ) {
	l--;
	p++;
	neg = 1;
    } else if ( *p == '+' ) {
	l--;
	p++;
    }

    // NOTE: toULong() code is similar
    if ( !l || !ok_in_base(*p,base) )
	goto bye;
    while ( l && ok_in_base(*p,base) ) {
	l--;
	int dv;
	if ( p->isDigit() ) {
	    dv = p->digitValue();
	} else {
	    if ( *p >= 'a' && *p <= 'z' )
		dv = *p - 'a' + 10;
	    else
		dv = *p - 'A' + 10;
	}
	if ( val > max_mult ||
	    (val == max_mult && dv > (INT_MAX % base) + neg) )
	    goto bye;
	val = base * val + dv;
	p++;
    }
    if ( neg )
	val = -val;
    while ( l && p->isSpace() )                 // skip trailing space
	l--,p++;
    if ( !l )
	is_ok = TRUE;
bye:
    if ( ok )
	*ok = is_ok;
    return is_ok ? val : 0;
}

/*!
    Returns the string converted to an \c {unsigned long} value to the
    base \a base, which is 10 by default and must be between 2 and 36.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.

    \sa number()
*/

ulong QString::toULong( bool *ok, int base ) const
{
    const QChar *p = unicode();
    ulong val = 0;
    int l = length();
    const ulong max_mult = UINT_MAX / base;
    bool is_ok = FALSE;
    if ( !p )
	goto bye;
    while ( l && p->isSpace() )                 // skip leading space
	l--,p++;
    if ( !l )
	goto bye;
    if ( *p == '+' )
	l--,p++;

    // NOTE: toLong() code is similar
    if ( !l || !ok_in_base(*p,base) )
	goto bye;
    while ( l && ok_in_base(*p,base) ) {
	l--;
	uint dv;
	if ( p->isDigit() ) {
	    dv = p->digitValue();
	} else {
	    if ( *p >= 'a' && *p <= 'z' )
		dv = *p - 'a' + 10;
	    else
		dv = *p - 'A' + 10;
	}
	if ( val > max_mult || (val == max_mult && dv > UINT_MAX % base) )
	    goto bye;
	val = base * val + dv;
	p++;
    }

    while ( l && p->isSpace() )                 // skip trailing space
	l--,p++;
    if ( !l )
	is_ok = TRUE;
bye:
    if ( ok )
	*ok = is_ok;
    return is_ok ? val : 0;
}

/*!
    Returns the string converted to a \c short value to the base \a
    base, which is 10 by default and must be between 2 and 36.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.
*/

short QString::toShort( bool *ok, int base ) const
{
    long v = toLong( ok, base );
    if ( ok && *ok && (v < -32768 || v > 32767) ) {
	*ok = FALSE;
	v = 0;
    }
    return (short)v;
}

/*!
    Returns the string converted to an \c {unsigned short} value to
    the base \a base, which is 10 by default and must be between 2 and
    36.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.
*/

ushort QString::toUShort( bool *ok, int base ) const
{
    ulong v = toULong( ok, base );
    if ( ok && *ok && (v > 65535) ) {
	*ok = FALSE;
	v = 0;
    }
    return (ushort)v;
}


/*!
    Returns the string converted to an \c int value to the base \a
    base, which is 10 by default and must be between 2 and 36.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.

    \code
	QString str( "FF" );
	bool ok;
	int hex = str.toInt( &ok, 16 );     // hex == 255, ok == TRUE
	int dec = str.toInt( &ok, 10 );     // dec == 0, ok == FALSE
    \endcode

    \sa number()
*/

int QString::toInt( bool *ok, int base ) const
{
    return (int)toLong( ok, base );
}

/*!
    Returns the string converted to an \c{unsigned int} value to the
    base \a base, which is 10 by default and must be between 2 and 36.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.

    \sa number()
*/

uint QString::toUInt( bool *ok, int base ) const
{
    return (uint)toULong( ok, base );
}

/*!
    Returns the string converted to a \c double value.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.

    \code
	QString string( "1234.56" );
	double a = string.toDouble();   // a == 1234.56
    \endcode

    \sa number()
*/

double QString::toDouble( bool *ok ) const
{
    char *end;

    const char *a = latin1();
    double val = strtod( a ? a : "", &end );
    if ( ok )
	*ok = ( a && *a && (end == 0 || (end - a) == (int)length()) );
    return val;
}

/*!
    Returns the string converted to a \c float value.

    If \a ok is not 0: if a conversion error occurs, \a *ok is set to
    FALSE; otherwise \a *ok is set to TRUE.

    \sa number()
*/

float QString::toFloat( bool *ok ) const
{
    return (float)toDouble( ok );
}


/*!
    Sets the string to the printed value of \a n in base \a base and
    returns a reference to the string.

    The base is 10 by default and must be between 2 and 36.

    \code
	QString string;
	string = string.setNum( 1234 );     // string == "1234"
    \endcode
*/

QString &QString::setNum( long n, int base )
{
#if defined(QT_CHECK_RANGE)
    if ( base < 2 || base > 36 ) {
	qWarning( "QString::setNum: Invalid base %d", base );
	base = 10;
    }
#endif
    char   charbuf[65*sizeof(QChar)];
    QChar *buf = (QChar*)charbuf;
    QChar *p = &buf[64];
    int  len = 0;
    bool neg;
    if ( n < 0 ) {
	neg = TRUE;
	if ( n == INT_MIN ) {
	    // Cannot always negate this special case
	    QString s1, s2;
	    s1.setNum(n/base, base );
	    s2.setNum((-(n+base))%base, base );
	    *this = s1 + s2;
	    return *this;
	}
	n = -n;
    } else {
	neg = FALSE;
    }
    do {
	*--p = "0123456789abcdefghijklmnopqrstuvwxyz"[((int)(n%base))];
	n /= base;
	++len;
    } while ( n );
    if ( neg ) {
	*--p = '-';
	++len;
    }
    return setUnicode( p, len );
}

/*!
    \overload

    Sets the string to the printed value of \a n in base \a base and
    returns a reference to the string.

    The base is 10 by default and must be between 2 and 36.
*/

QString &QString::setNum( ulong n, int base )
{
#if defined(QT_CHECK_RANGE)
    if ( base < 2 || base > 36 ) {
	qWarning( "QString::setNum: Invalid base %d", base );
	base = 10;
    }
#endif
    char   charbuf[65*sizeof(QChar)];
    QChar *buf = (QChar*)charbuf;
    QChar *p = &buf[64];
    int len = 0;
    do {
	*--p = "0123456789abcdefghijklmnopqrstuvwxyz"[((int)(n%base))];
	n /= base;
	len++;
    } while ( n );
    return setUnicode(p,len);
}

/*!
    \fn QString &QString::setNum( int n, int base )

    \overload

    Sets the string to the printed value of \a n in base \a base and
    returns a reference to the string.

    The base is 10 by default and must be between 2 and 36.
*/

/*!
    \fn QString &QString::setNum( uint n, int base )

    \overload

    Sets the string to the printed value of \a n in base \a base and
    returns a reference to the string.

    The base is 10 by default and must be between 2 and 36.
*/

/*!
    \fn QString &QString::setNum( short n, int base )

    \overload

    Sets the string to the printed value of \a n in base \a base and
    returns a reference to the string.

    The base is 10 by default and must be between 2 and 36.
*/

/*!
    \fn QString &QString::setNum( ushort n, int base )

    \overload

    Sets the string to the printed value of \a n in base \a base and
    returns a reference to the string.

    The base is 10 by default and must be between 2 and 36.
*/

/*!
    \overload

    Sets the string to the printed value of \a n, formatted in format
    \a f with precision \a prec, and returns a reference to the
    string.

    The format \a f can be 'f', 'F', 'e', 'E', 'g' or 'G'. See \link
    #arg-formats arg \endlink() for an explanation of the formats.
*/

QString &QString::setNum( double n, char f, int prec )
{
#if defined(QT_CHECK_RANGE)
    if ( !(f=='f' || f=='F' || f=='e' || f=='E' || f=='g' || f=='G') ) {
	qWarning( "QString::setNum: Invalid format char '%c'", f );
	f = 'f';
    }
#endif
    char format[20];
    char *fs = format; // generate format string: %.<prec>l<f>
    *fs++ = '%';
    if ( prec >= 0 ) {
	if ( prec > 99 ) // rather than crash in sprintf()
	    prec = 99;
	*fs++ = '.';
	if ( prec >= 10 ) {
	    *fs++ = prec / 10 + '0';
	    *fs++ = prec % 10 + '0';
	} else {
	    *fs++ = prec + '0';
	}
    }
    *fs++ = 'l';
    *fs++ = f;
    *fs = '\0';
#ifndef QT_NO_SPRINTF
    sprintf( format, n );
    return *this;
#else
    char buf[512];
    ::sprintf( buf, format, n );        // snprintf is unfortunately not portable
    return setLatin1(buf);
#endif
}

/*!
    \fn QString &QString::setNum( float n, char f, int prec )

    \overload

    Sets the string to the printed value of \a n, formatted in format
    \a f with precision \a prec, and returns a reference to the
    string.

    The format \a f can be 'f', 'F', 'e', 'E', 'g' or 'G'. See \link
    #arg-formats arg \endlink() for an explanation of the formats.
*/


/*!
    A convenience function that returns a string equivalent of the
    number \a n to base \a base, which is 10 by default and must be
    between 2 and 36.

    \code
	long a = 63;
	QString str = QString::number( a, 16 );             // str == "3f"
	QString str = QString::number( a, 16 ).upper();     // str == "3F"
    \endcode

    \sa setNum()
*/
QString QString::number( long n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
    \overload

    \sa setNum()
*/
QString QString::number( ulong n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
    \overload

    \sa setNum()
*/
QString QString::number( int n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
    \overload

    A convenience factory function that returns a string
    representation of the number \a n to the base \a base, which is 10
    by default and must be between 2 and 36.

    \sa setNum()
*/
QString QString::number( uint n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
    \overload

    Argument \a n is formatted according to the \a f format specified,
    which is \c g by default, and can be any of the following:

    \table
    \header \i Format \i Meaning
    \row \i \c e \i format as [-]9.9e[+|-]999
    \row \i \c E \i format as [-]9.9E[+|-]999
    \row \i \c f \i format as [-]9.9
    \row \i \c g \i use \c e or \c f format, whichever is the most concise
    \row \i \c G \i use \c E or \c f format, whichever is the most concise
    \endtable

    With 'e', 'E', and 'f', \a prec is the number of digits after the
    decimal point. With 'g' and 'G', \a prec is the maximum number of
    significant digits (trailing zeroes are omitted).

    \code
    double d = 12.34;
    QString ds = QString( "'E' format, precision 3, gives %1" )
		    .arg( d, 0, 'E', 3 );
    // ds == "1.234E+001"
    \endcode

    \sa setNum()
    */
QString QString::number( double n, char f, int prec )
{
    QString s;
    s.setNum( n, f, prec );
    return s;
}


/*! \obsolete

  Sets the character at position \a index to \a c and expands the
  string if necessary, filling with spaces.

  This method is redundant in Qt 3.x, because operator[] will expand
  the string as necessary.
*/

void QString::setExpand( uint index, QChar c )
{
    int spaces = index - d->len;
    at(index) = c;
    while (spaces-->0)
	d->unicode[--index]=' ';
}


/*!
  \fn const char* QString::data() const

  \obsolete

  Returns a pointer to a '\0'-terminated classic C string.

  In Qt 1.x, this returned a char* allowing direct manipulation of the
  string as a sequence of bytes. In Qt 2.x where QString is a Unicode
  string, char* conversion constructs a temporary string, and hence
  direct character operations are meaningless.
*/

/*!
    \fn bool QString::operator!() const

    Returns TRUE if this is a null string; otherwise returns FALSE.

    \code
	QString name = getName();
	if ( !name )
	    name = "Rodney";
    \endcode

    Note that if you say

    \code
	QString name = getName();
	if ( name )
	    doSomethingWith(name);
    \endcode

    It will call "operator const char*()", which is inefficent; you
    may wish to define the macro \c QT_NO_ASCII_CAST when writing code
    which you wish to remain Unicode-clean.

    When you want the above semantics, use:

    \code
	QString name = getName();
	if ( !name.isNull() )
	    doSomethingWith(name);
    \endcode

    \sa isEmpty()
*/


/*!
    \fn QString& QString::append( const QString& str )

    Appends \a str to the string and returns a reference to the
    result.

    \code
	string = "Test";
	string.append( "ing" );        // string == "Testing"
    \endcode

    Equivalent to operator+=().
*/

/*!
    \fn QString& QString::append( char ch )

    \overload

    Appends character \a ch to the string and returns a reference to
    the result.

    Equivalent to operator+=().
*/

/*!
    \fn QString& QString::append( QChar ch )

    \overload

    Appends character \a ch to the string and returns a reference to
    the result.

    Equivalent to operator+=().
*/

/*! \fn QString& QString::append( const QByteArray &str )
  \overload

  Appends \a str to the string and returns a reference to the result.

  Equivalent to operator+=().
 */

/*! \fn QString& QString::append( const std::string &str )
  \overload

  Appends \a str to the string and returns a reference to the result.

  Equivalent to operator+=().
 */


/*! \fn QString& QString::append( const char *str )
  \overload

  Appends \a str to the string and returns a reference to the result.

  Equivalent to operator+=().
 */

/*!
    Appends \a str to the string and returns a reference to the string.
*/
QString& QString::operator+=( const QString &str )
{
    uint len1 = length();
    uint len2 = str.length();
    if ( len2 ) {
	setLength(len1+len2);
	memcpy( d->unicode+len1, str.unicode(), sizeof(QChar)*len2 );
    } else if ( isNull() && !str.isNull() ) {   // ## just for 1.x compat:
	*this = fromLatin1( "" );
    }
    return *this;
}

/*!
    \overload

  Appends \a str to the string and returns a reference to the string.
*/
QString& QString::operator+=( const char *str )
{
    if ( str ) {
#ifndef QT_NO_TEXTCODEC
	if ( QTextCodec::codecForCStrings() )
	    return operator+=( fromAscii( str ) );
#endif

	uint len1 = length();
	uint len2 = strlen( str );
	if ( len2 ) {
	    setLength(len1+len2);
	    uint i = 0;
	    while( i < len2 ) {
		d->unicode[len1+i] = str[i];
		i++;
	    }
	} else if ( isNull() ) {   // ## just for 1.x compat:
	    *this = fromLatin1( "" );
	}
    }
    return *this;
}

/*! \overload

  Appends \a c to the string and returns a reference to the string.
*/

QString &QString::operator+=( QChar c )
{
    setLength(length()+1);
    d->unicode[length()-1] = c;
    return *this;
}

/*!
    \overload

    Appends \a c to the string and returns a reference to the string.
*/

QString &QString::operator+=( char c )
{
#ifndef QT_NO_TEXTCODEC
    if ( QTextCodec::codecForCStrings() )
	return operator+=( fromAscii( &c, 1 ) );
#endif
    setLength(length()+1);
    d->unicode[length()-1] = c;
    return *this;
}

/*!
  \fn QString &QString::operator+=( const QByteArray &str )
  \overload

  Appends \a str to the string and returns a reference to the string.
*/

/*!
  \fn QString &QString::operator+=( const std::string &str )
  \overload

  Appends \a str to the string and returns a reference to the string.
*/



/*!
    \fn char QChar::latin1() const

    Returns the Latin-1 value of this character, or 0 if it
    cannot be represented in Latin-1.
*/


/*!
    Returns a Latin-1 representation of the string. The
    returned value is undefined if the string contains non-Latin-1
    characters. If you want to convert strings into formats other than
    Unicode, see the QTextCodec classes.

    This function is mainly useful for boot-strapping legacy code to
    use Unicode.

    The result remains valid so long as one unmodified copy of the
    source string exists.

    \sa fromLatin1(), ascii(), utf8(), local8Bit()
*/
const char* QString::latin1() const
{
    if ( !d->ascii  || !d->islatin1 ) {
	d->ascii = unicodeToLatin1( d->unicode, d->len );
	d->islatin1 = TRUE;
    }
    return d->ascii;
}

/*!
    Returns an 8-bit ASCII representation of the string.

    If a codec has been set using QTextCodec::codecForCStrings(),
    it is used to convert Unicode to 8-bit char. Otherwise, this function
    does the same as latin1().

    \sa fromAscii(), latin1(), utf8(), local8Bit()
*/
const char* QString::ascii() const
{
#ifndef QT_NO_TEXTCODEC
    if ( QTextCodec::codecForCStrings() ) {
	if ( !d->ascii || d->islatin1 ) {
	    QCString s = QTextCodec::codecForCStrings()->fromUnicode( *this );
	    s.detach();
	    d->ascii = s.data();
	    d->islatin1 = FALSE;
	    s.resetRawData( s.data(), s.size() ); // we have stolen the data
	}
	return d->ascii;
    }
#endif // QT_NO_TEXTCODEC
    return latin1();
}

/*!
    Returns the string encoded in UTF-8 format.

    See QTextCodec for more diverse coding/decoding of Unicode strings.

    \sa fromUtf8(), ascii(), latin1(), local8Bit()
*/
QCString QString::utf8() const
{
    int l = length();
    int rlen = l*3+1;
    QCString rstr(rlen);
    uchar* cursor = (uchar*)rstr.data();
    const QChar *ch = d->unicode;
    for (int i=0; i<l; i++) {
	ushort u = ch->unicode();
 	if ( u < 0x80 ) {
 	    *cursor++ = (uchar)u;
 	} else {
 	    if ( u < 0x0800 ) {
		*cursor++ = 0xc0 | ((uchar) (u >> 6));
 	    } else {
 		*cursor++ = 0xe0 | ((uchar) (u >> 12));
 		*cursor++ = 0x80 | ( ((uchar) (u >> 6)) & 0x3f);
 	    }
 	    *cursor++ = 0x80 | ((uchar) (u&0x3f));
 	}
 	ch++;
    }
    rstr.truncate( cursor - (uchar*)rstr.data() );
    return rstr;
}

/*!
    Returns the Unicode string decoded from the first \a len
    characters of \a utf8, ignoring the rest of \a utf8. If \a len is
    -1 then the length of \a utf8 is used. If \a len is bigger than
    the length of \a utf8 then it will use the length of \a utf8.

    \code
	QString str = QString::fromUtf8( "123456789", 5 );
	// str == "12345"
    \endcode

    See QTextCodec for more diverse coding/decoding of Unicode strings.
*/
QString QString::fromUtf8( const char* utf8, int len )
{
    if ( !utf8 )
	return QString::null;

    if ( len < 0 )
	len = strlen( utf8 );
    QString result;
    result.setLength( len ); // worst case
    QChar *qch = (QChar *)result.unicode();
    ushort uc = 0;
    int need = 0;
    for (int i=0; i<len; i++) {
	uchar ch = utf8[i];
	if (need) {
	    if ( (ch&0xc0) == 0x80 ) {
		uc = (uc << 6) | (ch & 0x3f);
		need--;
		if ( !need ) {
		    *qch = uc;
		    qch++;
		}
	    } else {
		// error
		*qch = QChar::replacement;
		qch++;
		need = 0;
	    }
	} else {
	    if ( ch < 128 ) {
		*qch = ch;
		qch++;
	    } else if ( (ch&0xe0) == 0xc0 ) {
		uc = ch &0x1f;
		need = 1;
	    } else if ( (ch&0xf0) == 0xe0 ) {
		uc = ch &0x0f;
		need = 2;
	    }
	}
    }
    result.truncate( qch - result.unicode() );
    return result;
}

/*!
    Returns the Unicode string decoded from the first \a len
    characters of \a ascii, ignoring the rest of \a ascii. If \a len
    is -1 then the length of \a ascii is used. If \a len is bigger
    than the length of \a ascii then it will use the length of \a
    ascii.

    If a codec has been set using QTextCodec::codecForCStrings(),
    it is used to convert Unicode to 8-bit char. Otherwise, this function
    does the same as fromLatin1().

    This is the same as the QString(const char*) constructor, but you
    can make that constructor invisible if you compile with the define
    \c QT_NO_CAST_ASCII, in which case you can explicitly create a
    QString from 8-bit ASCII text using this function.

    \code
	QString str = QString::fromAscii( "123456789", 5 );
	// str == "12345"
    \endcode
 */
QString QString::fromAscii( const char* ascii, int len )
{
#ifndef QT_NO_TEXTCODEC
    if ( QTextCodec::codecForCStrings() ) {
	if ( !ascii )
	    return QString::null;
	if ( len < 0 )
	    len = strlen( ascii );
	if ( len == 0 || *ascii == '\0' )
	    return QString::fromLatin1( "" );
	return QTextCodec::codecForCStrings()->toUnicode( ascii, len );
    }
#endif
    return fromLatin1( ascii, len );
}


/*!
    Returns the Unicode string decoded from the first \a len
    characters of \a chars, ignoring the rest of \a chars. If \a len
    is -1 then the length of \a chars is used. If \a len is bigger
    than the length of \a chars then it will use the length of \a
    chars.

    \sa fromAscii()
*/
QString QString::fromLatin1( const char* chars, int len )
{
    uint l;
    QChar *uc;
    if ( len < 0 )
	 len = -1;
    uc = internalLatin1ToUnicode( chars, &l, len );
    return QString( new QStringData(uc, l, l), TRUE );
}

/*!
    \fn const QChar* QString::unicode() const

    Returns the Unicode representation of the string. The result
    remains valid until the string is modified.
*/

/*!
    Returns the string encoded in a locale-specific format. On X11,
    this is the QTextCodec::codecForLocale(). On Windows, it is a
    system-defined encoding. On Mac OS X, this always uses UTF-8 as
    the encoding.

    See QTextCodec for more diverse coding/decoding of Unicode
    strings.

    \sa fromLocal8Bit(), ascii(), latin1(), utf8()
*/

QCString QString::local8Bit() const
{
#ifdef QT_NO_TEXTCODEC
    return latin1();
#else
#ifdef Q_WS_X11
    QTextCodec* codec = QTextCodec::codecForLocale();
    return codec
	    ? codec->fromUnicode(*this)
	    : QCString(latin1());
#endif
#if defined( Q_WS_MACX )
    return utf8();
#endif
#if defined( Q_WS_MAC9 )
    return QCString(latin1()); //I'm evil..
#endif
#ifdef Q_WS_WIN
    return qt_winQString2MB( *this );
#endif
#ifdef Q_WS_QWS
    return utf8(); // ### if there is any 8 bit format supported?
#endif
#endif
}

/*!
    Returns the Unicode string decoded from the first \a len
    characters of \a local8Bit, ignoring the rest of \a local8Bit. If
    \a len is -1 then the length of \a local8Bit is used. If \a len is
    bigger than the length of \a local8Bit then it will use the length
    of \a local8Bit.

    \code
	QString str = QString::fromLocal8Bit( "123456789", 5 );
	// str == "12345"
    \endcode

    \a local8Bit is assumed to be encoded in a locale-specific format.

    See QTextCodec for more diverse coding/decoding of Unicode strings.
*/
QString QString::fromLocal8Bit( const char* local8Bit, int len )
{
#ifdef QT_NO_TEXTCODEC
    return fromLatin1( local8Bit, len );
#else

    if ( !local8Bit )
	return QString::null;
#ifdef Q_WS_X11
    QTextCodec* codec = QTextCodec::codecForLocale();
    if ( len < 0 )
	len = strlen( local8Bit );
    return codec
	    ? codec->toUnicode( local8Bit, len )
	    : fromLatin1( local8Bit, len );
#endif
#if defined( Q_WS_MAC )
    return fromUtf8(local8Bit,len);
#endif
// Should this be OS_WIN32?
#ifdef Q_WS_WIN
    if ( len >= 0 ) {
	QCString s(local8Bit,len+1);
	return qt_winMB2QString(s);
    }
    return qt_winMB2QString( local8Bit );
#endif
#ifdef Q_WS_QWS
    return fromUtf8(local8Bit,len);
#endif
#endif // QT_NO_TEXTCODEC
}

/*!
    \fn QString::operator const char *() const

    Returns latin1(). Be sure to see the warnings documented in the
    latin1() function. Note that for new code which you wish to be
    strictly Unicode-clean, you can define the macro \c
    QT_NO_ASCII_CAST when compiling your code to hide this function so
    that automatic casts are not done. This has the added advantage
    that you catch the programming error described in operator!().
*/

/*!
    \fn QString::operator std::string() const

    Returns ascii().
*/


/*!
    Returns the QString as a zero terminated array of unsigned shorts
    if the string is not null; otherwise returns zero.

    The result remains valid so long as one unmodified
    copy of the source string exists.
*/
const unsigned short *QString::ucs2() const
{
    if ( ! d->unicode )
	return 0;
    unsigned int len = d->len;
    if ( d->maxl < len + 1 ) {
	// detach, grow or shrink
	uint newMax = computeNewMax( len + 1 );
	QChar* nd = QT_ALLOC_QCHAR_VEC( newMax );
	if ( nd ) {
	    if ( d->unicode )
		memcpy( nd, d->unicode, sizeof(QChar)*len );
	    ((QString *)this)->deref();
	    ((QString *)this)->d = new QStringData( nd, len, newMax );
	}
    }
    d->unicode[len] = 0;
    return (unsigned short *) d->unicode;
}

/*!
  Constructs a string that is a deep copy of \a str, interpreted as a
  UCS2 encoded, zero terminated, Unicode string.

  If \a str is 0, then a null string is created.

  \sa isNull()
*/
QString QString::fromUcs2( const unsigned short *str )
{
    if ( !str ) {
	return QString::null;
    } else {
	int length = 0;
	while( str[length] != 0 )
	    length++;
	QChar* uc = QT_ALLOC_QCHAR_VEC( length );
	memcpy( uc, str, length*sizeof(QChar) );
	return QString( new QStringData( uc, length, length ), TRUE );
    }
}

/*!
  \fn QChar QString::at( uint ) const

    Returns the character at index \a i, or 0 if \a i is beyond the
    length of the string.

    \code
	const QString string( "abcdefgh" );
	QChar ch = string.at( 4 );
	// ch == 'e'
    \endcode

    If the QString is not const (i.e. const QString) or const& (i.e.
    const QString &), then the non-const overload of at() will be used
    instead.
*/

/*!
    \fn QChar QString::constref(uint i) const

    Returns the QChar at index \a i by value.

    Equivalent to at(\a i).

    \sa ref()
*/

/*!
    \fn QChar& QString::ref(uint i)

    Returns the QChar at index \a i by reference, expanding the string
    with QChar::null if necessary. The resulting reference can be
    assigned to, or otherwise used immediately, but becomes invalid
    once furher modifications are made to the string.

    \code
	QString string("ABCDEF");
	QChar ch = string.ref( 3 );         // ch == 'D'
    \endcode

    \sa constref()
*/

/*!
    \fn QChar QString::operator[]( int ) const

    Returns the character at index \a i, or QChar::null if \a i is
    beyond the length of the string.

    If the QString is not const (i.e., const QString) or const\&
    (i.e., const QString\&), then the non-const overload of operator[]
    will be used instead.
*/

/*!
    \fn QCharRef QString::operator[]( int )

    \overload

    The function returns a reference to the character at index \a i.
    The resulting reference can then be assigned to, or used
    immediately, but it will become invalid once further modifications
    are made to the original string.

    If \a i is beyond the length of the string then the string is
    expanded with QChar::nulls, so that the QCharRef references a
    valid (null) character in the string.

    The QCharRef internal class can be used much like a constant
    QChar, but if you assign to it, you change the original string
    (which will detach itself because of QString's copy-on-write
    semantics). You will get compilation errors if you try to use the
    result as anything but a QChar.
*/

/*!
    \fn QCharRef QString::at( uint i )

    \overload

    The function returns a reference to the character at index \a i.
    The resulting reference can then be assigned to, or used
    immediately, but it will become invalid once further modifications
    are made to the original string.

    If \a i is beyond the length of the string then the string is
    expanded with QChar::null.
*/

/*
  Internal chunk of code to handle the
  uncommon cases of at() above.
*/
void QString::subat( uint i )
{
    uint olen = d->len;
    if ( i >= olen ) {
	setLength( i+1 );               // i is index; i+1 is needed length
	for ( uint j=olen; j<=i; j++ )
	    d->unicode[j] = QChar::null;
    } else {
	// Just be sure to detach
	real_detach();
    }
}


/*!
    Resizes the string to \a len characters and copies \a unicode into
    the string. If \a unicode is 0, nothing is copied, but the
    string is still resized to \a len. If \a len is zero, then the
    string becomes a \link isNull() null\endlink string.

    \sa setLatin1(), isNull()
*/

QString& QString::setUnicode( const QChar *unicode, uint len )
{
    if ( len == 0 ) {                           // set to null string
	if ( d != shared_null ) {               // beware of nullstring being set to nullstring
	    deref();
	    d = shared_null ? shared_null : makeSharedNull();
	    d->ref();
	}
    } else if ( d->count != 1 || len > d->maxl ||
		( len * 4 < d->maxl && d->maxl > 4 ) ) {
	// detach, grown or shrink
	uint newMax = computeNewMax( len );
	QChar* nd = QT_ALLOC_QCHAR_VEC( newMax );
	if ( unicode )
	    memcpy( nd, unicode, sizeof(QChar)*len );
	deref();
	d = new QStringData( nd, len, newMax );
    } else {
	d->len = len;
	d->setDirty();
	if ( unicode )
	    memcpy( d->unicode, unicode, sizeof(QChar)*len );
    }
    return *this;
}

/*!
    Resizes the string to \a len characters and copies \a
    unicode_as_ushorts into the string (on some X11 client platforms
    this will involve a byte-swapping pass).

    If \a unicode_as_ushorts is 0, nothing is copied, but the string
    is still resized to \a len. If \a len is zero, the string becomes
    a \link isNull() null\endlink string.

    \sa setLatin1(), isNull()
*/
QString& QString::setUnicodeCodes( const ushort* unicode_as_ushorts, uint len )
{
     return setUnicode((const QChar*)unicode_as_ushorts, len);
}


/*!
    Sets this string to \a str, interpreted as a classic 8-bit ASCII C
    string. If \a len is -1 (the default), then it is set to
    strlen(str).

    If \a str is 0 a null string is created. If \a str is "", an empty
    string is created.

    \sa isNull(), isEmpty()
*/

QString &QString::setAscii( const char *str, int len )
{
#ifndef QT_NO_TEXTCODEC
    if ( QTextCodec::codecForCStrings() ) {
	*this = QString::fromAscii( str, len );
	return *this;
    }
#endif // QT_NO_TEXTCODEC
    return setLatin1( str, len );
}

/*!
    Sets this string to \a str, interpreted as a classic Latin1 C
    string. If \a len is -1 (the default), then it is set to
    strlen(str).

    If \a str is 0 a null string is created. If \a str is "", an empty
    string is created.

    \sa isNull(), isEmpty()
*/

QString &QString::setLatin1( const char *str, int len )
{
    if ( str == 0 )
	return setUnicode(0,0);
    if ( len < 0 )
	len = strlen( str );
    if ( len == 0 ) {                           // won't make a null string
	*this = QString::fromLatin1( "" );
    } else {
	setUnicode( 0, len );                   // resize but not copy
	QChar *p = d->unicode;
	while ( len-- )
	    *p++ = *str++;
    }
    return *this;
}

/*! \internal
 */
void QString::checkSimpleText() const
{
    QChar *p = d->unicode;
    QChar *end = p + d->len;
    while( p < end ) {
	ushort uc = p->unicode();
	// sort out regions of complex text formatting
	if ( uc > 0x058f && ( uc < 0x1100 || uc > 0xfb0f ) ) {
	    d->issimpletext = FALSE;
	    return;
	}
	p++;
    }
    d->issimpletext = TRUE;
}

/*! \fn bool QString::simpleText() const
  \internal
*/

/*! \internal
 */
bool QString::isRightToLeft() const
{
    int len = length();
    QChar *p = d->unicode;
    while( len-- ) {
	switch( ::direction( *p ) )
	{
	case QChar::DirL:
	case QChar::DirLRO:
	case QChar::DirLRE:
	    return FALSE;
	case QChar::DirR:
	case QChar::DirAL:
	case QChar::DirRLO:
	case QChar::DirRLE:
	    return TRUE;
	default:
	    break;
	}
	++p;
    }
    return FALSE;
}


/*!
    \fn int QString::compare( const QString & s1, const QString & s2 )

    Lexically compares \a s1 with \a s2 and returns an integer less
    than, equal to, or greater than zero if \a s1 is less than, equal
    to, or greater than \a s2.

    The comparison is based exclusively on the numeric Unicode values
    of the characters and is very fast, but is not what a human would
    expect. Consider sorting user-interface strings with
    QString::localeAwareCompare().

    \code
	int a = QString::compare( "def", "abc" );   // a > 0
	int b = QString::compare( "abc", "def" );   // b < 0
	int c = QString::compare(" abc", "abc" );   // c == 0
    \endcode
*/

/*!
    \overload

   Lexically compares this string with \a s and returns an integer
   less than, equal to, or greater than zero if it is less than, equal
   to, or greater than \a s.
*/
int QString::compare( const QString& s ) const
{
    return ucstrcmp( *this, s );
}

/*!
    \fn int QString::localeAwareCompare( const QString & s1, const QString & s2 )

    Compares \a s1 with \a s2 and returns an integer less than, equal
    to, or greater than zero if \a s1 is less than, equal to, or
    greater than \a s2.

    The comparison is performed in a locale- and also
    platform-dependent manner. Use this function to present sorted
    lists of strings to the user.

    \sa QString::compare() QTextCodec::locale()
*/

/*!
    \overload

    Compares this string with \a s.
*/

#if !defined(CSTR_LESS_THAN)
#define CSTR_LESS_THAN    1
#define CSTR_EQUAL        2
#define CSTR_GREATER_THAN 3
#endif

int QString::localeAwareCompare( const QString& s ) const
{
    // do the right thing for null and empty
    if ( isEmpty() || s.isEmpty() )
	return compare( s );

#if defined(Q_WS_WIN)
    int res;
    QT_WA( {
	const TCHAR* s1 = (TCHAR*)ucs2();
	const TCHAR* s2 = (TCHAR*)s.ucs2();
	res = CompareStringW( LOCALE_USER_DEFAULT, 0, s1, length(), s2, s.length() );
    } , {
	QCString s1 = local8Bit();
	QCString s2 = s.local8Bit();
	res = CompareStringA( LOCALE_USER_DEFAULT, 0, s1.data(), s1.length(), s2.data(), s2.length() );
    } );

    switch ( res ) {
    case CSTR_LESS_THAN:
	return -1;
    case CSTR_GREATER_THAN:
	return 1;
    default:
	return 0;
    }
#elif defined(Q_WS_X11)
    // declared in <string.h>
    int delta = strcoll( local8Bit(), s.local8Bit() );
    if ( delta == 0 )
	delta = ucstrcmp( *this, s );
    return delta;
#else
    return ucstrcmp( *this, s );
#endif
}

bool operator==( const QString &s1, const QString &s2 )
{
    if ( s1.unicode() == s2.unicode() )
	return TRUE;
    return (s1.length() == s2.length()) && s1.isNull() == s2.isNull() &&
	 (memcmp((char*)s1.unicode(),(char*)s2.unicode(),
		 s1.length()*sizeof(QChar)) == 0 );
}

bool operator!=( const QString &s1, const QString &s2 )
{ return !(s1==s2); }

bool operator<( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<=( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator>( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>=( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) >= 0; }


bool operator==( const QString &s1, const char *s2 )
{
    if ( !s2 )
	return s1.isNull();

    int len = s1.length();
    const QChar *uc = s1.unicode();
    while ( len ) {
	if ( !(*s2) || uc->unicode() != (uchar) *s2 )
	    return FALSE;
	++uc;
	++s2;
	--len;
    }
    return !*s2;
}

bool operator==( const char *s1, const QString &s2 )
{ return (s2 == s1); }

bool operator!=( const QString &s1, const char *s2 )
{ return !(s1==s2); }

bool operator!=( const char *s1, const QString &s2 )
{ return !(s1==s2); }

bool operator<( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<=( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator<=( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator>( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>=( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) >= 0; }

bool operator>=( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) >= 0; }


/*****************************************************************************
  Documentation for QString related functions
 *****************************************************************************/

/*!
    \fn bool operator==( const QString &s1, const QString &s2 )

    \relates QString

    Returns TRUE if \a s1 is equal to \a s2; otherwise returns FALSE.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) != 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator==( const QString &s1, const char *s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is equal to \a s2; otherwise returns FALSE.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) == 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator==( const char *s1, const QString &s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is equal to \a s2; otherwise returns FALSE.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) == 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator!=( const QString &s1, const QString &s2 )

    \relates QString

    Returns TRUE if \a s1 is not equal to \a s2; otherwise returns FALSE.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) != 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator!=( const QString &s1, const char *s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is not equal to \a s2; otherwise returns FALSE.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) != 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator!=( const char *s1, const QString &s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is not equal to \a s2; otherwise returns FALSE.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) != 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator<( const QString &s1, const char *s2 )

    \relates QString

    Returns TRUE if \a s1 is lexically less than \a s2; otherwise returns FALSE.
    The comparison is case sensitive.

    Equivalent to compare(\a s1, \a s2) \< 0.
*/

/*!
    \fn bool operator<( const char *s1, const QString &s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is lexically less than \a s2; otherwise returns FALSE.
    The comparison is case sensitive.

    Equivalent to compare(\a s1, \a s2) \< 0.
*/

/*!
    \fn bool operator<=( const QString &s1, const char *s2 )

    \relates QString

    Returns TRUE if \a s1 is lexically less than or equal to \a s2;
    otherwise returns FALSE.
    The comparison is case sensitive.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1,\a s2) \<= 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator<=( const char *s1, const QString &s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is lexically less than or equal to \a s2;
    otherwise returns FALSE.
    The comparison is case sensitive.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) \<= 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator>( const QString &s1, const char *s2 )

    \relates QString

    Returns TRUE if \a s1 is lexically greater than \a s2; otherwise
    returns FALSE.
    The comparison is case sensitive.

    Equivalent to compare(\a s1, \a s2) \> 0.
*/

/*!
    \fn bool operator>( const char *s1, const QString &s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is lexically greater than \a s2; otherwise
    returns FALSE.
    The comparison is case sensitive.

    Equivalent to compare(\a s1, \a s2) \> 0.
*/

/*!
    \fn bool operator>=( const QString &s1, const char *s2 )

    \relates QString

    Returns TRUE if \a s1 is lexically greater than or equal to \a s2;
    otherwise returns FALSE.
    The comparison is case sensitive.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) \>= 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn bool operator>=( const char *s1, const QString &s2 )

    \overload
    \relates QString

    Returns TRUE if \a s1 is lexically greater than or equal to \a s2;
    otherwise returns FALSE.
    The comparison is case sensitive.
    Note that a null string is not equal to a not-null empty string.

    Equivalent to compare(\a s1, \a s2) \>= 0.

    \sa isNull(), isEmpty()
*/

/*!
    \fn const QString operator+( const QString &s1, const QString &s2 )

    \relates QString

    Returns a string which is the result of concatenating the string
    \a s1 and the string \a s2.

    Equivalent to \a {s1}.append(\a s2).
*/

/*!
    \fn const QString operator+( const QString &s1, const char *s2 )

    \overload
    \relates QString

    Returns a string which is the result of concatenating the string
    \a s1 and character \a s2.

    Equivalent to \a {s1}.append(\a s2).
*/

/*!
    \fn const QString operator+( const char *s1, const QString &s2 )

    \overload
    \relates QString

    Returns a string which is the result of concatenating the
    character \a s1 and string \a s2.
*/

/*!
    \fn const QString operator+( const QString &s, char c )

    \overload
    \relates QString

    Returns a string which is the result of concatenating the string
    \a s and character \a c.

    Equivalent to \a {s}.append(\a c).
*/

/*!
    \fn const QString operator+( char c, const QString &s )

    \overload
    \relates QString

    Returns a string which is the result of concatenating the
    character \a c and string \a s.

    Equivalent to \a {s}.prepend(\a c).
*/


/*****************************************************************************
  QString stream functions
 *****************************************************************************/
#ifndef QT_NO_DATASTREAM
/*!
    \relates QString

    Writes the string \a str to the stream \a s.

    See also \link datastreamformat.html Format of the QDataStream operators \endlink
*/

QDataStream &operator<<( QDataStream &s, const QString &str )
{
    if ( s.version() == 1 ) {
	QCString l( str.latin1() );
	s << l;
    }
    else {
	int byteOrder = s.byteOrder();
	const QChar* ub = str.unicode();
	if ( ub || s.version() < 3 ) {
	    static const uint auto_size = 1024;
	    char t[auto_size];
	    char *b;
	    if ( str.length()*sizeof(QChar) > auto_size ) {
		b = new char[str.length()*sizeof(QChar)];
	    } else {
		b = t;
	    }
	    int l = str.length();
	    char *c=b;
	    while ( l-- ) {
		if ( byteOrder == QDataStream::BigEndian ) {
		    *c++ = (char)ub->row();
		    *c++ = (char)ub->cell();
		} else {
		    *c++ = (char)ub->cell();
		    *c++ = (char)ub->row();
		}
		ub++;
	    }
	    s.writeBytes( b, sizeof(QChar)*str.length() );
	    if ( str.length()*sizeof(QChar) > auto_size )
		delete [] b;
	} else {
	    // write null marker
	    s << (Q_UINT32)0xffffffff;
	}
    }
    return s;
}

/*!
    \relates QString

    Reads a string from the stream \a s into string \a str.

    See also \link datastreamformat.html Format of the QDataStream operators \endlink
*/

QDataStream &operator>>( QDataStream &s, QString &str )
{
#ifdef QT_QSTRING_UCS_4
#if defined(Q_CC_GNU)
#warning "operator>> not working properly"
#endif
#endif
    if ( s.version() == 1 ) {
	QCString l;
	s >> l;
	str = QString( l );
    }
    else {
	Q_UINT32 bytes;
	s >> bytes;                                     // read size of string
	if ( bytes == 0xffffffff ) {                    // null string
	    str = QString::null;
	} else if ( bytes > 0 ) {                       // not empty
	    int byteOrder = s.byteOrder();
	    str.setLength( bytes/2 );
	    QChar* ch = str.d->unicode;
	    static const uint auto_size = 1024;
	    char t[auto_size];
	    char *b;
	    if ( bytes > auto_size ) {
		b = new char[bytes];
	    } else {
		b = t;
	    }
	    s.readRawBytes( b, bytes );
	    int bt = bytes/2;
	    char *oldb = b;
	    while ( bt-- ) {
		if ( byteOrder == QDataStream::BigEndian )
		    *ch++ = (ushort) (((ushort)b[0])<<8) | (uchar)b[1];
		else
		    *ch++ = (ushort) (((ushort)b[1])<<8) | (uchar)b[0];
		b += 2;
	    }
	    if ( bytes > auto_size )
		delete [] oldb;
	} else {
	    str = "";
	}
    }
    return s;
}
#endif // QT_NO_DATASTREAM

/*****************************************************************************
  QConstString member functions
 *****************************************************************************/

/*!
  \class QConstString qstring.h
  \reentrant
  \ingroup text
  \brief The QConstString class provides string objects using constant Unicode data.

    In order to minimize copying, highly optimized applications can
    use QConstString to provide a QString-compatible object from
    existing Unicode data. It is then the programmer's responsibility
    to ensure that the Unicode data exists for the entire lifetime of
    the QConstString object.

    A QConstString is created with the QConstString constructor. The
    string held by the object can be obtained by calling string().
*/

/*!
    Constructs a QConstString that uses the first \a length Unicode
    characters in the array \a unicode. Any attempt to modify copies
    of the string will cause it to create a copy of the data, thus it
    remains forever unmodified.

    The data in \a unicode is not copied. The caller must be able to
    guarantee that \a unicode will not be deleted or modified.
*/
QConstString::QConstString( const QChar* unicode, uint length ) :
    QString( new QStringData( (QChar*)unicode, length, length ), TRUE )
{
}

/*!
    Destroys the QConstString, creating a copy of the data if other
    strings are still using it.
*/
QConstString::~QConstString()
{
    if ( d->count > 1 ) {
	QChar* cp = QT_ALLOC_QCHAR_VEC( d->len );
	memcpy( cp, d->unicode, d->len*sizeof(QChar) );
	d->unicode = cp;
    } else {
	d->unicode = 0;
    }

    // The original d->unicode is now unlinked.
}

/*!
    \fn const QString& QConstString::string() const

    Returns a constant string referencing the data passed during
    construction.
*/

/*!
    Returns TRUE if the string starts with \a s; otherwise returns
    FALSE.

    \code
	QString string("Bananas");
	bool a = string.startsWith("Ban");      //  a == TRUE
    \endcode

    \sa endsWith()
*/
bool QString::startsWith( const QString& s ) const
{
    if ( isNull() )
	return s.isNull();
    if ( s.length() > length() )
	return FALSE;
    for ( int i =0; i < (int) s.length(); i++ ) {
	if ( d->unicode[i] != s[i] )
	    return FALSE;
    }
    return TRUE;
}

/*!
    Returns TRUE if the string ends with \a s; otherwise returns
    FALSE.

    \sa startsWith()
*/
bool QString::endsWith( const QString& s ) const
{
    if ( isNull() )
	return s.isNull();
    int pos = length() - s.length();
    if ( pos < 0 )
	return FALSE;
    for ( uint i = 0; i < s.length(); i++ ) {
	if ( d->unicode[pos+i] != s[(int)i] )
	    return FALSE;
    }
    return TRUE;
}

/*! \fn void QString::detach()
  If the string does not share its data with another QString instance,
  nothing happens; otherwise the function creates a new, unique copy of
  this string. This function is called whenever the map is modified. The
  implicit sharing mechanism is implemented this way.
*/

#if defined(Q_OS_WIN32)

#include <windows.h>

/*!
  \obsolete

  Returns a static Windows TCHAR* from a QString, adding NUL if \a
  addnul is TRUE.

  The lifetime of the return value is until the next call to this function,
  or until the last copy of str is deleted, whatever comes first.

  Use ucs2() instead.
*/
const void* qt_winTchar(const QString& str, bool)
{
    // So that the return value lives long enough.
    static QString str_cache;
    str_cache = str;
#ifdef UNICODE
    return str_cache.ucs2();
#else
    return str_cache.latin1();
#endif
}

/*!
    Makes a new '\0'-terminated Windows TCHAR* from a QString.
*/
void* qt_winTchar_new(const QString& str)
{
    if ( str.isNull() )
	return 0;
    int l = str.length()+1;
    TCHAR *tc = new TCHAR[ l ];
#ifdef UNICODE
    memcpy( tc, str.ucs2(), sizeof(TCHAR)*l );
#else
    memcpy( tc, str.latin1(), sizeof(TCHAR)*l );
#endif
    return tc;
}

/*!
    Makes a QString from a Windows TCHAR*.
*/
QString qt_winQString(void* tc)
{
#ifdef UNICODE
    return QString::fromUcs2( (ushort*)tc );
#else
    return QString::fromLatin1( (TCHAR *)tc );
#endif
}

QCString qt_winQString2MB( const QString& s, int uclen )
{
    if ( uclen < 0 )
	uclen = s.length();
    if ( s.isNull() )
	return QCString();
    if ( uclen == 0 )
	return QCString("");
    BOOL used_def;
    QCString mb(4096);
    int len;
    while ( !(len=WideCharToMultiByte(CP_ACP, 0, (const WCHAR*)s.unicode(), uclen,
		mb.data(), mb.size()-1, 0, &used_def)) )
    {
	int r = GetLastError();
	if ( r == ERROR_INSUFFICIENT_BUFFER ) {
	    mb.resize(1+WideCharToMultiByte( CP_ACP, 0,
				(const WCHAR*)s.unicode(), uclen,
				0, 0, 0, &used_def));
		// and try again...
	} else {
#ifndef QT_NO_DEBUG
	    // Fail.
	    qWarning("WideCharToMultiByte cannot convert multibyte text (error %d): %s (UTF8)",
		r, s.utf8().data());
#endif
	    break;
	}
    }
    mb[len]='\0';
    return mb;
}

// WATCH OUT: mblen must include the NUL (or just use -1)
QString qt_winMB2QString( const char* mb, int mblen )
{
    if ( !mb || !mblen )
	return QString::null;
    const int wclen_auto = 4096;
    WCHAR wc_auto[wclen_auto];
    int wclen = wclen_auto;
    WCHAR *wc = wc_auto;
    int len;
    while ( !(len=MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED,
		mb, mblen, wc, wclen )) )
    {
	int r = GetLastError();
	if ( r == ERROR_INSUFFICIENT_BUFFER ) {
	    if ( wc != wc_auto ) {
		qWarning("Size changed in MultiByteToWideChar");
		break;
	    } else {
		wclen = MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED,
				    mb, mblen, 0, 0 );
		wc = new WCHAR[wclen];
		// and try again...
	    }
	} else {
	    // Fail.
	    qWarning("MultiByteToWideChar cannot convert multibyte text");
	    break;
	}
    }
    if ( len <= 0 )
	return QString::null;
    QString s( (QChar*)wc, len - 1 ); // len - 1: we don't want terminator
    if ( wc != wc_auto )
	delete [] wc;
    return s;
}

#endif // Q_OS_WIN32
