/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.jspbp.renderer.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.AbstractRootRenderer;
import org.kaoriha.jspbp.renderer.ViewState;
import org.kaoriha.jspbp.renderer.table.Data;
import org.kaoriha.jspbp.renderer.table.Pager;
import org.kaoriha.jspbp.renderer.table.SimpleRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scroller<ColT extends Enum<ColT>, CellT>
extends AbstractRootRenderer<Data<ColT, CellT>> {
    private int scrollerWidth = 10;
    private String prevMark = "<";
    private String nextMark = ">";
    private int farPageDistance = 20;
    private String farPrevMark = "\u00ab";
    private String farNextMark = "\u00bb";
    private Pager pager = new Pager(this.viewState);
    private AbstractRenderer<String> jumper = new SimpleRenderer<String>(this.viewState);

    public Scroller(ViewState viewState) {
        super(viewState);
    }

    @Override
    public List<Content> render() {
        Element aE;
        Element aE2;
        int pageWidth = ((Data)this.source).getQuery().getSize();
        if (((Data)this.source).getLength() <= pageWidth) {
            return null;
        }
        int c = ((Data)this.source).getLength() / pageWidth + 1;
        int i = ((Data)this.source).getQuery().getOffset() / pageWidth;
        if (i > c) {
            i = c - 1;
        }
        int o = 0;
        if (c > this.scrollerWidth && i > this.scrollerWidth / 2 && c - (o = i - this.scrollerWidth / 2) < this.scrollerWidth) {
            o = c - this.scrollerWidth;
        }
        boolean isStart = true;
        Element pE = new Element("p");
        if (i >= this.farPageDistance) {
            aE2 = this.getAE(pE, (i - this.farPageDistance) * pageWidth);
            this.jumper.setSource(this.farPrevMark);
            this.jumper.render(aE2);
            isStart = false;
        }
        if (i > 0) {
            if (isStart) {
                isStart = false;
            } else {
                pE.addContent(" ");
            }
            aE2 = this.getAE(pE, (i - 1) * pageWidth);
            this.jumper.setSource(this.prevMark);
            this.jumper.render(aE2);
        }
        this.pager.setCurrentPage(i + 1);
        for (int k = o; k < c && k < o + this.scrollerWidth; ++k) {
            if (isStart) {
                isStart = false;
            } else {
                pE.addContent(" ");
            }
            this.pager.setSource(k + 1);
            if (k == i) {
                this.pager.render(pE);
                continue;
            }
            this.pager.render(this.getAE(pE, k * pageWidth));
        }
        if (i < c - 1) {
            pE.addContent(" ");
            aE = this.getAE(pE, (i + 1) * pageWidth);
            this.jumper.setSource(this.nextMark);
            this.jumper.render(aE);
        }
        if (i + this.farPageDistance < c) {
            pE.addContent(" ");
            aE = this.getAE(pE, (i + this.farPageDistance) * pageWidth);
            this.jumper.setSource(this.farNextMark);
            this.jumper.render(aE);
        }
        return Arrays.asList(pE);
    }

    private Element getAE(Element parent, int offset) {
        List<Object> values = offset == 0 ? Collections.emptyList() : Arrays.asList(Integer.toString(offset));
        Element aE = new Element("a");
        aE.setAttribute("href", this.viewState.getNewUrl("o", values));
        parent.addContent((Content)aE);
        return aE;
    }

    public int getScrollerWidth() {
        return this.scrollerWidth;
    }

    public void setScrollerWidth(int scrollerWidth) {
        this.scrollerWidth = scrollerWidth;
    }

    public void setPrevMark(String prevMark) {
        this.prevMark = prevMark;
    }

    public String getPrevMark() {
        return this.prevMark;
    }

    public void setNextMark(String nextMark) {
        this.nextMark = nextMark;
    }

    public String getNextMark() {
        return this.nextMark;
    }

    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public Pager getPager() {
        return this.pager;
    }

    public void setJumper(AbstractRenderer<String> jumper) {
        this.jumper = jumper;
    }

    public AbstractRenderer<String> getJumper() {
        return this.jumper;
    }
}

