/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.jspbp.renderer.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.AbstractRootRenderer;
import org.kaoriha.jspbp.renderer.ViewState;
import org.kaoriha.jspbp.renderer.table.Data;
import org.kaoriha.jspbp.renderer.table.Query;
import org.kaoriha.jspbp.renderer.table.Scroller;
import org.kaoriha.jspbp.renderer.table.SimpleRenderer;
import org.kaoriha.jspbp.renderer.table.Sort;
import org.kaoriha.jspbp.renderer.table.Source;
import org.kaoriha.jspbp.renderer.table.Tbody;
import org.kaoriha.jspbp.renderer.table.Tfoot;
import org.kaoriha.jspbp.renderer.table.Thead;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table<ColT extends Enum<ColT>, CellT>
extends AbstractRootRenderer<Source<ColT, CellT>> {
    private AbstractRenderer<CellT> caption;
    private Thead<ColT, CellT> thead;
    private Tbody<ColT, CellT> tbody;
    private Tfoot<ColT, CellT> tfoot;
    private Scroller<ColT, CellT> scroller;

    public Table(ViewState viewState) {
        super(viewState);
        this.caption = new SimpleRenderer<CellT>(this.viewState);
        this.thead = new Thead(this.viewState);
        this.tbody = new Tbody(this.viewState);
        this.tfoot = new Tfoot(this.viewState);
        this.scroller = new Scroller(this.viewState);
    }

    @Override
    public List<Content> render() {
        Query q = new Query();
        if (this.viewState.getQueryMap().containsKey("s")) {
            ArrayList sortList = new ArrayList();
            for (String string : this.viewState.getQueryMap().get("s")) {
                boolean isAsc;
                if (string.charAt(0) == 'a') {
                    isAsc = true;
                } else {
                    if (string.charAt(0) != 'd') continue;
                    isAsc = false;
                }
                sortList.add(new Sort(((Source)this.source).valueOfEnum(string.substring(1)), isAsc));
            }
            q.setSortList(sortList);
        }
        if (this.viewState.getQueryMap().containsKey("o")) {
            try {
                int offset = Integer.parseInt(this.viewState.getQueryMap().get("o").get(0));
                q.setOffset(offset);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.viewState.getQueryMap().containsKey("l")) {
            try {
                int size = Integer.parseInt(this.viewState.getQueryMap().get("l").get(0));
                q.setSize(size);
            }
            catch (Exception e) {}
        } else {
            q.setSize(10);
        }
        Data data = ((Source)this.source).getData(q);
        Element table = new Element("table");
        if (data.getCaption() != null) {
            Element element = new Element("caption");
            table.addContent((Content)element);
            this.caption.setSource(data.getCaption());
            this.caption.render(element);
        }
        if (data.getHeader() != null) {
            this.thead.setSource(data);
            this.thead.render(table);
        }
        if (data.getCell() != null) {
            this.tbody.setSource(data);
            this.tbody.render(table);
        }
        if (data.getFooter() != null) {
            this.tfoot.setSource(data);
            this.tfoot.render(table);
        }
        this.scroller.setSource(data);
        List<Content> list = this.scroller.render();
        if (list == null) {
            return Arrays.asList(table);
        }
        ArrayList<Content> ret = new ArrayList<Content>();
        ret.add((Content)table);
        ret.addAll(list);
        return ret;
    }

    public Thead<ColT, CellT> getThead() {
        return this.thead;
    }

    public void setThead(Thead<ColT, CellT> thead) {
        this.thead = thead;
    }

    public Tbody<ColT, CellT> getTbody() {
        return this.tbody;
    }

    public void setTbody(Tbody<ColT, CellT> tbody) {
        this.tbody = tbody;
    }

    public Tfoot<ColT, CellT> getTfoot() {
        return this.tfoot;
    }

    public void setTfoot(Tfoot<ColT, CellT> tfoot) {
        this.tfoot = tfoot;
    }

    public AbstractRenderer<CellT> getCaption() {
        return this.caption;
    }

    public void setCaption(AbstractRenderer<CellT> caption) {
        this.caption = caption;
    }

    public void setScroller(Scroller<ColT, CellT> scroller) {
        this.scroller = scroller;
    }

    public Scroller<ColT, CellT> getScroller() {
        return this.scroller;
    }
}

