package org.kaoriha.jspbp.renderer;

import org.jdom.Element;

/**
 * Renderer class for child node.
 * 
 * @author NAKAZATO Hajime
 * 
 * @param <T>
 *            Source class.
 */
public abstract class AbstractRenderer<T> {
	protected final ViewState viewState;
	protected T source;

	protected AbstractRenderer(ViewState viewState) {
		this.viewState = viewState;
	}

	/**
	 * Render from source.
	 * @param parent
	 *            Add your content to this element.
	 */
	abstract public void render(Element parent);

	public void setSource(T source) {
		this.source = source;
	}
}
