package org.kaoriha.jspbp.renderer;

import java.lang.reflect.Constructor;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.jdom.output.XMLOutputter;

/**
 * renderer tag class. It receives viewStateId, source, rendererClass.
 * 
 * @author NAKAZATO Hajime
 */
public class RendererTag extends TagSupport {
	private String rendererClassName;
	private String viewStateId;
	private Object source;

	@SuppressWarnings("unchecked")
	@Override
	public int doStartTag() throws JspException {
		AbstractRootRenderer renderer;
		try {
			Class<? extends AbstractRootRenderer> c = Class.forName(
					rendererClassName).asSubclass(AbstractRootRenderer.class);
			Constructor<? extends AbstractRootRenderer> constructor = c
					.getConstructor(ViewState.class);
			ViewState viewState = new ViewStateImpl(viewStateId,
					(HttpServletRequest) pageContext.getRequest(),
					pageContext.getServletContext());
			renderer = constructor.newInstance(viewState);
			renderer.setSource(source);

			List<?> r = renderer.render();

			XMLOutputter xo = new XMLOutputter();
			pageContext.getOut().print(xo.outputString(r));
		} catch (ClassNotFoundException e) {
			throw new JspException("RendererTag#doStartTag failed. "
					+ rendererClassName + " not found. ", e);
		} catch (Exception e) {
			throw new JspException("RendererTag#doStartTag failed.", e);
		}

		return SKIP_BODY;
	}

	public void setRendererClass(String name) {
		rendererClassName = name;
	}

	public void setViewStateId(String viewStateId) {
		this.viewStateId = viewStateId;
	}

	public void setSource(Object source) {
		this.source = source;
	}
}
