package org.kaoriha.jspbp.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

/**
 * View state implementation class.
 * 
 * @author NAKAZATO Hajime
 */
public class ViewStateImpl implements ViewState {
	private static final Pattern SPLITTER = Pattern.compile("&|\\?");
	private final Map<String, List<String>> queryMap = new HashMap<String, List<String>>();
	private final HttpServletRequest request;
	private final String viewStateId;
	private final ServletContext servletContext;

	public ViewStateImpl(String viewStateId, HttpServletRequest request, ServletContext servletContext) {
		this.viewStateId = viewStateId;
		this.request = request;
		this.servletContext = servletContext;

		if (!request.getParameterMap().containsKey(viewStateId)) {
			return;
		}
		for (String s : request.getParameterValues(viewStateId)) {
			String[] kv = s.split("\\.");
			if (kv.length > 1) {
				put(kv[0], kv[1]);
			}
		}
	}

	private void put(String key, String value) {
		if (queryMap.containsKey(key)) {
			List<String> sl = queryMap.get(key);
			sl.add(value);
		} else {
			List<String> sl = new ArrayList<String>();
			sl.add(value);
			queryMap.put(key, sl);
		}
	}

	public Map<String, List<String>> getQueryMap() {
		return queryMap;
	}

	public String getNewUrl(String key, List<String> values) {
		Map<String, List<String>> kv = new HashMap<String, List<String>>();
		kv.put(key, values);
		return getNewUrl(kv);
	}

	public String getViewStateId() {
		return viewStateId;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	private boolean isStartsWithContains(String s, Set<String> values) {
		for (String v : values) {
			if (s.startsWith(v)) {
				return true;
			}
		}
		return false;
	}

	public String getNewUrl(Map<String, List<String>> kv) {
		StringBuilder sb = new StringBuilder();
		Set<String> startsSet = new HashSet<String>();
		for (String key : kv.keySet()) {
			startsSet.add(viewStateId + "=" + key + ".");
		}
		boolean isFirst = true;
		String req = request.getRequestURL().toString();
		if (request.getQueryString() != null) {
			req = req + "?" + request.getQueryString();
		}
		String[] sp = SPLITTER.split(req);
		for (String s : sp) {
			if (isStartsWithContains(s, startsSet)) {
				continue;
			}
			if (sb.length() == 0) {
				sb.append(s);
				continue;
			}
			if (isFirst) {
				sb.append("?");
				isFirst = false;
			} else {
				sb.append("&");
			}
			sb.append(s);
		}

		for (Map.Entry<String, List<String>> entry : kv.entrySet()) {
			String starts = viewStateId + "=" + entry.getKey() + ".";
			List<String> values = entry.getValue();
			for (String s : values) {
				if (isFirst) {
					sb.append("?");
					isFirst = false;
				} else {
					sb.append("&");
				}
				sb.append(starts + s);
			}
		}

		return sb.toString();
	}

	public ServletContext getServletContext() {
		return servletContext;
	}
}
