package org.kaoriha.jspbp.renderer.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.jdom.Content;
import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.AbstractRootRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Scroller<ColT extends Enum<ColT>, CellT> extends
		AbstractRootRenderer<Data<ColT, CellT>> {
	private int scrollerWidth = Default.SCROLLER_WIDTH;
	private String prevMark = Default.PREV_MARK;
	private String nextMark = Default.NEXT_MARK;
	private int farPageDistance = Default.FAR_PAGE_DISTANCE;
	private String farPrevMark = Default.FAR_PREV_MARK;
	private String farNextMark = Default.FAR_NEXT_MARK;

	public Scroller(ViewState viewState) {
		super(viewState);
	}

	private Pager pager = new Pager(viewState);
	private AbstractRenderer<String> jumper = new SimpleRenderer<String>(
			viewState);

	@Override
	public List<Content> render() {
		int pageWidth = source.getQuery().getSize();
		if (source.getLength() <= pageWidth) {
			return null;
		}

		int c = source.getLength() / pageWidth + 1;
		int i = source.getQuery().getOffset() / pageWidth;
		if (i > c) {
			i = c - 1;
		}

		int o = 0;
		if (c > scrollerWidth) {
			if (i > scrollerWidth / 2) {
				o = i - scrollerWidth / 2;
				if (c - o < scrollerWidth) {
					o = c - scrollerWidth;
				}
			}
		}

		boolean isStart = true;
		Element pE = new Element("p");
		if (i >= farPageDistance) {
			Element aE = getAE(pE, (i - farPageDistance) * pageWidth);

			jumper.setSource(farPrevMark);
			jumper.render(aE);
			isStart = false;
		}
		if (i > 0) {
			if (isStart) {
				isStart = false;
			} else {
				pE.addContent(" ");
			}
			Element aE = getAE(pE, (i - 1) * pageWidth);

			jumper.setSource(prevMark);
			jumper.render(aE);
		}

		pager.setCurrentPage(i + 1);
		int k;
		for (k = o; k < c && k < o + scrollerWidth; k++) {
			if (isStart) {
				isStart = false;
			} else {
				pE.addContent(" ");
			}

			pager.setSource(k + 1);
			if (k == i) {
				pager.render(pE);
			} else {
				pager.render(getAE(pE, k * pageWidth));
			}
		}
		if (i < c - 1) {
			pE.addContent(" ");

			Element aE = getAE(pE, (i + 1) * pageWidth);
			jumper.setSource(nextMark);
			jumper.render(aE);
		}
		if (i + farPageDistance < c) {
			pE.addContent(" ");

			Element aE = getAE(pE, (i + farPageDistance) * pageWidth);

			jumper.setSource(farNextMark);
			jumper.render(aE);
		}

		return Arrays.asList((Content)pE);
	}

	private Element getAE(Element parent, int offset) {
		List<String> values;
		if (offset == 0) {
			values = Collections.emptyList();
		} else {
			values = Arrays.asList(Integer.toString(offset));
		}
		Element aE = new Element("a");
		aE.setAttribute("href", viewState.getNewUrl(Constant.QN_OFFSET,
						values));
		parent.addContent(aE);
		return aE;
	}

	public int getScrollerWidth() {
		return scrollerWidth;
	}

	public void setScrollerWidth(int scrollerWidth) {
		this.scrollerWidth = scrollerWidth;
	}

	public void setPrevMark(String prevMark) {
		this.prevMark = prevMark;
	}

	public String getPrevMark() {
		return prevMark;
	}

	public void setNextMark(String nextMark) {
		this.nextMark = nextMark;
	}

	public String getNextMark() {
		return nextMark;
	}

	public void setPager(Pager pager) {
		this.pager = pager;
	}

	public Pager getPager() {
		return pager;
	}

	public void setJumper(AbstractRenderer<String> jumper) {
		this.jumper = jumper;
	}

	public AbstractRenderer<String> getJumper() {
		return jumper;
	}
}
