package org.kaoriha.jspbp.renderer.table;

import java.util.Comparator;
import java.util.Map;

import org.kaoriha.jspbp.renderer.table.Sort;

public class Sorter<ColT extends Enum<ColT>, U extends Comparable<U>>
		implements Comparator<Map<ColT, U>> {
	private final Sort<ColT> sort;

	public Sorter(Sort<ColT> sort) {
		this.sort = sort;
	}

	public int compare(Map<ColT, U> left, Map<ColT, U> right) {
		int r = left.get(sort.getColumn()).compareTo(
				right.get(sort.getColumn()));
		if (!sort.isAsc()) {
			return -r;
		}
		return r;
	}
}
