package org.kaoriha.jspbp.renderer.table;

import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Thead<ColT extends Enum<ColT>, CellT> extends AbstractRenderer<Data<ColT, CellT>> {
	public Thead(ViewState viewState) {
		super(viewState);
	}

	private Tr<ColT, CellT> tr = new Tr<ColT, CellT>(viewState);
	{
		tr.setCell(new Th<ColT, CellT>(viewState));
	}

	@Override
	public void render(Element parent) {
		Element thead = new Element("thead");
		parent.addContent(thead);
		tr.setSource(new DataRow<ColT, CellT>(source, source.getHeader()));
		tr.render(thead);
	}

	public Tr<ColT, CellT> getTr() {
		return tr;
	}

	public void setTr(Tr<ColT, CellT> tr) {
		this.tr = tr;
	}
}
