/* 
 * read zip, jar file
 */
#include <sys/types.h>
#include <unistd.h>

struct ZipFile {
  int is_onmem;
  char *p;
  int pos;
  int fd;
  long size;
  long count;
  long dir_size;
  char *central_directory;
};

typedef struct ZipFile ZipFile;

struct ZipDirectory {
  int direntry_size;
  int filename_offset;
  long compressed_size;
  long compression_method;
  long size; /* length of file */
  long filestart;  /* start of file in archive */
  long filename_length;
  /* char mid_padding[...]; */
  /* char filename[filename_length]; */
  /* char end_padding[...]; */
};

typedef struct ZipDirectory ZipDirectory;

#define ZIPDIR_FILENAME(ZIPD) ((char*)(ZIPD)+(ZIPD)->filename_offset)
#define ZIPDIR_NEXT(ZIPD) \
   ((ZipDirectory*)((char*)(ZIPD)+(ZIPD)->direntry_size))


#define STORED            0    /* compression methods */
#define SHRUNK            1
#define REDUCED1          2
#define REDUCED2          3
#define REDUCED3          4
#define REDUCED4          5
#define IMPLODED          6
#define TOKENIZED         7
#define DEFLATED          8
#define NUM_METHODS       9    /* index of last method + 1 */





ZipFile *zip_archive_open (char *fname, int onmem);
ZipFile *zip_archive_assign (ZipFile *zip, register char* p, int size);
int read_zip_archive(register ZipFile* zipf);
int zip_lseek (ZipFile * zip, off_t pos, int cmd);
int zip_read_file (ZipFile * zip, ZipDirectory * zipd, char **buf, int *size);
