/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventInfoProperty {
    public static final String PRIORITY = "priority";
    public static final String OUTPUT_DATE = "outputDate";
    public static final String GENERATION_DATE = "generationDate";
    public static final String PLUGIN_ID = "pluginId";
    public static final String MONITOR_ID = "monitorId";
    public static final String FACILITY_ID = "facilityId";
    public static final String SCOPE_TEXT = "scopeText";
    public static final String APPLICATION = "application";
    public static final String MESSAGE_ID = "messageId";
    public static final String MESSAGE = "message";
    public static final String MESSAGE_ORG = "messageOrg";
    public static final String CONFIRMED = "confirmed";
    public static final String CONFIRM_DATE = "confirmDate";
    public static final String DUPLICATION_COUNT = "duplicationCount";
    protected static Log m_log = LogFactory.getLog(EventInfoProperty.class);

    public Property getProperty(String monitorId, String pluginId, String facilityId, Date outputDate, Locale locale) throws FinderException, NamingException {
        Property m_priority = new Property(PRIORITY, Messages.getString((String)PRIORITY, (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_outputDate = new Property(OUTPUT_DATE, Messages.getString((String)"receive.time", (Locale)locale), "com.clustercontrol.composite.DateTimePropertyDefine");
        Property m_generationDate = new Property(GENERATION_DATE, Messages.getString((String)"output.time", (Locale)locale), "com.clustercontrol.composite.DateTimePropertyDefine");
        Property m_pluginId = new Property(PLUGIN_ID, Messages.getString((String)"plugin.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_monitorId = new Property(MONITOR_ID, Messages.getString((String)"monitor.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_facilityId = new Property(FACILITY_ID, Messages.getString((String)"facility.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_scopeText = new Property(SCOPE_TEXT, Messages.getString((String)"scope", (Locale)locale), "com.clustercontrol.composite.ScopePropertyDefine");
        Property m_application = new Property(APPLICATION, Messages.getString((String)APPLICATION, (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_messageId = new Property(MESSAGE_ID, Messages.getString((String)"message.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_message = new Property(MESSAGE, Messages.getString((String)MESSAGE, (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_messageOrg = new Property(MESSAGE_ORG, Messages.getString((String)"message.org", (Locale)locale), "com.clustercontrol.composite.TextAreaPropertyDefine", 9999);
        Property m_confirmed = new Property(CONFIRMED, Messages.getString((String)CONFIRMED, (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property m_confirmDate = new Property(CONFIRM_DATE, Messages.getString((String)"confirm.time", (Locale)locale), "com.clustercontrol.composite.DateTimePropertyDefine");
        Property m_duplicationCount = new Property(DUPLICATION_COUNT, Messages.getString((String)"duplication.count", (Locale)locale), "com.clustercontrol.composite.IntegerPropertyDefine");
        try {
            EventLogPK pk = new EventLogPK(monitorId, pluginId, facilityId, new Timestamp(outputDate.getTime()));
            EventLogLocal event = EventLogUtil.getLocalHome().findByPrimaryKey(pk);
            m_priority.setValue((Object)PriorityConstant.typeToString((int)event.getPriority()));
            m_outputDate.setValue((Object)event.getOutputDate());
            m_generationDate.setValue((Object)event.getGenerationDate());
            m_pluginId.setValue((Object)event.getPluginId());
            m_monitorId.setValue((Object)event.getMonitorId());
            m_facilityId.setValue((Object)event.getFacilityId());
            m_scopeText.setValue((Object)event.getScopeText());
            m_application.setValue((Object)event.getApplication());
            m_messageId.setValue((Object)event.getMessageId());
            m_message.setValue((Object)event.getMessage());
            m_messageOrg.setValue((Object)this.nullToSpace(event.getMessageOrg()));
            m_confirmed.setValue((Object)ConfirmConstant.typeToString((int)event.getConfirmFlg()));
            m_confirmDate.setValue((Object)event.getConfirmDate());
            m_duplicationCount.setValue((Object)event.getDuplicationCount());
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, monitorId, pluginId, outputDate.toString()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("getProperty():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, monitorId, pluginId, outputDate.toString()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("getProperty():" + e.getMessage()));
            throw e;
        }
        m_priority.setModify(0);
        m_outputDate.setModify(0);
        m_generationDate.setModify(0);
        m_pluginId.setModify(0);
        m_monitorId.setModify(0);
        m_facilityId.setModify(0);
        m_scopeText.setModify(0);
        m_application.setModify(0);
        m_messageId.setModify(0);
        m_message.setModify(0);
        m_messageOrg.setModify(0);
        m_confirmed.setModify(0);
        m_confirmDate.setModify(0);
        m_duplicationCount.setModify(0);
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren((PropertyTreeItem)m_priority);
        property.addChildren((PropertyTreeItem)m_outputDate);
        property.addChildren((PropertyTreeItem)m_generationDate);
        property.addChildren((PropertyTreeItem)m_pluginId);
        property.addChildren((PropertyTreeItem)m_monitorId);
        property.addChildren((PropertyTreeItem)m_facilityId);
        property.addChildren((PropertyTreeItem)m_scopeText);
        property.addChildren((PropertyTreeItem)m_application);
        property.addChildren((PropertyTreeItem)m_messageId);
        property.addChildren((PropertyTreeItem)m_message);
        property.addChildren((PropertyTreeItem)m_messageOrg);
        property.addChildren((PropertyTreeItem)m_confirmed);
        property.addChildren((PropertyTreeItem)m_confirmDate);
        property.addChildren((PropertyTreeItem)m_duplicationCount);
        return property;
    }

    private String nullToSpace(String target) {
        if (target == null) {
            return "";
        }
        return target;
    }
}

