/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.factory.SelectEvent;
import com.clustercontrol.monitor.factory.SelectStatus;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocalHome;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectScope {
    protected static Log m_log = LogFactory.getLog(SelectScope.class);

    public ArrayList getScopeList(String facilityId) throws CreateException, FinderException, NamingException {
        ArrayList list = new ArrayList();
        SelectStatus selectStatus = new SelectStatus();
        SelectEvent selectEvent = new SelectEvent();
        int parentPriority = 4;
        String parentFacilityId = null;
        String parentFacilityPath = null;
        Date parentOutputDate = null;
        try {
            EventLogLocal event;
            StatusInfoLocal status;
            ArrayList info;
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            FacilityTreeLocalHome ftHome = FacilityTreeUtil.getLocalHome();
            if (facilityId != null && !"".equals(facilityId) && (info = this.getHighPriorityScope(status = selectStatus.getHighPriorityStatus(facilityId, -1), event = selectEvent.getHighPriorityEvent(facilityId, -1), repository, facilityId, facilityId)) != null) {
                parentPriority = (Integer)info.get(0);
                parentFacilityId = (String)info.get(1);
                parentFacilityPath = (String)info.get(2);
                parentOutputDate = (Date)info.get(3);
            }
            ArrayList facilityIdList = repository.getFacilityIdList(facilityId, 1);
            String[] facilityIds = null;
            if (facilityIdList != null && facilityIdList.size() > 0) {
                facilityIds = new String[facilityIdList.size()];
                facilityIdList.toArray(facilityIds);
            } else if (facilityId != null) {
                facilityIds = new String[]{facilityId};
            } else {
                return null;
            }
            boolean statusInfoFlg = false;
            boolean eventLogFlg = false;
            boolean highPriorityFlg = false;
            for (int index = 0; facilityIds != null && index < facilityIds.length; ++index) {
                EventLogLocal event2;
                StatusInfoLocal status2;
                ArrayList info2;
                if (!facilityIds[index].equals(facilityId) && (info2 = this.getHighPriorityScope(status2 = selectStatus.getHighPriorityStatus(facilityIds[index], 0), event2 = selectEvent.getHighPriorityEvent(facilityIds[index], 0), repository, facilityIds[index], facilityId)) != null) {
                    Collection fts = ftHome.findByFacilityId(facilityIds[index]);
                    Iterator it = fts.iterator();
                    if (fts.size() != 0) {
                        FacilityTreeLocal ftl = (FacilityTreeLocal)it.next();
                        Integer sortValue = ftl.getSortValue();
                        info2.add(sortValue);
                    } else {
                        info2.add(new Integer(100));
                    }
                    list.add(info2);
                    if (parentPriority > (Integer)info2.get(0)) {
                        highPriorityFlg = true;
                    } else if (parentPriority == (Integer)info2.get(0)) {
                        if (parentOutputDate != null) {
                            if (parentOutputDate.before((Date)info2.get(3))) {
                                highPriorityFlg = true;
                            }
                        } else {
                            highPriorityFlg = true;
                        }
                    }
                    if (highPriorityFlg) {
                        parentPriority = (Integer)info2.get(0);
                        parentOutputDate = (Date)info2.get(3);
                        if (parentFacilityId == null && facilityId != null && !"".equals(facilityId)) {
                            parentFacilityId = facilityId;
                            parentFacilityPath = repository.getFacilityPath(facilityId, facilityId);
                        }
                    }
                }
                statusInfoFlg = false;
                eventLogFlg = false;
                highPriorityFlg = false;
            }
            if (parentFacilityId != null) {
                ArrayList<Object> info3 = new ArrayList<Object>();
                info3.add(new Integer(parentPriority));
                info3.add(parentFacilityId);
                info3.add(parentFacilityPath);
                info3.add(parentOutputDate);
                info3.add(new Integer(0));
                list.add(info3);
            }
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getScopeList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getScopeList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getScopeList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    private ArrayList getHighPriorityScope(StatusInfoLocal status, EventLogLocal event, RepositoryControllerLocal repository, String facilityId, String parentFacilityId) throws CreateException, FinderException, NamingException {
        ArrayList<Object> info = new ArrayList<Object>();
        boolean statusInfoFlg = false;
        boolean eventLogFlg = false;
        if (status == null && event == null) {
            return null;
        }
        if (status != null && event == null) {
            statusInfoFlg = true;
        } else if (status == null && event != null) {
            eventLogFlg = true;
        } else if (status != null && event != null) {
            if (status.getPriority() < event.getPriority()) {
                statusInfoFlg = true;
            } else if (status.getPriority() > event.getPriority()) {
                eventLogFlg = true;
            } else if (status.getPriority().intValue() == event.getPriority().intValue()) {
                if (status.getOutputDate().after(event.getOutputDate())) {
                    statusInfoFlg = true;
                } else {
                    eventLogFlg = true;
                }
            }
        }
        String facilityPath = repository.getFacilityPath(facilityId, parentFacilityId);
        if (statusInfoFlg) {
            info.add(status.getPriority());
            info.add(facilityId);
            info.add(facilityPath);
            info.add(new Date(status.getOutputDate().getTime()));
        } else if (eventLogFlg) {
            info.add(event.getPriority());
            info.add(facilityId);
            info.add(facilityPath);
            info.add(new Date(event.getOutputDate().getTime()));
        }
        return info;
    }
}

