#!/bin/sh

#Copyright (C) 2006, 2007 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み 
export EXEC_PATH=${0%/*}

. ${EXEC_PATH}/install.cfg

echo ""
                                                                                
echo "###################################################################"
echo "###                                                             ###"
echo "### Operation Management Software Hinemos Agent                 ###"
echo "###                                        Installer Ver 2.3.0  ###"
echo "###                                                             ###"
echo "###  Copyright (C) 2006,2007 NTT DATA Corporation.              ###"
echo "###################################################################"


EXEC_USER=`/usr/bin/whoami`
HOSTS_FILE=/etc/hosts
HOST=`hostname`

# check for incorrect user

if [ $EXEC_USER != "root" ]; then
        echo "";
        echo "ERROR  Set up Hinemos Agent at root user";
        echo "";
        exit 1;
fi

pre_install() {
	##
	## hostsファイルのチェック START
	##
	echo ""
	echo "${HOSTS_FILE} is checked before the agent is installed. "
	
	#ホスト名にIPアドレスの重複がないかチェックを行う
	check_flg=`grep ${HOST} ${HOSTS_FILE} | grep -v ^\# | awk '{print $1}' | wc -l`
	
	if [ ${check_flg} != 1 ]; then
	    echo "NG"
       	echo "IP address is not being set to the ${HOST} by the ${HOSTS_FILE} or two settings or more are done. "
	   	echo "Please change the setting in the single. "
	    echo "Please check the ${HOSTS_FILE}."
	    echo ""
	    
	    while [ 1 ]; do
	    	echo "Do you continue installing it?（Y/N）"
	    	read ANS
	    	case ${ANS} in
	    		y|Y)
	    	  		break
	    	  	;;
	    		n|N)
			  		echo "The installing discontinue."
			  		echo ""
			  		exit 1
			  	;;
		    	*)
			esac
		done
		
	else
	    echo "OK"
	fi
	
	##
	## hostsファイルのチェック END
	##
	
	
	##
	## パッケージのチェック START
	##
	echo ""
	echo "Necessary packages is checked before the agent is installed."
	
	# パッケージの有無をチェックする
	rpm_check() {
	    rpm -qi $1 >/dev/null 2>&1
	    check_flg=$?
	}
	
	# マニュアルに記述されているパッケージの有無をチェックする
	for p_name in ${CHECK_MAN[@]}
	do
	    rpm_check ${p_name}
	    if [ ${check_flg} = 1 ]; then
	        echo ${p_name} >> ${EXEC_PATH}/tmp.txt
	    fi
	done
	
	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
	    echo ""
	    echo "NG"
	    echo "The following packages are insufficient to install the Hinemos agent."
	    cat ${EXEC_PATH}/tmp.txt
	    echo ""
	    echo "Please confirm page 8 of the installation manual in detail."
	    echo ""
	    rm -rf ${EXEC_PATH}/tmp.txt
	    exit 1
	else
	    rm -rf ${EXEC_PATH}/tmp.txt
	fi
	
	# インストールするパッケージの依存関係をチェックする
	for p_name in "${CHECK_RPMS[@]}"
	do
	    rpm -U --force --nosignature --test "${p_name}" >/dev/null 2>> ${EXEC_PATH}/tmp.txt
	done
	
	#結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
	    echo "NG"
	    echo "The following packages are insufficient to install the Hinemos agent."
	    cat ${EXEC_PATH}/tmp.txt |grep -v : |awk '{print $1}'
	    echo ""
	    echo "Please confirm page 8 of the installation manual in detail."
	    echo ""
	    rm -rf ${EXEC_PATH}/tmp.txt
	    exit 1
	else
	    echo "OK"
	    echo ""
	    rm -rf ${EXEC_PATH}/tmp.txt
	fi
	
	# 一括制御機能で使用しているコマンドのパッケージの有無をチェックする
	for p_name in ${CHECK_PACKAGE[@]}
	do
	    rpm_check ${p_name}
	    if [ ${check_flg} = 1 ]; then
	        echo ${p_name} >> ${EXEC_PATH}/tmp.txt
	    fi
	done
	
	#結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
	    echo ""
	    echo "Warning：It is necessary to install the following packages to use "The Package control function" all."
	    cat ${EXEC_PATH}/tmp.txt
	    echo ""
	    echo "Please confirm page 8 of the installation manual in detail."
	    echo ""
	    sleep 2
	    rm -rf ${EXEC_PATH}/tmp.txt
	fi
	
	rm -rf ${EXEC_PATH}/tmp.txt
	
	##
	## パッケージのチェック END
	##
}


##
## インストーラ本編
##
while [ 1 ];
do
  echo "Hinemos Agent's"
  echo "     1) Installation"
  echo "     2) Uninstallation"
  echo "     9) Quit this installer"
  echo ""
  echo -n "===> "
 
  read CHOSEN_NUMBER
  
  case ${CHOSEN_NUMBER} in
      1)      
	  
	  echo ""
	  echo "Setup Hinemos agent."
	  echo ""
	  echo ""

		while [ 1 ];
		  do
                  echo "Installation will be start.  Is it all right? (Y/N)"
		  read ANS
		  case ${ANS} in
		      y|Y)
			  
			  # インストール準備部分
			  
			  # 確認
			  pre_install
			  
			  if [ ! -d ${HINEMOS_AGENT_HOME} ]; then
			      echo "${HINEMOS_AGENT_HOME}は存在しません。作成します。"
			      echo "mkdir -p ${HINEMOS_AGENT_HOME}" 
			      echo ""
			  fi

			  while [ ! "${IPADDR}" ] ;
			  do
			      echo -n "Please input a manager's IP Address --:"
			      read IPADDR
			  done
			
			  # コピー開始
			  echo "Start copying required files."
			  cp -pr $EXEC_PATH/hinemos_agent /opt
			  cp -p $EXEC_PATH/hinemos_agent.cfg ${HINEMOS_AGENT_HOME}/bin
			  echo "Copying required files was completed."
			  echo ""
		      echo "Installing  JRE"
			  sleep 2
			  echo ""
			  cp ${EXEC_PATH}/jre-1_5_0_09-linux-i586.bin ${HINEMOS_AGENT_HOME}
			  CURRENT_DIR=`pwd`
			  cd ${HINEMOS_AGENT_HOME}
			  ${HINEMOS_AGENT_HOME}/jre-1_5_0_09-linux-i586.bin
			  rm ${HINEMOS_AGENT_HOME}/jre-1_5_0_09-linux-i586.bin
			  cd $CURRENT_DIR

			  # マネージャIPアドレスの反映
			  sed "s/%%manager%%/$IPADDR/" ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties > ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties_tmp
			  mv -f ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties_tmp ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties

			  # ログ転送エージェントへのマネージャIPアドレスの反映
                          sed "s/%%manager%%/$IPADDR/" ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties > ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties_tmp
                          mv -f ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties_tmp ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties

			  #ログへのホスト名の反映のための設定
			  sed "s/%%HOST%%/$HOST/" ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties > ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties_tmp
                          mv -f ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties_tmp  ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
 
			  #一括制御機能のセットアップ
			  echo "Set up the Package control function."
			  echo ""
			  while [ 1 ] ;
			  do
				  echo "Please input the execution method of Package control function."
				  echo "     1) ssh"
				  echo "     2) rsh"
				  echo ""
				  echo -n "===> "
				  read SHELL

				  case ${SHELL} in
					1)
					  break
					  ;;
					2)
					  echo "rsh" >> /etc/securetty
					  echo "${IPADDR} hinemos" > ~/.rhosts
					  break
					  ;;
					*)
					  echo ""
					  ;;
				  esac
			  done
			  
		          #性能管理機能のセットアップ
			  echo "Set up the Performance management function."
			  echo "Net-SNMPのインストール"
			  rpm -Uvh --force --nosignature $SNMP_RPM
			  echo "view    systemview    included   .1.3.6.1 " >> /etc/snmp/snmpd.conf
			  echo "/etc/init.d/snmpd restart"
			  /etc/init.d/snmpd restart
			  echo "/sbin/chkconfig --level 345 snmpd on"
			  /sbin/chkconfig --level 345 snmpd on
			  
          		  #監視監理機能のセットアップ
			  echo "Set up the Condition monitoring function."
			  echo ""
			  TMP_M=0
			  TMP_A=0
			  TMP_DNS=0
			  
			  grep "add for Hinemos Manager" /etc/syslog-ng/syslog-ng.conf > /dev/null 2>&1 && TMP_M=1
			  grep "add for Hinemos Agent" /etc/syslog-ng/syslog-ng.conf > /dev/null 2>&1 && TMP_A=1

			  if [ "${TMP_M}" -eq 0 ] ; then
				if [ "${TMP_A}" -eq 0 ] ; then
				  echo "install syslog-ng"
				  rpm -Uvh --force $SYSLOG_NG_RPM
				  LOCAL_ADDR=`grep $HOST $HOSTS_FILE | grep -v ^\# | gawk '{print $1}'`
				  echo "#add for Hinemos Agent" >> /etc/syslog-ng/syslog-ng.conf
				  echo "filter f_hinemos_log { facility(user);  };" >> /etc/syslog-ng/syslog-ng.conf
				  echo "source s_netudp { udp(ip($LOCAL_ADDR) port(514)); };" >>/etc/syslog-ng/syslog-ng.conf
				  echo "log { source(s_netudp); filter(f_hinemos_log); destination(d_hinemos);};" >>/etc/syslog-ng/syslog-ng.conf
				  echo "destination d_hinemos { tcp(\"${IPADDR}\" port(514));};" >> /etc/syslog-ng/syslog-ng.conf
				  echo "log { source(s_local);filter(f_mesg);destination(d_hinemos);};" >> /etc/syslog-ng/syslog-ng.conf
				fi
			  fi
			  
			  # /etc/syslog-ng/syslog-ng.conf use_dns の編集
			  grep "use_dns" /etc/syslog-ng/syslog-ng.conf | grep "yes" > /dev/null 2>&1 && TMP_DNS=1
			  
			  if [ "${TMP_DNS}" -eq 0 ] ; then

				  SYSLOG_NG_TMP=`grep "use_dns" /etc/syslog-ng/syslog-ng.conf`
				  SYSLOG_NG_TMP_INSERT=`echo ${SYSLOG_NG_TMP} | sed "s/no/yes/g"`
				  
				  sed "s/${SYSLOG_NG_TMP}/#${SYSLOG_NG_TMP}\n\t${SYSLOG_NG_TMP_INSERT}/g" /etc/syslog-ng/syslog-ng.conf > /etc/syslog-ng/syslog-ng.conf_tmp
				  mv -f /etc/syslog-ng/syslog-ng.conf_tmp /etc/syslog-ng/syslog-ng.conf
				  
			  fi
			  
			  # syslogの停止・syslog-ngの起動
			  /etc/init.d/syslog stop
			  /etc/init.d/syslog-ng start
			  /sbin/chkconfig --level 2345 syslog off
			  /sbin/chkconfig --level 2345 syslog-ng on
			  
			  echo ""

		      break
		      ;;

		      n|N)
			  echo "Installation is stopped and return to the menu."
			  echo ""
			  sleep 1
			  break
			  ;;
		      *)
		  esac
		done
                ;;
      2)      
          echo "The Hinemos agent will be uninstalled. Is it all right (Y/N)?"
	  read ANS
	  case ${ANS} in
	      y|Y)
		TMP=0
		grep "add for Hinemos Manager" /etc/syslog-ng/syslog-ng.conf > /dev/null 2>&1 && TMP=1
		if [ !"${TMP}" ] ; then
			echo "Stopping syslo-ng."
			  /etc/init.d/syslog-ng stop
			  /etc/init.d/syslog start
		 	  /sbin/chkconfig --level 2345 syslog on
			  /sbin/chkconfig --level 2345 syslog-ng off
		fi

                   echo "Stopping Net-SNMP"
                  /etc/init.d/snmpd stop
                  /sbin/chkconfig --level 2345 snmpd off

		 TMP=0
		 tail -1 /etc/snmp/snmpd.conf | grep "view    systemview    included   .1.3.6.1 " > /dev/null 2>&1 && TMP=1
		 if [ ${TMP} ] ; then
			COUNT=`cat /etc/snmp/snmpd.conf | wc -l`
		 	COUNT=`expr ${COUNT} - 1`
			head -${COUNT} /etc/snmp/snmpd.conf >/etc/snmp/snmpd.conf_hinemos_back
			mv /etc/snmp/snmpd.conf_hinemos_back /etc/snmp/snmpd.conf
		 fi 
		
		grep "rsh" /etc/securetty > /dev/null 2>&1
		TMP=$?
		if [ ${TMP} -eq 0 ] ; then
			echo "Can you remove \"rsh\" from  /etc/securetty? (Y/N)"
			read TTY
			case ${TTY} in
			y|Y)
				grep -v rsh /etc/securetty > /etc/securetty.tmp
				mv /etc/securetty.tmp /etc/securetty
			;;
			*)
			;;
			esac
		fi
		if [ -f /root/.rhosts ] ; then
                        echo "Can you remove /root/.rhosts ?(Y/N)"
                        read RHOSTS
                        case ${RHOSTS} in
                        y|Y)
                                rm /root/.rhosts
                        ;;
                        *)
                        ;;
                        esac
                fi

		 rm -fr ${HINEMOS_AGENT_HOME}
		;;
	      *)
		;;
	  esac
	  echo ""
	  ;;
      9)      
	  echo "Hinemos agent installer is finished."
	  exit
	  ;;
	*)
	  echo ""
	  sleep 1
	  ;;
  esac
done
