// Game.cpp

#include <DxLib.h>
#include "define.h"
#include "Game.h"
#include "Input.h"
#include "Player.h"
#include "Map.h"

// O[oϐ
PLAYER yoshio;  // vC[
MAP mainMap;    // }bv

////////////////////////////////////////////////////////////////////////////////
// C[v֐
////////////////////////////////////////////////////////////////////////////////
void GameMain(void)
{
    while (ProcessMessage() == 0) {
        count++;
        // ESCꂽً}I
        if (CheckHitKey(KEY_INPUT_ESCAPE) != 0)
            break;
        GetInput();
        PlayerMain(yoshio, mainMap);
        GameDraw();
    }
}

////////////////////////////////////////////////////////////////////////////////
// Q[֐
////////////////////////////////////////////////////////////////////////////////
int GameInit(void)
{
    // Oo͖
    SetOutApplicationLogValidFlag(false);

    ChangeWindowMode(SCREEN_MODE);
    SetGraphMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);
    SetMainWindowText(GAME_CAPTION);
    if (DxLib_Init() == -1)
        return -1;
    SetDrawScreen(DX_SCREEN_BACK);
    InitInput();

    // vC[
    PlayerInit(yoshio, ".\\data\\character\\yoshio.png");
    // }bv
    MapInit(mainMap, ".\\data\\map\\big.png", ".\\data\\map\\big_mask.png", ".\\data\\map\\big_layer.png");
    // MapInit(mainMap, ".\\data\\map\\map00.png", ".\\data\\map\\map00.png", NULL);

    return 0;
}

////////////////////////////////////////////////////////////////////////////////
// `֐ 
////////////////////////////////////////////////////////////////////////////////
void GameDraw(void)
{
    MapDraw(mainMap);
    PlayerDraw(yoshio);
    MapLayerDraw(mainMap);
    #ifdef DEBUG_MODE
    PlayerDebug(yoshio);
    InputDebug();
    #endif
    ScreenFlip();
    #ifdef  DEBUG_MODE
    clsDx();
    #endif
    ClearDrawScreen();
    MapMaskDraw(mainMap);
}

