// Map.cpp

#include <DxLib.h>
#include "define.h"
#include "Map.h"

////////////////////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////////////////////
int MapInit(MAP &src, char *filename, char *mask_filename, char *layer_filename)
{
    src.hGraph = LoadGraph(filename);
    src.hMaskGraph = LoadGraph(mask_filename);
    if (layer_filename)
        src.hLayerGraph = LoadGraph(layer_filename);
    src.x = 0;
    src.y = 0;
    GetGraphSize(src.hGraph, &(src.w), &(src.h));

    return 0;
}

////////////////////////////////////////////////////////////////////////////////
// `
////////////////////////////////////////////////////////////////////////////////
void MapDraw(MAP src)
{
    DrawGraph(src.x, src.y, src.hGraph, false);
}

////////////////////////////////////////////////////////////////////////////////
// ړ}XN`
////////////////////////////////////////////////////////////////////////////////
void MapMaskDraw(MAP src)
{
    DrawGraph(src.x, src.y, src.hMaskGraph, false);
}

////////////////////////////////////////////////////////////////////////////////
// wC[`
////////////////////////////////////////////////////////////////////////////////
void MapLayerDraw(MAP src)
{
    DrawGraph(src.x, src.y, src.hLayerGraph, true);
}

