#include <ysbuild.h>
#include <Helper/GUIApplication.h>
#include <Helper/HostedUI.h>
#include <Helper/HostWindow.h>
#include "../HelperEx/Shells.h"
#include <YSLib/Adaptor/Image.h>

#include <YSLib/UI/ygui.h>
#include <iostream>
using namespace std;


int
main(int argc, char** argv)
{
	using namespace YSLib;
	using namespace Drawing;
	using namespace UI;

	if(argc > 1)
		try
		{
			GUIApplication app;
			ImageCodec codec;
			HBitmap image(argv[1]);
		//	HBitmap image(u8R"(T:\a.png)");
			auto buf(ImageCodec::Convert(image));
			auto p_img(ystdex::make_shared<Image>(buf.GetBufferPtr(),
				buf.GetWidth(), buf.GetHeight()));
			Control ctl(buf.GetSize());

		//	FetchDefaultFontCache();
			Host::ShowAndWait(ctl, WS_POPUP);
			yunseq(
				FetchEvent<Click>(ctl) += [](CursorEventArgs&& e){
					if(e.GetKeys()[VK_RBUTTON])
						YSLib::PostQuitMessage(0);
				},
				FetchEvent<TouchHeld>(ctl) += std::bind(Host::DragWindow,
					std::ref(*Host::GetWindowPtrOf(ctl)),
					std::placeholders::_1),
				FetchEvent<Paint>(ctl) += ImageBrush(std::move(p_img))
			);
			Execute(app);
		}
		catch(...)
		{}
}

