#ifndef INC_Y1_Shell_h_
#define INC_Y1_Shell_h_ 1

#include <Helper/GUIShell.h>
#include <Helper/ShellHelper.h>
#include <Helper/HostedUI.h>
#include <YCLib/Debug.h>

YSL_BEGIN

YSL_BEGIN_NAMESPACE(Host)

NativeWindowHandle
InitWindow(const Drawing::Size&, const wchar_t*, ::DWORD);


void
Show(UI::Widget&, ::DWORD = WS_POPUP | WS_MINIMIZEBOX, const wchar_t* = L"");

inline Host::Window*
ShowAndWait(UI::Widget& wgt, ::DWORD dw = WS_POPUP | WS_MINIMIZEBOX,
	 const wchar_t* title = L"")
{
	Show(wgt, dw, title);

	Host::Window* p_wnd{};

	while(!p_wnd)
		p_wnd = Host::GetWindowPtrOf(wgt);
	return p_wnd;
}


void
PrintFPS(FPSCounter&, Window&);

YSL_END_NAMESPACE(Host)


YSL_BEGIN_NAMESPACE(Shells)

class AnimatedShell : public GUIShell
{
protected:
	FPSCounter fpsCounter{std::chrono::milliseconds(500)};

public:
	std::function<void(UI::PaintEventArgs&&)> Refresh;

	template<typename F>
	AnimatedShell(F&& f)
		: Refresh(yforward(f))
	{
		//	IdleSleep = {};
		IdleSleep = std::chrono::nanoseconds(10000000);
	}
};

YSL_END_NAMESPACE(Shells)

YSL_END

#endif

