/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.unitarou.io.Ios;
import org.unitarou.jface.Computer;
import org.unitarou.util.ArgumentChecker;

public class FolderTreeContentProvider
implements ITreeContentProvider {
    private final Set<File> ignoreDrives_ = new HashSet<File>();

    public void setIgnoreDrives(File[] fileArray) {
        ArgumentChecker.throwIfNull((Object)fileArray);
        this.ignoreDrives_.clear();
        for (File file : fileArray) {
            this.ignoreDrives_.add(file);
        }
    }

    public Object[] getChildren(Object object) {
        if (object instanceof Computer) {
            File[] fileArray = File.listRoots();
            if (fileArray == null) {
                return new Object[0];
            }
            ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
            for (File file : fileArray) {
                if (this.ignoreDrives_.contains(file)) continue;
                arrayList.add(file);
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        if (object instanceof File) {
            File file = (File)object;
            if (!file.canRead()) {
                return new Object[0];
            }
            File[] fileArray = file.listFiles(Ios.NORMAL_DIRECTORY_FILTER);
            if (fileArray == null) {
                return new Object[0];
            }
            ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
            for (File file2 : fileArray) {
                if (file2.equals(object)) continue;
                arrayList.add(file2);
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            File file2 = file.getParentFile();
            return file2 == null ? Computer.instance() : file2;
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof Computer) {
            return true;
        }
        if (object instanceof File) {
            File file = (File)object;
            if (!file.exists()) {
                return false;
            }
            File[] fileArray = file.listFiles(Ios.NORMAL_DIRECTORY_FILTER);
            if (fileArray == null) {
                return false;
            }
            for (File file2 : fileArray) {
                if (file2.equals(object)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 != null && !(object2 instanceof File) && !(object2 instanceof Computer)) {
            throw new IllegalArgumentException("Bad input: " + object2);
        }
    }
}

