/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.util.ArgumentChecker;

public class RgbCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(RgbCodec.class);
    private static final RgbCodec instance_s_ = new RgbCodec();

    public static RgbCodec instance() {
        return instance_s_;
    }

    private RgbCodec() {
    }

    public boolean isEncodable(Object object) {
        return object instanceof RGB;
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        RGB rGB = (RGB)object;
        return StringConverter.asString(rGB);
    }

    public Object decode(String string) {
        try {
            return StringConverter.asRGB(string);
        }
        catch (DataFormatException dataFormatException) {
            log_s_.warn("[IGNORE] Invalid value: " + string);
            return null;
        }
    }
}

