/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private final ArrayList<Property> properties_;
    private final Map<SgfId, Property> propertyMap_;
    private String openUtr_;
    private String closeUtr_;
    private int hashCode_;

    public static Node makeMoveNode(SgfColor sgfColor, SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfColor, (Object)sgfPoint);
        Property property = sgfColor.moveType().makeProperty(sgfPoint);
        Node node = new Node();
        node.properties_.add(property);
        node.propertyMap_.put(property.sgfId(), property);
        return node;
    }

    public Node() {
        this.properties_ = new ArrayList(1);
        this.propertyMap_ = new HashMap<SgfId, Property>(1);
        this.openUtr_ = "";
        this.closeUtr_ = "";
        this.hashCode_ = 0;
    }

    public Node(Node node) {
        ArgumentChecker.throwIfNull((Object)node);
        this.properties_ = new ArrayList(node.properties_.size());
        this.propertyMap_ = new HashMap<SgfId, Property>(node.properties_.size());
        for (Property property : node.properties_) {
            Property property2 = new Property(property);
            this.properties_.add(property2);
            this.propertyMap_.put(property2.sgfId(), property2);
        }
        this.openUtr_ = node.openUtr_;
        this.closeUtr_ = node.closeUtr_;
        this.hashCode_ = node.hashCode_;
    }

    public Node(Property property) {
        this();
        if (property == null) {
            return;
        }
        if (!property.isValid()) {
            throw new IllegalArgumentException("A property must be valid.");
        }
        Property property2 = new Property(property);
        this.properties_.add(property2);
        this.propertyMap_.put(property2.sgfId(), property2);
    }

    public void addProperty(Property property) {
        ArgumentChecker.throwIfNull((Object)property);
        if (!property.isValid()) {
            throw new IllegalArgumentException("A property must be valid. property = " + property);
        }
        this.hashCode_ = 0;
        Property property2 = new Property(property);
        this.propertyMap_.put(property2.sgfId(), property2);
        for (int i = 0; i < this.properties_.size(); ++i) {
            Property property3 = this.properties_.get(i);
            if (!property3.getId().equals(property.getId())) continue;
            this.properties_.set(i, property2);
            return;
        }
        if (property2.sgfId().equals(SgfId.CHARSET)) {
            this.properties_.add(0, property2);
        } else {
            this.properties_.add(property2);
        }
    }

    public Property removeProperty(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        Iterator<Property> iterator = this.properties_.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            if (!property.sgfId().equals(sgfId)) continue;
            iterator.remove();
            this.propertyMap_.remove(property.sgfId());
            this.hashCode_ = 0;
            return property;
        }
        return null;
    }

    public void clearProperty() {
        this.properties_.clear();
        this.propertyMap_.clear();
        this.hashCode_ = 0;
    }

    public void setOpenUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.openUtr_ = string;
        this.hashCode_ = 0;
    }

    public void setCloseUtr(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.closeUtr_ = string;
        this.hashCode_ = 0;
    }

    public boolean contains(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return this.propertyMap_.containsKey(sgfId);
    }

    public Property getProperty(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return this.getProperty(SgfId.find(string));
    }

    public Property getProperty(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        Property property = this.propertyMap_.get(sgfId);
        if (property != null) {
            return new Property(property);
        }
        return null;
    }

    public Property[] getProperties() {
        Property[] propertyArray = new Property[this.properties_.size()];
        for (int i = 0; i < this.properties_.size(); ++i) {
            propertyArray[i] = new Property(this.properties_.get(i));
        }
        return propertyArray;
    }

    public Set<SgfId> getPropertyIds() {
        HashSet<SgfId> hashSet = new HashSet<SgfId>(this.properties_.size());
        for (Property property : this.properties_) {
            hashSet.add(property.sgfId());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public boolean contains(PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)propertyType);
        for (Property property : this.properties_) {
            if (!property.sgfId().propertyType().equals(propertyType)) continue;
            return true;
        }
        return false;
    }

    public String getOpenUtr() {
        return this.openUtr_;
    }

    public String getCloseUtr() {
        return this.closeUtr_;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Node node = (Node)object;
        return this.properties_.equals(node.properties_) && this.openUtr_.equals(node.openUtr_) && this.closeUtr_.equals(node.closeUtr_);
    }

    public int hashCode() {
        if (this.hashCode_ == 0) {
            this.hashCode_ = this.properties_.hashCode() + this.openUtr_.hashCode() * 7 + this.closeUtr_.hashCode() * 11;
        }
        return this.hashCode_;
    }

    public String toString() {
        return this.properties_.toString();
    }
}

