/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.util.ArgumentChecker;

class CreateGameTreeImpl
extends AbstractCommand {
    private final GameTree parent_;
    private final Node extensionPoint_;
    private final GameTree child_;
    private final GameTree mainstream_;

    CreateGameTreeImpl(GameTree gameTree, Node node, GameTree gameTree2) {
        ArgumentChecker.throwIfNull((Object)gameTree, (Object)node, (Object)gameTree2);
        this.parent_ = gameTree;
        this.extensionPoint_ = node;
        this.child_ = gameTree2;
        this.mainstream_ = new GameTree();
    }

    public void execute() {
        super.execute();
        Node node = this.parent_.getSequence().removeLast();
        while (node != this.extensionPoint_) {
            this.mainstream_.getSequence().addFirst(node);
            node = this.parent_.getSequence().removeLast();
        }
        this.parent_.getSequence().addLast(node);
        GameTree[] gameTreeArray = this.parent_.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            this.mainstream_.addGameTree(gameTreeArray[i]);
        }
        this.parent_.clearGameTree();
        this.parent_.addGameTree(this.mainstream_);
        this.parent_.addGameTree(this.child_);
    }

    public void undo() {
        super.undo();
        for (Node node : this.mainstream_.getSequence()) {
            this.parent_.getSequence().addLast(node);
        }
        this.parent_.clearGameTree();
        GameTree[] gameTreeArray = this.mainstream_.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            this.parent_.addGameTree(gameTreeArray[i]);
        }
        this.mainstream_.clearGameTree();
        this.mainstream_.getSequence().clear();
    }
}

