/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Message;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
implements TypedString<Result>,
NameDisplayable {
    private static final Message LB_DISPLAY_SCORED = new Message(Result.class, "lbDisplay");
    private static final Pattern scoreCondition_s_ = Pattern.compile("((W|B)\\+)(\\d+(\\.\\d+)?)");
    private static final int ENUM_POS = 1;
    private static final int SCORE_POS = 3;
    private final Archetype archetype_;
    private final double score_;
    private final String value_;

    public static Result parse(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        Matcher matcher = scoreCondition_s_.matcher(string);
        if (matcher.matches()) {
            Archetype archetype = Archetype.find(matcher.group(1));
            double d = Double.parseDouble(matcher.group(3));
            return new Result(archetype, d);
        }
        Archetype archetype = Archetype.find(string);
        if (archetype.equals(Archetype.OTHER)) {
            return new Result(string);
        }
        return new Result(archetype);
    }

    public Result(Archetype archetype) {
        ArgumentChecker.throwIfNull((Object)archetype);
        this.archetype_ = archetype;
        this.value_ = archetype.typeName_;
        this.score_ = 0.0;
    }

    public Result(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.archetype_ = Archetype.OTHER;
        this.value_ = string;
        this.score_ = 0.0;
    }

    public Result(Archetype archetype, double d) {
        ArgumentChecker.throwIfNull((Object)archetype);
        this.archetype_ = archetype;
        this.score_ = Archetype.SCORED.contains(this.archetype_) ? d : 0.0;
        this.value_ = this.archetype_.typeName_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.RESULT);
    }

    @Override
    public String getString() {
        if (Archetype.SCORED.contains(this.archetype_)) {
            return this.archetype_.typeName_ + String.valueOf(this.score_);
        }
        return this.archetype_.typeName_;
    }

    @Override
    public String displayName() {
        if (Archetype.OTHER == this.archetype_) {
            return this.value_;
        }
        if (Archetype.SCORED.contains(this.archetype_)) {
            return LB_DISPLAY_SCORED.get(this.archetype_.winner_.displayName(), String.valueOf(this.score_));
        }
        return this.archetype_.displayName();
    }

    @Override
    public int compareTo(Result result) {
        int n = this.archetype_.typeName_.compareTo(result.archetype_.typeName_);
        return n != 0 ? n : (this.score_ - result.score_ > 0.0 ? 1 : -1);
    }

    public Archetype getArchetype() {
        return this.archetype_;
    }

    public double getScore() {
        return this.score_;
    }

    public String getValue() {
        return this.value_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Archetype implements NameDisplayable
    {
        BLACK_RESIGN("B+Resign", SgfColor.BLACK),
        BLACK_R("B+R", SgfColor.BLACK),
        BLACK_Time("B+Time", SgfColor.BLACK),
        BLACK_T("B+T", SgfColor.BLACK),
        BLACK_FORFEIT("B+Forfeit", SgfColor.BLACK),
        BLACK_F("B+F", SgfColor.BLACK),
        BLACK_WIN("B+", SgfColor.BLACK),
        VOID("Void", null),
        UNKNOWN("?", null),
        ZERO("0", null),
        DRAW("Draw", null),
        OTHER("Other", null),
        WHITE_WIN("W+", SgfColor.WHITE),
        WHITE_RESIGN("W+Resign", SgfColor.WHITE),
        WHITE_R("W+R", SgfColor.WHITE),
        WHITE_Time("W+Time", SgfColor.WHITE),
        WHITE_T("W+T", SgfColor.WHITE),
        WHITE_FORFEIT("W+Forfeit", SgfColor.WHITE),
        WHITE_F("W+F", SgfColor.WHITE);

        public static final EnumSet<Archetype> SCORED;
        private static final Messages messages_s_;
        private static final EnumSet<Archetype> findTargets_s_;
        private final SgfColor winner_;
        private final String typeName_;
        private final String displayNameKey_;

        public static Archetype find(String string) {
            for (Archetype archetype : findTargets_s_) {
                if (!archetype.typeName_.equalsIgnoreCase(string)) continue;
                return archetype;
            }
            return OTHER;
        }

        private Archetype(String string2, SgfColor sgfColor) {
            ArgumentChecker.throwIfNull((Object)string2);
            this.winner_ = sgfColor;
            this.typeName_ = string2;
            this.displayNameKey_ = Messages.createKey(this.getClass(), this.typeName_);
        }

        public String toString() {
            return this.displayName() + "(" + this.typeName_ + ")";
        }

        @Override
        public String displayName() {
            return messages_s_.get(this.displayNameKey_);
        }

        public String typeName() {
            return this.typeName_;
        }

        static {
            SCORED = EnumSet.of(WHITE_WIN, BLACK_WIN);
            messages_s_ = Messages.createByPackage(Archetype.class);
            EnumSet<Archetype> enumSet = EnumSet.allOf(Archetype.class);
            enumSet.remove(OTHER);
            findTargets_s_ = enumSet;
        }
    }
}

